/*
 * Desmo Target Compiler
 *
 * See DESMO.TXT and: DESO ?
 *
 * ?COPY.TXT 2003-2007 Dave Dunfield
 */
#include <stdio.h>
#include "DESMO.h"

#define	tSEND		(MAXDATA)		// Send command
#define	tFILE		(MAXDATA-1)		// FILE command
#define	tMARK		(MAXDATA-2)		// MARK command
#define	tEND		(MAXDATA-3)		// End block command (+start marker)

unsigned char *blocks[] = {
	"VERIFY",
	"READ8",
	"READ16",
	"READ32",
	"WRITE8",
	"WRITE16",
	"WRITE32",
	"LREAD8",
	"LREAD16",
	"LREAD32",
	"LWRITE8",
	"LWRITE16",
	"LWRITE32",
	"LOAD",
	0 };

unsigned char *commands[] = {
	"END",
	"MARK",
	"FILE",
	"SEND",
	"PRINT",
	"FILL",
	"DROP",
	"EXPECT",
	"UNTIL",
	"TIME",
	"FLUSH",
	"FLAGS",
	"BAUD",
	"ESCAPE",
	"BADDR",
	"AADDR",
	"BDATA",
	"ADATA",
	0 };

unsigned char
	State,			// State of input
	*ptr,			// General parsing pointer
	buffer[200],	// Line input buffer
	temp[65],		// Temporary buffer
	block[50],		// Current block
	outbuf[10000];	// Output data
unsigned
	Long[2],		// Long value
	Long1[2],		// Long value
	Line,			// Current line number
	Dlen,			// Data block length
	Dbase,			// Base data length
	Baud,			// Target baudrate
	outptr,			// Output pointer
	Mark,			// Mark output
	Outdata,		// Data output
	Bstart[14],		// Starting offser
	Bend[14];		// Ending address

FILE
	*fp,			// General file pointer
	*fp1;			// ""

unsigned
	L115200[] = { 0xC200, 0x0001 };

/*
 * Formatted print to console device
 */
register error(unsigned args)
{
	char buffer[81];
	_format_(nargs() * 2 + &args, buffer);
	printf("%u: %s\n", Line, buffer);
	exit(-2);
}

skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

parse(unsigned char *dest)
{
	skip();
	while(*ptr && !isspace(*ptr))
		*dest++ = toupper(*ptr++);
	*dest = 0;
}

unsigned lookup(unsigned word, unsigned char *keywords[])
{
	unsigned i;
	unsigned char *p;

	for(i=0; p = keywords[i]; ++i) {
		if(!strcmp(word, p))
			return i; }
	error("Not found: %s\n", word);
}

getbyte(unsigned char *r)
{
	unsigned b, c, v;
	unsigned char f;
top:
	if(State) {
		if(!*ptr)
			error("End of line within string");
		if(*ptr != State) {
			*r = *ptr++;
			return -1; }
		++ptr;
		State = 0; }
	b = 10;
	switch(skip()) {
	default: error("Unknown value element");
	case 0 :	return 0;
	case '\'' :
	case '"' :
		State = *ptr++;
		goto top;
	case '%' :	b = 2; goto donum;
	case '$' :	b = 16;
donum: ++ptr;
	case '0' :
	case '1' :
	case '2' :
	case '3' :
	case '4' :
	case '5' :
	case '6' :
	case '7' :
	case '8' :
	case '9' : }

	v = f = 0;
	do {
		c = *ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if(c >= 'a')
			c -= ('a'-10);
		else if(c >=  'A')
			c -= ('A'-10);
		else
			break;
		if(c >= b)						/* outside of base */
			break;
		v = (v * b) + c;
		f = -1;
		++ptr; }
	while(*ptr && !isspace(*ptr));
	if(!f)
		error("Bad value element");
	*r = v;
	return -1;
}

getdata()
{
	unsigned char c;
	if(!getbyte(&c))
		error("Data value required");
	return c;
}

getflags()
{
	unsigned char c, f;
	f = c = 0;
	for(;;) {
		switch(skip()) {
		default: error("Unknown switch value");
		case '+' :
		case '-' :
		case 0  :
			if(!f)
				error("Switch value required");
			return c;
		case 'D' : c |= CF_DTR;		break;
		case 'R' : c |= CF_RTS;		break;
		case 'E' : c |= CF_ERROR;	break;
		case 'F' : c |= CF_FAIL;	break;
		case 'A' : c |= CF_MESSAGE; }
		++ptr;
		f = -1; }
}

unsigned getnum(unsigned l, unsigned h)
{
	unsigned char c, *p, temp[50];
	parse(p = temp);
	longset(Long, 0);
	do {
		c = *p - '0';
		if(c > 9)
			error("Bad numeric value");
		longset(Long1, 10);
		longmul(Long, Long1);
		longset(Long1, c);
		longadd(Long, Long1); }
	while(*++p);
	if(l|h) {
		if((*Long < l) || (*Long > h) || Long[1])
			error("Number out of range"); }
	return *Long;
}

Dclose()
{
	if(Dlen) {
		outbuf[Dbase] = Dlen;
		Dlen = 0; }
}
Dbyte(unsigned char c)
{
	if(Dlen >= MAXDATA)
		Dclose();
	if(!Dlen)
		Dbase = outptr++;
	outbuf[outptr++] = c;
	++Dlen;
	++Outdata;
}
Cbyte(unsigned char c)
{
	Dclose();
	outbuf[outptr++] = c;
}

static char help[] = { "\n\
Use:	DTC <filename>\n\n\
Read <filename>.DTS source file and builds <filename>.DTC control file.\n\
\n?COPY.TXT 2003-2005 Dave Dunfield\n**See COPY.TXT**.\n" };

main(int argc, char *argv[])
{
	unsigned i, j, inblock;
	unsigned char c, f;

	printf("DESMO Target Compiler - v1.0\n");
	if(argc < 2)
		abort(help);

	concat(buffer, argv[1], ".DTS");
	fp = fopen(buffer, "rvq");
	inblock = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		State = 0;
		++Line;
// printf("%u: %s\n", Line, buffer);
		switch(skip()) {
		case ';':	// Comment
		case 0 :	// Blank line
			continue;
		case '$' :
			if(inblock)
				error("Block '%s' not ended.\n", block);
			++ptr;
			parse(block);
			inblock = lookup(block, blocks)+1;
			Bstart[inblock-1] = outptr;
			Mark = Outdata = 0;
			f = 3;
			continue; }
		parse(temp);
		switch(i = lookup(temp, commands) + tEND) {
		case tBAUD:
			getnum(0, 0);
			longcpy(Long1, L115200);
			longdiv(Long1, Long);
			longmul(Long, Long1);
			if(longcmp(Long, L115200))
				error("Bad baud rate");
			if(inblock) {
				Cbyte(tBAUD);
				Cbyte(*Long1);
				continue; }
			Baud = *Long1;
			continue; }
		if(!inblock)
			error("No Block not active");
		switch(i) {
		case tEND :		// End definition
			if(!inblock)
				error("No block open");
			Cbyte(0x00);
			Bend[inblock-1] = outptr;
			inblock = 0;
			continue;
		case tMARK :	// MARK
			Mark = Outdata;
			continue;
		case tFILE :	// Send file
			parse(temp);
			if(!(fp1 = fopen(temp, "rvb")))
				error("Unable to open file: %s", temp);
			while((j = getc(fp1)) != EOF)
				Dbyte(j);
			fclose(fp1);
			continue;
		case tSEND :	// Send ...
			while(getbyte(&c))
				Dbyte(c);
			continue;
		case tPRINT :	// Print message
			Cbyte(i);
			skip();
			while(getbyte(&c))
				Cbyte(c);
			Cbyte(0);
			continue;
		case tFILL :	// Fill block
			c = getdata();
			j = getnum(1, 65535) - (Outdata - Mark);
			if(j & 0x8000)
				error("Data exceeds fill");
			while(j > 256) {
				Cbyte(i);
				Cbyte(c);
				Cbyte(0);
				j -= 256; }
			if(j) {
				Cbyte(i);
				Cbyte(c);
				Cbyte(j); }
			continue;
		case tDROP :	// Drop characters
		case tTIME :	// Set timeout
		case tFLUSH :	// Flush data
			Cbyte(i);
			Cbyte(getnum(1,255));
			continue;
		case tEXPECT :	// Expect a character
		case tUNTIL :	// Until a character
			Cbyte(i);
			Cbyte(getdata());
			continue;
		case tFLAGS :	// Set/Clear flags
	ftop:	switch(skip()) {
			case '+' : ++ptr; f |= getflags();	break;
			case '-' : ++ptr; f &= ~getflags();	break;
			default:	f = getflags(); }
			switch(skip()) {
			case '+' :
			case '-' : goto ftop; }
			Cbyte(i);
			Cbyte(f);
			continue;
		case tESCAPE :	// Wait for ESCAPE
			Cbyte(i);
			continue;
		case tBADDR :	// Binary address
			i = 0xF0;
		doindex:
			do {
				Cbyte(getnum(0,3) + i); }
			while(skip());
			continue;
		case tBADDR+1: i = 0xF4; goto doindex;
		case tBADDR+2: i = 0xF8; goto doindex;
		case tBADDR+4: i = 0xFC; goto doindex;
	} }
	fclose(fp);
	for(i=inblock=0; i < 14; ++i) {
		printf("Block %-8s ", blocks[i]);
		if(j = Bend[i] - Bstart[i]) {
			printf("%5u bytes\n", j);
			inblock += j;
			continue; }
		printf("Not defined.\n"); }

	if(!Baud)
		error("No BAUD specified");
	concat(buffer, argv[1], ".DTC");
	fp = fopen(buffer, "wvqb");
	fput(&Baud, sizeof(Baud), fp);
	inblock = 1;
	for(i=0; i < 14; ++i) {
		if(Bend[i]) {
			fput(&inblock, sizeof(inblock), fp);
			inblock += (Bend[i]-Bstart[i]); }
		else {
			j = 0;
			fput(&j, sizeof(j), fp); } }

	for(i=0; i < 14; ++i) {
		if(Bend[i])
			fput(outbuf+Bstart[i], Bend[i]-Bstart[i], fp); }
	fclose(fp);
}
