/*
 * Tables/Functions to implement the 68HC16 cross disassembler
 */

#define	XPSHM	0x08
#define	XBIT16	0x10
#define	PCREL	0x20

/* Text strings that the disassembler needs */
char _cpu_[]	= "68HC16";		/* Name of CPU */
char _cmd_[]	= "DIS16";		/* Command name */
char _byte_[]	= "FCB     ";	/* Directive to encode bytes */
char _word_[]	= "FDB     ";	/* Directive to encode words */
char _string_[]	= "FCC     ";	/* Directive to encode strings */

unsigned char inames[] = {
	'A','C','E',	/* 80 */
	'A','D','C',	/* 81 */
	'A','D','D',	/* 82 */
	'A','I','S',	/* 83 */
	'A','I','X',	/* 84 */
	'A','I','Y',	/* 85 */
	'A','I','Z',	/* 86 */
	'A','N','D',	/* 87 */
	'A','S','L',	/* 88 */
	'A','S','R',	/* 89 */
	'B','C','C',	/* 8A */
	'B','C','S',	/* 8B */
	'B','E','Q',	/* 8C */
	'B','G','E',	/* 8D */
	'B','G','T',	/* 8E */
	'B','H','I',	/* 8F */
	'B','L','E',	/* 90 */
	'B','L','S',	/* 91 */
	'B','L','T',	/* 92 */
	'B','M','I',	/* 93 */
	'B','N','E',	/* 94 */
	'B','P','L',	/* 95 */
	'B','R','A',	/* 96 */
	'B','R','N',	/* 97 */
	'B','V','C',	/* 98 */
	'B','V','S',	/* 99 */
	'B','S','R',	/* 9A */
	'B','C','L',	/* 9B */
	'B','I','T',	/* 9C */
	'B','R','C',	/* 9D */
	'B','R','S',	/* 9E */
	'B','S','E',	/* 9F */
	'C','L','R',	/* A0 */
	'C','M','P',	/* A1 */
	'C','O','M',	/* A2 */
	'C','P','D',	/* A3 */
	'C','P','E',	/* A4 */
	'C','P','S',	/* A5 */
	'C','P','X',	/* A6 */
	'C','P','Y',	/* A7 */
	'C','P','Z',	/* A8 */
	'D','A','A',	/* A9 */
	'D','E','C',	/* AA */
	'E','D','I',	/* AB */
	'E','M','U',	/* AC */
	'E','O','R',	/* AD */
	'I','N','C',	/* AE */
	'J','M','P',	/* AF */
	'J','S','R',	/* B0 */
	'L','B','C',	/* B1 */
	'L','B','E',	/* B2 */
	'L','B','G',	/* B3 */
	'L','B','L',	/* B4 */
	'L','B','M',	/* B5 */
	'L','B','R',	/* B6 */
	'L','B','V',	/* B7 */
	'L','D','A',	/* B8 */
	'L','D','D',	/* B9 */
	'L','D','E',	/* BA */
	'L','D','S',	/* BB */
	'L','D','X',	/* BC */
	'L','D','Y',	/* BD */
	'L','D','Z',	/* BE */
	'L','S','R',	/* BF */
	'M','A','C',	/* C0 */
	'M','O','V',	/* C1 */
	'M','U','L',	/* C2 */
	'N','E','G',	/* C3 */
	'O','R','A',	/* C4 */
	'O','R','D',	/* C5 */
	'O','R','E',	/* C6 */
	'P','S','H',	/* C7 */
	'P','U','L',	/* C8 */
	'R','O','L',	/* C9 */
	'R','O','R',	/* CA */
	'S','B','C',	/* CB */
	'S','T','A',	/* CC */
	'S','T','D',	/* CD */
	'S','T','E',	/* CE */
	'S','T','S',	/* CF */
	'S','T','X',	/* D0 */
	'S','T','Y',	/* D1 */
	'S','T','Z',	/* D2 */
	'S','U','B',	/* D3 */
	'T','A','B',	/* D4 */
	'T','E','D',	/* D5 */
	'T','M','E',	/* D6 */
	'T','S','T',	/* D7 */
	'X','G','D',	/* D8 */
	'X','G','E'		/* D9 */
};

/* Table of 68HC16 opcodes: OPCODE, FLAG/LENGTH, TEXT */
/* FLAG = 0x80 if second opcode byte required. */
unsigned char itable[] = {
	0x37,0x82,0x0B,"ABA",
	0x37,0x82,0x4F,"ABX",
	0x37,0x82,0x5F,"ABY",
	0x37,0x82,0x6F,"ABZ",
	0x37,0x82,0x22,"\x80",				/* ACE */
	0x37,0x82,0x23,"\x80D",				/* ACED */
	0x43,0x02,"\x81A \xC1,X",			/* ADCA */
	0x53,0x02,"\x81A \xC1,Y",			/* ADCA */
	0x63,0x02,"\x81A \xC1,Z",			/* ADCA */
	0x73,0x02,"\x81A #\xC1",			/* ADCA */
	0x17,0x84,0x43,"\x81A \xD2,X",		/* ADCA */
	0x17,0x84,0x53,"\x81A \xD2,Y",		/* ADCA */
	0x17,0x84,0x63,"\x81A \xD2,Z",		/* ADCA */
	0x17,0x84,0x73,"\x81A \xD2",		/* ADCA */
	0x27,0x82,0x43,"\x81A E,X",			/* ADCA */
	0x27,0x82,0x53,"\x81A E,Y",			/* ADCA */
	0x27,0x82,0x63,"\x81A E,Z",			/* ADCA */
	0xC3,0x02,"\x81B \xC1,X",			/* ADCB */
	0xD3,0x02,"\x81B \xC1,Y",			/* ADCB */
	0xE3,0x02,"\x81B \xC1,Z",			/* ADCB */
	0xF3,0x02,"\x81B #\xC1",			/* ADCB */
	0x17,0x84,0xC3,"\x81B \xD2,X",		/* ADCB */
	0x17,0x84,0xD3,"\x81B \xD2,Y",		/* ADCB */
	0x17,0x84,0xE3,"\x81B \xD2,Z",		/* ADCB */
	0x17,0x84,0xF3,"\x81B \xD2",		/* ADCB */
	0x27,0x82,0xC3,"\x81B E,X",			/* ADCB */
	0x27,0x82,0xD3,"\x81B E,Y",			/* ADCB */
	0x27,0x82,0xE3,"\x81B E,Z",			/* ADCB */
	0x83,0x02,"\x81D \xC1,X",			/* ADCD */
	0x93,0x02,"\x81D \xC1,Y",			/* ADCD */
	0xA3,0x02,"\x81D \xC1,Z",			/* ADCD */
	0x37,0x84,0xB3,"\x81D #\xD2",		/* ADCD */
	0x37,0x84,0xC3,"\x81D \xD2,X",		/* ADCD */
	0x37,0x84,0xD3,"\x81D \xD2,Y",		/* ADCD */
	0x37,0x84,0xE3,"\x81D \xD2,Z",		/* ADCD */
	0x37,0x84,0xF3,"\x81D \xD2",		/* ADCD */
	0x27,0x82,0x83,"\x81D E,X",			/* ADCD */
	0x27,0x82,0x93,"\x81D E,Y",			/* ADCD */
	0x27,0x82,0xA3,"\x81D E,Z",			/* ADCD */
	0x37,0x84,0x33,"\x81E #\xD2",		/* ADCE */
	0x37,0x84,0x43,"\x81E \xD2,X",		/* ADCE */
	0x37,0x84,0x53,"\x81E \xD2,Y",		/* ADCE */
	0x37,0x84,0x63,"\x81E \xD2,Z",		/* ADCE */
	0x37,0x84,0x73,"\x81E \xD2",		/* ADCE */
	0x41,0x02,"\x82A \xC1,X",			/* ADDA */
	0x51,0x02,"\x82A \xC1,Y",			/* ADDA */
	0x61,0x02,"\x82A \xC1,Z",			/* ADDA */
	0x71,0x02,"\x82A #\xC1",			/* ADDA */
	0x17,0x84,0x41,"\x82A \xD2,X",		/* ADDA */
	0x17,0x84,0x51,"\x82A \xD2,Y",		/* ADDA */
	0x17,0x84,0x61,"\x82A \xD2,Z",		/* ADDA */
	0x17,0x84,0x71,"\x82A \xD2",		/* ADDA */
	0x27,0x82,0x41,"\x82A E,X",			/* ADDA */
	0x27,0x82,0x51,"\x82A E,Y",			/* ADDA */
	0x27,0x82,0x61,"\x82A E,Z",			/* ADDA */
	0xC1,0x02,"\x82B \xC1,X",			/* ADDB */
	0xD1,0x02,"\x82B \xC1,Y",			/* ADDB */
	0xE1,0x02,"\x82B \xC1,Z",			/* ADDB */
	0xF1,0x02,"\x82B #\xC1",			/* ADDB */
	0x17,0x84,0xC1,"\x82B \xD2,X",		/* ADDB */
	0x17,0x84,0xD1,"\x82B \xD2,Y",		/* ADDB */
	0x17,0x84,0xE1,"\x82B \xD2,Z",		/* ADDB */
	0x17,0x84,0xF1,"\x82B \xD2",		/* ADDB */
	0x27,0x82,0xC1,"\x82B E,X",			/* ADDB */
	0x27,0x82,0xD1,"\x82B E,Y",			/* ADDB */
	0x27,0x82,0xE1,"\x82B E,Z",			/* ADDB */
	0x81,0x02,"\x82D \xC1,X",			/* ADDD */
	0x91,0x02,"\x82D \xC1,Y",			/* ADDD */
	0xA1,0x02,"\x82D \xC1,Z",			/* ADDD */
	0xFC,0x02,"\x82D #\xC1",			/* ADDD */
	0x37,0x84,0xB1,"\x82D #\xD2",		/* ADDD */
	0x37,0x84,0xC1,"\x82D \xD2,X",		/* ADDD */
	0x37,0x84,0xD1,"\x82D \xD2,Y",		/* ADDD */
	0x37,0x84,0xE1,"\x82D \xD2,Z",		/* ADDD */
	0x37,0x84,0xF1,"\x82D \xD2",		/* ADDD */
	0x27,0x82,0x81,"\x82D E,X",			/* ADDD */
	0x27,0x82,0x91,"\x82D E,Y",			/* ADDD */
	0x27,0x82,0xA1,"\x82D E,Z",			/* ADDD */
	0x7C,0x02,"\x82E #\xC1",			/* ADDE */
	0x37,0x84,0x31,"\x82E #\xD2",		/* ADDE */
	0x37,0x84,0x41,"\x82E \xD2,X",		/* ADDE */
	0x37,0x84,0x51,"\x82E \xD2,Y",		/* ADDE */
	0x37,0x84,0x61,"\x82E \xD2,Z",		/* ADDE */
	0x37,0x84,0x71,"\x82E \xD2",		/* ADDE */
	0x27,0x82,0x78,"ADE",
	0x37,0x82,0xCD,"ADX",
	0x37,0x82,0xDD,"ADY",
	0x37,0x82,0xED,"ADZ",
	0x37,0x82,0x4D,"AEX",
	0x37,0x82,0x5D,"AEY",
	0x37,0x82,0x6D,"AEZ",
	0x3F,0x02,"\x83 #\xC1",				/* AIS */
	0x37,0x84,0x3F,"\x83 #\xD2",		/* AIS */
	0x3C,0x02,"\x84 #\xC1",				/* AIX */
	0x37,0x84,0x3C,"\x84 #\xD2",		/* AIX */
	0x3D,0x02,"\x85 #\xC1",				/* AIY */
	0x37,0x84,0x3D,"\x85 #\xD2",		/* AIY */
	0x3E,0x02,"\x86 #\xC1",				/* AIZ */
	0x37,0x84,0x3E,"\x86 #\xD2",		/* AIZ */
	0x46,0x02,"\x87A \xC1,X",			/* ANDA */
	0x56,0x02,"\x87A \xC1,Y",			/* ANDA */
	0x66,0x02,"\x87A \xC1,Z",			/* ANDA */
	0x76,0x02,"\x87A #\xC1",			/* ANDA */
	0x17,0x84,0x46,"\x87A \xD2,X",		/* ANDA */
	0x17,0x84,0x56,"\x87A \xD2,Y",		/* ANDA */
	0x17,0x84,0x66,"\x87A \xD2,Z",		/* ANDA */
	0x17,0x84,0x76,"\x87A \xD2",		/* ANDA */
	0x27,0x82,0x46,"\x87A E,X",			/* ANDA */
	0x27,0x82,0x56,"\x87A E,Y",			/* ANDA */
	0x27,0x82,0x66,"\x87A E,Z",			/* ANDA */
	0xC6,0x02,"\x87B \xC1,X",			/* ANDB */
	0xD6,0x02,"\x87B \xC1,Y",			/* ANDB */
	0xE6,0x02,"\x87B \xC1,Z",			/* ANDB */
	0xF6,0x02,"\x87B #\xC1",			/* ANDB */
	0x17,0x84,0xC6,"\x87B \xD2,X",		/* ANDB */
	0x17,0x84,0xD6,"\x87B \xD2,Y",		/* ANDB */
	0x17,0x84,0xE6,"\x87B \xD2,Z",		/* ANDB */
	0x17,0x84,0xF6,"\x87B \xD2",		/* ANDB */
	0x27,0x82,0xC6,"\x87B E,X",			/* ANDB */
	0x27,0x82,0xD6,"\x87B E,Y",			/* ANDB */
	0x27,0x82,0xE6,"\x87B E,Z",			/* ANDB */
	0x86,0x02,"\x87D \xC1,X",			/* ANDD */
	0x96,0x02,"\x87D \xC1,Y",			/* ANDD */
	0xA6,0x02,"\x87D \xC1,Z",			/* ANDD */
	0x37,0x84,0xB6,"\x87D #\xD2",		/* ANDD */
	0x37,0x84,0xC6,"\x87D \xD2,X",		/* ANDD */
	0x37,0x84,0xD6,"\x87D \xD2,Y",		/* ANDD */
	0x37,0x84,0xE6,"\x87D \xD2,Z",		/* ANDD */
	0x37,0x84,0xF6,"\x87D \xD2",		/* ANDD */
	0x27,0x82,0x86,"\x87D E,X",			/* ANDD */
	0x27,0x82,0x96,"\x87D E,Y",			/* ANDD */
	0x27,0x82,0xA6,"\x87D E,Z",			/* ANDD */
	0x37,0x84,0x36,"\x87E #\xD2",		/* ANDE */
	0x37,0x84,0x46,"\x87E \xD2,X",		/* ANDE */
	0x37,0x84,0x56,"\x87E \xD2,Y",		/* ANDE */
	0x37,0x84,0x66,"\x87E \xD2,Z",		/* ANDE */
	0x37,0x84,0x76,"\x87E \xD2",		/* ANDE */
	0x37,0x84,0x3A,"\x87P #\xD2",		/* ANDP */
	0x04,0x02,"\x88 \xC1,X",			/* ASL */
	0x14,0x02,"\x88 \xC1,Y",			/* ASL */
	0x24,0x02,"\x88 \xC1,Z",			/* ASL */
	0x17,0x84,0x04,"\x88 \xD2,X",		/* ASL */
	0x17,0x84,0x14,"\x88 \xD2,Y",		/* ASL */
	0x17,0x84,0x24,"\x88 \xD2,Z",		/* ASL */
	0x17,0x84,0x34,"\x88 \xD2",			/* ASL */
	0x37,0x82,0x04,"\x88A",				/* ASLA */
	0x37,0x82,0x14,"\x88B",				/* ASLB */
	0x27,0x82,0xF4,"\x88D",				/* ASLD */
	0x27,0x82,0x74,"\x88E",				/* ASLE */
	0x27,0x82,0xB6,"\x88M",				/* ASLM */
	0x27,0x84,0x04,"\x88W \xD2,X",		/* ASLW */
	0x27,0x84,0x14,"\x88W \xD2,Y",		/* ASLW */
	0x27,0x84,0x24,"\x88W \xD2,Z",		/* ASLW */
	0x27,0x84,0x34,"\x88W \xD2",		/* ASLW */
	0x0D,0x02,"\x89 \xC1,X",			/* ASR */
	0x1D,0x02,"\x89 \xC1,Y",			/* ASR */
	0x2D,0x02,"\x89 \xC1,Z",			/* ASR */
	0x17,0x84,0x0D,"\x89 \xD2,X",		/* ASR */
	0x17,0x84,0x1D,"\x89 \xD2,Y",		/* ASR */
	0x17,0x84,0x2D,"\x89 \xD2,Z",		/* ASR */
	0x17,0x84,0x3D,"\x89 \xD2",			/* ASR */
	0x37,0x82,0x0D,"\x89A",				/* ASRA */
	0x37,0x82,0x1D,"\x89B",				/* ASRB */
	0x27,0x82,0xFD,"\x89D",				/* ASRD */
	0x27,0x82,0x7D,"\x89E",				/* ASRE */
	0x27,0x82,0xBA,"\x89M",				/* ASRM */
	0x27,0x84,0x0D,"\x89W \xD2,X",		/* ASRW */
	0x27,0x84,0x1D,"\x89W \xD2,Y",		/* ASRW */
	0x27,0x84,0x2D,"\x89W \xD2,Z",		/* ASRW */
	0x27,0x84,0x3D,"\x89W \xD2",		/* ASRW */
	0xB4,0x02,"\x8A \xE1",				/* BCC */
	0xB5,0x02,"\x8B \xE1",				/* BCS */
	0xB7,0x02,"\x8C \xE1",				/* BEQ */
	0xBC,0x02,"\x8D \xE1",				/* BGE */
	0xBE,0x02,"\x8E \xE1",				/* BGT */
	0xB2,0x02,"\x8F \xE1",				/* BHI */
	0xBF,0x02,"\x90 \xE1",				/* BLE */
	0xB3,0x02,"\x91 \xE1",				/* BLS */
	0xBD,0x02,"\x92 \xE1",				/* BLT */
	0xBB,0x02,"\x93 \xE1",				/* BMI */
	0xB6,0x02,"\x94 \xE1",				/* BNE */
	0xBA,0x02,"\x95 \xE1",				/* BPL */
	0xB0,0x02,"\x96 \xE1",				/* BRA */
	0xB1,0x02,"\x97 \xE1",				/* BRN */
	0xB8,0x02,"\x98 \xE1",				/* BVC */
	0xB9,0x02,"\x99 \xE1",				/* BVS */
	0x36,0x02,"\x9A \xE1",				/* BSR */
	0x17,0x84,0x08,"\x9BR \xC3,X,#\xC2",	/* BCLR */
	0x17,0x84,0x18,"\x9BR \xC3,Y,#\xC2",	/* BCLR */
	0x17,0x84,0x28,"\x9BR \xC3,Z,#\xC2",	/* BCLR */
	0x08,0x04,"\x9BR \xD2,X,#\xC1",		/* BCLR */
	0x18,0x04,"\x9BR \xD2,Y,#\xC1",		/* BCLR */
	0x28,0x04,"\x9BR \xD2,Z,#\xC1",		/* BCLR */
	0x38,0x04,"\x9BR \xD2,#\xC1",		/* BCLR */
	0x27,0x86,0x08,"\x9BRW \xD2,X,#\xD4",	/* BCLRW */
	0x27,0x86,0x18,"\x9BRW \xD2,Y,#\xD4",	/* BCLRW */
	0x27,0x86,0x28,"\x9BRW \xD2,Z,#\xD4",	/* BCLRW */
	0x27,0x86,0x38,"\x9BRW \xD2,#\xD4",		/* BCLRW */
	0x37,0x82,0xA6,"BGND",
	0x49,0x02,"\x9CA \xC1,X",			/* BITA */
	0x59,0x02,"\x9CA \xC1,Y",			/* BITA */
	0x69,0x02,"\x9CA \xC1,Z",			/* BITA */
	0x79,0x02,"\x9CA #\xC1",			/* BITA */
	0x17,0x84,0x49,"\x9CA \xD2,X",		/* BITA */
	0x17,0x84,0x59,"\x9CA \xD2,Y",		/* BITA */
	0x17,0x84,0x69,"\x9CA \xD2,Z",		/* BITA */
	0x17,0x84,0x79,"\x9CA \xD2",		/* BITA */
	0x27,0x82,0x49,"\x9CA E,X",			/* BITA */
	0x27,0x82,0x59,"\x9CA E,Y",			/* BITA */
	0x27,0x82,0x69,"\x9CA E,Z",			/* BITA */
	0xC9,0x02,"\x9CB \xC1,X",			/* BITB */
	0xD9,0x02,"\x9CB \xC1,Y",			/* BITB */
	0xE9,0x02,"\x9CB \xC1,Z",			/* BITB */
	0xF9,0x02,"\x9CB #\xC1",			/* BITB */
	0x17,0x84,0xC9,"\x9CB \xD2,X",		/* BITB */
	0x17,0x84,0xD9,"\x9CB \xD2,Y",		/* BITB */
	0x17,0x84,0xE9,"\x9CB \xD2,Z",		/* BITB */
	0x17,0x84,0xF9,"\x9CB \xD2",		/* BITB */
	0x27,0x82,0xC9,"\x9CB E,X",			/* BITB */
	0x27,0x82,0xD9,"\x9CB E,Y",			/* BITB */
	0x27,0x82,0xE9,"\x9CB E,Z",			/* BITB */
	0xCB,0x04,"\x9DLR \xC2,X,#\xC1,\xE3",	/* BRCLR */
	0xDB,0x04,"\x9DLR \xC2,Y,#\xC1,\xE3",	/* BRCLR */
	0xEB,0x04,"\x9DLR \xC2,Z,#\xC1,\xE3",	/* BRCLR */
	0x0A,0x06,"\x9DLR \xD2,X,#\xC1,\xF4",	/* BRCLR */
	0x1A,0x06,"\x9DLR \xD2,Y,#\xC1,\xF4",	/* BRCLR */
	0x2A,0x06,"\x9DLR \xD2,Z,#\xC1,\xF4",	/* BRCLR */
	0x3A,0x06,"\x9DLR \xD2,#\xC1,\xF4",		/* BRCLR */
	0x8B,0x04,"\x9EET \xC2,X,#\xC1,\xE3",	/* BRSET */
	0x9B,0x04,"\x9EET \xC2,Y,#\xC1,\xE3",	/* BRSET */
	0xAB,0x04,"\x9EET \xC2,Z,#\xC1,\xE3",	/* BRSET */
	0x0B,0x06,"\x9EET \xD2,X,#\xC1,\xF4",	/* BRSET */
	0x1B,0x06,"\x9EET \xD2,Y,#\xC1,\xF4",	/* BRSET */
	0x2B,0x06,"\x9EET \xD2,Z,#\xC1,\xF4",	/* BRSET */
	0x3B,0x06,"\x9EET \xD2,#\xC1,\xF4",		/* BRSET */
	0x17,0x84,0x09,"\x9FT \xC3,X,#\xC2",	/* BSET */
	0x17,0x84,0x19,"\x9FT \xC3,Y,#\xC2",	/* BSET */
	0x17,0x84,0x29,"\x9FT \xC3,Z,#\xC2",	/* BSET */
	0x09,0x04,"\x9FT \xD2,X,#\xC1",		/* BSET */
	0x19,0x04,"\x9FT \xD2,Y,#\xC1",		/* BSET */
	0x29,0x04,"\x9FT \xD2,Z,#\xC1",		/* BSET */
	0x39,0x04,"\x9FT \xD2,#\xC1",		/* BSET */
	0x27,0x86,0x09,"\x9FTW \xD2,X,#\xD4",	/* BSETW */
	0x27,0x86,0x19,"\x9FTW \xD2,Y,#\xD4",	/* BSETW */
	0x27,0x86,0x29,"\x9FTW \xD2,Z,#\xD4",	/* BSETW */
	0x27,0x86,0x39,"\x9FTW \xD2,#\xD4",		/* BSETW */
	0x37,0x82,0x1B,"CBA",
	0x05,0x02,"\xA0 \xC1,X",			/* CLR */
	0x15,0x02,"\xA0 \xC1,Y",			/* CLR */
	0x25,0x02,"\xA0 \xC1,Z",			/* CLR */
	0x17,0x84,0x05,"\xA0 \xD2,X",		/* CLR */
	0x17,0x84,0x15,"\xA0 \xD2,Y",		/* CLR */
	0x17,0x84,0x25,"\xA0 \xD2,Z",		/* CLR */
	0x17,0x84,0x35,"\xA0 \xD2",			/* CLR */
	0x37,0x82,0x05,"\xA0A",				/* CLRA */
	0x37,0x82,0x15,"\xA0B",				/* CLRB */
	0x27,0x82,0xF5,"\xA0D",				/* CLRD */
	0x27,0x82,0x75,"\xA0E",				/* CLRE */
	0x27,0x82,0xB7,"\xA0M",				/* CLRM */
	0x27,0x84,0x05,"\xA0W \xD2,X",		/* CLRW */
	0x27,0x84,0x15,"\xA0W \xD2,Y",		/* CLRW */
	0x27,0x84,0x25,"\xA0W \xD2,Z",		/* CLRW */
	0x27,0x84,0x35,"\xA0W \xD2",		/* CLRW */
	0x48,0x02,"\xA1A \xC1,X",			/* CMPA */
	0x58,0x02,"\xA1A \xC1,Y",			/* CMPA */
	0x68,0x02,"\xA1A \xC1,Z",			/* CMPA */
	0x78,0x02,"\xA1A #\xC1",			/* CMPA */
	0x17,0x84,0x48,"\xA1A \xD2,X",		/* CMPA */
	0x17,0x84,0x58,"\xA1A \xD2,Y",		/* CMPA */
	0x17,0x84,0x68,"\xA1A \xD2,Z",		/* CMPA */
	0x17,0x84,0x78,"\xA1A \xD2",		/* CMPA */
	0x27,0x82,0x48,"\xA1A E,X",			/* CMPA */
	0x27,0x82,0x58,"\xA1A E,Y",			/* CMPA */
	0x27,0x82,0x68,"\xA1A E,Z",			/* CMPA */
	0xC8,0x02,"\xA1B \xC1,X",			/* CMPB */
	0xD8,0x02,"\xA1B \xC1,Y",			/* CMPB */
	0xE8,0x02,"\xA1B \xC1,Z",			/* CMPB */
	0xF8,0x02,"\xA1B #\xC1",			/* CMPB */
	0x17,0x84,0xC8,"\xA1B \xD2,X",		/* CMPB */
	0x17,0x84,0xD8,"\xA1B \xD2,Y",		/* CMPB */
	0x17,0x84,0xE8,"\xA1B \xD2,Z",		/* CMPB */
	0x17,0x84,0xF8,"\xA1B \xD2",		/* CMPB */
	0x27,0x82,0xC8,"\xA1B E,X",			/* CMPB */
	0x27,0x82,0xD8,"\xA1B E,Y",			/* CMPB */
	0x27,0x82,0xE8,"\xA1B E,Z",			/* CMPB */
	0x00,0x02,"\xA2 \xC1,X",			/* COM */
	0x10,0x02,"\xA2 \xC1,Y",			/* COM */
	0x20,0x02,"\xA2 \xC1,Z",			/* COM */
	0x17,0x84,0x00,"\xA2 \xD2,X",		/* COM */
	0x17,0x84,0x10,"\xA2 \xD2,Y",		/* COM */
	0x17,0x84,0x20,"\xA2 \xD2,Z",		/* COM */
	0x17,0x84,0x30,"\xA2 \xD2",			/* COM */
	0x37,0x82,0x00,"\xA2A",				/* COMA */
	0x37,0x82,0x10,"\xA2B",				/* COMB */
	0x27,0x82,0xF0,"\xA2D",				/* COMD */
	0x27,0x82,0x70,"\xA2E",				/* COME */
	0x27,0x84,0x00,"\xA2W \xD2,X",		/* COMW */
	0x27,0x84,0x10,"\xA2W \xD2,Y",		/* COMW */
	0x27,0x84,0x20,"\xA2W \xD2,Z",		/* COMW */
	0x27,0x84,0x30,"\xA2W \xD2",		/* COMW */
	0x88,0x02,"\xA3 \xC1,X",			/* CPD */
	0x98,0x02,"\xA3 \xC1,Y",			/* CPD */
	0xA8,0x02,"\xA3 \xC1,Z",			/* CPD */
	0x37,0x84,0xB8,"\xA3 #\xD2",		/* CPD */
	0x37,0x84,0xC8,"\xA3 \xD2,X",		/* CPD */
	0x37,0x84,0xD8,"\xA3 \xD2,Y",		/* CPD */
	0x37,0x84,0xE8,"\xA3 \xD2,Z",		/* CPD */
	0x37,0x84,0xF8,"\xA3 \xD2",			/* CPD */
	0x27,0x82,0x88,"\xA3 E,X",			/* CPD */
	0x27,0x82,0x98,"\xA3 E,Y",			/* CPD */
	0x27,0x82,0xA8,"\xA3 E,Z",			/* CPD */
	0x37,0x84,0x38,"\xA4 #\xD2",		/* CPE */
	0x37,0x84,0x48,"\xA4 \xD2,X",		/* CPE */
	0x37,0x84,0x58,"\xA4 \xD2,Y",		/* CPE */
	0x37,0x84,0x68,"\xA4 \xD2,Z",		/* CPE */
	0x37,0x84,0x78,"\xA4 \xD2",			/* CPE */
	0x4F,0x02,"\xA5 \xC1,X",			/* CPS */
	0x5F,0x02,"\xA5 \xC1,Y",			/* CPS */
	0x6F,0x02,"\xA5 \xC1,Z",			/* CPS */
	0x37,0x84,0x7F,"\xA5 #\xD2",		/* CPS */
	0x17,0x84,0x4F,"\xA5 \xD2,X",		/* CPS */
	0x17,0x84,0x5F,"\xA5 \xD2,Y",		/* CPS */
	0x17,0x84,0x6F,"\xA5 \xD2,Z",		/* CPS */
	0x17,0x84,0x7F,"\xA5 \xD2",			/* CPS */
	0x4C,0x02,"\xA6 \xC1,X",			/* CPX */
	0x5C,0x02,"\xA6 \xC1,Y",			/* CPX */
	0x6C,0x02,"\xA6 \xC1,Z",			/* CPX */
	0x37,0x84,0x7C,"\xA6 #\xD2",		/* CPX */
	0x17,0x84,0x4C,"\xA6 \xD2,X",		/* CPX */
	0x17,0x84,0x5C,"\xA6 \xD2,Y",		/* CPX */
	0x17,0x84,0x6C,"\xA6 \xD2,Z",		/* CPX */
	0x17,0x84,0x7C,"\xA6 \xD2",			/* CPX */
	0x4D,0x02,"\xA7 \xC1,X",			/* CPY */
	0x5D,0x02,"\xA7 \xC1,Y",			/* CPY */
	0x6D,0x02,"\xA7 \xC1,Z",			/* CPY */
	0x37,0x84,0x7D,"\xA7 #\xD2",		/* CPY */
	0x17,0x84,0x4D,"\xA7 \xD2,X",		/* CPY */
	0x17,0x84,0x5D,"\xA7 \xD2,Y",		/* CPY */
	0x17,0x84,0x6D,"\xA7 \xD2,Z",		/* CPY */
	0x17,0x84,0x7D,"\xA7 \xD2",			/* CPY */
	0x4E,0x02,"\xA8 \xC1,X",			/* CPZ */
	0x5E,0x02,"\xA8 \xC1,Y",			/* CPZ */
	0x6E,0x02,"\xA8 \xC1,Z",			/* CPZ */
	0x37,0x84,0x7E,"\xA8 #\xD2",		/* CPZ */
	0x17,0x84,0x4E,"\xA8 \xD2,X",		/* CPZ */
	0x17,0x84,0x5E,"\xA8 \xD2,Y",		/* CPZ */
	0x17,0x84,0x6E,"\xA8 \xD2,Z",		/* CPZ */
	0x17,0x84,0x7E,"\xA8 \xD2",			/* CPZ */
	0x37,0x82,0x21,"\xA9",				/* DAA */
	0x01,0x02,"\xAA \xC1,X",			/* DEC */
	0x11,0x02,"\xAA \xC1,Y",			/* DEC */
	0x21,0x02,"\xAA \xC1,Z",			/* DEC */
	0x17,0x84,0x01,"\xAA \xD2,X",		/* DEC */
	0x17,0x84,0x11,"\xAA \xD2,Y",		/* DEC */
	0x17,0x84,0x21,"\xAA \xD2,Z",		/* DEC */
	0x17,0x84,0x31,"\xAA \xD2",			/* DEC */
	0x37,0x82,0x01,"\xAAA",				/* DECA */
	0x37,0x82,0x11,"\xAAB",				/* DECB */
	0x27,0x84,0x01,"\xAAW \xD2,X",		/* DECW */
	0x27,0x84,0x11,"\xAAW \xD2,Y",		/* DECW */
	0x27,0x84,0x21,"\xAAW \xD2,Z",		/* DECW */
	0x27,0x84,0x31,"\xAAW \xD2",		/* DECW */
	0x37,0x82,0x28,"\xABV",				/* EDIV */
	0x37,0x82,0x29,"\xABVS",			/* EDIVS */
	0x37,0x82,0x25,"\xACL",				/* EMUL */
	0x37,0x82,0x26,"\xACLS",			/* EMULS */
	0x44,0x02,"\xADA \xC1,X",			/* EORA */
	0x54,0x02,"\xADA \xC1,Y",			/* EORA */
	0x64,0x02,"\xADA \xC1,Z",			/* EORA */
	0x74,0x02,"\xADA #\xC1",			/* EORA */
	0x17,0x84,0x44,"\xADA \xD2,X",		/* EORA */
	0x17,0x84,0x54,"\xADA \xD2,Y",		/* EORA */
	0x17,0x84,0x64,"\xADA \xD2,Z",		/* EORA */
	0x17,0x84,0x74,"\xADA \xD2",		/* EORA */
	0x27,0x82,0x44,"\xADA E,X",			/* EORA */
	0x27,0x82,0x54,"\xADA E,Y",			/* EORA */
	0x27,0x82,0x64,"\xADA E,Z",			/* EORA */
	0xC4,0x02,"\xADB \xC1,X",			/* EORB */
	0xD4,0x02,"\xADB \xC1,Y",			/* EORB */
	0xE4,0x02,"\xADB \xC1,Z",			/* EORB */
	0xF4,0x02,"\xADB #\xC1",			/* EORB */
	0x17,0x84,0xC4,"\xADB \xD2,X",		/* EORB */
	0x17,0x84,0xD4,"\xADB \xD2,Y",		/* EORB */
	0x17,0x84,0xE4,"\xADB \xD2,Z",		/* EORB */
	0x17,0x84,0xF4,"\xADB \xD2",		/* EORB */
	0x27,0x82,0xC4,"\xADB E,X",			/* EORB */
	0x27,0x82,0xD4,"\xADB E,Y",			/* EORB */
	0x27,0x82,0xE4,"\xADB E,Z",			/* EORB */
	0x84,0x02,"\xADD \xC1,X",			/* EORD */
	0x94,0x02,"\xADD \xC1,Y",			/* EORD */
	0xA4,0x02,"\xADD \xC1,Z",			/* EORD */
	0x37,0x84,0xB4,"\xADD #\xD2",		/* EORD */
	0x37,0x84,0xC4,"\xADD \xD2,X",		/* EORD */
	0x37,0x84,0xD4,"\xADD \xD2,Y",		/* EORD */
	0x37,0x84,0xE4,"\xADD \xD2,Z",		/* EORD */
	0x37,0x84,0xF4,"\xADD \xD2",		/* EORD */
	0x27,0x82,0x84,"\xADD E,X",			/* EORD */
	0x27,0x82,0x94,"\xADD E,Y",			/* EORD */
	0x27,0x82,0xA4,"\xADD E,Z",			/* EORD */
	0x37,0x84,0x34,"\xADE #\xD2",		/* EORE */
	0x37,0x84,0x44,"\xADE \xD2,X",		/* EORE */
	0x37,0x84,0x54,"\xADE \xD2,Y",		/* EORE */
	0x37,0x84,0x64,"\xADE \xD2,Z",		/* EORE */
	0x37,0x84,0x74,"\xADE \xD2",		/* EORE */
	0x37,0x82,0x2B,"FDIV",
	0x37,0x82,0x27,"F\xC2S",			/* FMULS */
	0x37,0x82,0x2A,"IDIV",
	0x03,0x02,"\xAE \xC1,X",			/* INC */
	0x13,0x02,"\xAE \xC1,Y",			/* INC */
	0x23,0x02,"\xAE \xC1,Z",			/* INC */
	0x17,0x84,0x03,"\xAE \xD2,X",		/* INC */
	0x17,0x84,0x13,"\xAE \xD2,Y",		/* INC */
	0x17,0x84,0x23,"\xAE \xD2,Z",		/* INC */
	0x17,0x84,0x33,"\xAE \xD2",			/* INC */
	0x37,0x82,0x03,"\xAEA",				/* INCA */
	0x37,0x82,0x13,"\xAEB",				/* INCB */
	0x27,0x84,0x03,"\xAEW \xD2,X",		/* INCW */
	0x27,0x84,0x13,"\xAEW \xD2,Y",		/* INCW */
	0x27,0x84,0x23,"\xAEW \xD2,Z",		/* INCW */
	0x27,0x84,0x33,"\xAEW \xD2",		/* INCW */
	0x7A,0x04,"\xAF \xC1,\xD2",			/* JMP */
	0x4B,0x04,"\xAF \xC1,\xD2,X",		/* JMP */
	0x5B,0x04,"\xAF \xC1,\xD2,Y",		/* JMP */
	0x6B,0x04,"\xAF \xC1,\xD2,Z",		/* JMP */
	0x7A,0x84,0x00,"\xAF \xD2",			/* JMP */
	0x4B,0x84,0x00,"\xAF \xD2,X",		/* JMP */
	0x5B,0x84,0x00,"\xAF \xD2,Y",		/* JMP */
	0x6B,0x84,0x00,"\xAF \xD2,Z",		/* JMP */
	0xFA,0x04,"\xB0 \xC1,\xD2",			/* JSR */
	0x89,0x04,"\xB0 \xC1,\xD2,X",		/* JSR */
	0x99,0x04,"\xB0 \xC1,\xD2,Y",		/* JSR */
	0xA9,0x04,"\xB0 \xC1,\xD2,Z",		/* JSR */
	0xFA,0x84,0x00,"\xB0 \xD2",			/* JSR */
	0x89,0x84,0x00,"\xB0 \xD2,X",		/* JSR */
	0x99,0x84,0x00,"\xB0 \xD2,Y",		/* JSR */
	0xA9,0x84,0x00,"\xB0 \xD2,Z",		/* JSR */
	0x37,0x84,0x84,"\xB1C \xF2",		/* LBCC */
	0x37,0x84,0x85,"\xB1S \xF2",		/* LBCS */
	0x37,0x84,0x87,"\xB2Q \xF2",		/* LBEQ */
	0x37,0x84,0x8C,"\xB3E \xF2",		/* LBGE */
	0x37,0x84,0x8E,"\xB3T \xF2",		/* LBGT */
	0x37,0x84,0x82,"L\x8F \xF2",		/* LBHI */
	0x37,0x84,0x8F,"\xB4E \xF2",		/* LBLE */
	0x37,0x84,0x83,"\xB4S \xF2",		/* LBLS */
	0x37,0x84,0x8D,"\xB4T \xF2",		/* LBLT */
	0x37,0x84,0x8B,"\xB5I \xF2",		/* LBMI */
	0x37,0x84,0x86,"L\x94 \xF2",		/* LBNE */
	0x37,0x84,0x8A,"L\x95 \xF2",		/* LBPL */
	0x37,0x84,0x80,"\xB6A \xF2",		/* LBRA */
	0x37,0x84,0x81,"\xB6N \xF2",		/* LBRN */
	0x37,0x84,0x88,"\xB7C \xF2",		/* LBVC */
	0x37,0x84,0x89,"\xB7S \xF2",		/* LBVS */
	0x37,0x84,0x91,"\xB2V \xF2",		/* LBEV */
	0x37,0x84,0x90,"\xB5V \xF2",		/* LBMV */
	0x27,0x84,0xF9,"L\x9A \xF2",		/* LBSR */
	0x45,0x02,"\xB8A \xC1,X",			/* LDAA */
	0x55,0x02,"\xB8A \xC1,Y",			/* LDAA */
	0x65,0x02,"\xB8A \xC1,Z",			/* LDAA */
	0x75,0x02,"\xB8A #\xC1",			/* LDAA */
	0x17,0x84,0x45,"\xB8A \xD2,X",		/* LDAA */
	0x17,0x84,0x55,"\xB8A \xD2,Y",		/* LDAA */
	0x17,0x84,0x65,"\xB8A \xD2,Z",		/* LDAA */
	0x17,0x84,0x75,"\xB8A \xD2",		/* LDAA */
	0x27,0x82,0x45,"\xB8A E,X",			/* LDAA */
	0x27,0x82,0x55,"\xB8A E,Y",			/* LDAA */
	0x27,0x82,0x65,"\xB8A E,Z",			/* LDAA */
	0xC5,0x02,"\xB8B \xC1,X",			/* LDAB */
	0xD5,0x02,"\xB8B \xC1,Y",			/* LDAB */
	0xE5,0x02,"\xB8B \xC1,Z",			/* LDAB */
	0xF5,0x02,"\xB8B #\xC1",			/* LDAB */
	0x17,0x84,0xC5,"\xB8B \xD2,X",		/* LDAB */
	0x17,0x84,0xD5,"\xB8B \xD2,Y",		/* LDAB */
	0x17,0x84,0xE5,"\xB8B \xD2,Z",		/* LDAB */
	0x17,0x84,0xF5,"\xB8B \xD2",		/* LDAB */
	0x27,0x82,0xC5,"\xB8B E,X",			/* LDAB */
	0x27,0x82,0xD5,"\xB8B E,Y",			/* LDAB */
	0x27,0x82,0xE5,"\xB8B E,Z",			/* LDAB */
	0x85,0x02,"\xB9 \xC1,X",			/* LDD */
	0x95,0x02,"\xB9 \xC1,Y",			/* LDD */
	0xA5,0x02,"\xB9 \xC1,Z",			/* LDD */
	0x37,0x84,0xB5,"\xB9 #\xD2",		/* LDD */
	0x37,0x84,0xC5,"\xB9 \xD2,X",		/* LDD */
	0x37,0x84,0xD5,"\xB9 \xD2,Y",		/* LDD */
	0x37,0x84,0xE5,"\xB9 \xD2,Z",		/* LDD */
	0x37,0x84,0xF5,"\xB9 \xD2",			/* LDD */
	0x27,0x82,0x85,"\xB9 E,X",			/* LDD */
	0x27,0x82,0x95,"\xB9 E,Y",			/* LDD */
	0x27,0x82,0xA5,"\xB9 E,Z",			/* LDD */
	0x37,0x84,0x35,"\xBA #\xD2",		/* LDE */
	0x37,0x84,0x45,"\xBA \xD2,X",		/* LDE */
	0x37,0x84,0x55,"\xBA \xD2,Y",		/* LDE */
	0x37,0x84,0x65,"\xBA \xD2,Z",		/* LDE */
	0x37,0x84,0x75,"\xBA \xD2",			/* LDE */
	0x27,0x84,0x71,"\xBAD \xD2",		/* LDED */
	0x27,0x82,0xB0,"LDHI",
	0xCF,0x02,"\xBB \xC1,X",			/* LDS */
	0xDF,0x02,"\xBB \xC1,Y",			/* LDS */
	0xEF,0x02,"\xBB \xC1,Z",			/* LDS */
	0x37,0x84,0xBF,"\xBB #\xD2",		/* LDS */
	0x17,0x84,0xCF,"\xBB \xD2,X",		/* LDS */
	0x17,0x84,0xDF,"\xBB \xD2,Y",		/* LDS */
	0x17,0x84,0xEF,"\xBB \xD2,Z",		/* LDS */
	0x17,0x84,0xFF,"\xBB \xD2",			/* LDS */
	0xCC,0x02,"\xBC \xC1,X",			/* LDX */
	0xDC,0x02,"\xBC \xC1,Y",			/* LDX */
	0xEC,0x02,"\xBC \xC1,Z",			/* LDX */
	0x37,0x84,0xBC,"\xBC #\xD2",		/* LDX */
	0x17,0x84,0xCC,"\xBC \xD2,X",		/* LDX */
	0x17,0x84,0xDC,"\xBC \xD2,Y",		/* LDX */
	0x17,0x84,0xEC,"\xBC \xD2,Z",		/* LDX */
	0x17,0x84,0xFC,"\xBC \xD2",			/* LDX */
	0xCD,0x02,"\xBD \xC1,X",			/* LDY */
	0xDD,0x02,"\xBD \xC1,Y",			/* LDY */
	0xED,0x02,"\xBD \xC1,Z",			/* LDY */
	0x37,0x84,0xBD,"\xBD #\xD2",		/* LDY */
	0x17,0x84,0xCD,"\xBD \xD2,X",		/* LDY */
	0x17,0x84,0xDD,"\xBD \xD2,Y",		/* LDY */
	0x17,0x84,0xED,"\xBD \xD2,Z",		/* LDY */
	0x17,0x84,0xFD,"\xBD \xD2",			/* LDY */
	0xCE,0x02,"\xBE \xC1,X",			/* LDZ */
	0xDE,0x02,"\xBE \xC1,Y",			/* LDZ */
	0xEE,0x02,"\xBE \xC1,Z",			/* LDZ */
	0x37,0x84,0xBE,"\xBE #\xD2",		/* LDZ */
	0x17,0x84,0xCE,"\xBE \xD2,X",		/* LDZ */
	0x17,0x84,0xDE,"\xBE \xD2,Y",		/* LDZ */
	0x17,0x84,0xEE,"\xBE \xD2,Z",		/* LDZ */
	0x17,0x84,0xFE,"\xBE \xD2",			/* LDZ */
	0x27,0x82,0xF1,"LPSTOP",
	0x0F,0x02,"\xBF \xC1,X",			/* LSR */
	0x1F,0x02,"\xBF \xC1,Y",			/* LSR */
	0x2F,0x02,"\xBF \xC1,Z",			/* LSR */
	0x17,0x84,0x0F,"\xBF \xD2,X",		/* LSR */
	0x17,0x84,0x1F,"\xBF \xD2,Y",		/* LSR */
	0x17,0x84,0x2F,"\xBF \xD2,Z",		/* LSR */
	0x17,0x84,0x3F,"\xBF \xD2",			/* LSR */
	0x37,0x82,0x0F,"\xBFA",				/* LSRA */
	0x37,0x82,0x1F,"\xBFB",				/* LSRB */
	0x27,0x82,0xFF,"\xBFD",				/* LSRD */
	0x27,0x82,0x7F,"\xBFE",				/* LSRE */
	0x27,0x84,0x0F,"\xBFW \xD2,X",		/* LSRW */
	0x27,0x84,0x1F,"\xBFW \xD2,Y",		/* LSRW */
	0x27,0x84,0x2F,"\xBFW \xD2,Z",		/* LSRW */
	0x27,0x84,0x3F,"\xBFW \xD2",		/* LSRW */
	0x7B,0x02,"\xC0 #\xC1",				/* MAC */
	0x30,0x04,"\xC1B \xC1,X,\xD2",		/* MOVB */
	0x32,0x04,"\xC1B \xD2,\xC1,X",		/* MOVB */
	0x37,0x86,0xFE,"\xC1B \xD2,\xD4",	/* MOVB */
	0x31,0x04,"\xC1W \xC1,X,\xD2",		/* MOVW */
	0x33,0x04,"\xC1W \xD2,\xC1,X",		/* MOVW */
	0x37,0x86,0xFF,"\xC1W \xD2,\xD4",	/* MOVW */
	0x37,0x82,0x24,"\xC2",				/* MUL */
	0x02,0x02,"\xC3 \xC1,X",			/* NEG */
	0x12,0x02,"\xC3 \xC1,Y",			/* NEG */
	0x22,0x02,"\xC3 \xC1,Z",			/* NEG */
	0x17,0x84,0x02,"\xC3 \xD2,X",		/* NEG */
	0x17,0x84,0x12,"\xC3 \xD2,Y",		/* NEG */
	0x17,0x84,0x22,"\xC3 \xD2,Z",		/* NEG */
	0x17,0x84,0x32,"\xC3 \xD2",			/* NEG */
	0x37,0x82,0x02,"\xC3A",				/* NEGA */
	0x37,0x82,0x12,"\xC3B",				/* NEGB */
	0x27,0x82,0xF2,"\xC3D",				/* NEGD */
	0x27,0x82,0x72,"\xC3E",				/* NEGE */
	0x27,0x84,0x02,"\xC3W \xD2,X",		/* NEGW */
	0x27,0x84,0x12,"\xC3W \xD2,Y",		/* NEGW */
	0x27,0x84,0x22,"\xC3W \xD2,Z",		/* NEGW */
	0x27,0x84,0x32,"\xC3W \xD2",		/* NEGW */
	0x27,0x82,0x4C,"NOP",
	0x47,0x02,"\xC4A \xC1,X",			/* ORAA */
	0x57,0x02,"\xC4A \xC1,Y",			/* ORAA */
	0x67,0x02,"\xC4A \xC1,Z",			/* ORAA */
	0x77,0x02,"\xC4A #\xC1",			/* ORAA */
	0x17,0x84,0x47,"\xC4A \xD2,X",		/* ORAA */
	0x17,0x84,0x57,"\xC4A \xD2,Y",		/* ORAA */
	0x17,0x84,0x67,"\xC4A \xD2,Z",		/* ORAA */
	0x17,0x84,0x77,"\xC4A \xD2",		/* ORAA */
	0x27,0x82,0x47,"\xC4A E,X",			/* ORAA */
	0x27,0x82,0x57,"\xC4A E,Y",			/* ORAA */
	0x27,0x82,0x67,"\xC4A E,Z",			/* ORAA */
	0xC7,0x02,"\xC4B \xC1,X",			/* ORAB */
	0xD7,0x02,"\xC4B \xC1,Y",			/* ORAB */
	0xE7,0x02,"\xC4B \xC1,Z",			/* ORAB */
	0xF7,0x02,"\xC4B #\xC1",			/* ORAB */
	0x17,0x84,0xC7,"\xC4B \xD2,X",		/* ORAB */
	0x17,0x84,0xD7,"\xC4B \xD2,Y",		/* ORAB */
	0x17,0x84,0xE7,"\xC4B \xD2,Z",		/* ORAB */
	0x17,0x84,0xF7,"\xC4B \xD2",		/* ORAB */
	0x27,0x82,0xC7,"\xC4B E,X",			/* ORAB */
	0x27,0x82,0xD7,"\xC4B E,Y",			/* ORAB */
	0x27,0x82,0xE7,"\xC4B E,Z",			/* ORAB */
	0x87,0x02,"\xC5 \xC1,X",			/* ORD */
	0x97,0x02,"\xC5 \xC1,Y",			/* ORD */
	0xA7,0x02,"\xC5 \xC1,Z",			/* ORD */
	0x37,0x84,0xB7,"\xC5 #\xD2",		/* ORD */
	0x37,0x84,0xC7,"\xC5 \xD2,X",		/* ORD */
	0x37,0x84,0xD7,"\xC5 \xD2,Y",		/* ORD */
	0x37,0x84,0xE7,"\xC5 \xD2,Z",		/* ORD */
	0x37,0x84,0xF7,"\xC5 \xD2",			/* ORD */
	0x27,0x82,0x87,"\xC5 E,X",			/* ORD */
	0x27,0x82,0x97,"\xC5 E,Y",			/* ORD */
	0x27,0x82,0xA7,"\xC5 E,Z",			/* ORD */
	0x37,0x84,0x37,"\xC6 #\xD2",		/* ORE */
	0x37,0x84,0x47,"\xC6 \xD2,X",		/* ORE */
	0x37,0x84,0x57,"\xC6 \xD2,Y",		/* ORE */
	0x37,0x84,0x67,"\xC6 \xD2,Z",		/* ORE */
	0x37,0x84,0x77,"\xC6 \xD2",			/* ORE */
	0x37,0x84,0x3B,"ORP #\xD2",
	0x37,0x82,0x08,"\xC7A",				/* PSHA */
	0x37,0x82,0x18,"\xC7B",				/* PSHB */
	0x27,0x82,0xB8,"\xC7MAC",			/* PSHMAC */
	0x37,0x82,0x09,"\xC8A",				/* PULA */
	0x37,0x82,0x19,"\xC8B",				/* PULB */
	0x27,0x82,0xB9,"\xC8MAC",			/* PULMAC */
	0xFB,0x02,"R\xC0 #\xC1",			/* RMAC */
	0x0C,0x02,"\xC9 \xC1,X",			/* ROL */
	0x1C,0x02,"\xC9 \xC1,Y",			/* ROL */
	0x2C,0x02,"\xC9 \xC1,Z",			/* ROL */
	0x17,0x84,0x0C,"\xC9 \xD2,X",		/* ROL */
	0x17,0x84,0x1C,"\xC9 \xD2,Y",		/* ROL */
	0x17,0x84,0x2C,"\xC9 \xD2,Z",		/* ROL */
	0x17,0x84,0x3C,"\xC9 \xD2",			/* ROL */
	0x37,0x82,0x0C,"\xC9A",				/* ROLA */
	0x37,0x82,0x1C,"\xC9B",				/* ROLB */
	0x27,0x82,0xFC,"\xC9D",				/* ROLD */
	0x27,0x82,0x7C,"\xC9E",				/* ROLE */
	0x27,0x84,0x0C,"\xC9W \xD2,X",		/* ROLW */
	0x27,0x84,0x1C,"\xC9W \xD2,Y",		/* ROLW */
	0x27,0x84,0x2C,"\xC9W \xD2,Z",		/* ROLW */
	0x27,0x84,0x3C,"\xC9W \xD2",		/* ROLW */
	0x0E,0x02,"\xCA \xC1,X",			/* ROR */
	0x1E,0x02,"\xCA \xC1,Y",			/* ROR */
	0x2E,0x02,"\xCA \xC1,Z",			/* ROR */
	0x17,0x84,0x0E,"\xCA \xD2,X",		/* ROR */
	0x17,0x84,0x1E,"\xCA \xD2,Y",		/* ROR */
	0x17,0x84,0x2E,"\xCA \xD2,Z",		/* ROR */
	0x17,0x84,0x3E,"\xCA \xD2",			/* ROR */
	0x37,0x82,0x0E,"\xCAA",				/* RORA */
	0x37,0x82,0x1E,"\xCAB",				/* RORB */
	0x27,0x82,0xFE,"\xCAD",				/* RORD */
	0x27,0x82,0x7E,"\xCAE",				/* RORE */
	0x27,0x84,0x0E,"\xCAW \xD2,X",		/* RORW */
	0x27,0x84,0x1E,"\xCAW \xD2,Y",		/* RORW */
	0x27,0x84,0x2E,"\xCAW \xD2,Z",		/* RORW */
	0x27,0x84,0x3E,"\xCAW \xD2",		/* RORW */
	0x27,0x82,0x77,"RTI",
	0x27,0x82,0xF7,"RTS",
	0x37,0x82,0x0A,"SBA",
	0x42,0x02,"\xCBA \xC1,X",			/* SBCA */
	0x52,0x02,"\xCBA \xC1,Y",			/* SBCA */
	0x62,0x02,"\xCBA \xC1,Z",			/* SBCA */
	0x72,0x02,"\xCBA #\xC1",			/* SBCA */
	0x17,0x84,0x42,"\xCBA \xD2,X",		/* SBCA */
	0x17,0x84,0x52,"\xCBA \xD2,Y",		/* SBCA */
	0x17,0x84,0x62,"\xCBA \xD2,Z",		/* SBCA */
	0x17,0x84,0x72,"\xCBA \xD2",		/* SBCA */
	0x27,0x82,0x42,"\xCBA E,X",			/* SBCA */
	0x27,0x82,0x52,"\xCBA E,Y",			/* SBCA */
	0x27,0x82,0x62,"\xCBA E,Z",			/* SBCA */
	0xC2,0x02,"\xCBB \xC1,X",			/* SBCB */
	0xD2,0x02,"\xCBB \xC1,Y",			/* SBCB */
	0xE2,0x02,"\xCBB \xC1,Z",			/* SBCB */
	0xF2,0x02,"\xCBB #\xC1",			/* SBCB */
	0x17,0x84,0xC2,"\xCBB \xD2,X",		/* SBCB */
	0x17,0x84,0xD2,"\xCBB \xD2,Y",		/* SBCB */
	0x17,0x84,0xE2,"\xCBB \xD2,Z",		/* SBCB */
	0x17,0x84,0xF2,"\xCBB \xD2",		/* SBCB */
	0x27,0x82,0xC2,"\xCBB E,X",			/* SBCB */
	0x27,0x82,0xD2,"\xCBB E,Y",			/* SBCB */
	0x27,0x82,0xE2,"\xCBB E,Z",			/* SBCB */
	0x82,0x02,"\xCBD \xC1,X",			/* SBCD */
	0x92,0x02,"\xCBD \xC1,Y",			/* SBCD */
	0xA2,0x02,"\xCBD \xC1,Z",			/* SBCD */
	0x37,0x84,0xB2,"\xCBD #\xD2",		/* SBCD */
	0x37,0x84,0xC2,"\xCBD \xD2,X",		/* SBCD */
	0x37,0x84,0xD2,"\xCBD \xD2,Y",		/* SBCD */
	0x37,0x84,0xE2,"\xCBD \xD2,Z",		/* SBCD */
	0x37,0x84,0xF2,"\xCBD \xD2",		/* SBCD */
	0x27,0x82,0x82,"\xCBD E,X",			/* SBCD */
	0x27,0x82,0x92,"\xCBD E,Y",			/* SBCD */
	0x27,0x82,0xA2,"\xCBD E,Z",			/* SBCD */
	0x37,0x84,0x32,"\xCBE #\xD2",		/* SBCE */
	0x37,0x84,0x42,"\xCBE \xD2,X",		/* SBCE */
	0x37,0x84,0x52,"\xCBE \xD2,Y",		/* SBCE */
	0x37,0x84,0x62,"\xCBE \xD2,Z",		/* SBCE */
	0x37,0x84,0x72,"\xCBE \xD2",		/* SBCE */
	0x27,0x82,0x79,"SDE",
	0x4A,0x02,"\xCCA \xC1,X",			/* STAA */
	0x5A,0x02,"\xCCA \xC1,Y",			/* STAA */
	0x6A,0x02,"\xCCA \xC1,Z",			/* STAA */
	0x17,0x84,0x4A,"\xCCA \xD2,X",		/* STAA */
	0x17,0x84,0x5A,"\xCCA \xD2,Y",		/* STAA */
	0x17,0x84,0x6A,"\xCCA \xD2,Z",		/* STAA */
	0x17,0x84,0x7A,"\xCCA \xD2",		/* STAA */
	0x27,0x82,0x4A,"\xCCA E,X",			/* STAA */
	0x27,0x82,0x5A,"\xCCA E,Y",			/* STAA */
	0x27,0x82,0x6A,"\xCCA E,Z",			/* STAA */
	0xCA,0x02,"\xCCB \xC1,X",			/* STAB */
	0xDA,0x02,"\xCCB \xC1,Y",			/* STAB */
	0xEA,0x02,"\xCCB \xC1,Z",			/* STAB */
	0x17,0x84,0xCA,"\xCCB \xD2,X",		/* STAB */
	0x17,0x84,0xDA,"\xCCB \xD2,Y",		/* STAB */
	0x17,0x84,0xEA,"\xCCB \xD2,Z",		/* STAB */
	0x17,0x84,0xFA,"\xCCB \xD2",		/* STAB */
	0x27,0x82,0xCA,"\xCCB E,X",			/* STAB */
	0x27,0x82,0xDA,"\xCCB E,Y",			/* STAB */
	0x27,0x82,0xEA,"\xCCB E,Z",			/* STAB */
	0x8A,0x02,"\xCD \xC1,X",			/* STD */
	0x9A,0x02,"\xCD \xC1,Y",			/* STD */
	0xAA,0x02,"\xCD \xC1,Z",			/* STD */
	0x37,0x84,0xCA,"\xCD \xD2,X",		/* STD */
	0x37,0x84,0xDA,"\xCD \xD2,Y",		/* STD */
	0x37,0x84,0xEA,"\xCD \xD2,Z",		/* STD */
	0x37,0x84,0xFA,"\xCD \xD2",			/* STD */
	0x27,0x82,0x8A,"\xCD E,X",			/* STD */
	0x27,0x82,0x9A,"\xCD E,Y",			/* STD */
	0x27,0x82,0xAA,"\xCD E,Z",			/* STD */
	0x37,0x84,0x4A,"\xCE \xD2,X",		/* STE */
	0x37,0x84,0x5A,"\xCE \xD2,Y",		/* STE */
	0x37,0x84,0x6A,"\xCE \xD2,Z",		/* STE */
	0x37,0x84,0x7A,"\xCE \xD2",			/* STE */
	0x27,0x84,0x73,"\xCED \xD2",		/* STED */
	0x8F,0x02,"\xCF \xC1,X",			/* STS */
	0x9F,0x02,"\xCF \xC1,Y",			/* STS */
	0xAF,0x02,"\xCF \xC1,Z",			/* STS */
	0x17,0x84,0x8F,"\xCF \xD2,X",		/* STS */
	0x17,0x84,0x9F,"\xCF \xD2,Y",		/* STS */
	0x17,0x84,0xAF,"\xCF \xD2,Z",		/* STS */
	0x17,0x84,0xBF,"\xCF \xD2",			/* STS */
	0x8C,0x02,"\xD0 \xC1,X",			/* STX */
	0x9C,0x02,"\xD0 \xC1,Y",			/* STX */
	0xAC,0x02,"\xD0 \xC1,Z",			/* STX */
	0x17,0x84,0x8C,"\xD0 \xD2,X",		/* STX */
	0x17,0x84,0x9C,"\xD0 \xD2,Y",		/* STX */
	0x17,0x84,0xAC,"\xD0 \xD2,Z",		/* STX */
	0x17,0x84,0xBC,"\xD0 \xD2",			/* STX */
	0x8D,0x02,"\xD1 \xC1,X",			/* STY */
	0x9D,0x02,"\xD1 \xC1,Y",			/* STY */
	0xAD,0x02,"\xD1 \xC1,Z",			/* STY */
	0x17,0x84,0x8D,"\xD1 \xD2,X",		/* STY */
	0x17,0x84,0x9D,"\xD1 \xD2,Y",		/* STY */
	0x17,0x84,0xAD,"\xD1 \xD2,Z",		/* STY */
	0x17,0x84,0xBD,"\xD1 \xD2",			/* STY */
	0x8E,0x02,"\xD2 \xC1,X",			/* STZ */
	0x9E,0x02,"\xD2 \xC1,Y",			/* STZ */
	0xAE,0x02,"\xD2 \xC1,Z",			/* STZ */
	0x17,0x84,0x8E,"\xD2 \xD2,X",		/* STZ */
	0x17,0x84,0x9E,"\xD2 \xD2,Y",		/* STZ */
	0x17,0x84,0xAE,"\xD2 \xD2,Z",		/* STZ */
	0x17,0x84,0xBE,"\xD2 \xD2",			/* STZ */
	0x40,0x02,"\xD3A \xC1,X",			/* SUBA */
	0x50,0x02,"\xD3A \xC1,Y",			/* SUBA */
	0x60,0x02,"\xD3A \xC1,Z",			/* SUBA */
	0x70,0x02,"\xD3A #\xC1",			/* SUBA */
	0x17,0x84,0x40,"\xD3A \xD2,X",		/* SUBA */
	0x17,0x84,0x50,"\xD3A \xD2,Y",		/* SUBA */
	0x17,0x84,0x60,"\xD3A \xD2,Z",		/* SUBA */
	0x17,0x84,0x70,"\xD3A \xD2",		/* SUBA */
	0x27,0x82,0x40,"\xD3A E,X",			/* SUBA */
	0x27,0x82,0x50,"\xD3A E,Y",			/* SUBA */
	0x27,0x82,0x60,"\xD3A E,Z",			/* SUBA */
	0xC0,0x02,"\xD3B \xC1,X",			/* SUBB */
	0xD0,0x02,"\xD3B \xC1,Y",			/* SUBB */
	0xE0,0x02,"\xD3B \xC1,Z",			/* SUBB */
	0xF0,0x02,"\xD3B #\xC1",			/* SUBB */
	0x17,0x84,0xC0,"\xD3B \xD2,X",		/* SUBB */
	0x17,0x84,0xD0,"\xD3B \xD2,Y",		/* SUBB */
	0x17,0x84,0xE0,"\xD3B \xD2,Z",		/* SUBB */
	0x17,0x84,0xF0,"\xD3B \xD2",		/* SUBB */
	0x27,0x82,0xC0,"\xD3B E,X",			/* SUBB */
	0x27,0x82,0xD0,"\xD3B E,Y",			/* SUBB */
	0x27,0x82,0xE0,"\xD3B E,Z",			/* SUBB */
	0x80,0x02,"\xD3D \xC1,X",			/* SUBD */
	0x90,0x02,"\xD3D \xC1,Y",			/* SUBD */
	0xA0,0x02,"\xD3D \xC1,Z",			/* SUBD */
	0x37,0x84,0xB0,"\xD3D #\xD2",		/* SUBD */
	0x37,0x84,0xC0,"\xD3D \xD2,X",		/* SUBD */
	0x37,0x84,0xD0,"\xD3D \xD2,Y",		/* SUBD */
	0x37,0x84,0xE0,"\xD3D \xD2,Z",		/* SUBD */
	0x37,0x84,0xF0,"\xD3D \xD2",		/* SUBD */
	0x27,0x82,0x80,"\xD3D E,X",			/* SUBD */
	0x27,0x82,0x90,"\xD3D E,Y",			/* SUBD */
	0x27,0x82,0xA0,"\xD3D E,Z",			/* SUBD */
	0x37,0x84,0x30,"\xD3E #\xD2",		/* SUBE */
	0x37,0x84,0x40,"\xD3E \xD2,X",		/* SUBE */
	0x37,0x84,0x50,"\xD3E \xD2,Y",		/* SUBE */
	0x37,0x84,0x60,"\xD3E \xD2,Z",		/* SUBE */
	0x37,0x84,0x70,"\xD3E \xD2",		/* SUBE */
	0x37,0x82,0x20,"SWI",
	0x27,0x82,0xF8,"SXT",
	0x37,0x82,0x17,"\xD4",				/* TAB */
	0x37,0x82,0xFD,"TAP",
	0x37,0x82,0x07,"TBA",
	0x27,0x82,0xFA,"TBEK",
	0x37,0x82,0x9F,"TBSK",
	0x37,0x82,0x9C,"TBXK",
	0x37,0x82,0x9D,"TBYK",
	0x37,0x82,0x9E,"TBZK",
	0x27,0x82,0x7B,"TDE",
	0x37,0x82,0x2F,"TDMSK",
	0x37,0x82,0x2D,"TDP",
	0x27,0x82,0xFB,"\xD5",				/* TED */
	0x27,0x82,0xB1,"\xD5M",				/* TEDM */
	0x27,0x82,0xBB,"TEKB",
	0x27,0x82,0xB2,"TEM",
	0x27,0x82,0xB4,"\xD6R",				/* TMER */
	0x27,0x82,0xB5,"\xD6T",				/* TMET */
	0x27,0x82,0xB3,"TMXED",
	0x37,0x82,0xFC,"TPA",
	0x37,0x82,0x2C,"TPD",
	0x37,0x82,0xAF,"TSKB",
	0x06,0x02,"\xD7 \xC1,X",			/* TST */
	0x16,0x02,"\xD7 \xC1,Y",			/* TST */
	0x26,0x02,"\xD7 \xC1,Z",			/* TST */
	0x17,0x84,0x06,"\xD7 \xD2,X",		/* TST */
	0x17,0x84,0x16,"\xD7 \xD2,Y",		/* TST */
	0x17,0x84,0x26,"\xD7 \xD2,Z",		/* TST */
	0x17,0x84,0x36,"\xD7 \xD2",			/* TST */
	0x37,0x82,0x06,"\xD7A",				/* TSTA */
	0x37,0x82,0x16,"\xD7B",				/* TSTB */
	0x27,0x82,0xF6,"\xD7D",				/* TSTD */
	0x27,0x82,0x76,"\xD7E",				/* TSTE */
	0x27,0x84,0x06,"\xD7W \xD2,X",		/* TSTW */
	0x27,0x84,0x16,"\xD7W \xD2,Y",		/* TSTW */
	0x27,0x84,0x26,"\xD7W \xD2,Z",		/* TSTW */
	0x27,0x84,0x36,"\xD7W \xD2",		/* TSTW */
	0x27,0x82,0x4F,"TSX",
	0x27,0x82,0x5F,"TSY",
	0x27,0x82,0x6F,"TSZ",
	0x37,0x82,0xAC,"TXKB",
	0x37,0x82,0x4E,"TXS",
	0x27,0x82,0x5C,"TXY",
	0x27,0x82,0x6C,"TXZ",
	0x37,0x82,0xAD,"TYKB",
	0x37,0x82,0x5E,"TYS",
	0x27,0x82,0x4D,"TYX",
	0x27,0x82,0x6D,"TYZ",
	0x37,0x82,0xAE,"TZKB",
	0x37,0x82,0x6E,"TZS",
	0x27,0x82,0x4E,"TZX",
	0x27,0x82,0x5E,"TZY",
	0x27,0x82,0xF3,"WAI",
	0x37,0x82,0x1A,"XGAB",
	0x27,0x82,0x7A,"\xD8E",				/* XGDE */
	0x37,0x82,0xCC,"\xD8X",				/* XGDX */
	0x37,0x82,0xDC,"\xD8Y",				/* XGDY */
	0x37,0x82,0xEC,"\xD8Z",				/* XGDZ */
	0x37,0x82,0x4C,"\xD9X",				/* XGEX */
	0x37,0x82,0x5C,"\xD9Y",				/* XGEY */
	0x37,0x82,0x6C,"\xD9Z",				/* XGEZ */
	0x34, 0x02, "PSHM \xC9",
	0x35, 0x02, "PULM \xC9",

	/*  This entry always matches invalid opcodes */
	0x00, 0x00, "FCB \xC0,\xC1" };

char *pshmreg[] = { "D", "E", "X", "Y", "Z", "K", "CC", "?" };
char *pulmreg[] = { "CC", "K", "Z", "Y", "X", "E", "D", "?" };

unsigned char opcode, opcode1, *inst_ptr;

/*
 * Get a word from memory in the proper "endian"
 * 68HC16 uses "big endian", 1st byte is HIGH, 2nd byte is LOW
 */
unsigned get_word(index)
	unsigned index;
{
	return (memory[index] << 8) | memory[index+1];
}

/*
 * Load an instruction into memory, determine it length, and
 * identify any symbol addresses it references.
 *
 * Entry:
 *	'memory' contains the first byte of the instruction only
 *	additional bytes may be obtained by calling getbyte()
 *	'dflag' indicates that symbol definitions should be performed.
 *	'bflag' indicates that byte symbols are to be defined.
 * Exit:
 *	'memory' must be filled with the remainder of the instruction
 *	'length' must be set to the length of the instruction
 *	set_symbol() must be called for values or addresses referenced
 *	in the operands of the instruction.
 */
load_instruction()
{
	unsigned i, type;
	unsigned char c, *ptr;
	char d;

	opcode = *memory;		/* Record opcode for later */
	opcode1 = memory[1] = getbyte();

	/* Search instruction table for this opcode */
	inst_ptr = itable;
	while(*inst_ptr++ != opcode) {
		if(!*inst_ptr++) {	/* 0 length = FCB */
			length = 2;
			return; }
		++inst_ptr;		/* Skip possible second byte */
	skip_to_next:
		while(*inst_ptr++); }

	/* Determine length & check second byte if required */
	length = (type = *inst_ptr++) & 0x07;
	if(type & 0x80) {
		if(*inst_ptr++ != opcode1)
			goto skip_to_next; }

	/* Load instruction into memory */
	for(i=2; i < length; ++i)
		memory[i] = getbyte();

	if(dflag) {
		ptr = inst_ptr;
		while(*ptr != ' ')
			if(!*ptr++)
				return;
		while(c = *ptr++) if((c & 0xC0) == 0xC0) {
			if(c & PCREL) {
				if(c & XBIT16) {
					set_symbol(get_word(c & 0x07)+address+6, BIT16);
					continue; }
				else {
					d = memory[c & 0x07];
					set_symbol((address+6)+(int)d, BIT16);
					continue; } }
			if(c & XBIT16) {
				set_symbol(get_word(c & 0x07), BIT16);
				continue; }
			if(bflag && !(c & XPSHM))
				set_symbol(memory[c & 0x07], BIT8); } }
}

/*
 * Display an instruction on the standard output stream
 *
 * Entry:
 *	'memory' - Contains the instruction data
 *	'length' - Contains length of instruction
 * Exit:
 *	instruction is written to stdout
 *	return value is length of string written
 *
 *	'printv()' can be used to output symbolic values
 */
display_instruction()
{
	unsigned i;
	unsigned char c, *ptr;
	char d;

	/* Display instruction name */
	i = 0;
	while((c = *inst_ptr++) != ' ') {
		if(!c)
			return i;
		if(c & 0x80) {
			ptr = inames + (c & 0x7F)*3;
			putc(*ptr++, stdout);
			putc(*ptr++, stdout);
			i += 2;
			c = *ptr; } 
		++i;
		putc(c, stdout); }

	/* Space if operands */
	do
		putc(' ', stdout);
	while(++i < 8);

	/* Display operands */
	while(c = *inst_ptr++) {
		if(c & 0x80) {
			if(c & PCREL) {
				if(c & XBIT16) {
					i += printv(get_word(c & 0x07)+address+6, BIT16);
					continue; }
				else {
					d = memory[c & 0x07];
					i += printv((address+6)+(int)d, BIT16);
					continue; } }
			if(c & XBIT16) {
				i += printv(get_word(c & 0x07), BIT16);
				continue; }
			if(c & XPSHM) {
				c = memory[1];
				d = 0;
				do {
					if(c & 0x01) {
						ptr = ((*memory == 0x34) ? pshmreg : pulmreg)[d];
						fputs(ptr, stdout);
						i += strlen(ptr);
						if(c & 0xFE) {
							putc(',', stdout);
							++i; } }
					++d; }
				while(c >>= 1);
				continue; }
			i += printv(memory[c & 0x07], BIT8);
			continue; }
		++i;
		putc(c, stdout); }

	return i;
}
