/* Stuff for _AVR_.  By Tom, the coolest student who wishes an A+ from the
coolest supervisor :).

	This file implements the parsing and displaying required for the AVR
dissassembler.  It is not the most efficient code I have ever written but it
gets the job done (hopefully).  Symbols for any type of field have been
included.  Some things don't work so nicely such as the pseudo-ops which
when decoded look wierd.  Some others like SBR will not appear correct because
the label will not display (the immed is inversed of the actual value it
was).
*/

/* !!!NEW SYMBOL!!! (used in test.c which is a copy of disasm.c) this
determines how long the opcode output can be (it was 3) */
#define op_size		4

/* Text strings that the disassembler needs */
char _cpu_[]	= "AVR";		/* Name of CPU */
char _cmd_[]	= "DISAVR";		/* Command name */
char _byte_[]	= "DB      ";	/* Directive to encode bytes */
char _word_[]	= "DW      ";	/* Directive to encode words */
char _string_[]	= "STR     ";	/* Directive to encode strings */

/* Modifiers
	1			5-bit Dest register
	2			5-bit source register
	3			4-bit R16+ (register)
	4			8-bit immd
	5			12-bit immd
	6			6-bit offset immd
	7			3-bit minor bit (BST for example)
	8			3-bit SREG bit
	9			3 bit minor bit in SREG
	a			6-bit port
	!			7-bit fields (Branches) (*)
	@			2-bit reg field (K,X,Y,Z)
	#			6-bit immd (ADIW, SBIW)
	$			22-bit constant (CALL)
	%			16-bit constant (LDS, STS)
	^			Just display opcode.
	&			Modifiers for LDD/STD
	*			5-bit port address (CBI/SBI)
*/

/* Table of instruction opcodes: 2MASK, 2COMPARE, 1TYPE/LENGTH, 1TEXT */
char itable[] = {
	/* 4 bit */
	0xF0, 0x00, 0x70, 0x00, 2, 'A','N','D','I',' ','3',',','4', 0,
	0xF0, 0x00, 0xE0, 0x00, 2, 'L','D','I',' ','3',',','4', 0,
	0xF0, 0x00, 0x60, 0x00, 2, 'O','R','I',' ','3',',','4', 0,
	0xF0, 0x00, 0x30, 0x00, 2, 'C','P','I',' ','3',',','4', 0,
	0xF0, 0x00, 0x40, 0x00, 2, 'S','B','C','I',' ','3',',','4', 0,
	0xF0, 0x00, 0xD0, 0x00, 2, 'R','C','A','L','L',' ','5', 0,
	0xF0, 0x00, 0xC0, 0x00, 2, 'R','J','M','P',' ','5', 0,
	0xF0, 0x00, 0x50, 0x00, 2, 'S','U','B','I',' ','3',',','4', 0,

	/* 5 bit */
	0xD2, 0x08, 0x80, 0x00, 2, 'L','D','&',' ','1',',','Z','6', 0,
	0xD2, 0x08, 0x80, 0x08, 2, 'L','D','&',' ','1',',','Y','6', 0,
	0xD2, 0x08, 0x82, 0x08, 2, 'S','T','&',' ','Y','6',',','1', 0,
	0xD2, 0x08, 0x82, 0x00, 2, 'S','T','&',' ','Z','6',',','1', 0,
	0xF8, 0x00, 0xB0, 0x00, 2, 'I','N',' ','1',',','a', 0,
	0xF8, 0x00, 0xB8, 0x00, 2, 'O','U','T',' ','a',',','1', 0,

	/* 6 bit */
	0xFC, 0x00, 0x14, 0x00, 2, 'C','P',' ','1',',','2', 0,
	0xFC, 0x00, 0x04, 0x00, 2, 'C','P','C',' ','1',',','2', 0,
	0xFC, 0x00, 0x1C, 0x00, 2, 'A','D','C',' ','1',',','2', 0,
	0xFC, 0x00, 0x0C, 0x00, 2, 'A','D','D',' ','1',',','2', 0,
	0xFC, 0x00, 0x20, 0x00, 2, 'A','N','D',' ','1',',','2', 0,
	0xFC, 0x00, 0xF4, 0x00, 2, 'B','R','B','C',' ','9',',','!', 0,
	0xFC, 0x00, 0xF0, 0x00, 2, 'B','R','B','S',' ','9',',','!', 0,
	0xFC, 0x00, 0x10, 0x00, 2, 'C','P','S','E',' ','1',',','2', 0,
	0xFC, 0x00, 0x2C, 0x00, 2, 'M','O','V',' ','1',',','2', 0,
	0xFC, 0x00, 0x9C, 0x00, 2, 'M','U','L',' ','1',',','2', 0,
	0xFC, 0x00, 0x24, 0x00, 2, 'E','O','R',' ','1',',','2', 0,
	0xFC, 0x00, 0x08, 0x00, 2, 'S','B','C',' ','1',',','2', 0,
	0xFC, 0x00, 0x28, 0x00, 2, 'O','R',' ','1',',','2', 0,
	0xFC, 0x00, 0x18, 0x00, 2, 'S','U','B',' ','1',',','2', 0,

	/* 7-bit */
	0xFE, 0x00, 0xFA, 0x00, 2, 'B','S','T',' ','1',',','7', 0,
	0xFE, 0x00, 0xFC, 0x00, 2, 'S','B','R','C',' ','1',',','7', 0,
	0xFE, 0x00, 0xFE, 0x00, 2, 'S','B','R','S',' ','1',',','7', 0,
	0xFE, 0x0F, 0x94, 0x02, 2, 'S','W','A','P',' ','1', 0,

	/* 8-bit */
	0xFF, 0x00, 0x96, 0x00, 2, 'A','D','I','W',' ','@',',','#', 0,
	0xFF, 0x00, 0x97, 0x00, 2, 'S','B','I','W',' ','@',',','#', 0,
	0xFE, 0x08, 0xF8, 0x00, 2, 'B','L','D',' ','1',',','7', 0,
	0xFF, 0x00, 0x98, 0x00, 2, 'C','B','I',' ','*',',','7', 0,
	0xFF, 0x00, 0x9A, 0x00, 2, 'S','B','I',' ','*',',','7', 0,
	0xFF, 0x00, 0x99, 0x00, 2, 'S','B','I','C',' ','*',',','7', 0,
	0xFF, 0x00, 0x9B, 0x00, 2, 'S','B','I','S',' ','*',',','7', 0,

	/* 10-bit */
	0xFE, 0x0E, 0x94, 0x0E, 4, 'C','A','L','L',' ','$', 0,
	0xFE, 0x0E, 0x94, 0x0C, 4, 'J','M','P',' ','$', 0,

	/* 11-bit */
	0xFE, 0x0F, 0x94, 0x05, 2, 'A','S','R',' ','1', 0,
	0xFF, 0x8F, 0x94, 0x88, 2, 'B','C','L','R',' ','8', 0,
	0xFF, 0x8F, 0x94, 0x08, 2, 'B','S','E','T',' ','8', 0,
	0xFE, 0x0F, 0x92, 0x0C, 2, 'S','T',' ','X',',','1', 0,
	0xFE, 0x0F, 0x92, 0x0D, 2, 'S','T',' ','X','+',',','1', 0,
	0xFE, 0x0F, 0x92, 0x0E, 2, 'S','T',' ','-','X',',','1', 0,
	0xFE, 0x0F, 0x82, 0x08, 2, 'S','T',' ','Y',',','1', 0,
	0xFE, 0x0F, 0x92, 0x09, 2, 'S','T',' ','Y','+',',','1', 0,
	0xFE, 0x0F, 0x92, 0x0A, 2, 'S','T',' ','-','Y',',','1', 0,
	0xFE, 0x0F, 0x82, 0x00, 2, 'S','T',' ','Z',',','1', 0,
	0xFE, 0x0F, 0x92, 0x01, 2, 'S','T',' ','Z','+',',','1', 0,
	0xFE, 0x0F, 0x92, 0x02, 2, 'S','T',' ','-','Z',',','1', 0,
	0xFE, 0x0F, 0x90, 0x0C, 2, 'L','D',' ','1',',','X', 0,
	0xFE, 0x0F, 0x90, 0x0D, 2, 'L','D',' ','1',',','X','+', 0,
	0xFE, 0x0F, 0x90, 0x0E, 2, 'L','D',' ','1',',','-','X', 0,
	0xFE, 0x0F, 0x80, 0x08, 2, 'L','D',' ','1',',','Y', 0,
	0xFE, 0x0F, 0x90, 0x09, 2, 'L','D',' ','1',',','Y','+', 0,
	0xFE, 0x0F, 0x90, 0x0A, 2, 'L','D',' ','1',',','-','Y', 0,
	0xFE, 0x0F, 0x80, 0x00, 2, 'L','D',' ','1',',','Z', 0,
	0xFE, 0x0F, 0x90, 0x01, 2, 'L','D',' ','1',',','Z','+', 0,
	0xFE, 0x0F, 0x90, 0x02, 2, 'L','D',' ','1',',','-','Z', 0,
	0xFE, 0x0F, 0x90, 0x00, 4, 'L','D','S',' ','1',',','%', 0,
	0xFE, 0x0F, 0x92, 0x00, 4, 'S','T','S',' ','%',',','1', 0,
	0xFE, 0x0F, 0x94, 0x07, 2, 'R','O','R',' ','1', 0,
	0xFE, 0x0F, 0x94, 0x00, 2, 'C','O','M',' ','1', 0,
	0xFE, 0x0F, 0x94, 0x0A, 2, 'D','E','C',' ','1', 0,
	0xFE, 0x0F, 0x94, 0x03, 2, 'I','N','C',' ','1', 0,
	0xFE, 0x0F, 0x94, 0x06, 2, 'L','S','R',' ','1', 0,
	0xFE, 0x0F, 0x94, 0x01, 2, 'N','E','G',' ','1', 0,
	0xFE, 0x0F, 0x90, 0x0F, 2, 'P','O','P',' ','1', 0,
	0xFE, 0x0F, 0x92, 0x0F, 2, 'P','U','S','H',' ','1', 0,

	/* 12 bits */
	0xFF, 0x0F, 0x95, 0x09, 2, 'I','C','A','L','L', 0,
	0xFF, 0x0F, 0x94, 0x09, 2, 'I','J','M','P', 0,

	/* the rest */
	0xFF, 0x9F, 0x95, 0x08, 2, 'R','E','T', 0,
	0xFF, 0x9F, 0x95, 0x18, 2, 'R','E','T','I', 0,
	0xFF, 0xEF, 0x95, 0x88, 2, 'S','L','E','E','P', 0,
	0xFF, 0xEF, 0x95, 0xC8, 2, 'L','P','M', 0,
	0xFF, 0xEF, 0x95, 0xA8, 2, 'W','D','R', 0,
	0xFF, 0xFF, 0x00, 0x00, 2, 'N','O','P', 0,

	/*  This entry always matches invalid opcodes */
	0x00, 0x00, 0x00, 0x00, 0x02, 'D','W',' ','^', 0 };

unsigned 		opcode;
unsigned char	*inst_ptr;

/*
 * Get a word from memory in the proper "endian"
 */
unsigned get_word(index)
	unsigned index;
{
	return (memory[index+1] << 8) | memory[index];
}

/*
 * Load an instruction into memory, determine it length, and
 * identify any symbol addresses it references.
 *
 * Entry:
 *	'memory' contains the first byte of the instruction only
 *	additional bytes may be obtained by calling getbyte()
 *	'dflag' indicates that symbol definitions should be performed.
 *	'bflag' indicates that byte symbols are to be defined.
 * Exit:
 *	'memory' must be filled with the remainder of the instruction
 *	'length' must be set to the length of the instruction
 *	set_symbol() must be called for values or addresses referenced
 *	in the operands of the instruction.
 */
load_instruction()
{
	unsigned i, temp;

	/* Record opcode for later */
	opcode = *memory | ((memory[1] = getbyte()) << 8);
//printf("Opcode: %04x\n", opcode);

	/* Search instruction table for this opcode */
	inst_ptr = itable;
	while(	((inst_ptr[0] & memory[1]) != inst_ptr[2]) ||
			((inst_ptr[1] & memory[0]) != inst_ptr[3]) ) {
		inst_ptr += 5;									/* Skip opcode+len */
		while(*inst_ptr++);  } 							/* skip text */

	length = *(inst_ptr + 4);							/* length */
//printf("len == %u\n", length);
	inst_ptr += 5;										/* Skip to text */

	/* Load instruction into memory */
	for(i=2; i < length; i++)
		memory[i] = getbyte();

	/* Add any operand to symbol table */
	if(dflag) {
		if(length > 2) {
			set_symbol(get_word(2), BIT16); return; }

		// RJMP and RCALL
		if(((opcode & 0xF000) == 0xD000) || ((opcode & 0xF000) == 0xC000))
			set_symbol(((((opcode&0xFFF) | (opcode & 0x800 ? 0xF000 : 0))+1)*2)+address, BIT16);
		else if(((opcode & 0xFC00) == 0xF400) || ((opcode & 0xFC00) == 0xF000)) {
			temp = ((opcode >> 3) & 0x7F); temp |= temp & 0x40 ? 0xFFA0 : 0;
			set_symbol(address + temp + temp + 2, BIT16); }
		else if(bflag) {
			if(((opcode & 0xF800) == 0xB000) || ((opcode & 0xF800) == 0xB800))
				set_symbol((opcode & 15) | ((opcode >> 5) & 0x30), BIT8);
			else /* 8 bit immd */
				switch(opcode & 0xF000) {
				case 0x7000: case 0xE000: case 0x6000: case 0x3000:
				case 0x4000: case 0xD000: case 0xC000: case 0xA000:
					set_symbol((opcode & 15)|((opcode>>4)&15), BIT8); break;
				default: /* LD R,Y/Z+q */
					switch(opcode & 0xD208) {
					case 0x8000: case 0x8008:
						set_symbol((opcode & 7) | ((opcode >> 7) & 0x18) | ((opcode >> 8) & 0x20), BIT8); break;
					default: /* 6-bit immd */
						switch(opcode & 0xFF00) {
						case 0x9600: case 0x9700:
							set_symbol((opcode&15)|((opcode>>2)&0x30),BIT8); break;
						case 0x9800: case 0x9A00:
							set_symbol((opcode>>3)&31, BIT8); break; } } } } }
}

/*
 * Display an instruction on the standard output stream
 *
 * Entry:
 *	'memory' - Contains the instruction data
 *	'length' - Contains length of instruction
 * Exit:
 *	instruction is written to stdout
 *	return value is length of string written
 *
 *	'printv()' can be used to output symbolic values
 */
display_instruction()
{
	unsigned i, temp;
	unsigned char c;

	i = 0;
	while(*inst_ptr)
		switch(c = *inst_ptr++) {
			case ' ':	for(; i < 8; ++i) putc(' ', stdout); break;
			case '1':	i += printf("R%d", (opcode >> 4) & 31); break;
			case '2':	i += printf("R%d", ((opcode >> 5) & 16) | (opcode & 15)); break;
			case '3':	i += printf("R%d", 16 + ((opcode >> 4) & 15)); break;
			case '4':	i += printv((opcode & 15) | ((opcode >> 4) & 0xF0), BIT8); break;
			case '5':	i += printv(((((opcode&0xFFF) | (opcode & 0x800 ? 0xF000 : 0))+1)*2)+address, BIT16); break;
			case '6':
				if(temp = (opcode & 7) | ((opcode >> 7) & 0x18) | ((opcode >> 8) & 0x20)) {
					++i; putc('+', stdout); i += printv(temp, BIT8); }
				break;
			case '7':	++i; putc((opcode & 7)+'0', stdout);	break;
			case '8':	++i; putc("CZNVSHTI"[(opcode >> 4) & 7], stdout); break;
			case '9':	++i; putc("CZNVSHTI"[opcode & 7], stdout); break;
			case 'a':	i += printv((opcode & 15) | ((opcode >> 5) & 0x30), BIT8);	break;
			case '!':
				temp = ((opcode >> 3) & 0x7F);
				temp |= temp & 0x40 ? 0xFFC0 : 0;
				i += printv(address+temp+temp+2, BIT16); break;
			case '@':	putc('W' + ((opcode >> 4) & 3), stdout); ++i; break;
			case '#':	i += printv((opcode & 15) | ((opcode >> 2) & 0x30), BIT8); break;
			case '$':
				temp = get_word(2);
				i += printf("%u,",
					((((opcode >> 3) & 0x1E) | (opcode & 1)) << 1)
					| ((temp&0x8000) >> 15)
					);
			 	i += printv(temp*2, BIT16);
				break;
			case '%':	i += printv(get_word(2), BIT16); break;
			case '^':	i += printf("$%04x", opcode); break;
			case '&':
				if((opcode & 7) | ((opcode >> 6) & 0x30) | ((opcode >> 7) & 0x40)) {
					++i; putc('D', stdout); }
				break;
			case '*':	i += printv((opcode >> 3) & 31, BIT8); break;
			default:	++i; putc(c, stdout); break; }
	return i;
}