/*
 * Universal Cross Disassembler
 *
 * ?COPY.TXT 1991-2006 Dave Dunfield
 * **See COPY.TXT**.
 */
#include <stdio.h>

#define	SYMSIZE	45000	/* Maximum size of a symbol table */
#define	ADRANGE	1000		/* Number of address ranges */
#define	COMSIZE	128			/* Maximum size of a comment */

#define	SYMDEF	0x80		/* Symbol is defined */
#define	BIT16	0x40		/* Symbol is referenced as 16-bit */
#define	BIT8	0x20		/* Symbol is referenced as 8-bit */

/*
 * Symbol table variables
 */
unsigned char sym_pool[SYMSIZE];

/*
 * Address typing table variables
 */
unsigned adlow[ADRANGE], adhigh[ADRANGE], adtop=0;
unsigned char adtype[ADRANGE], *sym_top = &sym_pool;

/*
 * Command option flags
 */
unsigned begin = 0, size = -1, addr = 0, eline = 0, hbytes = 3,
char aflag = -1, bflag = 0, dflag = 0, eflag = -1, *eptr;
FILE *cfp = 0, *dfp = 0;

/*
 * Variables for reading file with unget capability
 */
unsigned char ugetf = 0, ugetc;
FILE *fp;

/*
 * Global variables containing instruction information
 */
unsigned char memory[128];
unsigned address, length;

/*
 * Variables for handling comments
 */
unsigned caddr = 0, cskip = 0;
char comment[COMSIZE+2], cflag;

/*
 * Symbol output flags
 */
char *flags[] = { "?", "B", "W", "B+W" };

#include "cpu.c"

/*
 * Report an error & terminate
 */
register error(unsigned args)
{
	char buffer[200];

	_format_(nargs() * 2 + &args, buffer);
	fprintf(stderr, "\nError in %s", eptr);
	if(eline) fprintf(stderr, ", Line(%u)", eline);
	fputs(": ", stderr);
	fputs(buffer, stderr);
	putc('\n', stderr);
	exit(-1);
}

/*
 * Parse value in a particular number base
 */
char *get_value(char *sptr, unsigned base, unsigned *vptr)
{
	char *ptr;
	unsigned value, c;

	while(isspace(*sptr))
		++sptr;
	switch(*(ptr = sptr)) {
		case '%' : base = 2; goto incptr;
		case '@' : base = 8; goto incptr;
		case '&' : base =10; goto incptr;
		case '$' : base =16;
		incptr: ++ptr; }
	value = 0;
	do {
		if(isdigit(c = *ptr))			/* convert numeric digits */
			c -= '0';
		else if(c >= 'a')				/* convert lower case alphabetics */
			c -= ('a' - 10);
		else if(c >= 'A')				/* convert upper case alphabetics */
			c -= ('A' - 10);
		else							/* not a valid "digit" */
			goto badnum;
		if(c >= base)					/* outside of base */
			goto badnum;
		value = (value * base) + c; }	/* include in total */
	while((*++ptr) && !isspace(*ptr));

	*vptr = value;
	while(isspace(*ptr))
		++ptr;
	return ptr;

badnum:
	error("Bad number: %s", sptr);
}

/*
 * Get byte from input file with possible unget pending
 */
getbyte()
{
	if(ugetf) {
		ugetf = 0;
		return ugetc; }
	return getc(fp);
}

/*
 * Add a symbol table entry
 */
set_symbol(value, flags)
	unsigned value, flags;
{
	unsigned i;
	unsigned char *ptr;

	/* Look for previously defined symbol */
	ptr = sym_pool;
	while(ptr < sym_top) {
		if(*(int*)ptr == value) {
			*(ptr+2) |= flags;
			return; }
		ptr += (*(ptr+2) & 0x1F) + 3; }

	/* New symbol, add to list */
	*(int*)sym_top = value;
	sym_top = (ptr = sym_top + 2) + 1;
	sprintf(sym_top,"H%04x", value);
	i = 0;
	while(*sym_top) {
		++i;
		++sym_top; }
	if((sym_pool+SYMSIZE) <= sym_top) {
		eptr = "Processing";
		error("Symbol table full"); }
	*ptr = flags | i;
}

/*
 * Get a byte from the code block text
 */
char get_text(offset) asm
{
	MOV	BX,4[BP]					; Get offset
	MOV	AL,CS:byte ptr HELLO[BX]	; Get byte
}
/*
 * Perform a disassembly
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i, j, l, s, atype, maxlen;
	unsigned char *ptr, *ptr1, c;

	if(argc < 2) {
		printf("\nDDS %s Cross Disassembler, Release 1.3\n\nUse: %s", _cpu_, _cmd_);
	i=0;
	while(c = get_text(i++))
		putc(c, stdout);
#ifdef CPU_OPTION
	fputs(cpu_help, stdout);
#endif
	while(c = get_text(i++))
		putc(c, stdout);
return; }

/* parse for command line options. */
	for(i=2; i < argc; ++i) {
		eline = 0;
		eptr = "Command line";
		if(*(ptr = ptr1 = argv[i]) == '-') {		/* Enable switch */
			while(*++ptr) switch(j = toupper(*ptr)) {
				case 'A' : aflag = 0;		break;
				case 'B' : bflag = -1;
				case 'D' : dflag = -1;		break;
				case 'E' : eflag = 0;		break;
				default:
				#ifdef CPU_OPTION
					if(cpu_option(j))
						continue;
				#endif
					goto badopt; }
			continue; }
		if(*++ptr == '=') switch(toupper(*(ptr++ - 1))) {
			case 'H' : get_value(ptr, 10, &hbytes);	continue;
			case 'A' : get_value(ptr, 16, &addr);	continue;
			case 'B' : get_value(ptr, 10, &begin);	continue;
			case 'C' :
				cfp = fopen(ptr, "rvq");
				continue;
			case 'D' :		/* Define table */
				fp = fopen(ptr, "rvq");
				eptr = "Definition file";
				while(fgets(ptr1 = memory, sizeof(memory), fp)) {
					++eline;
					if(*memory == '*')		/* Comment */
						continue;
					if(*memory == '!') {	/* Block definition */
						maxlen = 0;
					reselect:
						switch(*++ptr1) {
							default:
								if(isdigit(*ptr1)) {
									ptr1 = get_value(ptr1, 10, &maxlen)-1;
									goto reselect; }
								error("Bad block type: %s", memory);
							case '=' :				/* Special symbol */
								++ptr1;
								j = SYMDEF;
								goto defsym;
							case '<' : j=1; break;	/* Byte data - no symbol */
							case '[' : j=2; break;	/* Byte data - symbol */
							case '>' : j=3; break;	/* Word data - no symbol */
							case ']' : j=4; break;	/* Word data - symbol */
							case '\'': j=5; break;	/* Character data */
							case '"' : j=6; break;	/* String data */
							case '%' : j=7; }		/* Special opcodes */
						adtype[adtop] = (maxlen << 4) | j;
						++ptr1;
						if(*ptr1 == '#') {		/* Define block by size */
							adlow[adtop] = address;
							get_value(ptr1+1, 10, &j);
							address += (j - 1); }
						else {					/* Absolute address */
							ptr1 = get_value(ptr1, 16, &adlow[adtop]);
							if(*ptr1 == '#') {
								get_value(ptr1+1, 10, &j);
								address = (adlow[adtop] + j) - 1; }
							else
								get_value(ptr1, 16, &address); }
						adhigh[adtop++] = address++; }
					else {					/* Symbol definition */
						j = 0;
					defsym:
						ptr = sym_top+3;
						while((*ptr1) && !isspace(*ptr1))
							*ptr++ = *ptr1++;
						*ptr = 0;
						if(ptr == (sym_top+3))
							error("Bad symbol name: %s", memory);
						while(isspace(*ptr)) ++ptr;
						get_value(ptr1, 16, &address);
						*(int*)sym_top = address;
						sym_top = (ptr1 = sym_top + 2) + 1;
						while(*sym_top) {
							++j;
							++sym_top; }
						*ptr1 = j; } }
				fclose(fp);
				continue;
			case 'N' : get_value(ptr, 10, &size);	continue;
			case 'W' :
				dfp = fopen(ptr, "wvq");
				continue; }
	badopt:
		error("Bad option: %s\n", argv[i]); }

	fp = fopen(argv[1], "rvqb");
	stdout = setbuf(stdout, 512);
	if(!aflag)
		printf("         ORG     $%04x\n", addr);

	eptr = "Comment file";
	eline = 0;

top:
	for(i=0; i < begin; ++i)
		getbyte();
	address = addr;
	s = size;
	while(s-- && !((*memory = getbyte()) & 0xff00)) {

	/* Check for special address type */
	for(i=atype=0; i < adtop; ++i) {
		if((address >= adlow[i]) && (address <= adhigh[i])) {
			atype = adtype[i] & 15;
			maxlen = adtype[i] >> 4;
			break; } }

	/* Process data at this address to determine length */
	switch(atype) {
		case 0 :			/* standard CPU instruction */
		default:
			load_instruction(atype);
			break;
		case 1 :			/* Byte data */
		case 2 :			/* Byte data - possible symbol */
			if(!maxlen) maxlen = 10;
			if((length = (adhigh[i] - address) + 1) > maxlen) length = maxlen;
			for(i=1; i < length; ++i)
				memory[i] = getbyte();
			if((atype == 2) && dflag) {
				for(i=0; i < length; ++i)
					set_symbol(memory[i], BIT8); }
			break;
		case 3 :			/* Word data */
		case 4 :			/* Word data - possible symbol */
			if(!(maxlen *= 2)) maxlen = 8;
			length = ((adhigh[i] - address)+2) / 2;
			if((length *= 2) > maxlen) length = maxlen;
			for(i=1; i < length; ++i)
				memory[i] = getbyte();
			if(atype == 4) {
				for(i=0; i < length; i += 2)
					set_symbol(get_word(i), BIT16); }
			break;
		case 5 :			/* Character data */
			if(!maxlen) maxlen = 10;
			if((length = (adhigh[i] - address)+1) > maxlen) length = maxlen;
			for(i=1; i < length; ++i)
				memory[i] = getbyte(fp);
			break;
		case 6 :			/* String data */
			if(!maxlen) maxlen = 10;
			i = (adhigh[i] - address) + (length = 1);
			if(isprint(c = *memory) && (c != '"')) {
				while(length < i) {
					memory[length++] = ugetc = getbyte();
					if((ugetc == '"') || !isprint(ugetc)) {
						--length;
						ugetf = -1;
						break; }
					if(length >= 40)
						break; } }
			else {
				atype = 1;	/* Switch to byte data */
				while(length < i) {
					if(length >= maxlen)
						break;
					memory[length++] = ugetc = getbyte();
					if(isprint(ugetc) && (ugetc != '"')) {
						--length;
						ugetf = -1;
						break; } } } }

	/* If dumping symbols - Process */
		if(dflag) {
			address += length;
			continue; }

	/* Process comments from comment file */
	if(cfp) {
		nextcom: if(cskip)
			--cskip;
		else if(caddr <= address) {
			cflag = 0;
			++eline;
			if(!fgets(comment, sizeof(comment)-1, cfp)) {
				fclose(cfp);
				cfp = 0; }
			else switch(*comment) {
				case '@' :	/* Skip to address */
					get_value(comment+1, 16, &caddr);
					goto nextcom;
				case '#' :	/* Skip n lines */
					get_value(comment+1, 10, &cskip);
					goto nextcom;
				default:
					cflag = -1;
					break;
				case '*' :
					if(aflag)
						printf("%04x", address);
					for(i = (hbytes*4) + 3; i; --i)
						putc(' ', stdout);
					printf("%s\n", comment);
					goto nextcom; } } }

	/* If enabled, output disassembly format display options */
		if(aflag) {
			printf("%04x ", address);
			for(i=0; i < hbytes; ++i)
				printf(i < length ? "%02x " : "   ", memory[i]);
			putc(' ', stdout);
			for(i=0; i < hbytes; ++i) {
				c = (i < length) ? memory[i] : ' ';
				putc(((c >= ' ') && (c < 0x7f)) ? c : '.', stdout); }
			putc(' ', stdout); }

	/* Display any symbol occuring at this address */
		ptr = sym_pool;
		while(ptr < sym_top) {
			if((*(int*)ptr == address) && !(*(ptr+2) & SYMDEF)) {
				i = print_symbol(ptr, stdout);
				do
					putc(' ', stdout);
				while(++i < 9);
				*(ptr+2) |= SYMDEF;
				goto skipsp; }
			ptr += (*(ptr+2) & 0x1F) + 3; }
		printf("         ");
skipsp:

	/* Display disassembly data for this address */
	switch(atype) {
		case 0 :			/* Standard CPU instruction */
		default:
			l = display_instruction(atype);
			break;
		case 1 :			/* Byte data */
		case 2 :			/*	""	""	*/
		case 5 :			/* Character data */
			fputs(_byte_, stdout);
			for(i=l=0; i < length;) {
				c = memory[i];
				if(atype == 2) 
					l += printv(c, BIT8);
				else if((atype == 5) && isprint(c) && (c != '\'')) {
					printf("'%c'", c);
					l += 3; }
				else {
					printf("$%02x", c);
					l += 3; }
				if(++i < length) { putc(',', stdout); ++l; } }
			break;
		case 3 :			/* Word data */
		case 4 :			/*	""	""	*/
			fputs(_word_, stdout);
			for(i=l=0; i < length;) {
				if(atype == 4)
					l += printv(get_word(i), BIT16);
				else {
					printf("$%04x", get_word(i));
					l += 5; }
				if((i += 2) < length) { putc(',', stdout); ++l; } }
			break;
		case 6 :			/* String data */
			fputs(_string_, stdout);
			putc('"', stdout);
			for(i=0; i < length;)
				putc(memory[i++], stdout);
			l = i + 2;
			putc('\"', stdout); }

		/* Output any pending line comment */
		if(cflag && *comment) {
			do
				putc(' ', stdout);
			while(++l < 23);
			fputs(comment, stdout); }

		putc('\n', stdout);
		address += length; }

	if(dflag) {
		dflag = 0;
		rewind(fp);
		goto top; }

	fclose(fp);

	/* Dump address blocks back to file */
	if(dfp)
		for(i=0; i < adtop; ++i)
			fprintf(dfp, "!%c%04x %04x\n", "?<[>]'\""[adtype[i]&15], adlow[i], adhigh[i]);

	/* Dump the symbol table to file */
	ptr = sym_pool;
	while(ptr < sym_top) {
		i = *(ptr+2);		/* Get flags */
		if((j = i & SYMDEF) || eflag) {
			if(dfp) {
				print_symbol(ptr, dfp);
				fprintf(dfp, " %04x %s\n", *(int*)ptr, flags[(i >> 5) & 3]); } }
		if(!j) {
			if(aflag)
				printf("%04x%15s", *(int*)ptr, "");
			j = print_symbol(ptr, stdout);
			do
				putc(' ', stdout);
			while(++j < 9);
			printf("EQU   $%04x %s\n", *(int*)ptr, flags[(i >> 5) & 3]); }
		ptr += (i & 0x1F) + 3; }

	if(dfp)
		fclose(dfp);

	fclose(stdout);
}

/*
 * Print a value using either a format, or a name from the symbol table
 * Returns length (in characters) of actual string output.
 */
printv(value, size_flags)
	unsigned value;
	char size_flags;
{
	int i;
	char *ptr;

	ptr = sym_pool;
	while(ptr < sym_top) {
		if(*(int*)ptr == value) {
			i = print_symbol(ptr, stdout);
			*(ptr+2) |= size_flags;
			return i; }
		ptr += (*(ptr+2) & 0x1F) + 3; }

	if(size_flags == BIT16) {
		printf("$%04x", value);
		return 5; }

	printf("$%02x", value);
	return 3;
}

/*
 * Display a symbol name from a pointer into the symbol table
 */
print_symbol(s, fp)
	unsigned char *s;
	FILE *fp;
{
	unsigned i, j;

	i = *(s += 2) & 0x1F;
	for(j=0; j < i; ++j)
		putc(*++s, fp);
	return i;
}
asm {
HELLO:
DB' <filename> [options ...]',10,10
db'opts:	-a	- Assembly output',10
db'	-b	- include Byte data accesses (in -d)',10
db'	-d	- pre-Define symbols for word accesses',10
db'	-e	- Exclude out of range addresses (in w=)',10
db 0
db'	a=addr	- specify memory Address',10
db'	b=size	- specify Beginning offset (in file)',10
db'	c=file	- merge Comments from file',10
db'	d=file	- Define symbols/blocks from file',10
db'	h=value	- specify # of hex bytes shown in listing',10
db'	n=size	- specify Number of instructions to disassemble',10
db'	w=file	- Write symbols/blocks to file',10
db 10,'?COPY.TXT 1991-2006 Dave Dunfield',10
db'**See COPY.TXT**.',10
db 0;
}
