#include <stdio.h>

#define	UC	0x01	// Convert to upper case
#define	RC	0x02	// Remove ':'
#define	QT	0x04	// Allow quotes

unsigned char
	*ptr,			// General pointer
	buffer[200],	// Line input buffer
	outbuf[250],	// Output buffer
	label[50],		// Instruction label
	inst[50],		// Instruction opcode
	operand[100],	// Instruction operand
	comment[100];	// Instruction comment

FILE
	*fp;

static char *I1[] = {
	"RET", "RZ", "RNZ", "RC", "RNC", "RP", "RM", "RPE", "RPO",
	"RRC", "RLC", "RAR", "RAL", "CMA", "CMC", "STC", "EI", "DI",
	"XCHG", "XTHL", "PCHL", "SPHL", "NOP", "HLT",
	0 };

unsigned
	Line,
	opos,
	tp;
char
	Xmacro,
	Xorg,
	Xequal,
	Tab = 8,
	Xcomment,
	Bcomment = 255,
	Lcomment = 255,
	Ucomment,
	Rcomment,
	XMflag = 255;

int isspace(char c)
{
	return (c == ' ') || (c == '\t');
}

skip()
{
	while(isspace(*ptr))
		++ptr;
}

void parse(unsigned char *dest, unsigned opt)
{
	unsigned char c, f;
	unsigned l;
	skip();
	l = f = 0;
	while(c = *ptr) {
		++ptr;
		if(opt & QT) {	// Allow quotes
			if((c == '\'') || (c == '\"')) {
				if(!f)
					f = c;
				else if(c == f)
					f = 0; } }
		if(!f) {
			if(isspace(c))
				break;
			if(opt & UC) {
				if((c >= 'a') && (c <= 'z'))
					c -= ('a'-'A'); } }
		*dest++ = c;
		++l; }
	if((opt & RC) && l) {
		if(*(dest-1) == ':')
			--dest; }
	*dest = 0;
}

unsigned char help[] = { "\n\
Use:	ASMFMT filename [options]\n\n\
opts:	/B	- remove Block comments\n\
	/L	- remove Line  comments\n\
	/M	- remove Macros\n\
	/O	- remove Org statements\n\
	/U	- translate comments to Upper case\n\
	/;	- Remove ';' in line comments\n\
	/=	- translate '=(exp)' to '=exp'\n\
	B=c	- set block comment character\n\
	T=n	- set Tab width\n\
\nDave Dunfield - "#__DATE__"\n" };

main(int argc, char *argv[])
{
	unsigned i;
	static unsigned char *f;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '/L' : Lcomment = 0;		continue;
		case '/B' : Bcomment = 0;		continue;
		case '/M' : Xmacro = 255;		continue;
		case '/O' : Xorg = 255;			continue;
		case '/U' : Ucomment = 255;		continue;
		case '/;' : Rcomment = 255;		continue;
		case '/=' : Xequal = 255;		continue;
		case 'B=' : Xcomment = *ptr;	continue;
		case 'T=' : Tab = atoi(ptr);	continue;
		case '/A' :
			Xcomment = '*';
			Tab = 0;
			Rcomment = Xmacro = Xequal = Xorg = Ucomment = 255;
			continue;
		} if(f)
			abort("Too many filenames.");
		f = ptr-2; }
	if(!f)
		abort(help);

	fp = fopen(f, "rvq");
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++Line;
		*label = *inst = *operand = *comment = 0;
		switch(*buffer) {
			case '*' :
			case ';' :
				write_comment();
				continue;
			default:
				parse(label, UC|RC);
			case ' ':
			case '\t':
				parse(inst, UC);
				for(i=0; I1[i]; ++i) {
					if(!strcmp(inst, I1[i])) {	// No operands
						*operand = 0;
						goto noop; } }
				parse(operand, UC|QT);
		noop:	skip();
				strcpy(comment, ptr); }
		write_inst(); }
	fclose(fp);
}

write_comment()
{
	unsigned char c;
	opos = 0;
	if(Bcomment) {
		if(Xcomment) {
			++ptr;
			skip();
			outbuf[opos++] = Xcomment; }
		while(c = *ptr++) {
			if(Ucomment && (c >= 'a') && (c <= 'z'))
				c -= ('a'-'A');
			outbuf[opos++] = c; }
		while(opos && isspace(outbuf[opos-1]))
			--opos;
		outbuf[opos] = 0;
		fputs(outbuf, stdout);
		putc('\n', stdout); } 
}

outab()
{
	outbuf[opos++] = '\t';
	tp = (tp +  8) & 0xF8;
}
xout(char *p, unsigned x, char uc)
{
	unsigned char c;
	if(x) {
		if(Tab) {
			outab();
			while(tp < x)
				outab(); }
		else
			outbuf[opos++] = ' '; }
	while(c = *p++) {
		if(uc && (c >= 'a') && (c <= 'z'))
			c -= ('a'-'A');
		outbuf[opos++] = c;
		++tp; }
}

write_inst()
{
	tp = opos = 0;
	if(!XMflag) {
		if(!strcmp(inst, "ENDMAC"))
			XMflag = 255;
		return; }
	if(Xmacro) {
		if(!strcmp(inst, "MACRO")) {
			XMflag = 0;
			fprintf(stderr, "%u: Removing macro '%s'\n", Line, label);
			return; } }
	if(Xequal)
		stripequ(operand);
	if(Xorg) {
		if(!strcmp(inst, "ORG"))
			return; }
	xout(label, 0, 0);
	xout(inst, 8, 0);
	xout(operand, 16, 0);
	if(Lcomment) {
		ptr = comment;
		if(Rcomment && (*ptr == ';')) {
			++ptr;
			skip(); }
		xout(ptr, 32, Ucomment); }
	while(opos && isspace(outbuf[opos-1]))
		--opos;
	outbuf[opos] = 0;
	fputs(outbuf, stdout);
	putc('\n', stdout);
}			

stripequ(unsigned char x[])
{
	unsigned i;
	i = 0;
	while(x[i] != '=') {
		if(!x[i++])
			return; }
	if(x[++i] != '(')
		return;

	fprintf(stderr, "%u: [%s] ->", Line, x);
	while(x[++i])
		x[i-1] = x[i];
	if(x[i-=2] != ')')
		fprintf(stderr, " *No closing ')'*");
	x[i] = 0;
	fprintf(stderr, " [%s]\n", x);
}
