SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$E700
;
; DMF "BGND" BackGround process utility by D. Dunfield
;
RUNRAM	EQU	$E000		; Run location
;
CIN	EQU	$0020		; Console input address
COUT	EQU	$0028		; Console output address
CTEST	EQU	$0030		; Console test function
XXX	JMP	START
;
START	SVC	41		; Get single filename
	RNZ
	MVI	M,'B'		; Append 'B'
	INX	H		; Next
	MVI	M,'G'		; Append 'G'
	INX	H		; Next
	MVI	M,'T'		; Append 'T'
	XCHG			; Get command pointer
	SHLD	DEPOS		; Save for later
	LXI	H,RUNRAM	; Point to run location
	SVC	26		; Calculate disk operands
	RNZ			; Error
	SVC	28		; Read file into memory
	RNZ			; Error
	LXI	H,STRMSG	; Point to startup message
	SVC	8		; Display
	LHLD	DEPOS		; Get command line
	XCHG			; DE = command line
	SVC	14		; Skip to next
	CALL	RUNRAM		; Initialize program
; Patch console vectors
	LHLD	CIN+1		; Get current console input
	SHLD	OLDIN+1		; Save it
	LHLD	COUT+1		; Get current console output
	SHLD	OLDOUT+1	; Save it
	LHLD	CTEST+1		; Get current console test
	SHLD	OLDTST+1	; Save it
	SHLD	PATCHIN+1	; Patch input
	LXI	H,NEWIN		; New input vector
	SHLD	CIN+1		; Write it
	LXI	H,NEWOUT	; New output vector
	SHLD	COUT+1		; Write it
	LXI	H,NEWTST	; New test vector
	SHLD	CTEST+1		; Write it
	LXI	H,TERM		; Patch to termination
	SHLD	XXX+1		; Save it
	SUB	A		; Zero return
INOK	RET
;
; Replacement console input function
; - call background task during polling loop.
;
NEWIN	ANA	A		; Device zero
OLDIN	JNZ	$E900		; No - use old handler
PATCHIN	CALL	$E900		; Test console
	JC	INOK		; We have data
	PUSH	H		; Save HL
	PUSH	D		; SAVE DE
	PUSH	B		; SAVE BC
	CALL	RUNRAM+3	; Call background
	POP	B		; Restore BC
	POP	D		; Restore DE
	POP	H		; Restore HL
	JMP	PATCHIN		; Wait for it
;
; Replacement device output function
; - call background task during polling loop
;
NEWOUT	PUSH	H		; Save HL
	PUSH	D		; Save DE
	PUSH	B		; Save BC
	PUSH	PSW		; Save device
	CALL	RUNRAM+6	; Call background
	POP	PSW		; Restore device
	POP	B		; Restore BC
	POP	D		; Restore DE
	POP	H		; Restore HL
OLDOUT	JMP	$E900		; Call output function
;
; Replacement console test function
;
NEWTST	PUSH	H		; Save HL
	PUSH	D		; Save DE
	PUSH	B		; Save BC
	CALL	RUNRAM+9	; Call background
	POP	B		; Restore BC
	POP	D		; Restore DE
	POP	H		; Restore HL
OLDTST	JMP	$E900		; Call test function
;
; Terminate background task
;
TERM	LHLD	OLDIN+1		; Get old vector
	SHLD	CIN+1		; Restore
	LHLD	OLDOUT+1	; Get old vector
	SHLD	COUT+1		; Restore
	LHLD	OLDTST+1	; Get old vector
	SHLD	CTEST+1		; Restore
	LXI	H,ENMSG		; Point to end message
XLOP	MOV	B,M		; Get data
	SUB	A		; Out to zero
	CALL	COUT		; Write it	???
	INX	H		; Next value
	CPI	$0D		; End of message?
	JNZ	XLOP		; Do it all
	SUB	A		; Zero RC
	RET
ENMSG	DB	7		; Bell
	STR	'BACKGROUND TASK ENDED'
	DB	$0A
	DB	$0D
	RET
STRMSG	STR	'BACKGROUND TASK STARTED'
	DB	$0D
DEPOS	DW	0		; Command line pointer
FILE	EQU	*
