;
; Simplified NorthStar Controller Boot Block
;
; This is the boot code from DMF, which I have simplified by removing
; all of the User Program Interface (UPI) code which also occupies the
; same block of memory, but is not part of the boot process.
;
	ORG	$2000		; Loader goes here (fixed by Disk ROM)
; Fixed memory addresses
DOS	EQU	$F000		; Dos load address
STACK	EQU	*+$200		; Initial stack goes here
;
; This is the disk access subroutine in the NorthStar controller ROM.
; Note that only the READ function is actually available, since WRITE
; redirects into the NorthStar DOS. Also note that this function does
; NOT span multiple tracks.
;
; A=#blks B=track C=drive D=Sector E=01Read 00Write HL=RamAddr
DSKROM	EQU	$E91E		; Disk controller entry point
;
; Boot loads first block (sector 4 on disk) at address $2000
; & Jumps to $2004
;
	DW	0		; Filler (2000-2001)
	DW	0		; Filler (2002-2003)
	JMP	LODALL		; Launch loader
;
; *******************************************
; *** DMF / UPI code removed for clairity ***
; *******************************************
;

;
; Load remainder of DOS into high memory
;
LODALL	LXI	SP,STACK	; Initial stack
; First re-read UPI block into memory at 0000
	MVI	A,1		; One block
	LXI	B,1		; Track 0, Drive 1
	LXI	D,$0401		; Sector 4, READ
	LXI	H,0		; Into RAM at zero
	CALL	DSKROM		; Read zero block
	JNZ	LODALL		; Retry on failure
; Then load remainder of track 0 into DOS area
	MVI	A,5		; 5 blocks
	LXI	B,1		; Track 0, Drive 1
	LXI	D,$0501		; Sector 5, READ
	LXI	H,DOS		; Load address
	CALL	DSKROM		; Read first part of DOS
	JNZ	LODALL		; Retry on failure
; Finally, load remainder of DOS from track 1
	MVI	A,6		; 6 blocks
	LXI	B,$101		; Track 1, Drive 1
	LXI	D,1		; Sector 0, READ
	LXI	H,DOS+$500	; Next block
	CALL	DSKROM		; Read second part of DOS
	JNZ	LODALL		; Retry on failure
	JMP	DOS		; Enter OS
