SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$E000
;
; DMF "@" Command script interpreter by D. Dunfield
;
VARS	EQU	*+$400
BLINE	EQU	VARS+$180
STACK	EQU	VARS+$1FF
TEXT	EQU	STACK+1
;
; Parse filename & load file
	JMP	GO		; Normal entry point
	JMP	STOR		; Store text
	JMP	VSTOR		; Store value
GO	PUSH	D		; Save pointer to filename
	SVC	41		; Get single filename
	JNZ	QUIT		; Bad operand
	MVI	M,'C'		; Append 'C'
	INX	H		; Next
	MVI	M,'M'		; Append 'M'
	INX	H		; Next
	MVI	M,'D'		; Append 'D'
	LXI	H,TEXT		; Point to data buffer
	PUSH	D		; Save options pointer
	SVC	26		; Get disk parameters
	JNZ	QUIT		; Error occured
	MVI	B,1		; Read
	SVC	28		; Load file into memory
	POP	D		; Restore parm pointer
	JNZ	QUIT		; Failed to load
; Clear local storage
	LXI	H,VARS		; Address variables
	LXI	B,$180		; Size of variable block
CLV	MVI	M,' '		; Clear
	INX	H		; Next
	DCX	B		; Do them all
	MOV	A,B		; Get high
	ORA	C		; All done
	JNZ	CLV		; Do them all
; Assign command line variables
	MVI	B,'A'		; First variable
GETPRM	SVC	14		; Get next option
	JZ	NOMORE		; No more
	PUSH	B		; Save var number
	MOV	A,B		; Get variable
	CALL	STOR		; Store text into variable
	POP	B		; Restore var
	INR	B		; Next
	JMP	GETPRM		; Get next one
; Set '@' to contain number of options
NOMORE	MOV	A,B		; Get final option #
	SUI	'A'		; Convert to binary
	MOV	L,A		; Set low
	MVI	H,0		; Zero high
	MVI	A,'@'		; Address special '@' varible
	CALL	VSTOR		; Store value into varibale
	POP	D		; Restore pointer to filename
	MVI	A,'N'		; Special 'N' variable
	CALL	STOR		; Store filename into 'N'
	LXI	H,REGAIN	; Progeam exit - Reentry vector
	SVC	39		; Take over program exit vector
	LXI	D,TEXT		; Point to data area
	SUB	A		; Get zero
	STA	LINE		; Init line
EXEC	LDA	LINE		; Load line number
	INR	A		; Advance
	STA	LINE		; Resave line number
EXEC1	LXI	SP,STACK	; Reset stack (in case error)
	PUSH	D		; Save file pointer
EXEC2	SVC	14		; Skip to next
	JZ	NXT		; End of line - go to next
	CPI	$FF		; End of file?
	JZ	TERM		; Yes, exit
	CPI	'&'		; Special command?
	JZ	COMD		; Yes, Handle it
	CPI	'-'		; Label identifier?
	JZ	LABL		; Yes, handle it
	CPI	'*'		; Comment?
	JZ	NXT		; Skip remainder of line
	CALL	BLDLIN		; Build command line
	SVC	32		; Execute DOS command
; Program has terminated
REGAIN	MOV	L,A		; Get return code
	MVI	H,0		; Zero high
	MVI	A,'R'		; Special 'R' variable
	CALL	VSTOR		; Store return code value into 'R'
NXT	LXI	SP,STACK-2	; Reset stack
	POP	D		; Restore file poijter
	CALL	NEWLIN		; Skip to new line
	JMP	EXEC		; And proceed
; Advance DE to point to new line
NEWLIN	LDAX	D		; Get char from line
	INX	D		; Next
	CPI	$0D		; End of line
	JNZ	NEWLIN		; Keep looking
	RET
;
; Label definition - skip over line
;
LABL	LDAX	D		; Get character from label
	INX	D		; Skip to next
	CPI	' '		; Look for end of label
	JZ	EXEC1		; Found - proceed with line
	CPI	$0D		; end of line?
	JNZ	LABL		; No - keep looking
	JMP	EXEC		; Process next line
;
; End of file has been encountered - exit
;
TERM	SUB	A		; Zero return code
	JMP	QUIT		; And exit
;
; Process an expression
;
EXPR	INX	D		; Skip to next
	LDAX	D		; Get character
	INX	D		; Skip to next
	STA	VCHR		; Save variable char
	CALL	BLDLIN		; Build line
	SVC	14		; Skip to non-blank
	INX	D		; Skip character
	CPI	'='		; Assignment?
	JNZ	SYNT		; No error
	SVC	14		; Skip to next
	CALL	GETOP		; Get operator
	CPI	'+'		; Addition?
	JZ	NUM		; Process numeric
	CPI	'-'		; Subtraction?
	JZ	NUM		; Process numeric
	LDA	VCHR		; Get variable back
	CALL	STOR		; Store text into variable
	JMP	NXT		; and process next line
; Process numeric expression
NUM	SVC	16		; Read decimal value (left)
	JNZ	SYNT		; Syntax error
	PUSH	H		; Save value
	SVC	14		; Skip to next
	PUSH	PSW		; Save operator
	INX	D		; Skip operator
	SVC	16		; Read decimal value (right)
	JNZ	SYNT		; Syntax error
	POP	PSW		; Restore operator
	POP	B		; Restore left value
	CPI	'+'		; Addition?
	JNZ	SUBT		; No - must be subtract ??? (ordering)
	DAD	B		; Add right and left
TERME	CALL	VSTV		; Store value into variable
	JMP	NXT		; And process next line
SUBT	MOV	A,L		; Get low
	CMA			; Compliment
	MOV	L,A		; Resave
	MOV	A,H		; Get high
	CMA			; Compliment
	MOV	H,A		; Resave
	INX	H		; Turn compliment into negate
	DAD	B		; Add (making subtract)
	JMP	TERME		; Store value
;
; Unrecoverable source code/syntax error
;
SYNT	LXI	H,ERRMSG	; Point to message
	SVC	8		; Display
	LHLD	LINE		; Get line #
	MVI	H,0		; Zero high
	SVC	11		; Display
	SVC	6		; New line
	MVI	A,99		; return code=99
;
; Terminate command processor
;
QUIT	PUSH	PSW		; Save return code
	MVI	H,0		; 0 = restore vector
	SVC	39		; Restore program termination vector
	POP	PSW		; Restore return code
	SVC	30		; And exit
;
; Get next operator after current work
; Ie: skip current, then parse single char operator
;
GETOP	PUSH	D		; Save position
	SVC	14		; Skip to non-blank
GEZ1	LDAX	D		; Get next character
	INX	D		; Advance
	CPI	' '		; Space?
	JZ	ENDE		; Yes, exit
	CPI	$0D		; End of line?
	JNZ	GEZ1		; Keep looking
ENDE	SVC	14		; Skip to non-blank & get char
	POP	D		; Restore DE
	RET
;
; Special command handler
;
COMD	LXI	H,CTAB		; Point to command table
	SVC	36		; Lookup command
; TYPE command(s)
	DCR	A		; Test for TYPEN
	DCR	A		; Test for TYPE
	JP	INPUT		; No, try next
NOIND	PUSH	PSW		; Save indicator
	CALL	BLDLIN		; Build the line
	SVC	14		; Skip to next
TYPE	LDAX	D		; Read data
	INX	D		; Advance
	CPI	$0D		; End of line?
	JZ	ENTYP		; Yes, exit
	SVC	3		; Display on console
	JMP	TYPE		; and get next
ENTYP	POP	PSW		; Restore command
	INR	A		; TYPE?
	JNZ	NXT		; No, no LFCR
	SVC	6		; LFCR
	JMP	NXT		; Next command
; INPUT command(s)
INPUT	DCR	A		; Test for READN
	DCR	A		; Test for READ
	JP	SKIP		; No, try next
	XCHG			; Save command pointer
	INR	A		; TYPE?
	JZ	NO13		; Yes, use prompt
	SVC	13		; Get line no prompt
	JMP	SWPHL		; & continue
NO13	SVC	12		; Get line with prompt
SWPHL	XCHG			; Restore command pointer
READ	SVC	14		; Skip to next
	JZ	NXT		; Null like - skip
	CPI	'&'		; Variable?
	JNZ	SYNT		; No, syntax error
	INX	D		; Skip to name
	LDAX	D		; Get name
	INX	D		; Advance
	XCHG			; Return to input data
	PUSH	H		; Save command command pointer
	PUSH	PSW		; Save variable
	SVC	14		; Skip to next
	POP	PSW		; Restore variable
	CALL	STOR		; Store into variable
	POP	H		; Restore command pointer
	XCHG			; Return to file data
	JMP	READ		; Handle next variable
;
; Skip ahead <n> lines in command file
;
SKIP	JNZ	GOTO		; Not skip
	CALL	BLDLIN		; Build the line
	SVC	16		; Get # lines to skip
	JNZ	SYNT		; Syntax error
	INR	L		; Extra one because out line counts
	POP	D		; Get stacked command pointer
	LDA	LINE		; Get line number
	MOV	B,A		; Save
SK1	CALL	NEWLIN		; Skip line
	LDA	LINE		; Get line number
	INR	A		; Advance
	STA	LINE		; Resave
	DCR	L		; Reduce count
	JZ	EXEC1		; We found it
	LDAX	D		; Get data from line
	ANA	A		; End of file?
	JP	SK1		; No, Keep looking
	LXI	H,SKMSG		; Indicate SKIP err
	SVC	8		; Display
	MOV	A,B		; Get line
	STA	LINE		; Resave
	JMP	SYNT		; Indicate error
;
; Advance to a specific label
GOTO	DCR	A		; GOTO?
	JNZ	IF		; No, try next
	CALL	BLDLIN		; Build line
	SVC	14		; Skip to next
	CPI	'-'		; Label name?
	JNZ	SYNT		; No, error
	LXI	H,TEXT		; Point to start of file
	MVI	C,1		; New line count
	XCHG			; HL = label
	INX	H		; Skip
	SHLD	ADR		; Save address
GLP	LHLD	ADR		; Get label address
GLP1	LDAX	D		; Get char from source
	ANA	A		; End of file?
	JM	NOLINE		; Yes, give up
	PUSH	D		; Save position
	CPI	'-'		; Is it a label?
	JNZ	NOTIT		; No, don't bother
GLP2	INX	D		; Skip to next
	LDAX	D		; Read character
	CPI	' '		; End of word?
	JZ	ENDG		; Yes - handle
	CPI	$0D		; end of line?
	JZ	ENDG		; Yes - handle
	CMP	M		; Match label?
	INX	H		; Skip to next
	JZ	GLP2		; And keep looking
; Not this one - try next line
NOTIT	CALL	NEWLIN		; Read next line
	INR	C		; Advance line number
	POP	H		; Restore position
	JMP	GLP		; And try this one
ENDG	MOV	A,M		; Get data
	CPI	$0D		; End of line?
	JZ	EOKG		; Yes, this is the label?
	CPI	' '		; End of word?
	JNZ	NOTIT		; No, this is not it
; We found the label
EOKG	MOV	A,C		; Get line number
	STA	LINE		; Save
	POP	D		; Restore postiion
	JMP	EXEC1		; And execute
; We searched entire file and did not find the label
NOLINE	LXI	H,LBLMSG	; Point to message
	SVC	8		; Issue
	JMP	SYNT		; And exit
;
; IF statement - conditional execution
;
IF	DCR	A		; Is this IF?
	JNZ	EXIT		; No, try next
	CALL	BLDLIN		; Build a line
	CALL	GETOP		; Get following operator
	CPI	'='		; Is it equality?
	JZ	EQU		; Handle equality
	SVC	16		; Get left decimal value
	JNZ	SYNT		; Error
	PUSH	H		; Save left
	SVC	14		; skip to blank
	PUSH	PSW		; Save operator
	INX	D		; Skip operator
	SVC	16		; Get right decimal value
	JNZ	SYNT		; Error
	POP	PSW		; Restore operator
	POP	B		; Restore left
	CPI	'>'		; Greater than?
	JZ	GRTR		; Handle >
	CPI	'<'		; Less than?
	JNZ	SYNT		; No - error
; Perform < test
LESS	CALL	NCOMP		; Compare
	JZ	NXT		; Equal - skip
	JC	NXT		; > - skip
	JMP	GOIF		; Do the command
; Perform > test
GRTR	CALL	NCOMP		; Compare
	JNC	NXT		; <= - skip
	JMP	GOIF		; Do the command
; '=' test - perform as text
EQU	SVC	14		; Skip to left
	PUSH	D		; Save pointer
	CALL	ADVNC		; Advance to end
	INX	D		; Skip '='
	SVC	14		; Skip to right
	POP	H		; Restore left
CMPLP	LDAX	D		; Get char from right
	CMP	M		; Same as left?
	INX	D		; Next right
	INX	H		; Next left
	JNZ	NXT		; Different - stop
	CPI	' '		; End of work
	JNZ	CMPLP		; Keep looking
; Execute command
GOIF	POP	D		; Restore pointer
	CALL	ADVNC		; Skip &IF
	CALL	ADVNC		; Skip operator
	INX	D		; Skip to operator
	SVC	14		; Skip to right
	CALL	ADVNC		; Skip right
	JMP	EXEC1		; And execute
;
; Skip to end of input line word
;
ADVNC	LDAX	D		; Get input
	INX	D		; Skip to next
	CPI	' '		; Space?
	JNZ	ADVNC		; No, keep looking
	SVC	14		; Skip to next
	RET
;
; Exit command - terminate processing
;
EXIT	DCR	A		; EXIT?
	JNZ	ANUM		; No, try next
	CALL	BLDLIN		; Build line
	SVC	16		; Get value
	JNZ	SYNT		; Error
	MOV	A,L		; Get return code
	JMP	QUIT		; And exit
;
; Test for numeric input
;
ANUM	DCR	A		; NUM?
	JNZ	EXPR		; No, try next
	CALL	BLDLIN		; Build line
	SVC	14		; Read next
	JZ	NBAD		; Invalid (no operands)
NUM1	SVC	14		; Skip to next
NUM2	LDAX	D		; Read data
	INX	D		; Next
	CPI	' '		; End of argument?
	JZ	NUM1		; Yes, process next
	CPI	$0D		; Return?
	JZ	AOK		; All done
	CPI	'0'		; Numeric
	JC	NBAD		; No - invalid
	CPI	$3A		; < '9'+1?
	JC	NUM2		; Yes, keep going
; Numeric arguments failed test
NBAD	MVI	L,1		; Indicate non-numeric
	JMP	NGO		; and save
; Numeric arguments passed
AOK	MVI	L,0		; Indicate numeric
NGO	MVI	H,0		; Zero high
	MVI	A,'R'		; Select 'R' return code
	CALL	VSTOR		; Store
	JMP	NXT		; And process
;
; Store a value into a variable
;
VSTOR	STA	VCHR		; Save variable
VSTV	PUSH	D		; Save DE
	SUB	A		; Convert to binary
	PUSH	PSW		; Save for later
; Stack digits in reverse order
PTOP	LXI	B,$FFF6		; Start with -10
	MOV	D,B		; -1
	MOV	E,B		; -1
PLB0	DAD	B		; Add 10
	INX	D		; Increment result
	JC	PLB0		; Not there yet
	MOV	A,L		; Get low order
	ADI	$3A		; Convert to ASCII
	PUSH	PSW		; Stack for reverse
	XCHG			; HL = HL/10
	MOV	A,H		; Get value
	ORA	L		; More to go?
	JNZ	PTOP		; Do them all
; Compute address for variable
	LDA	VCHR		; Get variable character
	SUI	$40		; Convert to binary
	CPI	27		; In range?
	JNC	SYNT		; Bad name - error
	MOV	C,A		; x1
	ADD	A		; x2
	ADD	A		; x4
	ADD	A		; x8
	SUB	C		; x7
	ADD	A		; x14
	MOV	C,A		; Set low address
	MVI	A,=VARS		; Point to vars
	ACI	0		; Include carry
	MOV	B,A		; Set high address
; Unstack dights (in correct order)
PNOUT	POP	PSW		; Get digit
	JNC	SKP0		; End of digit stack
	STAX	B		; Save in output
	INX	B		; Next
	JMP	PNOUT		; do more
SKP0	MVI	A,' '		; Terminate with space
	STAX	B		; Save
	POP	D		; Restore DE
	RET
;
; Build a line with varible substitution
;
BLDLIN	LXI	H,BLINE		; Point to line
	MVI	M,' '		; Begin with ' ' (for back search)
	INX	H		; Advance
BLD1	LDAX	D		; Read from source
	INX	D		; Next
	CPI	'&'		; variable?
	JZ	VAR		; Yes, handle it
	MOV	M,A		; Copy to output
	INX	H		; Advance
	CPI	$0D		; End of line?
	JNZ	BLD1		; Do entre line
	LXI	D,BLINE		; Point to built line
	RET
; Substitute variable content
VAR	LDAX	D		; Get variable
	INX	D		; Next
	SUI	$40		; Convert to binary
	CPI	27		; In range?
	JNC	SYNT		; no - error
; Compute variable address
	MOV	C,A		; x1
	ADD	A		; x2
	ADD	A		; x4
	ADD	A		; x8
	SUB	C		; x7
	ADD	A		; x14
	MOV	C,A		; Set low address
	MVI	A,=VARS		; Point to vars
	ACI	0		; Adjust for carry
	MOV	B,A		; Set high address
; Copy variable content into output
	PUSH	D		; Save pointer
	MVI	D,14		; Move 14 chars
GL1	LDAX	B		; Read from variable
	MOV	M,A		; Write to output
	INX	B		; Next in variable
	CPI	' '		; End of variable?
	JZ	GOUT		; Yes, stop
	INX	H		; Next in output
	DCR	D		; Reduce count
	JNZ	GL1		; do them all
GOUT	POP	D		; Restore pointer
	JMP	BLD1		; And continue building
;
; Store text into a variable
;
STOR	SUI	$40		; Convert to Binary
	CPI	27		; In range?
	JNC	SYNT		; No - error
	MOV	C,A		; x1
	ADD	A		; x2
	ADD	A		; x4
	ADD	A		; x8
	SUB	C		; x7
	ADD	A		; x14
	MOV	C,A		; Set low address
	MVI	A,=VARS		; Point to variables
	ACI	0		; Adjust for carry
	MOV	B,A		; Set high address
	MVI	L,14		; Copy up to 14 chars
ST1	LDAX	D		; Read from source
	INX	D		; Next in source
	STAX	B		; Write to variable
	CPI	$0D		; End offline?
	JZ	CR		; Yes, handle it
	INX	B		; Next in variable
	CPI	' '		; End of word?
	RZ			; Yes, handle it
	DCR	L		; Reduce count
	JNZ	ST1		; Do them all
; Skip to end of input word (truncate)
XX	LDAX	D		; Read from input
	INX	D		; Next in input
	CPI	' '		; End of work?
	RZ			; Yes
	CPI	$0D		; End of line?
	JNZ	XX		; No, keep looking
	DCX	D		; Backup to EOL
	RET
; Carriage return - terminate word with blank
CR	MVI	A,' '		; Get blank
	STAX	B		; Save it
	DCX	D		; Backup to CR
	RET
;
; Compare HL with BX
;
NCOMP	MOV	A,H		; Get high
	CMP	B		; Same?
	RNZ			; No need to go further
	MOV	A,L		; Get low
	CMP	C		; Compare?
	RET
; Message strings
ERRMSG	STRZ	'ERR,L='
SKMSG	STRZ	'SKIP '
LBLMSG	STRZ	'LABEL '
; Command lookup table
CTAB	DB	$86
	STR	'&TYPEN'
	DB	$85
	STR	'&TYPE'
	DB	$86
	STR	'&READN'
	DB	$85
	STR	'&READ'
	DB	$85
	STR	'&SKIP'
	DB	$85
	STR	'&GOTO'
	DB	$83
	STR	'&IF'
	DB	$85
	STR	'&EXIT'
	DB	$84
	STR	'&NUM'
	DB	$80
; Variable storage
VCHR	DB	0
LINE	DB	0
ADR	DW	0
ENDIT	EQU	*
