SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$0100
;
; DMF "CMDUTIL" Command Script helper utility by D. Dunfield
;
CMD	EQU	$E000		; Base address of CMD utility
CSTOR	EQU	CMD+3		; Address to STORE text
VSTOR	EQU	CMD+6		; Address to STORE value
;
; First check stack to verify that we are called from CMD
	LXI	H,0		; Begin with zero
	DAD	SP		; Get stack
	SHLD	QUIT+1		; Save for later
	MOV	A,H		; Get high address
	CPI	=CMD+$500	; Called from CMDUTIL?
	JNZ	NOCMD		; No, report error
; Lookup command in table
	LXI	H,TABLE		; Point to command table
	SVC	36		; Look up command
	ANA	A		; FILE?
	JZ	FILE		; Yes, handle it
	DCR	A		; DEC?
	JZ	DEC		; Yes, handle it
	DCR	A		; HEX?
	JZ	HEX		; Yes, handle it
	LXI	H,BADOPT	; Point to message
	SVC	8		; Display
	MVI	A,1		; RC=1 (bad operand)
	RET
; FILE command
FILE	SVC	19		; Get filename
	RNZ			; Error
	SVC	24		; Look it up
	RNZ			; Error
	LXI	B,11		; Offset to disk address
	DAD	B		; Adjust pointer
	MOV	B,M		; Get high address
	INX	H		; Next
	MOV	C,M		; Get low address
	CALL	STOR		; Store into variable & inc
	MOV	C,M		; Get size
	MVI	B,0		; Zero high
	CALL	STOR		; Store into variable & inc
	MOV	B,M		; Get User data
	INX	H		; Advance
	MOV	L,M		; Get low byte
	MOV	H,B		; Copy
	JMP	SAVHEX		; And save
; Parse variable from command line & store
STOR	PUSH	H		; Save H
	SVC	14		; Skip to non-blank
	PUSH	D		; Save pointer
	JZ	ENDIT		; End of line
	LDAX	D		; Get character
	MOV	H,B		; Save value
	MOV	L,C		; Into HL
	CALL	ESTOR		; Store it
	POP	D		; Restore command line
	POP	H		; Restore dir pointer
	INX	D		; Skip variable name
	INX	H		; Skip to next in dir
	SUB	A		; Indicate success
	RET
; No more operands - stop storing
ENDIT	SUB	A		; End of line was encountered
; Return to caller - restore stack frist
QUIT	LXI	SP,0		; Restore stack
	RET
; Perform a store
ESTOR	MOV	B,A		; Save for later
	SUI	$40		; Convert to binary
	CPI	27		; In range?
	MOV	A,B		; Restore
	JC	VSTOR		; Ok to proceed
; Bad variable name - issue message * exit
NOVAR	LXI	H,BADVAR	; Point to message
	SVC	8		; Display
	MVI	A,99		; Return code
	JMP	QUIT		; Exit
; Not called from COMMAND file
NOCMD	LXI	H,CMDONL	; Point to message
	SVC	8		; Display
	MVI	A,100		; Return code
	RET
; Command lookup table
TABLE	DB	$83
	STR	'FILE'
	DB	$83
	STR	'DEC'
	DB	$83
	STR	'HEX'
	DB	$80
; Convert HEX value into decimal
DEC	SVC	15		; Get HEX value
	RNZ			; Error
	SVC	14		; Skip to variable
	CALL	ESTOR		; Store it
	SUB	A		; Indicate success
	RET
; Convert decimal value into HEX
HEX	SVC	16		; Get DECIMAL operand
	RNZ
SAVHEX	SVC	14		; Skip to variable
	PUSH	PSW		; Save variable name
	LXI	D,SPARE		; Point to buffer
	MOV	A,H		; Get high value
	CALL	SAVBYT		; Save it
	MOV	A,L		; Get low byte
	CALL	SAVBYT		; Save it
	MVI	A,' '		; Blank terminate
	STAX	D		; Terminate buffer
	LXI	D,SPARE		; Reset to beginning
	POP	PSW		; Restore variable
	MOV	B,A		; Make copy
	SUI	$40		; Convert to binary
	CPI	$27		; In range?
	JNC	NOVAR		; No, report error
	MOV	A,B		; Restore
	CALL	CSTOR		; Save as text
	SUB	A		; Return A
	RET
; Write a single byte to the memory buffer
SAVBYT	PUSH	PSW		; Save value
	RRC			; Shift
	RRC			; High
	RRC			; Into
	RRC			; Low
	CALL	HSAV		; Save it
	POP	PSW		; Restore value
HSAV	ANI	$0F		; Save only this nibble
	ORI	$30		; Convert to binary
	CPI	$3A		; In range
	JC	OKH		; Yes - it's ok
	ADI	7		; Adjust A-F to ASCII
OKH	STAX	D		; Save in buffer
	INX	D		; next
	RET
; Fixed messages
BADOPT	STR	'INVALID OPTION'
	DB	$0D
BADVAR	STR	'INVALID VARIABLE OPERAND'
	DB	$0D
CMDONL	STR	'CALL FROM CMD FILE.'
	DB	$0D
; Buffer for HEX data storate
SPARE	STR	'         '
