SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$100
;
; DMF "DISK" Disk management utility by D. Dunfield
;
DATA	EQU	*+$300		; Data buffer goes here
;
	LXI	H,CMDTAB	; Point to command table
	SVC	36		; Lookup command
	CPI	4		; In range?
	JNC	BADOPR		; No, indicate bad operand
	CPI	3		; 'COPY?'
	JNZ	NORM		; Don't need From/To
	CALL	WRIMSG		; Output message
	STRZ	'FROM '
NORM	CALL	WRIMSG		; Output message
	STRZ	'DRIVE#?'
	SVC	13		; Get input
	SVC	14		; Skip to non-blank
	SUI	$30		; Convert to binary
	SVC	29		; Set disk drive
	RNZ			; Bad drive
	DCR	B		; 'SORT'?
	JM	CSORT		; Do SORT
	DCR	B		; 'COMPRES'?
	JM	CMPRS		; Do compress
	DCR	B		; 'INITIALIZE'?
	JM	INIT		; Do initalize
	DCR	B		; 'COPY'?
	JM	COPY		; Do copy
	ORI	$FF		; -1 bad parm (should never get here)
	RET
;
; Sort the disk directory by disk address
;
CSORT	CALL	SORT		; Perform sort
	SVC	22		; Rewrite directory
	RET
;
; Sort the disk directory
;
SORT	SVC	21		; Read directory
	JNZ	ABORT		; Failed
	SHLD	DIRADR		; Save directory address
	LXI	H,DATA		; Point to data area
TOP	PUSH	H		; Save address
	LXI	H,65535		; Big number (low water mark)
	SHLD	FDA		; Save for later
	POP	H		; Restore address
	CALL	GETSML		; Find lowest address
	JZ	EXIT		; No more found
	MVI	B,16		; Move 16 bytes
TLP	LDAX	D		; Read from dir entry
	MOV	M,A		; Write to new directory image
	MVI	A,' '		; Get unused marker
	STAX	D		; Mark old entry unused
	INX	D		; Next in source
	INX	H		; Next in dest
	DCR	B		; Reduce count
	JNZ	TLP		; Do entire entry
	JMP	TOP		; And try next
;
; Find the lowest address in directory
; On exit: DE = selecte entry
;
GETSML	PUSH	H		; Save address
	LXI	B,64		; Test 64 entries
	LHLD	DIRADR		; Get directory address
GLP	MOV	A,M		; Get entry
	CPI	' '		; Used?
	JZ	NXT		; No - try next
	PUSH	H		; Save Address
	LXI	D,11		; Offset to disk address
	DAD	D		; Adjust address
	MOV	D,M		; Get HIGH address
	INX	H		; Next
	MOV	E,M		; Get LOW address
	LHLD	FDA		; Get low-water mark
	CALL	COMP		; This one lower?
	JNC	NOSWAP		; No - do not change
	XCHG			; HL = new LW mark
	SHLD	FDA		; Save it
	MVI	B,10		; Indicate success
	POP	H		; Restore address
	SHLD	SA		; Save this entry address
	PUSH	H		; Resave address
NOSWAP	POP	H		; Restore address
; Advance to next directory address
NXT	LXI	D,16		; Size of directory entry
	DAD	D		; Adjust address
	DCR	C		; reduce count
	JNZ	GLP		; Check all entries
	LHLD	SA		; Get entry we selected
	XCHG			; DE = entry
	POP	H		; Restore address
	MOV	A,B		; Get return code
	ANA	A		; And set flags
	RET
; Now copy new directory back to old
EXIT	MOV	A,H		; Get data from new
	CPI	=(DATA+1024)	; Are we at end?
	JZ	EXIT1		; Yes, exit
	MVI	M,' '		; Blank it
	INX	H		; Next
	JMP	EXIT		; Blank remainder
EXIT1	LXI	D,DATA		; New directory
	LHLD	DIRADR		; old directory
	LXI	B,1024		; Size of directory
F1	LDAX	D		; Read byte from new
	MOV	M,A		; Write to old
	INX	D		; Next in source
	INX	H		; Next in dest
	DCX	B		; Reduce count
	MOV	A,B		; Get high
	ORA	C		; Is it zero?
	JNZ	F1		; do all
	RET
;
; Compare DE with HL
;
COMP	MOV	A,D		; Get HIGH
	CMP	H		; Same?
	RNZ			; No need to continue
	MOV	A,E		; Get LOW
	CMP	L		; Compare
	RET
;
; Compress the disk
;
CMPRS	CALL	SORT		; Sort the directory
	LXI	H,4		; Start of data area
	SHLD	FDA		; Save marker
	CALL	GETFIL		; Get next file entry
LOP1	LHLD	FS		; Get file size
	DAD	D		; Add to file address
	SHLD	NFA		; Save new file address
	LHLD	FDA		; Get next free
	XCHG			; Get
	LHLD	SA		; Get file address
	CALL	COMP		; FDA < SA (Free < File)
	JNC	FIXFDA		; No, adjust FDA
; Gap found in drive - move file to fill
	CALL	WRIMSG		; Output message
	STRZ	'MOVING "'	; Text
	CALL	PRNAM		; Display filename
	CALL	WRIMSG		; Output message
	STRZ	'" FROM '	; Text
	SVC	11		; Display from sector
	CALL	WRIMSG		; Output messsage
	STRZ	' TO '		; Text
	XCHG			; Get to sector
	SVC	11		; Display to sector
	SVC	6		; New line
	XCHG			; swap back
	LDA	FS		; Get file size
M1	CPI	21		; More than 20 blocks (2 tracks)
	JC	LST		; No - single transaction
	PUSH	PSW		; Save size
	MVI	A,20		; Move 20 blocks
	CALL	XFER		; Copy the data
	LXI	B,20		; Add 20 blocks
	DAD	B		; Adjust From
	XCHG			; Get to
	DAD	B		; Adjust To
	XCHG			; Swap back
	POP	PSW		; Restore length
	SUI	20		; Subtract 20 blocks
	JMP	M1		; and do next
; Transfer blocks(A) from HL to DE
XFER	PUSH	D		; Save DE
	PUSH	H		; Save FROM
	PUSH	D		; Save TO
	MVI	B,1		; Read Command
	LXI	D,DATA		; -> Data buffer
	PUSH	PSW		; Save length
	SVC	28		; Read disk
	JNZ	HDE		; Disk error
	POP	PSW		; Restore length
	POP	H		; Get TO
	LXI	D,DATA		; <- Data buffer
	MVI	B,0		; Write command
	SVC	28		; Write disk
	JNZ	HDE		; Disk error
	POP	H		; Restore FROM
	POP	D		; restore TO
	RET
; Last block to transfer
LST	ANA	A		; More blocks?
	CNZ	XFER		; Yes, transfer
	LHLD	FDA		; Get free disk address
	CALL	UPDIR		; Update directory entry
	XCHG			; DE=disk addrss
	LHLD	FS		; Get flie size
	MVI	H,0		; Zero high
	DAD	D		; Adjust addrss
	SHLD	FDA		; Set new free disk address
; Read and process next file
RDNXT	CALL	GETFIL		; Get next file entry
	LHLD	NFA		; Get next file address
	CALL	COMP		; Overlaid file
	JNC	LOP1		; No - move next file
; Next file overlays this one - adjust to point to correct
; offset within overlaid file
	PUSH	H		; Save address
	LHLD	SA		; Get saved address
	MOV	A,H		; Get high
	CMA			; Compliment to negate
	MOV	D,A		; Copy high
	MOV	A,L		; Get low
	CMA			; Compliment to negate
	MOV	E,A		; Save low
	INX	D		; Compete negation: 0-address
	POP	H		; Restore address
	DAD	D		; Adjust
	MOV	A,H		; Get high
	CMA			; Compliment to negate
	MOV	D,A		; Save high
	MOV	A,L		; Get low
	CMA			; Compliment to negate
	MOV	E,A		; Save low
	INX	D		; Complete negation: 0-new_address
	LHLD	FDA		; Get free address
	DAD	D		; Adjust
	CALL	WRIMSG		; Output message
	STRZ	'UPDATE "'	; Text
	CALL	PRNAM		; Display filename
	CALL	WRIMSG		; Output message
	STRZ	'" TO POINT TO '
	SVC	11		; Display sector
	SVC	6		; New line
	CALL	UPDIR		; Update directory entry
	JMP	RDNXT
; Update the free disk address
FIXFDA	XCHG			; Copy address
	LHLD	FS		; Get file soze
	MVI	H,0		; Zero high
	DAD	D		; Adjust
	LXI	D,3		; Size of directory
	CALL	COMP		; Insure in data space
	JNC	RDNXT		; No - do not update
	SHLD	FDA		; Save new free address
	JMP	RDNXT		; and proceed
; Update directory entry
UPDIR	XCHG			; Save address
	LHLD	CENT		; Get current entry
	LXI	B,11		; Offset to disk addrss
	DAD	B		; Addjust directory address
	MOV	M,D		; Save HIGH disk address
	INX	H		; Next
	MOV	M,E		; Save LOW disk address
	XCHG			; Swap pack
	RET
; Display filename
PRNAM	PUSH	H		; Save HL
	LHLD	CENT		; Get current entry
	MVI	B,8		; Display 8 char name
PR1	MOV	A,M		; Get data from name
	INX	H		; Next
	SVC	3		; Send to console
	DCR	B		; Reduce count
	JNZ	PR1		; Do them all
	MVI	A,'.'		; Separator
	SVC	3		; Display
	MVI	B,3		; Display 3 char type
PR2	MOV	A,M		; Get data from type
	INX	H		; Next
	SVC	3		; Send to console
	DCR	B		; Reduce count
	JNZ	PR2		; Do then all
	POP	H		; Restore HL
	RET
;
; Read file entry from directory
;
GETFIL	LHLD	DIRADR		; Get directory address
GFLP	MOV	A,M		; Get file marker
	CPI	' '		; Used?
	JZ	DONE		; Yes - finished
	SHLD	CENT		; Save current entry pointer
	LXI	D,11		; Offset to disk address
	DAD	D		; Adjust address
	MOV	D,M		; Get HIGH disk address
	INX	H		; Next
	MOV	E,M		; Get LOW disk address
	INX	H		; Next
	MOV	A,M		; Get size
	STA	FS		; Save file size
	XCHG			; HL = disk address
	SHLD	SA		; Save address
	XCHG			; Swap back
	INX	H		; Skip user data
	INX	H		; Skip user data
	INX	H		; Skip user data
	SHLD	DIRADR		; Save new directory address
	RET
; Display "DONE" message, update direcrory and exit
DONE	CALL	WRIMSG		; Output message
	STR	'DONE...'
	DB	$0D		; New line
; Hard disk error has occured
HDE	SVC	22		; Try to write directory
	SVC	30		; Re-enter DOS
;
; Initialize a diskette
;
INIT	LXI	H,DATA		; Point to data area
	MVI	A,=(DATA+$A00)	; End address
INLP	MVI	M,' '		; Write blank
	INX	H		; Next
	CMP	H		; At end?
	JNZ	INLP		; Do them all
	CALL	WRIMSG		; Output message
	STR	'INITIALIZING...'
	DB	$0D		; New line
	MVI	A,35		; Write 35 tracks
	LXI	H,0		; Disk address = 0
INP1	PUSH	PSW		; Save track count
	MVI	A,10		; Track = 10 sectors
	LXI	D,DATA		; Point to data area
	PUSH	H		; Save disk address
	MVI	B,0		; Write command
	SVC	28		; Perform disk operation
	JNZ	ABORT		; Failed
	POP	H		; Restore disk address
	LXI	D,10		; Offset to next track
	DAD	D		; Adjust disk address
	POP	PSW		; Restore track count
	DCR	A		; Reduce count
	JNZ	INP1		; Do them all
;
; Exit without writing directory
;
GETOUT	CALL	WRIMSG		; Output message
	STR	'DONE...'	; Text
	DB	$0D		; New line
	SUB	A		; Indicate success
ABORT	SVC	30		; Exit to DOS
;
; Copy a diskette
;
COPY	CALL	WRIMSG		; Output message
	STRZ	'TO DRIVE#?'	; Text
	SVC	13		; Get input
	SVC	14		; Skip to parameter
	SUI	$31		; Convert to binary
	CPI	3		; 0-2 = (1-3)
	JNC	BADOPR		; Bad operand
	INR	A		; Fix to actial disk ID.
	STA	FDA		; Save destination drive
	LXI	H,0		; Begin at sector 0
	MVI	A,5		; Move 5 blocks (5 * 70 = 350)
CPL1	CALL	CFER		; Copy block
	LXI	D,70		; Offset to next block
	DAD	D		; Adjust
	DCR	A		; Reduce count
	JNZ	CPL1		; Continnue
	JMP	GETOUT		; And exit
; Copy 70 sectors from source to destination drive
CFER	PUSH	PSW		; Save block count
	MVI	B,1		; Read command
	LXI	D,DATA		; Data buffer
	PUSH	H		; Save DISK address
	MVI	A,70		; Move 70 sectors
	SVC	28		; Read the disk
	JNZ	ABORT		; Failed
	POP	H		; Restore address
	PUSH	H		; Resave address
	LDA	FDA		; Get destination drive
	MOV	C,A		; Set drive for SVC
	MVI	A,70		; Move 70 sectors
	LXI	D,DATA		; Data buffer
	MVI	B,0		; Write command
	SVC	27		; Write disk
	JNZ	ABORT		; Failed...
	POP	H		; Restore address
	POP	PSW		; Restore block count
	RET
; Report a bad operand or request
BADOPR	CALL	WRIMSG		; Output message
	STR	'?PARM'		; Text
	DB	$0D		; Newline
	MVI	A,1		; "Operand missing or invalid"
	SVC	30		; Exit
;
; Write message [PC] to console
WRIMSG	XTHL			; Swap to HL
	SVC	8		; Output
	XTHL			; Swap back
	RET
;
; COMMAND table
;
CMDTAB	DB	$82
	STR	'SORT'
	DB	$83
	STR	'COMPRES'
	DB	$82
	STR	'INITIALIZE'
	DB	$83
	STR	'COPY'
	DB	$80
;
; Data area
;
DIRADR	DW	0		; Directory address in RAM
FDA	DW	0		; Free disk address
SA	DW	0		; Saved disk address
CENT	DW	0		; Current directory entry
NFA	DW	0		; New file address
FS	DW	0		; File size (high is zero)
