	ORG	$EF00		; F000 - 256 bytes for UI
;
; DMF operating system for NorthStar MDS controller by D. Dunfield
;
Z0	EQU	0
DSKSIZ	EQU	350		; Size of disk (total sectors)
TRKSIZ	EQU	10		; Size of track in sectors
BOOT	EQU	*		; Establish base for address adjustment
BOOT1	EQU	BOOT+$E000	; Adjusted base
; DSKROM: A=#blks B=track C=drive D=Sector E=01Read 00Write HL=RamAddr
DSKROM	EQU	$E91E		; Disk controller entry point
;
; Boot loads first block (sector 4 on disk) at address $2000 &
; Jumps to $2004
	DW	$7F7F		; Filler
	DW	$7F7F		; Filler
	JMP	LODALL-BOOT1	; Execute boot block
; This location contains the last drive on which the direcrory was
; accessed - this indicates what drive the RAM copy of the directory
; applies to.
LSTDRV	EQU	*-BOOT		; Last directory accessed
	DB	0
; Restart 1 - return to DOS
RST1	EQU	*-BOOT		; Adjusted address (RST1)
	JMP	CPENT		; Enter DOS
; Set RESTART-1 address
SETRST	EQU	*-BOOT		; Adjusted address
	SHLD	RST1+1		; Set new RST-1 address
	RET
	DB	0
; RST-2 SVC entry point
	JMP	SVC		; Enter SVC (RST2)
TEMP	EQU	*-BOOT		; Temp location used during disk access
;	DB	0,0,0,0,0
	DW	0
	DW	0
	DB	0
; User I/O entry entry points
INIT	EQU	*-BOOT		; User I/O initialzation (RST3)
	JMP	UINIT
;	DB	0,0,0,0,0	; Filler
	DW	0
	DW	0
	DB	0
IN	EQU	*-BOOT		; User input function (RST4)
	JMP	UIN
;	DB	0,0,0,0,0	; Filler
	DW	0
	DW	0
	DB	0
OUT	EQU	*-BOOT		; User output function (RST5)
	JMP	UOUT
;	DB	0,0,0,0,0	; Filler
	DW	0
	DW	0
	DB	0
CTRLC	EQU	*-BOOT		; User test function (RST6)
	JMP	UCTRLC
OBJ	EQU	*-BOOT		; Fixed "OBJ" for exe comparison
	STR	'OBJ'
RWCHK	EQU	*-BOOT		; Read/Write check flag
	DW	0
; RST-7 entry point
RST7	JMP	$E900		; Reload DOS
; SVC handler table
SVCTAB	EQU	*-BOOT
	DW	$E900		;0  Reboot
	DW	CTRLC		;1  Test for character/Ctrl-C
	DW	CONIN		;2  Console input
	DW	CONOUT		;3  Console output
	DW	IN		;4  General input
	DW	OUT		;5  General output
	DW	LFCR		;6  Output LFCR
	DW	SPACE		;7  Output space
	DW	WRLINE		;8  Writes a message
	DW	HEXOUT		;9  Hex output (byte)
	DW	PRHEX		;10 Hex output (word)
	DW	PRDEC		;11 Decimal output
	DW	GETLIN		;12 Get line from console
	DW	NODOT		;13 Get line without prompt
	DW	SKIP		;14 Skip to non blank
	DW	GETHEX		;15 Get hex value
	DW	GETDEC		;16 Get decimal value
	DW	GETNAM		;17 Get filename
	DW	VALID		;18 Test for valid filename
	DW	GETVAL		;19 Get valid filename
	DW	COMNAM		;20 Compare name
	DW	DIREAD		;21 Read directory into buffer
	DW	DIRITE		;22 Write directory from buffer
	DW	LOCRAM		;23 Locate name in RAM directory
	DW	LOCDIR		;24 Read DIR and locate name
	DW	GETFIL		;25 Get disk parameters from directory ent.
	DW	LFILE		;26 Get disk parameters from filename
	DW	DCOM		;27 Perform disk command (any drive)
	DW	CMDISK		;28 Perform disk command (file drive)
	DW	SVCDRV		;29 Set DOS drive (for 21, 22)
SVC30	EQU	*-BOOT		; Record position so we can patch
	DW	CPENT		;30 Reenter DOS
	DW	COMND		;31 Shell to DOS
	DW	CPEX		;32 Execute DOS command
	DW	DIR		;33 Display directory
	DW	SETRST		;34 Set RST-1 address
	DW	SETDEV		;35 Set console output device
	DW	LCMD		;36 Table lookup
	DW	FINADR		;37 Find free disk address
	DW	FINDET		;38 Find available direcrory entry
	DW	SET30		;39 Set SVC-30 address (take over DOS return)
	DW	SVCDEF		;40 Set default drive
	DW	GETOBJ		;41 Get filename (no type)
NUMSVC	EQU	42		; Number of valid SVC's
;
; Load remainder of DOS into high memory
;
LODALL	LXI	SP,STACK	; Initial stack
; First read UPI block into memory at 0000
	MVI	A,1		; One block
	LXI	B,1		; Track 0, Drive 1
	LXI	D,$0401		; Sector 4, READ
	LXI	H,0		; Into RAM at zero
	CALL	DSKROM		; Read zero block
	JNZ	LODALL-BOOT1	; Retry on failure
; Then load remainder of track 0 into DOS area
	MVI	A,5		; 5 blocks
	LXI	B,1		; Track 0, Drive 1
	LXI	D,$0501		; Sector 5, READ
	LXI	H,CP		; Load address
	CALL	DSKROM		; Read first part of DOS
	JNZ	LODALL-BOOT1	; Retry on failure
; Finally, load remainder of DOS from track 1
	MVI	A,6		; 6 blocks
	LXI	B,$101		; Track 1, Drive 1
	LXI	D,1		; Sector 0, READ
	LXI	H,CP+$500	; Next block
	CALL	DSKROM		; Read second part of DOS
	JNZ	LODALL-BOOT1	; Retry on failure
	JMP	CP		; Enter OS
; Supervisor call entry point
SVC	EQU	*-BOOT		;
	SHLD	TEMP+1		; Save HL
	LXI	H,0		; Start with zero
	DAD	SP		; Get SP
	SHLD	CPLOOP+1	; Set DOS sp below user
	POP	H		; Get return address
	INX	H		; Skip operand
	PUSH	H		; Stack it
	DCX	H		; Back to operand
	PUSH	PSW		; Save AF
	MOV	A,M		; Get operand
	CPI	NUMSVC		; In range?
	JNC	BADSVC		; Report bad SVC request
	ADD	A		; Double for 2byte entries
	LXI	H,SVCTAB	; Point to table
	ADD	L		; Offset into table
	MOV	L,A		; Reset new address
	MOV	A,M		; Get low address
	INX	H		; Skip to high
	MOV	H,M		; Get high address
	MOV	L,A		; Set low address
	POP	PSW		; Restore A
	PUSH	H		; Save address
	LHLD	TEMP+1		; Restore HL
	RET			; Call handler
;	DB	0,0,0,0,0
	DW	0
	DW	0
	DB	0
; Buffered filename - init to startup filename
NAME	EQU	*-BOOT
	STR	'IPLSTART'
TYPE	EQU	*-BOOT
	STR	'OBJ'
; Active drive
DRIVE	EQU	*-BOOT
	DB	1
; User data field associated with filename
UDAT	EQU	*-BOOT
	DW	0
;
; OS data areas
;
DISK	EQU	*+$C00		; Address of disk buffer
STACK	EQU	DISK		; OS stack is just below
BUFFER	EQU	STACK-256	; General OS buffer
;
; Beginning of OS code in high memory
;
CP	LXI	SP,STACK	; Initialize stack
	CALL	INIT		; Initialize I/O devices
	CALL	WRIMSG		; Output messsage
; Since we only use this once - borrow it for temp storage
	STR	'DMF-80/ST 1.0'	; Start code
CR	DB	13		; terminate msg + null line address
	CALL	LOCDIR		; Locate IPLSTART.OBJ
	LXI	D,CR		; Null command line (no operands)
	JZ	PROF		; Execute IPLSTART.OBJ if found
; Main command interpreter
RER	LXI	SP,STACK	; Reset stack in case we got here by error
	CALL	COMD1		; Execute command shell
	JMP	RER		; If it returns - relaunch
;
; Bad SVC request
BADSVC	CALL	WRIMSG		; Display message
	STRZ	'BAD SVC AT '
	DCX	H		; Backup to offending service ID
	CALL	PRHEX		; Display address
	CALL	LFCR		; New line
	ORI	$FF		; Insure not zero
PROF	CZ	EXECPR		; Execute IPLSTART.OBJ on first call
; Display return code & re-enter DOS
CPENT	LXI	SP,STACK	; Reset stack
	LXI	H,RER		; Return here
	PUSH	H		; Fake return address
	JMP	RETURN		; Display code & enter command look
; Execute program
EXECPR	PUSH	D		; Save D
	JMP	RUNPRF		; And run the prgoram
; Indicate entering command interpreter with prompt
COMND	CALL	WRIMSG		; Output message
	STR	'DMF:'		; Text
	DB	$0D		; New line & terminate
; Get a command line & execute
COMD1	CALL	GETLIN		; Get input line
	CPI	$0D		; Null line?
	JZ	COMND		; Yes, reprompt
	PUSH	D		; Save pointer
	CALL	CMD		; Lookup command
	POP	D		; Restore pointer
	ANA	A		; 'RETURN'
	RZ			; Yes, exit shell
	CALL	CPEX		; execute command
; Display return indicator
RETURN	MOV	L,A		; Get return code
	MVI	H,0		; Zero high
	MVI	A,'R'		; Get indicator
	CALL	CONOUT		; Display
	MOV	A,L		; Get return code back
	ANA	A		; Test
	JZ	SEMI		; Zero - not numeric display
	MVI	A,'('		; Opening brace
	CALL	CONOUT		; Display
	CALL	PRDEC		; Display return code value
	MVI	A,')'		; Closing brace
	CALL	CONOUT		; Display
SEMI	CALL	WRIMSG		; Display closing message
	STR	';'		; Semicolon
	DB	$0D		; Newline & terminate
	JMP	COMD1		; And get next command
; Issue newline and get an input line
NEWIN	CALL	LFCR		; New line
; Get an input line from the console with '.' prompt
GETLIN	MVI	A,'.'		; Prompt
	CALL	OUT0		; Display on console
; Get an input line from the console
NODOT	LXI	D,BUFFER	; Point to input buffer
GET1	MOV	A,E		; Get offset
	ANA	A		; Test
	JM	NEWIN		; Backup past beginning
	CALL	CONIN		; Get input
	CPI	$7F		; Delete?
	JNZ	GET2		; No, normal
	MVI	A,8		; Translate to backspace
	CALL	OUT0		; Display
	MVI	A,' '		; Wipe out char
	CALL	OUT0		; Display
	MVI	A,8		; Translate to backspace
GET2	CALL	OUT0		; Display on console
	CPI	3		; Control-C?
	JZ	NEWIN		; Yes, reset input
	DCX	D		; Backup pointer (assume backspace)
	CPI	8		; Backspace (rub-out)
	JZ	GET1		; Yes, use new pointer
	INX	D		; Correct bad assumption
	STAX	D		; Save character
	INX	D		; Adance in buffer
	CPI	$0D		; End of line?
	JNZ	GET1		; No, get next character
	MVI	A,$0A		; Line-free
	CALL	OUT0		; Send to console
	LXI	D,BUFFER	; Point to buffer
	LDAX	D		; Get first char from buffer
	RET
; Write message [PC] to console
WRIMSG	XTHL			; Get PC - save HL
	CALL	WRLINE		; Output message
	XTHL			; Restore HL - set new return address
	RET
; Write a line [HL] to the console
WRLINE	MOV	A,M		; Get byte from line
	INX	H		; Advance to next
	ANA	A		; End of line (no LFCR)?
	RZ			; Yes, stop
	CALL	CONOUT		; Display
	CPI	$0D		; End of line (LFCR)?
	JNZ	WRLINE		; No, keep displaying
; Display LF/CR on console
LFCR	MVI	A,$0A		; Get LF
	CALL	CONOUT		; Display
	MVI	A,$0D		; Get CR
	CALL	CONOUT		; Display
	CALL	CTRLC		; Test for Control-C
	JZ	LFCC		; Yes - handle it
	CPI	$0A		; Line-feed (pause output)?
	RNZ			; No, it's OK
CTRLS	CALL	CONIN		; Wait for character
	CPI	$0D		; Carriage return?
	RZ			; Yes, proceed
	CPI	3		; Ctrl-C?
	JNZ	CTRLS		; No, wait for it
;
; Control-C has been encountered
;
LFCC	CALL	WRIMSG		; Output message
	STR	'^C'		; Text
	DB	$0D		; Newline
	MVI	A,7		; DOS return code (CTRL-C)
	JMP	FIXUP		; Terminate / return to caller
; Set SVC 30 address
SET30	MOV	A,H		; Get value
	ANA	A		; Is it zero
	JNZ	NODEF		; No, keep this value
	LXI	H,CPENT		; 0 = entry point
NODEF	SHLD	SVC30		; Save new entry point
	RET
; Display a SPACE on the console
SPACE	PUSH	PSW		; Save A
	MVI	A,' '		; Get space
	CALL	CONOUT		; Display
	POP	PSW		; Restore A
	RET
; Lookup word [DE] in command table
CMD	LXI	H,TAB		; Point to command table
; Lookup word [DE] in table [HL]
LCMD	MVI	B,0		; Begin with entry #0
	CALL	SKIP		; Skip to non-blank
TLP0	PUSH	D		; Save position
	MOV	A,M		; flag byte
	ANI	$7F		; Remove high bit marker
	JZ	OKCMD		; End of table
	MOV	C,A		; Save length
CMDL	INX	H		; Next byte in table
	DCR	C		; Reduce length
	LDAX	D		; Get data from input word
	CALL	TSPCR		; End of word?
	JZ	GTST		; Yes, see if we matched enough
	CMP	M		; Does it match table?
	INX	D		; Skip to next
	JZ	CMDL		; Yes, keep looking
; Word did not match - skip to next table entry
NOVAL	POP	D		; Restore postion
	INR	B		; Advance entry number
CMD1	MOV	A,M		; Get byte from table
	ANA	A		; Test
	INX	H		; Advance to next
	JP	CMD1		; Go till entry of entry
	DCX	H		; Backup to flag
	JMP	TLP0		; And test this one
; Word ended - see if we have enough to declare a match
GTST	ORA	C		; Enough?
	JP	NOVAL		; No, try next one
OKCMD	CALL	SKIP		; Skip to next work
	MOV	A,B		; Get entry number
	POP	H		; Clean stack
	RET
; Command lookup table
; Each entry begins with a flag byte which has the high bit set to
; indicate a new entry, and the remaining bits indicate the minimum
; match length which is accepted. ($80 indicates end of list).
TAB	DB	$82
	STR	'RETURN'
	DB	$83
	STR	'DIRECT'
	DB	$82
	STR	'CREATE'
	DB	$83
	STR	'DELETE'
	DB	$82
	STR	'LOAD'
	DB	$82
	STR	'SAVE'
	DB	$82
	STR	'JUMP'
	DB	$82
	STR	'RUN'
	DB	$82
	STR	'READ'
	DB	$82
	STR	'WRITE'
	DB	$83
	STR	'DISPLAY'
	DB	$82
	STR	'STORE'
	DB	$82
	STR	'SET'
	DB	$82
	STR	'OUTPUT'
	DB	$82
	STR	'DRIVE'
	DB	$80
; Display a decimal number[DE], formatted into a field
FMTDEC	LXI	B,99		; Greater than 99?
	CALL	NCOMP		; Compare
	CNC	SPACE		; No, output space
	MVI	C,9		; Greater than 9
	CALL	NCOMP		; Compare
	CNC	SPACE		; No, output space
	XCHG			; HL = number
; Display HL in decimal without corrupting registers
PRDEC	PUSH	D		; Save DE
	PUSH	B		; Save BC
	PUSH	H		; Save HL
	CALL	DECPRT		; Output in decimal
	POP	H		; Restore HL
	POP	B		; Restore BC
	POP	D		; Restore DE
	RET
; Advance to next non-space character in line
SKIP	LDAX	D		; Get character
	CPI	$0D		; CR?
	RZ			; Yes, stop
	CPI	' '		; Space
	RNZ			; Yes, stop
	INX	D		; Next character
	JMP	SKIP		; Keep looking
; Advance to next SPACE or CR
ADVNC	CALL	TLDAXD		; Get char/test for SP/CP
	RZ			; Found it
	INX	D		; Next character
	JMP	ADVNC		; Keep looking
; Load indirect from D and check for SPACE or CR (line end)
TLDAXD	LDAX	D		; Get character
; Test character in A for SPACE or CR (line end)
TSPCR	CPI	' '		; Space?
	RZ			; Yes, exit with Z
	CPI	$0D		; CR?
	RET
; Get a decimal number from the input line
GETDEC	CALL	SKIP		; Skip to non-blank
	JZ	BADOPR		; End of line - fail
	CALL	ADVNC		; Advance to end of word
	PUSH	B		; Save BC
	PUSH	D		; Save position
	LXI	B,1		; Begin with digit=1
	LXI	H,0		; Begin with zero
ETOP	DCX	D		; Backup to prev. character
	LDAX	D		; Get character
	CPI	' '		; Beginning of operand?
	JZ	DECEND		; Yes, we have it all
	CALL	NUM		; Valid number?
	JC	BADOPR		; No, report error
	ANI	$0F		; Convert to 0-9 binary
ZLOOP	DCR	A		; Reduce count
	JM	ESP1		; All done
	DAD	B		; Add digit
	JMP	ZLOOP		; Do them all
; Multiply digit value by 10
ESP1	PUSH	H		; Save HL
	MOV	H,B		; Get digit value
	MOV	L,C		; ""
	DAD	B		; x2
	DAD	H		; x4
	DAD	B		; x5
	DAD	H		; x10
	MOV	B,H		; Resave digit value
	MOV	C,L		; ""
	POP	H		; Restore HL
	JMP	ETOP		; Do next
DECEND	POP	D		; Restore position (at end)
	POP	B		; Restore BC
ZERO	SUB	A		; Return code=0
	RET
; Test for A beign a valid decimal number '0'-'9'
NUM	CPI	'0'		; Test for < 0
	RC			; Yes, return C=1 (bad)
	CPI	$3A		; Test for < 10
	CMC			; Compliment C=1 if bad
	RET
; Get a HEX value for HL
GETHEX	CALL	SKIP		; Skip to non-blank
	JZ	BADOPR		; Report error
	LXI	H,0		; Begin with zero
TOPHEX	CALL	TLDAXD		; Get character from command
	JZ	ZERO		; All done
	INX	D		; Skip to next
	CALL	NUM		; Valid number?
	JNC	HEXOK		; Yes - also valid hex
	CPI	'A'		; Valid hex?
	JC	BADOPR		; No - fail
	CPI	'G'		; Valid hex?
	JNC	BADOPR		; No - fail
	SUI	7		; Convert to number offset 11-15
HEXOK	SUI	$30		; Cpnvert to binary 0-15
	DAD	H		; x2
	DAD	H		; x4
	DAD	H		; x8
	DAD	H		; x16
	ORA	L		; Insert into low order digit
	MOV	L,A		; And resave
	JMP	TOPHEX		; Do them all
; Display value [HL] in hex
PRHEX	MOV	A,H		; Get high byte
	CALL	HEXOUT		; Display
	MOV	A,L		; Get low byte
; Display value [A] in hex
HEXOUT	PUSH	PSW		; Save value
	RRC			; Rotate
	RRC			; High nibble
	RRC			; into
	RRC			; Low nibble
	CALL	HOUT		; Display high nibble
	POP	PSW		; Restore value
HOUT	ANI	$F		; Save only low nibble
	ADI	$30		; Covert to printable
	CPI	$3A		; Numeric?
	JC	CONOUT		; Ok to print
	ADI	7		; Adjust 'A'-'F' to correct
	JMP	CONOUT		; And display
; Write directory from disk buffer
DIRITE	SUB	A		; Disk WRITE command
	JMP	DIRECT		; And perform command
; Read directory into disk buffer
DIREAD	MVI	A,1		; Disk READ command
DIRECT	STA	DICMD+1		; Save command
	PUSH	D		; Save D
	LXI	D,DISK		; Point to disk buffer
	LXI	H,0		; Disk address = 0
	MVI	A,4		; 4 sectors
DICMD	MVI	B,1		; Set disk operation
	CALL	CMDISK		; Perform disk operation
	POP	D		; Restore D
	LDA	DRIVE		; Get drive accessed
	STA	LSTDRV		; Set last drive (directory)
	LXI	H,DISK		; Point to disk area
	SUB	A		; Zero return code
	RET
; Perform a disk command
CMDISK	PUSH	PSW		; Save A
	LDA	DRIVE		; Get disk drive
	MOV	C,A		; C = drive
	POP	PSW		; Restore A
	JMP	DCOM		; Perform disk command
; Get filename from command line
GETNAM	MVI	A,1		; Get drive number
	STA	DRIVE		; Set drive
	CALL	SKIP		; Skip to operand
	LXI	H,NAME		; Point to name
	MVI	B,8		; Save 8 characters
GNAM1	LDAX	D		; Get value
	INX	D		; Skip to next
	CPI	'.'		; Separator?
	JZ	FILL		; Yes, move on to type
	CPI	$0D		; End of line?
	JZ	BADOPR		; Yes, bad name
	MOV	M,A		; Save character in name
	INX	H		; Next location in buffer
	DCR	B		; Reduce count of remaining chars
	JP	GNAM1		; Do them all
	JMP	BADOPR		; More than 8 chars - error
FILL	MOV	A,B		; Get count
	CPI	8		; Any data entered?
	JZ	BADOPR		; No, bad name
	CALL	PAD		; Pad with blanks
	MVI	B,3		; type is 3 characters
GTYP1	CALL	TLDAXD		; Get data from buffer
	JZ	TYPDUN		; Finished with type
	INX	D		; Skip to next in source
	CPI	','		; Drive specified?
	JZ	GETDRV		; Yes, handle it
	MOV	M,A		; Save in buffer
	INX	H		; Skip to next in buffer
	DCR	B		; Reduce count
	JP	GTYP1		; Do them all
	JMP	BADOPR		; More than 3 chars - error
; Drive has been specified
GETDRV	LDAX	D		; Get drive ID
	INX	D		; Skip to next
	CALL	VALDRV		; Validate & store drive
TYPDUN	CALL	PAD		; Padd type with blanks
	LXI	H,NAME		; Point to name
	LDA	DRIVE		; Get drive
	MOV	C,A		; C = drive
	SUB	A		; Zero return
	RET
; Pad buffer with spaces for length in B
PAD	DCR	B		; Reduce count
	RM			; All done
	MVI	M,' '		; Pad with one space
	INX	H		; Move to next
	JMP	PAD		; Do themn all
; Compare name [HL] with buffered filename
COMNAM	PUSH	H		; Save HL
	PUSH	B		; Save BC
	PUSH	D		; Save DE
	LXI	D,NAME		; Point to name
	MVI	C,8		; Test 8 characters
	CALL	COMX		; Compare
	JNZ	EXIT		; No match - fail
	MVI	B,0		; Skip to end
	DAD	B		; in source
	LXI	D,TYPE		; Point to type
	MVI	C,3		; Test 3 characters
	CALL	COMX		; Compare
EXIT	POP	D		; Restore DE
	POP	B		; Restore BC
	POP	H		; Restore HL
	RET
; Compare [DE] with [HL] for legnth
COMX	LDAX	D		; Get data from source
	INX	D		; Skip to next
	CPI	'*'		; Wildcard matches anything
	RZ			; Allow it
	CMP	M		; Match buffer?
	RNZ			; No, indicate fail
	INX	H		; Skip to next
	DCR	C		; Reduce count
	JNZ	COMX		; Do them all
	RET
; Get a filename and insure it is valid.
GETVAL	CALL	GETNAM		; Get filename
; Insure buffered filename is valid
VALID	LXI	H,NAME		; Point to name
	MOV	A,M		; Get data from name
	CPI	'@'		; Test valid char
	JC	BADOPR		; Bad char
	CPI	$5B		; Test valid char
	JNC	BADOPR		; Bad char
	MVI	B,11		; Test 11 characters
VLP1	MOV	A,M		; Get data
	INX	H		; Skip to next
	CPI	'*'		; Wildcard?
	JZ	BADOPR		; Bad
	CPI	','		; Drive separator?
	JZ	BADOPR		; Bad
	CPI	'.'		; Type separator?
	JZ	BADOPR		; Bad
	DCR	B		; Reduce count
	JNZ	VLP1		; Do them all
	LXI	H,NAME		; Point to name
	SUB	A		; Zero return code
	RET
; Test for an object file extension
TSTOBJ	PUSH	D		; Save DE
	PUSH	H		; Save HL
	MVI	C,3		; Test 3 characters
	LXI	D,OBJ		; Point to 'OBJ'
	CALL	COMX		; Test it
	POP	H		; Restore HL
	POP	D		; Restore DE
	RET
; Locate an empty directory entry
FINDET	LXI	H,DISK		; Point to buffered directory
	LXI	B,16		; 16 bytes/enry
ET1	MOV	A,M		; Get entry
	SBI	' '		; Is this empty?
	RZ			; Yes
	DAD	B		; Skip to next
	MOV	A,H		; Get high
	CPI	=(DISK+1024)	; Are we at end?
	JNZ	ET1		; No - keep going
	MVI	A,5		; "Directory full"
	ANA	A		; Clear Z
	RET
;
; Locate filename in directory from DISK
;
LOCDIR	CALL	DIREAD		; Read directory into RAM
;
; Locate filename in directory in RAM
;
LOCRAM	LXI	H,DISK		; Point to disk area
	MVI	B,64		; Max. 64 entries
LOC0	MOV	A,M		; Get character from disk
	CPI	' '		; Used?
	JZ	LOC9		; No, skip to next
	CALL	COMNAM		; Compare name
	MVI	A,0		; Assume succes
	RZ			; And exit if so
; Not this entry - advance to next
LOC9	MOV	A,L		; Get low adress
	ADI	16		; Offset by dir size
	MOV	L,A		; Resave
	JNC	LOC1		; No carry over
	INR	H		; Advance high
LOC1	DCR	B		; Reduce entry count
	JNZ	LOC0		; More to check
	MVI	A,2		; Indicate "File not found"
	ANA	A		; Set ZF
	RET
;
; Locate free disk address
;
FINADR	LXI	H,DISK		; Point to directory in RAM
	LXI	B,4		; Start high-water mark at first avail.
FLP	MOV	A,M		; Get entry
	CPI	' '		; Used?
	JZ	FLNXT		; No, skip
	LXI	D,11		; Offset to disk address
	DAD	D		; Adjust pointer
	MOV	D,M		; Get disk address (high)
	INX	H		; Next
	MOV	E,M		; Get disk address (low)
	INX	H		; Next
	PUSH	H		; Save HL
	MOV	L,M		; Get size
	MVI	H,0		; Zero high
	DAD	D		; Calculate next free
	XCHG			; DE = next free
	POP	H		; Restore HL
	CALL	NCOMP		; Is it greater?
	INX	H		; Skip size
	INX	H		; Skip udata-1
	INX	H		; Skip udata-2
	JNC	NXTST		; Not higher
	MOV	B,D		; Set new high water
	MOV	C,E		; mark to this address
	JMP	NXTST		; And test the next
; Skip to next directory entry
FLNXT	LXI	D,16		; Size of directory entry
	DAD	D		; Advance pointer
NXTST	MOV	A,H		; Get high address
	CPI	=(DISK+1024)	; Are we at end of directory?
	JNZ	FLP		; No, keep looking
	MOV	H,B		; Get free address
	MOV	L,C		; "" ""
	RET
; Compare BC and DE
NCOMP	MOV	A,B		; Get high
	CMP	D		; Same?
	RNZ			; No - all we need
	MOV	A,C		; Get low
	CMP	E		; Compare
	RET
;
; Get disk parameters from directory entry
;
GETFIL	PUSH	B		; Save RAM address
	JMP	LFIL1		; And continue
;
; Get LOAD/SAVE operands: filename + memory address & obtain disk parameters
;
GETOP	CALL	GETVAL		; Get filename
	CALL	GETHEX		; Get disk address
;
; Get disk parameters from buffered filename
;
LFILE	PUSH	H		; Save RAM address
	CALL	LOCDIR		; Lookup file in directory
	JNZ	NOFILE		; Not found.
LFIL1	LXI	D,11		; Offset to disk address
	DAD	D		; Advance pointer
	MOV	D,M		; Get high address
	INX	H		; Next
	MOV	E,M		; Get low address
	INX	H		; Next
	LDA	DRIVE		; Get drive
	MOV	C,A		; Set in C for disk parm call.
	MVI	B,1		; Read command
	MOV	A,M		; Get size
	XCHG			; HL = DISKaddr
	POP	D		; DE = RAMaddr
	RET
; Read data from console
CONIN	SUB	A		; Device 0
	CALL	IN		; Call input
	CPI	$61		; Lower case?
	RC			; No - ok
	CPI	$7B		; Lower case?
	RNC			; No - ok
	ANI	$DF		; Covert to upper case
	RET
; Write character in A to console
OUT0	PUSH	B		; Save B
	MOV	B,A		; B = output character
	CPI	8		; Backspace?
	JZ	OUTOK		; Ok to send
	CPI	13		; CR?
	JZ	OUTOK		; Ok to send
	CPI	10		; LF?
	JZ	OUTOK		; Ok to send
	CPI	' '		; Space
	JNC	OUTOK		; Ok to send
	MVI	A,'^'		; Control indicator
	CALL	OUT0		; output
	MOV	A,B		; Get character
	ADI	$40		; Convert to printeble
	CALL	OUT0		; Display it
	MOV	A,B		; Restore character
	POP	B		; Restore BC
	RET
; Ok to output "normal" character
OUTOK	SUB	A		; Get zero
	CPI	1		; Insure Z clear
	JMP	OUTF		; And output
;
; Display number HL in decimal
;
DECPRT	LXI	B,$FFF6		; Begin with -10
DPL0	MOV	D,B		; -1
	MOV	E,B		; -1
DPL1	DAD	B		; Add 10
	INX	D		;
	JC	DPL1		; Not there yet
	MVI	A,$3A		; '0'+10
	ADD	L		; Convert to printable digit
	PUSH	PSW		; Save for later
	XCHG			; HL = HL/10
	MOV	A,H		; Get value
	ORA	L		; More to go?
	CNZ	DPL0		; Yes, output in correct order (recurse)
	POP	PSW		; Resore output character
; Display character in A on console
CONOUT	PUSH	B		; Save BC
	MOV	B,A		; B = output
ODEV	MVI	A,0		; Device = 0
	CPI	$FF		; Special case - null output
OUTF	CNZ	OUT		; No - call output function
	MOV	A,B		; Restore character
	POP	B		; Restore BC
	RET
; Get READ/WRITE parameters from command line
REAWRI	CALL	SKIP		; Skip to non-blank
	CALL	VALDRV		; Validate & store drive
	INX	D		; Skip
	CALL	GETDEC		; Get sector number
	PUSH	H		; Save
	CALL	GETDEC		; Get # blocks
	MOV	A,L		; into A
	PUSH	PSW		; Save
	CALL	GETHEX		; Get RAM address
	XCHG			; DE = RAMaddr
	POP	PSW		; Restore # blocks
	POP	H		; HL = DISKaddr
	RET
; Set console output device from command line
SDEV	CALL	GETDEC		; Get device number
	MOV	A,L		; Into A
; Set console output device to value in A
SETDEV	STA	ODEV+1		; Save device number
	SUB	A		; Indicate success
	RET
;
; Execute a DOS command
;
CPEX	LXI	H,0		; Start with zero
	DAD	SP		; Get SP
	SHLD	CPLOOP+1	; Set DOS SP
CPLOOP	LXI	SP,0		; Reset SP in case error
	CALL	CMD		; Get command & lookup
	ANA	A		; 'RETURN'?
	RZ			; Yes - exit
	DCR	A		; 'DIR'?
	JZ	DIR		; Yes - display directory
	DCR	A		; 'CREATE'?
	JZ	CREATE		; Yes - create file
	DCR	A		; 'DELETE'?
	JZ	DELETE		; Yes - delete file
	DCR	A		; 'LOAD'?
	JZ	LOAD		; Yes - load file
	DCR	A		; 'SAVE'?
	JZ	SAVE		; Yes - save file
	DCR	A		; 'JUMP?
	JZ	JUMP		; Yes - Jump to Program
	DCR	A		; 'RUN'
	JZ	RUN		; Yes - execute prgoram
	DCR	A		; 'READ'
	JZ	HREAD		; Yes - read disk
	DCR	A		; 'WRITE'
	JZ	HWRITE		; Yes - write disk
	DCR	A		; 'DISPLAY'
	JZ	DISP		; Yes - display memory
	DCR	A		; 'STORE'
	JZ	STOR		; Yes - store into memory
	DCR	A		; 'SET'
	JZ	SETCMD		; Handle 'SET' functions
	PUSH	D		; Save command line pointer
	CALL	GETOBJ		; Get object filename
	LDA	DRIVE		; Get drive
	MOV	B,A		; Save
	LDA	LSTDRV		; Get last drive
	CMP	B		; Same?
	CNZ	DIREAD		; No, read directory
	CALL	LOCRAM		; Locate file in RAM
	POP	D		; Restore command line pointer
	JZ	RUN		; File was found - execute
; DOS command was not recognized
UNKN	CALL	WRIMSG		; Output message
	STR	'UNKNOWN DMF COMMAND'
	DB	$0D		; New line
	ORI	$FF		; return 255 (ZF clear)
	RET
; DOS command had a bad operand
BADOPR	CALL	WRIMSG		; Output message
	STR	'OPERAND MISSING OR INVALID'
	DB	$0D		; New line
	MVI	A,1		; Return code
; Restore SP and return to caller with return code in A
FIXUP	LHLD	CPLOOP+1	; Get saved SP
	SPHL			; Set SP
	ANA	A		; Test return code
	RET
;
; Display directory of disk
;
DIR	MVI	A,1		; Assume drive
	STA	DRIVE		; Set default drive
	MVI	A,'*'		; Assume all files
	STA	NAME		; Set default name
	STA	TYPE		; Set default type
	CALL	SKIP		; Skip to option
	CPI	$0D		; End of line?
	JZ	GETIT		; Go for it
	CALL	NUM		; Is it a number?
	JC	DIRN		; No - try name
	CALL	VALDRV		; Validate & store drive
	JMP	GETIT		; And do directory
DIRN	CALL	GETNAM		; Get file specification
; Locate buffered filename in directory
GETIT	CALL	LOCDIR		; Locate in directory
	JNZ	NOFILE		; No file found - error
; Display current directory entry
D1	PUSH	H		; Save position
	MOV	A,M		; Check name
	CPI	' '		; Is this one used?
	JZ	DIRSKP		; No - do not display
	CALL	COMNAM		; Compare name to requested
	JNZ	DIRSKP		; No match - do not display
	MVI	C,8		; Name is 8 chars wide
	CALL	PRX		; Display fixed width
	MVI	A,'.'		; Separator
	CALL	CONOUT		; Display
	PUSH	H		; Save position of extension
	MVI	C,3		; Type is 3 chars wide
	CALL	PRX		; Display fixed width
	CALL	SPACE		; Space over
	CALL	SPACE		; Space over
	MOV	D,M		; Get high disk address
	INX	H		; Next
	MOV	E,M		; Get low disk address
	INX	H		; Next
	CALL	FMTDEC		; Display
	XCHG			; Get position back
	MOV	E,M		; Get size
	INX	H		; Next
	MVI	D,0		; Zero high
	CALL	SPACE		; Space over
	CALL	SPACE		; Space over
	CALL	FMTDEC		; Display
	POP	H		; Restore position to extension
	CALL	TSTOBJ		; Is it an OBJ file?
	JNZ	GLF		; No - no more output
	XCHG			; Get postion back
	MOV	D,M		; Get high run address
	INX	H		; Next
	MOV	E,M		; Get low run address
	XCHG			; HL = run address
	CALL	SPACE		; Space over
	CALL	SPACE		; Space over
	CALL	SPACE		; Space over
	CALL	PRHEX		; Display run address
GLF	CALL	LFCR		; New line
; Skip to the next directory entry
DIRSKP	POP	H		; Restore position
	LXI	D,16		; Size of entry
	DAD	D		; Adjust postiion to next entry
	MOV	A,H		; Get high address
	CPI	=(DISK+1024)	; At end of directory?
	JNZ	D1		; No - display next
	SUB	A		; Indicate succes
	RET
; Display fixed width text [HL] (width in C)
PRX	MOV	A,M		; Get text
	INX	H		; Advance
	CALL	CONOUT		; Display
	DCR	C		; Reduce count
	JNZ	PRX		; Do them all
	RET
;
; Create a file
;
CREATE	CALL	GETVAL		; Get valid filename
	CALL	GETDEC		; Get size of file
	PUSH	H		; Save
	LXI	H,TYPE		; Point to type
	CALL	TSTOBJ		; Is it object?
	JNZ	NOOBJ		; No - ok
	CALL	GETHEX		; Get run address
	SHLD	UDAT		; Set user data
NOOBJ	CALL	LOCDIR		; Lookup file
	JZ	EXISTS		; File already exists
	CALL	SKIP		; Skip to operand
	CZ	FINADR		; No address supplied - find free
	CNZ	GETDEC		; Get supplied address
	PUSH	H		; Save disk address
NL2	CALL	FINDET		; Find empty directory entry
	JNZ	DIRFULL		; None available
	MVI	B,11		; Copy 11 characters (name.ext)
	LXI	D,NAME		; Point to name
NL1	LDAX	D		; Get character from name
	MOV	M,A		; Write to directory
	INX	H		; Next dest
	INX	D		; Next source
	DCR	B		; Reduce count
	JNZ	NL1		; Do them all
	POP	D		; Restore
	MOV	M,D		; Write HIGH disk address
	INX	H		; Advance
	MOV	M,E		; Write LOW disk address
	INX	H		; Advance
	POP	B		; Restore size
	PUSH	B		; Resave
	XCHG			; HL = disk address
	DAD	B		; Adjust to size
	XCHG			; Swap back
	LXI	B,DSKSIZ	; Get disk size
	CALL	NCOMP		; Are we over?
	JC	TOBIG		; Report error
	POP	D		; Restore size
	MOV	M,E		; Save size
	INX	H		; Next
	XCHG			; DE=position
	LHLD	UDAT		; Get user data
	XCHG			; HL=position, DE=udata
	MOV	M,D		; Write high user address
	INX	H		; Next
	MOV	M,E		; Write low user address
	JMP	DIRITE		; And write directory
; Report "Directory full" error
DIRFULL	CALL	WRIMSG		; Write message
	STR	'DIRECTORY FULL'
	DB	$0D		; New line
	MVI	A,5		; Directory full
	JMP	FIXUP		; And proceed
; Report "File already exists" error
EXISTS	CALL	WRIMSG		; Write message
	STR	'FILE ALREADY EXISTS'
	DB	$0D		; New line
	MVI	A,3		; Return code
	JMP	FIXUP		; Return to caller
; Report "File not found" error
NOFILE	CALL	WRIMSG		; Write message
	STR	'FILE NOT FOUND'
	DB	$0D		; New line
	MVI	A,2		; Return code
	JMP	FIXUP		; Return to caller
; Report file too large for disk
TOBIG	CALL	WRIMSG		; Write message
	STR	'SPACE NOT AVAILABLE'
	DB	$0D		; New line
	MVI	A,4		; Return code
	JMP	FIXUP		; Return to caller
;
; Delete a file
;
DELETE	CALL	GETNAM		; Get filename
	DCR	A		; Get FF
	STA	UDAT		; Save flag
	MVI	B,11		; Test 11 characters
	LXI	H,NAME		; Point to buffered name
CHLP	MOV	A,M		; Read from name
	CPI	'*'		; Wildcard?
	JZ	DEFGO		; Yes - assume default
	INX	H		; Advance position
	DCR	B		; Reduce count
	JNZ	CHLP		; Check them all
	SUB	A		; Reset flag
	STA	UDAT		; And store
DEFGO	CALL	SKIP		; Skip to parameter
	JZ	NOPARM		; No parameter
	SUI	'Y'		; Prompt override?
	JNZ	BADOPR		; No - error
	STA	UDAT		; Reset flag
NOPARM	CALL	LOCDIR		; Locate file in directory
	JNZ	NOFILE		; No file found
DEL01	LDA	UDAT		; Get flag
	ANA	A		; Prompt override or single file
	JZ	ERASE		; Yes - erase the file
	PUSH	H		; Save HL
	MVI	C,8		; Display 8 chars
	CALL	PRX		; Display file name
	MVI	A,'.'		; Separator
	CALL	CONOUT		; Display
	MVI	C,3		; Display 3 chars
	CALL	PRX		; Display file extension
	CALL	WRIMSG		; Output message
	STRZ	' (Y/N/Q)?'
	POP	H		; Restore HL
DEL04	CALL	CONIN		; Read character
	CPI	3		; Control-C?
	JZ	ABDEL		; Yes, throw away changes
	CPI	'Q'		; Quit?
	JZ	OK		; Yes - proceed
	CPI	'Y'		; Yes?
	JZ	OK		; Yes - proceed
	CPI	'N'		; No?
	JNZ	DEL04		; No - wait for valid character
OK	PUSH	PSW		; Save response
	CALL	CONOUT		; Output
	CALL	LFCR		; New line
	POP	PSW		; Restore response
	CPI	'Q'		; Quit?
	JZ	DIRITE		; Yes - write directory & exit
	CPI	'Y'		; Yes?
	JNZ	DELN		; No - do not update
ERASE	MVI	M,' '		; Invalidate file entry
; Skip to next directory entry
DELN	LXI	B,16		; Size of entry
	DAD	B		; Adjust position
	MOV	A,H		; Get high
	CPI	=(DISK+1024)	; Are we at top of disk
	JZ	DIRITE		; Yes - write dir & exit
	MOV	A,M		; Get file flag
	CPI	' '		; Entry used?
	JZ	DELN		; No, skip to next
	CALL	COMNAM		; Does it match?
	JZ	DEL01		; Yes - do this one
	JMP	DELN		; No, skip to next
; Abort delete command
ABDEL	CALL	WRIMSG		; Output message
	STR	'^C'		; Indicate ^C
	DB	$0D		; New line
	CALL	DIREAD		; Re-read directory
	MVI	A,7		; Control-C indicator
	RET
;
; Load a file into memory
;
LOAD	CALL	GETOP		; Get filename & address
	MVI	B,1		; Indicate READ
	JMP	CMDISK		; Perform DISK command
;
; Save file from memory
;
SAVE	CALL	GETOP		; Get filename & address
	MVI	B,0		; Indicate WRITE
	JMP	CMDISK		; Perform disk command
;
; Execute program in memory
;
JUMP	CALL	GETHEX		; Get memory address
	CALL	SKIP		; Skip to next option
	PCHL			; Execute program
;
; Get a filename (no extension) & set extension to 'OBJ'
;
GETOBJ	CALL	SKIP		; Skip to non-blank
	JZ	BADOPR		; Indicate bad operand
	MVI	B,8		; Read 8 characters
OBJDRV	MVI	A,1		; Get drive
	STA	DRIVE		; Set drive
	LXI	H,NAME		; Point to filename
RUL1	CALL	TLDAXD		; Read from input
	JZ	RUGO		; End of name
	INX	D		; Skip to next
	CPI	','		; Drive specifier?
	JZ	FINDRV		; Handle it
	CPI	'*'		; Wildcard?
	JZ	BADOPR		; Not allowed
	MOV	M,A		; Save in filename
	INX	H		; Next in filename
	DCR	B		; Reduce count
	JP	RUL1		; Do them all
	JMP	BADOPR		; >8 chars - error
; Drive was specified, process
FINDRV	LDAX	D		; Get drive indicator
	INX	D		; Skip
	CALL	VALDRV		; Validate & store
; Pad the name and add OBJ type
RUGO	DCR	B		; Reduce count
	JM	COTYP		; 8 chars Finished
	MVI	M,' '		; Pad with blank
	INX	H		; Skip to next
	JMP	RUGO		; And proceed
COTYP	MVI	M,'O'		; Add 'O'
	INX	H		; Next
	MVI	M,'B'		; Add 'B'
	INX	H		; Next
	MVI	M,'J'		; Add 'J'
	DCX	H		; Back to 'B'
	DCX	H		; Back to 'O'
	SUB	A
	RET
;
; Run a program
;
RUN	CALL	GETOBJ		; Get filename
	PUSH	D		; Save command line
	CALL	LOCDIR		; Lookup
	JNZ	NOFILE		; Report error
; Run a program file
RUNPRF	PUSH	H		; Save directory position
	LXI	B,14		; Offset to RUN address
	DAD	B		; Adjust position
	MOV	B,M		; Get high run address
	INX	H		; Next
	MOV	C,M		; Get low run address
	POP	H		; Restore position
	PUSH	B		; Save address
	CALL	GETFIL		; Get filename
	MVI	B,1		; Indicate READ
	CALL	CMDISK		; Read file from disk
	POP	H		; Restore RUN address
	POP	D		; Restore command pointer
	CALL	SKIP		; Skip to operands
	PCHL			; Execute prgoram
;
; Read sector(s) from the drive to memory
;
HREAD	CALL	REAWRI		; Get Drive, Sector, Size, Address
	MVI	B,1		; Indicate READ
	JMP	CMDISK		; Read the data
;
; Write sectors(s) to the drive from memory
HWRITE	CALL	REAWRI		; Get Drive, Sector, Size, Address
	MVI	B,0		; Indicate WRITE
	JMP	CMDISK		; Write the data
;
; SET functions
;
SETCMD	CALL	CMD		; Loop operand keyword
	SUI	13		; 'OUTPUT'?
	JZ	SDEV		; Yes - set console device
	DCR	A		; 'DRIVE'?
	JZ	DEFDSK		; Yes - set default drive
	JMP	BADOPR		; Indicate error
;
; Validate a drive number (ASCII) and store
;
VALDRV	SUI	$30		; Convert: ASCII->Binary
SVCDRV	DCR	A		; Convert: 0-2
	CPI	3		; In range?
	JNC	BADOPR		; No, report error
	INR	A		; Convert: 1-3
	STA	DRIVE		; Set new drive
	SUB	A		; Indicate success
	RET
;
; Display memory
;
DISP	CALL	GETHEX		; Get operand
	MOV	A,L		; Get low
	ANI	$F0		; Adjust to even boundary
	MOV	L,A		; Resave
	PUSH	H		; Save address
	CALL	SKIP		; Skip to next
	CNZ	GETHEX		; Get HEX value
	MOV	B,H		; Save high end
	MOV	C,L		; Save low end
	POP	H		; Restore address
DISP1	CALL	PRHEX		; Display address
	PUSH	H		; Save address
	MVI	D,16		; Output 16 bytes
	CALL	SPACE		; Extra space
DISP2	CALL	SPACE		; Space over
	MOV	A,L		; Get address
	ANI	3		; At 4 byte boundary?
	CZ	SPACE		; Yes - extra space
	MOV	A,M		; Get data
	CALL	HEXOUT		; display
	INX	H		; Advance
	DCR	D		; Reduce count
	JNZ	DISP2		; Display them all
	MVI	D,4		; # separating spaces
SPLP	CALL	SPACE		; Space over
	DCR	D		; Reduce count
	JNZ	SPLP		; Do them all
	MVI	D,16		; Do 16 characters
	POP	H		; Restore addrss
CHDISP	MOV	A,M		; Get data
	INX	H		; Next
	CPI	' '		; Printable?
	JC	DISDOT		; No - change to '.'
	CPI	$7F		; Printable?
	JC	ITSOK		; Yes - ok to show
DISDOT	MVI	A,'.'		; Change non-print into '.'
ITSOK	CALL	CONOUT		; Display
	DCR	D		; Reduce count
	JNZ	CHDISP		; And continue
	CALL	LFCR		; New line
	MOV	D,H		; Get high
	MOV	E,L		; Get low
	CALL	NCOMP		; Compare with end
	JNC	DISP1		; More to go
	SUB	A		; Indicate success
	RET
;
; Store value(s) into memory
;
STOR	CALL	GETHEX		; Get Address
	MOV	B,H		; Copy
	MOV	C,L		; Copy
STOR1	CALL	GETHEX		; Get data value
	MOV	A,L		; into A
	STAX	B		; Save
	INX	B		; Advance
	CALL	SKIP		; More?
	JNZ	STOR1		; Yes, handle them
	SUB	A		; Indicate success
	RET
; Set default drive from command line
DEFDSK	LDAX	D		; Get drive from command line
; Set the default drive used by DOS
SVCDEF	CALL	VALDRV		; Validate & store drive
	LDA	DRIVE		; Get drive
	STA	GETNAM+1	; Patch GETNAM
	STA	DIR+1		; Patch DIR
	STA	OBJDRV+1	; Patch OBJDRV
	SUB	A		; Indicate success
	RET
;
; Perform disk command over multiple tracks
; A=#blks B=Command(00=W/01=R/03=V) C=Drive DE=RAMaddr HL=DISKaddr
;
DCOM	ANA	A		; Zero blocks?
	RZ			; Do nothing
	PUSH	PSW		; Save block count
DTRY1	MVI	A,10		; 10 sectors/track
	STA	TEMP+1		; Save for later
	POP	PSW		; Restore blocks
DTRY	CALL	ACCDSK		; Access the disk
	JNZ	DSKERR		; Report disk error
	ANA	A		; More data?
	RZ			; No, we are finished
	PUSH	PSW		; Save block count
	PUSH	B		; Save command/drive
	PUSH	H		; Save RAM addres
	MOV	L,A		; Get remaining blocks
	LDA	TEMP+2		; Get initial size
	SUB	L		; Compute offset
	MOV	H,A		; Set high address
	MOV	C,A		; Set high address
	MOV	A,L		; Get low address
	MVI	L,0		; Zero low
	MOV	B,L		; Zero low
	DAD	D		; Adjust RAM address
	XCHG			; DE = adjusted address
	POP	H		; Restore DISK address
	DAD	B		; Adjust disk address
	POP	B		; Restore command/drive
	JMP	DTRY1		; And continue command on new track
;
; Perform a disk access & do read after write check if enabled
;
ACCDSK	PUSH	H		; Save HL
	PUSH	D		; Save DE
	PUSH	B		; Save BC
	STA	TEMP+2		; Save # blocks
	CALL	UDISK		; Access this track
	LXI	H,TEMP		; Point to temp location
	MOV	M,B		; Save
	POP	B		; Restore BC
	POP	D		; Restore DE
	POP	H		; Restore HL
	RNZ			; If error, stop
	PUSH	PSW		; Save A
	LDA	RWCHK		; Read/After write enabled?
	ORA	B		; Test with WRITE=0
	JZ	VERWRI		; Yes, do verify
	POP	PSW		; Restore A
	RET
; Verify write operations
VERWRI	POP	PSW		; Save A
	MVI	B,2		; Verify operation
	LDA	TEMP+2		; Get # blocks
	CALL	ACCDSK		; Perform verify
	MVI	B,0		; Zero
	RET
;
; A disk error has occured - retry, issue console message if fatal
;
DSKERR	PUSH	PSW		; Save code
	LDA	TEMP+1		; Get retry count
	DCR	A		; Time to quit?
	JZ	NOWAY		; Yes - give up
	STA	TEMP+1		; Resave new count
	POP	PSW		; Clean stack
	LDA	TEMP+2		; Get block count
	JMP	DTRY		; And go again
; Disk error is fatal!
NOWAY	CALL	WRIMSG		; Output message
	STRZ	'HDE('		; Text
	POP	PSW		; Restore code
	XCHG			; Save sector
	MOV	L,A		; Get code
	MVI	H,0		; Zero high
	CALL	PRDEC		; display
	CALL	WRIMSG		; Output message
	STRZ	') D'		; text
	MOV	L,C		; Get drive
	CALL	PRDEC		; display
	CALL	WRIMSG		; Output message
	STRZ	' S'		; text
	LDA	TEMP+2		; Get # blks
	MOV	L,A		; Set
	DAD	D		; Add to start
	LDA	TEMP		; Get sectors remaining
	MOV	B,A		; into B
	MOV	A,L		; Get sector
	SUB	B		; Adjust
	MOV	L,A		; Resave
	JNC	NODEC		; No carry back
	DCR	H		; Adjust high
NODEC	CALL	PRDEC		; Display sector
	CALL	LFCR		; New line
	MVI	A,6		; "Unrecoverable disk error"
	JMP	FIXUP		; Return to caller
; Disk tracking area at address 0
; 0000: Last drive accessed
; 0001: Track position on drive 1
; 0002: Track position on drive 2
; 0003: Track position on drive 3
INFO	EQU	0		; Last drive accessed
;
; Access the disk within a single track
; A=#blks BC=Cmd/Sector DE=RAMaddr HL=DISKaddr
; Sets C if operation spans next track & returns remaining blks in A
; - you must seek and recall
;
UDISK	PUSH	PSW		; Save A (sector count)
	PUSH	D		; Save DE (RAM address)
	PUSH	B		; Save BC (Cmd/Sector)
	PUSH	H		; Save HL (DISK address)
	MVI	D,0		; Zero high
	MOV	E,A		; Get # blks
	DAD	D		; HL = Last sector
DEC0	EQU	$FFFF
	LXI	D,DEC0-DSKSIZ	; HL = last valid block
	DAD	D		; Test for within disk
	POP	H		; Restore HL (RAM address)
	JC	SYNT		; Overflow - report error
	MOV	A,C		; Get drive
	DCR	A		; Adjust to 0 offset
	CPI	3		; In range?
	JNC	SYNT		; Bad drive - error
	MOV	A,B		; Get command
	CPI	3		; Valid command?
	JNC	SYNT		; Bad command - error
; Determine starting track
	LXI	D,Z0-TRKSIZ	; Adjust by -TRKSIZE
	MVI	B,255		; And -1
D10	INR	B		; Advance count
	DAD	D		; subtract TRKSIZE
	JC	D10		; Go till we find track
	MOV	D,B		; D = track
	MOV	A,L		; Get sector
	ADI	TRKSIZ		; Adjust to positive
	MOV	E,A		; E = sector
	LDA	$EB90		; Read disk status
	ANI	$10		; Motors on?
	JNZ	ALRON		; Already on
	MVI	B,50		; Wait for motors
	CALL	WSEC		; Wait sector times
	JMP	LODHED		; Load head
ALRON	LDA	INFO		; Get last drive accessed
	CMP	C		; Same drive?
	JZ	NOLOAD		; Yes, no need to load heads
; Load heads on drive
LODHED	MOV	A,C		; Get drive #
	STA	INFO		; Remember we are using this one
	MVI	B,$EB		; Address disk controller status
	LDAX	B		; Select drive (C=drive)
	MVI	B,13		; Wait for head load
	CALL	WSEC		; Wait sector times
; Step to desired track position
NOLOAD	MVI	H,=INFO		; Set high address
	MOV	L,C		; Address selected drive track position
GOSTEP	MOV	A,M		; Read track position
	CMP	D		; Compare to desired position
	JZ	ATTRK		; We are at desired track - proceed
	JC	STPOUT		; Less than - step out
; Step in one track
STPIN	LDA	$EB9C		; Step IN direction & read status
	DCR	M		; Record new position
	RRC			; At track 0
	JNC	CSTEP		; No, proceed with step
	MVI	M,0		; Reset track position
	JMP	GOSTEP		; And proceed
; Step out one track
STPOUT	LDA	$EB9D		; Step OUT direction
	INR	M		; Record new position
CSTEP	LDA	$EB09		; Assert STEP
	XTHL			; Wait a bit
	XTHL			; Wait a bit
	LDA	$EB08		; Deassert STEP
	MVI	B,2		; Wait for step
	CALL	WSEC		; Wait sector times
	JMP	GOSTEP		; And proceed
; We are at the correct track
ATTRK	CALL	WSEC1		; Wait for pulse & get sector
	CMP	E		; Are we at sector
	JNZ	ATTRK		; No, keep waiting
	POP	B		; Restore BC (Cmd/Drive)
	POP	H		; Restore HL from DE (RAM address)
	DCR	B		; Test command
	JM	WRITE		; Write operation
	JNZ	VERIFY		; Verify operation
; Read a sector from the disk
READ	CALL	GETBDY		; Wait for body mode
	MOV	B,C		; Initialize Check
RBYT	LDAX	D		; Read data
	MOV	M,A		; Save data
	INX	H		; Skip to next
	XRA	B		; Compute
	RLC			; Check...
	MOV	B,A		; Resave check
	DCR	C		; Reduce count
	JNZ	RBYT		; Do all 256 bytes/sector
	LDAX	D		; Get check byte
	XRA	B		; Same as computed?
	JNZ	RERR		; No, report error
	POP	PSW		; Restore sector count
	DCR	A		; Reduce count
	ANA	A		; Done them all? / clear carry
	RZ			; Yes, stop
	PUSH	PSW		; Resave sector count
	CALL	WSEC1		; Wait one sector time
	JNZ	READ		; Read next if still on this track
	POP	PSW		; Clean stack
	CMP	A		; Set ZF
	STC			; Indicate more to go
	RET
; Read error has occured
RERR	POP	B		; Clean stack
	MVI	A,2		; "Read data CRC error"
	ANA	A		; Clear ZF
	RET
; Verify a sector with the disk
VERIFY	CALL	GETBDY		; Wait for body mode
	MOV	B,C		; Begin check = 00
VBYT	LDAX	D		; Read byte of data
	CMP	M		; Same as memory?
	JNZ	VERR		; No - report error
	INX	H		; Next
	XRA	B		; Compute
	RLC			; Check...
	MOV	B,A		; Resave check
	DCR	C		; Reduce count
	JNZ	VBYT		; Do all 256 bytes
	LDAX	D		; Get check byte
	XRA	B		; Same as computed?
	JNZ	RERR		; No - report error
	POP	PSW		; Restore # sectors
	DCR	A		; Reduce count
	ANA	A		; Done them all? / clear carry
	RZ			; Yes, stop
	PUSH	PSW		; Resave count
	CALL	WSEC1		; Wait one sector
	JNZ	READ		; Verify next if still on this track
	POP	PSW		; Clean stack
	CMP	A		; Set 'Z'
	STC			; Indicate more to go
	RET
; Data on disk did not verify
VERR	POP	B		; Clean stack
	MVI	A,3		; "Verify data error"
	ANA	A		; Clear ZF
	RET
; Write sector to the disk
WRITE	LDA	$EB04		; Read status
	ANI	2		; Write protected?
	JNZ	WRIERR		; Yes, report error
TSTWRI	LDA	$EB10		; Read status
	ANI	$08		; Ready for data?
	JZ	TSTWRI		; No, wait for it
; Write preamble
	LXI	B,15		; Write 15 bytes of zero
WRIZ	MOV	E,B		; Get zero
	MVI	D,$EA		; Address controller write register
	LDAX	D		; Write byte
	MOV	A,M		; Timing... ???
	DCR	C		; Reduce count
	JNZ	WRIZ		; Do them all
	MVI	E,$FB		; Sync byte
	LDAX	D		; Write sync byte
	MOV	A,M		; Timing... ???
; Write data
WLP1	MOV	A,M		; Get data
	MOV	E,A		; Set controller write data
	XRA	B		; Compute
	RLC			; Check...
	MOV	B,A		; Resave check
	LDAX	D		; Write the data
	INX	H		; Advance to next
	DCR	C		; Reduce count
	JNZ	WLP1		; Write them all
	MOV	E,B		; Get check byte
	INX	B		; C=1
	LDAX	D		; Write check byte
	POP	PSW		; Restore sector count
	DCR	A		; Reduce count
	ANA	A		; Done them all? / clear carry
	RZ			; Yes, stop
	PUSH	PSW		; Resave count
	CALL	WSEC1		; Wait for next sector
	JNZ	WRITE		; Write next sector
	POP	PSW		; Clean stack
	CMP	A		; Set ZF
	STC			; Indicate more to go
	RET
; Write error has occured
WRIERR	POP	B		; Clean stack
	MVI	A,4		; "Write protect violation"
	ANA	A		; Clear ZF
	RET
;
; Wait for disk to indicate "Body" mode
; On exit, DE=data address, C=00 (for 256 byte data count)
;
GETBDY	LXI	D,$EB50		; Data read address
	LXI	B,$8C00		; Timeout & data count
TSTBDY	LDA	$EB10		; Get status
	ANI	4		; Body mode
	RNZ			; Ready for data
	DCR	B		; Reduce timeout
	JNZ	TSTBDY		; Keep looking
	POP	PSW		; Clean return address
	POP	B		; Restore BC
	MVI	A,1		; "Sync byte not found"
	ANA	A		; Clear Z
	RET
; Wait one sector time
WSEC1	MVI	B,1		; Indicate one sector time
; Wait B sector times
WSEC	LDA	$EB14		; Reset sector flag
WS1P	LDA	$EBB0		; Read status
	ANA	A		; Sector pulse?
	JP	WS1P		; No, wait for it
	DCR	B		; Reduce count
	JNZ	WSEC		; Do them all
	ANI	$0F		; Return sector number
	RET
; Error in disk parameters
SYNT	POP	B		; Clean BC
	POP	D		; Clean DE
	POP	PSW		; Clean A
	ORI	255		; Set -1(Error) & clear Z
	RET
;
;---------------------------------------------------------------
; User supplied I/O functions
;---------------------------------------------------------------
;
; User I/O initialization function
;
UINIT	MVI	A,$03		; Insure command mode
	OUT	$06		; Write
	OUT	$06		; Write
	MVI	A,$77
	OUT	$06
	MVI	A,$7A
	OUT	$06
	MVI	A,$37
	OUT	$06
	MVI	B,$1A
	JMP	TOUT
;
; User Input function
;
UIN	IN	$06		; Read status
	ANI	$02		; Character ready?
	JZ	UIN		; No, wait for it
	IN	$05		; Read character
	RET
;
; User output function
;
UOUT	DCR	A		; Device 1
	JZ	CONPRT		; Yes, console + printer
	DCR	A		; Device 2
	JZ	LPRT		; Yes, printer only
TOUT	IN	$06		; Read status
	RRC			; Uart TX ready?
	JNC	TOUT		; Wait for it
	MOV	A,B		; Get character
	OUT	$05		; Output
	CPI	$0C		; Clear-screen?
	RNZ			; No, its OK
; Output a PAD after clearing the screen
WAINXT	IN	$06		; Read status
	RRC			; Uary TX ready?
	JNC	WAINXT		; Wait for it
	MVI	A,$7F		; Get pad
	OUT	$05		; Output
	MOV	A,B		; Restore character
	RET
;
; User I/O test input function
;
UCTRLC	IN	$06		; Read status
	ANI	$02		; Character ready?
	JZ	NOCHR		; No.
	IN	$05		; Read character
	CPI	$03		; Is it control-C?
	STC			; Indicate data RX
	RET
NOCHR	ORI	$FF		; No character - return FF
	RET
;
; Output device 1 - write to console and printer
CONPRT	CALL	TOUT		; Write to console
; Output device 2 - write to printer
LPRT	IN	8		; Read status
	ANI	$20		; Character ready?
	JZ	OKPRT		; No, ok to TX
	IN	9		; Read character
	CPI	$13		; CTRL-S?
	JNZ	OKPRT		; No, ok to TX
; CTRL-S has been received - wait for CTRL-Q
WAICTLS	IN	8		; Read status
	ANI	$20		; Character ready?
	JZ	WAICTLS		; No, wait for it
	IN	9		; Read character
	CPI	$11		; CTRL-Q?
	JNZ	WAICTLS		; No, wait for it
OKPRT	IN	8		; Read status
	ANI	2		; TX ready?
	JZ	OKPRT		; No, wait for it
	MOV	A,B		; Get character
	OUT	9		; Write
	RET
