SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
;
	ORG	$100
;
ZERO	EQU	0
*FULL	SCREEN	EDITOR.
SCREEN	EQU	$900
CMPSRN	EQU	ZERO-SCREEN
HOME	EQU	$B		; Command key
CLR	EQU	$1A		; Redraw screen ($0C)
INPCHR	EQU	6
CANEDT	EQU	26
CLRLIN	EQU	$F
UP	EQU	$E
DOWN	EQU	$A
RIGHT	EQU	9
LEFT	EQU	8
DELETE	EQU	$7F
NONPRT	EQU	$7C
TEXT	EQU	$2000
STACK	EQU	TEXT-1
INBUF	EQU	TEXT-256
INIT	MVI	A,$FF
	STA	TEXT
	SUB	A
	STA	MODE
	LXI	H,TEXT
	SHLD	TXTPOS
	SVC	14
	JZ	WRSCRN
	SVC	19
	RNZ
	LXI	H,TEXT
	SVC	26
	RNZ
	MVI	B,1
	SVC	28
	RNZ
	JMP	MOVTOP
SPACE	MVI	A,' '
	JMP	COUT
PMSG	MOV	A,M
	CPI	$FF
	RZ
	CALL	COUT
	CPI	$0D
	INX	H
	JNZ	PMSG
	CALL	CRLF
	RET
CRLF	MVI	A,$0D
	CALL	COUT
	MVI	A,$0A
COUT	PUSH	B
	MOV	B,A
	PUSH	H
	LDA	SCLPOS
	MOV	C,A
	LHLD	CURPOS
	MOV	A,L
	CPI	23
	JC	OKOUT
	MOV	A,B
	CPI	$0A
	JZ	SKOUT
OKOUT	SUB	A
	SVC	5
SKOUT	MOV	A,B
	CPI	' '
	JC	CTRL
	CPI	DELETE
	JZ	NOINX
CADV	INR	H
	MOV	A,H
	CPI	80
	JC	NOINX
	MVI	H,0
CDWN	MOV	A,C
	CPI	2
	JZ	NOINX
	INR	L
	MOV	A,L
	CMP	C
	JZ	CTOPT
	CPI	24
	JC	NOINX
CTOPT	MVI	L,2
	JMP	NOINX
CTRL	CPI	$0D
	JNZ	MUP
	MVI	H,0
	JMP	NOINX
MUP	CPI	UP
	JNZ	MDN
	MOV	A,C
	CPI	2
	JZ	NOINX
	MOV	A,L
	CPI	23
	JNZ	MUPOK
MBOT	MOV	L,C
	DCR	L
	JMP	NOINX
MUPOK	CPI	3
	JC	MBOT
	DCR	L
	JMP	NOINX
MDN	CPI	DOWN
	JZ	CDWN
	CPI	RIGHT
	JZ	CADV
	CPI	LEFT
	JNZ	MCLR
	DCR	H
	JP	NOINX
	MVI	H,79
	DCR	L
	MOV	A,L
	CPI	2
	JNC	NOINX
	MVI	L,2
	JMP	NOINX
MCLR	CPI	CLR
	JNZ	NOINX
	LXI	H,0
NOINX	SHLD	CURPOS
	MOV	A,B
	POP	H
	POP	B
	RET
;CURSOR	MVI	A,$18
;	PUSH	H
;	CALL	OUT0
;	SUB	A
;CLOOP	DCR	H
;	JM	CEXIT
;	ADI	1
;	DAA
;	JMP	CLOOP
;CEXIT	CALL	OUT0
;	MOV	A,L
;	POP	H
;	SHLD	CURPOS
;OUT0	PUSH	B
;	MOV	B,A
;	SUB	A
;	SVC	5
;	POP	B
;	RET
CURSOR	MVI	A,$1B		; ESC lead-in
	CALL	OUT0		; Write it
	MVI	A,'='		; Load cursor
	CALL	OUT0		; Write it
	MOV	A,H		; Get X
	CALL	OUT1		; Output
	MOV	A,L		; Get Y
out1:	ADI	' '		; Adjust to ASCII
out0:	PUSH	B		; Save B
	MOV	B,A		; Copy character
	SUB	A		; Console device
	SVC	5		; Output
	POP	B		; Restore
	RET
;
SCALE	MVI	C,'1'
SCLP1	LXI	H,STXT
	CALL	PMSG
	MOV	A,C
	INR	C
	CALL	COUT
	CPI	'8'
	JNZ	SCLP1
	RET
STXT	STR	'----*----'
	DB	$FF
PROMPT	STR	'==> '
	DB	$FF
FEDIT	STR	'FEDIT:  '
	DB	$FF
INPUT	STR	' INPUT MODE'
	DB	$FF
INSERT	STR	'INSERT MODE'
	DB	$FF
NORMAL	STR	'  EDIT MODE'
	DB	$FF
MODE	DB	0
SCLPOS	DB	0
DEFPOS	DW	$0417
TXTPOS	DW	0
TXTEND	DW	0
CURPOS	DW	0
MSGTXT	DW	RDYMSG
WRHEAD	LXI	H,0
	CALL	CURSOR
	LXI	H,FEDIT
	CALL	PMSG
	LDA	MODE
	LXI	H,NORMAL
	ANA	A
	JZ	HEADC
	LXI	H,INPUT
	DCR	A
	JZ	HEADC
	LXI	H,INSERT
HEADC	MVI	C,61
HEAD1	MVI	A,' '
	CALL	COUT
	DCR	C
	JNZ	HEAD1
	CALL	PMSG
	LXI	H,$0700
	CALL	CURSOR
	LHLD	MSGTXT
	CALL	PMSG
	LXI	H,RDYMSG
	SHLD	MSGTXT
	RET
DISTXT	LXI	H,2
	CALL	CURSOR
	MVI	C,20
	LXI	D,SCREEN-1
	LHLD	TXTPOS
DLP0	MVI	B,80
DLP1	MOV	A,B
	CPI	3
	MOV	A,M
	INX	H
	JC	SKDIS
	DCX	H
	INX	D
	STAX	D
	DCR	B
	CPI	$FF
	JZ	BOTSCL
	INX	H
	CPI	' '
	JNC	OKPRT
	CPI	$0D
	JZ	OKPRT
	MVI	A,NONPRT
OKPRT	CALL	COUT
SKDIS	CPI	$0D
	JNZ	DLP1
	MVI	A,$A0
	STAX	D
CLRP	INX	D
	STAX	D
	DCR	B
	JNZ	CLRP
	CALL	CRLF
	DCR	C
	JNZ	DLP0
	INX	D
	MVI	A,$FF
	STAX	D
BOTSCL	MVI	A,22
	SUB	C
	STA	SCLPOS
	SHLD	TXTEND
	MOV	L,A
	MVI	H,0
	CALL	CURSOR
	CALL	SCALE
	RET
CIN	SUB	A
	LHLD	CURPOS
	SHLD	LSTPOS
	SVC	2		; Get character
	CPI	HOME		; Command?
	JZ	GETCMD		; Do command
	CPI	INPCHR
	JZ	INPMOD
	CPI	CLR
	JZ	SCRCLR
	CPI	CANEDT
	JZ	WRSCRN
	CPI	$1B
	RNZ
	LDA	MODE
	ANA	A
	MVI	A,2
	JZ	INSMOD
	SUB	A
	JMP	INSMOD
INPMOD	MVI	A,1
INSMOD	STA	MODE
	PUSH	PSW
	CALL	WRHEAD
	LHLD	LSTPOS
	CALL	CURSOR
	MOV	A,L
	CPI	23
	JZ	NOADD
	POP	PSW
	CPI	1
	JZ	INSLIN
	JMP	CIN
SCRCLR	CALL	REPL
	JMP	WRSCRN
NOADD	POP	PSW
	JMP	CIN
LSTPOS	DW	0
REPL	LXI	H,SCREEN
	LDA	SCLPOS
	DCR	A
	DCR	A
	MOV	C,A
	MOV	B,A
	ANA	A
	JZ	SKPIN
FIX1	LXI	D,80
	DAD	D
	DCR	E
	PUSH	H
	DCX	H
	MVI	M,$0D
FIX2	DCX	H
	MOV	A,H
	CPI	=SCREEN
	JC	NOSPAC
	MOV	A,M
	CPI	$A0
	JNZ	NOSPAC
	MVI	M,$0D
	DCR	E
	JNZ	FIX2
NOSPAC	POP	H
	DCR	C
	JNZ	FIX1
SKPIN	MVI	M,$FF
	LXI	H,SCREEN
	MOV	D,H
	MOV	E,L
CLBLK	MOV	A,M
	CPI	$0D
	JZ	CLE1
CLEAN	MOV	A,M
	CPI	$0D
	JZ	CLEOL
	INX	H
	CPI	$A0
	JNZ	OKCLN
	MVI	A,' '
OKCLN	STAX	D
	INX	D
	CPI	$FF
	JNZ	CLEAN
EXCLN	LXI	H,CMPSRN-1
	DAD	D
	XCHG
	LHLD	TXTPOS
	DAD	D
	XCHG
	LHLD	TXTEND
	CALL	CHLDE
	JZ	NOMOV
	JC	INSMOV
DELMOV	MOV	A,M
	STAX	D
	INX	H
	INX	D
	CPI	$FF
	JNZ	DELMOV
	JMP	NOMOV
INSMOV	PUSH	H
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	DAD	D
	XCHG
	CALL	GEOF
	MOV	B,H
	MOV	C,L
	DAD	D
	POP	D
INLPX	LDAX	B
	MOV	M,A
	CALL	CHLDE
	JZ	NOMOV
	DCX	H
	DCX	B
	JMP	INLPX
NOMOV	LHLD	TXTPOS
	LXI	D,SCREEN
	LDAX	D
	CPI	$0D
	JNZ	NOLP1
	INX	D
NOLP1	LDAX	D
	CPI	$FF
	RZ
	MOV	M,A
	INX	H
	INX	D
	JMP	NOLP1
CHLDE	MOV	A,H
	CMP	D
	RNZ
	MOV	A,L
	CMP	E
	RET
GEOF	LXI	H,TEXT
GEOFX	MOV	A,M
	CPI	$FF
	RZ
	INX	H
	JMP	GEOFX
CLEOL	STAX	D
	INX	D
CLE1	INX	H
	CMP	M
	JZ	CLE1
	JMP	CLBLK
DISSCR	MVI	A,CLR
	CALL	COUT
	CALL	WRHEAD
	LXI	H,1
	CALL	CURSOR
	CALL	SCALE
	CALL	DISTXT
	LXI	H,$17
	CALL	CURSOR
	LXI	H,PROMPT
	JMP	PMSG
WRSCRN	CALL	DISSCR
GETCMD	LXI	SP,STACK
	LXI	H,$17
	CALL	CURSOR
	MVI	B,78
	LXI	H,INBUF
	LXI	D,INBUF+80
CLRCMD	MVI	A,' '
	CALL	COUT
	MOV	A,M
	STAX	D
	MVI	M,$A0
	INX	H
	INX	D
	DCR	B
	JNZ	CLRCMD
	MVI	A,$0D
	MOV	M,A
	STAX	D
	CALL	COUT
	LXI	H,PROMPT
	CALL	PMSG
	LHLD	DEFPOS
	CALL	CURSOR
	LXI	H,$0417
	SHLD	DEFPOS
GETLIN	CALL	CIN
	LHLD	CURPOS
	XCHG
	CPI	$0A
	CALL	COUT
	LHLD	CURPOS
	CPI	$0D
	JZ	CRSPEC
	CPI	CLRLIN
	JZ	TXTOK
	CPI	' '
	JC	FIXPOS
TXTOK	PUSH	H
	MOV	B,A
	MOV	A,E
	CPI	23
	MOV	A,B
	JNZ	NOC1
	LXI	H,INBUF-4
	MVI	B,0
	JMP	NOC2
NOC1	LXI	H,SCREEN-80
	DCR	E
	LXI	B,80
FNDLP	DAD	B
	DCR	E
	JNZ	FNDLP
NOC2	MOV	C,D
	DAD	B
	CPI	DELETE
	JZ	DELCHR
	CPI	CLRLIN
	JZ	ERAEOF
	PUSH	PSW
	LDA	MODE
	CPI	2
	JNZ	NOINS
	PUSH	H
	MOV	B,M
INSLP	INX	H
	MOV	C,M
	MOV	M,B
	MOV	A,B
	CALL	COUT
	MOV	B,C
	INR	D
	MOV	A,D
	CPI	78
	JC	INSLP
	POP	H
NOINS	POP	PSW
	MOV	M,A
POSCSR	POP	H
	CALL	CURSOR
	JMP	GETLIN
DELCHR	MOV	B,H
	MOV	C,L
DELP1	INX	B
	LDAX	B
	MOV	M,A
	CALL	COUT
	INX	H
	INR	D
	MOV	A,D
	CPI	79
	JC	DELP1
	JMP	POSCSR
ERAEOF	LDA	CURPOS+1
	MOV	B,A
	MVI	A,79
	SUB	B
	MOV	B,A
ERLP	DCR	B
	JM	POSCSR
	MVI	A,' '
	MVI	M,$A0
	INX	H
	CALL	COUT
	JMP	ERLP
CRSPEC	MOV	A,L
	CPI	23
	JZ	GOTCMD
	LDA	SCLPOS
	DCR	A
	CMP	L
	JZ	GETCMD
	MVI	A,$0A
	CALL	COUT
	LDA	MODE
	DCR	A
	JNZ	FIXPOS
INSLIN	LHLD	CURPOS
	SHLD	LSTPOS
	DCR	L
	MOV	A,L
	LXI	H,SCREEN-80
	LXI	B,80
FX1	DAD	B
	DCR	A
	JNZ	FX1
	XCHG
	LXI	H,SCREEN
	CALL	GEOFX
	PUSH	H
	DAD	B
	XTHL
	POP	B
FX2	MOV	A,M
	STAX	B
	CALL	CHLDE
	JZ	FX3
	DCX	B
	DCX	H
	JMP	FX2
FX3	MVI	C,78
	MVI	M,' '
	INX	H
FX4	MVI	M,$A0
	INX	H
	DCR	C
	JNZ	FX4
	LDA	SCLPOS
	INR	A
	STA	SCLPOS
	CALL	REPL
	CALL	DISSCR
	LHLD	LSTPOS
	SHLD	CURPOS
FIXPOS	LHLD	CURPOS
	CALL	CURSOR
	JMP	GETLIN
GOTCMD	CALL	WRHEAD
CMDENT	LXI	H,INBUF
	CALL	SKPBLK
	CPI	$0D
	JZ	GETCMD
	CPI	'='
	JZ	OLDCMD
	PUSH	PSW
	PUSH	H
	CALL	REPL
	POP	H
	MVI	B,0
	CALL	SKPBLK
	CPI	$0D
	JZ	ENDOP
FNDEND	MOV	A,M
	CPI	' '
	JZ	LSTOP
	CPI	$A0
	JZ	LSTOP
	INX	H
	JMP	FNDEND
OLDCMD	LXI	H,INBUF
	LXI	D,INBUF+80
	MVI	C,80
OLDMOV	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	C
	JNZ	OLDMOV
	JMP	CMDENT
LSTOP	MVI	C,1
CALC	DCX	H
	MOV	A,M
	SUI	'0'
	JC	ENDOP
	CPI	$A
	JNC	ENDOP
	MOV	E,A
	MOV	D,C
	SUB	A
MULP	ADD	E
	DCR	D
	JNZ	MULP
	ADD	B
	MOV	B,A
	MOV	A,C
	ADD	A
	ADD	A
	ADD	C
	ADD	A
	MOV	C,A
	JMP	CALC
ENDOP	MOV	A,B
	CPI	1
	JNC	SKDEF
	MVI	B,19
SKDEF	POP	PSW
	CPI	'Q'
	JNZ	NOTQ
	MVI	A,CLR
	CALL	COUT
	SUB	A
	SVC	30
NOTQ	CPI	'N'
	JNZ	NOTNXT
LOOP	CALL	ADVLIN
	JZ	WRSCRN
	DCR	B
	JNZ	LOOP
	JMP	WRSCRN
ADVLIN	LHLD	TXTPOS
NEW	MOV	A,M
	CPI	$FF
	RZ
	INX	H
	CPI	$0D
	JNZ	NEW
	SHLD	TXTPOS
	ORI	$FF
	RET
NOTNXT	CPI	'U'
	JNZ	NOTUP
MOVUP	LHLD	TXTPOS
	DCX	H
BAC	DCX	H
	MOV	A,H
	CPI	=(TEXT-100)
	JZ	MOVTOP
	MOV	A,M
	CPI	$0D
	JNZ	BAC
	INX	H
	SHLD	TXTPOS
	DCR	B
	JNZ	MOVUP
	JMP	WRSCRN
SKPBLK	MOV	A,M
	INX	H
	CPI	' '
	JZ	SKPBLK
	CPI	$A0
	JZ	SKPBLK
	RET
NOTUP	CPI	'B'
	JNZ	GOEND
MOVTOP	LXI	H,TEXT
	SHLD	TXTPOS
	JMP	WRSCRN
GOEND	CPI	'E'
	JNZ	FIND
	CALL	GEOF
	SHLD	TXTPOS
	JMP	MOVUP
UNCMD	LXI	H,UNKMSG
ERRMSG	SHLD	MSGTXT
	JMP	WRSCRN
RDYMSG	STR	'READY'
	DB	$0D
BADOP	STR	'INVALID FILE NAME'
	DW	=$070D
FNF	STR	'FILE NOT FOUND'
	DW	=$070D
DSKERR	STR	'HARD ISK ERROR'
	DW	=$070D
INVRC	STR	'BAD DOS RC'
	DW	=$070D
SIZMSG	STR	'FILE OVERFLOW'
	DW	=$070D
UNKMSG	STR	'UNKNOWN COMMAND'
	DW	=$070D
STRNF	STR	'STRING NOT FOUND'
	DW	=$070D
INPMSG	STR	'ENTER TEXT:'
	DB	$0D
FIND	CPI	'/'
	JNZ	INPTXT
	LHLD	TXTPOS
FITOP	MOV	A,M
	INX	H
	ANA	A
	JM	NOTFND
	CPI	$0D
	JNZ	FITOP
LINT	LXI	D,INBUF+1
LLOK	MOV	A,M
	INR	A
	JZ	NOTFND
	LDAX	D
LL2	CMP	M
	INX	H
	JNZ	LINT
	INX	D
	LDAX	D
	CPI	$A0
	JNZ	LL2
	MVI	B,1
	SHLD	TXTPOS
	JMP	MOVUP
NOTFND	LXI	H,STRNF
	JMP	ERRMSG
INPTXT	CPI	'I'
	JNZ	LOAD
	CALL	GEOF
	PUSH	H
	LXI	B,20
	DAD	B
	XCHG
	LHLD	TXTPOS
	DCX	H
	MOV	B,H
	MOV	C,L
	POP	H
INPMOV	MOV	A,M
	STAX	D
	DCX	D
	DCX	H
	MOV	A,H
	CMP	B
	JNZ	INPMOV
	MOV	A,L
	CMP	C
	JNZ	INPMOV
	MVI	E,21
	MVI	A,$0D
INPCR	STAX	B
	INX	B
	DCR	E
	JNZ	INPCR
	LXI	H,$0002
	SHLD	DEFPOS
	LXI	H,INPMSG
	JMP	ERRMSG
LOAD	CPI	'L'
	JNZ	SAVE
	CALL	DLOOK
	MVI	B,1
	SVC	28
	JZ	WRSCRN
ACCERR	LXI	H,BADOP
	DCR	A
	JZ	ERRMSG
	LXI	H,FNF
	DCR	A
	JZ	ERRMSG
	DCR	A
	LXI	H,DSKERR
	DCR	A
	JZ	ERRMSG
	LXI	H,INVRC
	JMP	ERRMSG
DLOOK	LXI	D,INBUF
	PUSH	D
DLK1	INX	D
	LDAX	D
	CPI	$A0
	JNZ	DLK1
	MVI	A,$0D
	STAX	D
	POP	D
	SVC	14
	INX	D
	LDAX	D
	CPI	'F'
	JNZ	UNCMD
	INX	D
	SVC	19
	JNZ	ACCERR
	LXI	H,TEXT
	SVC	26
	JNZ	ACCERR
	RET
SAVE	CPI	'S'
	JNZ	GETFIL
	CALL	DLOOK
	PUSH	H
	PUSH	B
	MOV	B,A
	CALL	GEOF
	DCX	H
	MOV	A,H
	SUI	=TEXT
	CMP	B
	MOV	A,B
	POP	B
	POP	H
	JNC	OVFL
	MVI	B,0
	SVC	28
	JNZ	ACCERR
	JMP	WRSCRN
OVFL	LXI	H,SIZMSG
	JMP	ERRMSG
GETFIL	CPI	'G'
	JNZ	UNCMD
	CALL	DLOOK
	PUSH	PSW
	PUSH	H
	CALL	GEOF
	XCHG
	POP	H
	POP	PSW
	SVC	28
	JNZ	ACCERR
	JMP	WRSCRN
ENDIT	EQU	*
