SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$2000
;
; DMF "NSTAR" NorthStar DOS emulator by D. Dunfield
;
HDE	EQU	6
;
	LXI	H,HDERR		Point to HD error handler
	SHLD	HDERR+1		Save it
	SVC	41		Get filename
	RNZ			Error - quit
	JMP	START		And continue with startup
	NOP			Filler
;
; -- NorthStar DOS entry points
;
; Console output function
COUT	SVC	5		DMF COUT function
	RET
; Console input function
CIN	JMP	CONIN		Perform console in with LC->UC
; Terminal initialization function
TINIT	RET			Ignore
	RET			Filler
	RET			Filler
; Control-C test
CTRLC	SVC	1		DMF Ctrl-C check
	RET
HDERR	JMP	XHDERR		Entry point
DLOOK	JMP	XDLOOK		Entry point for directory lookup
DWRIT	JMP	XDWRIT		Entry point for directory writeback
DCOM	JMP	XDCOM		Entry point for disk command
LIST	JMP	XLIST		Entry point for directory list
DOS	JMP	XDOS		Entry point for DOS reentry
RWCHK	DB	$00		Read after write check flag (no used)
DOSERR	JMP	DOSERR		Dos error has occured
	DB	0		Indicates single-density
; Hard disk error - restore stack & exit
HERROR	LHLD	SAVSP		; Get SP
	SPHL			; Restore STACK
	JMP	HDERR		; Perform error
XHDERR	SVC	30		; Reenter DOS
; Return to OS
XDOS	SUB	A		Get zero
	SVC	35		Reset console output
	SVC	30		Return to DOS
; Console input - translate to uppercase
CONIN	SVC	4		DOS CIN function
	CPI	$61		Lower case?
	RC			No - it's OK
	ANI	$DF		Translate to upper
	RET
; Disk command:
; A=#blks B=W/R/V:0/1/2 C=Drive DE=RamAddr HL=DiskAddr
XDCOM	CALL	GETSP		Save SP in case error
	PUSH	PSW		Save # blks
	PUSH	D		Save RamAddr
	PUSH	H		Save DiskAddr
	SVC	27		DMF disk operation
	POP	H		Restore DiskAddr
	POP	D		Restore RamAddr
	CPI	HDE		Hard drive error? ???
	JZ	HERROR		Handle it
	POP	PSW		Restore # blocks
	ANA	A		Clear carry (OK)
	RET
; Directory list function
; A=Drive L=output device
XLIST	CALL	GETSP		; Save SP in case error
	ADI	$30		Convert to ASCII
	STA	NSNAME+5	Set drive for list
	MOV	A,L		Get passed device
	SVC	35		Set console output device
	LXI	D,NSNAME	Point to '*.#*'
	SVC	33		List Directory
	PUSH	PSW		Save return code
	MVI	A,$FF		No output ???
	SVC	35		Set console output device
	POP	PSW		Restore return code
	CPI	HDE		Drive error?
	JZ	HERROR		Handle it
	RET
NSNAME	STR	"*.#*,1"	Directory matching pattern
	DB	$0D		End of line
; Directory lookup routine
; A=Drive HL=Filename
XDLOOK	CALL	GETSP		Save SP in case error
	STA	DRIVE		Save for later
	ADI	$30		Convert to ASCII
	MOV	C,A		Save drive
	MOV	A,M		Get char from filename
	CPI	$20		Space?
	JZ	FNDNEW		End of name
	LXI	D,FNBUF		Point to filename buffer
	CALL	BLFILE		Zero the filename
XDL1	MOV	A,M		Get char from name
	CPI	$2C		Comma?
	JZ	XDL2		Yes - end of name
	CPI	$20		Space?
	JZ	XDL3		Yes - end of name
	CPI	$0D		Return?
	JZ	XDL3		Yes - end of name
	STAX	D		Copy into name
	INX	H		Next source
	INX	D		Next dest
	JMP	XDL1		Copy entire name
XDL2	INX	H		Skip ','
	MOV	C,M		Get drive
XDL3	MVI	A,$2E		Get '.'
	STAX	D		Append
	INX	D		Next
	MVI	A,$23		Get '#'
	STAX	D		Append
	INX	D		Next
	MVI	A,$30		Get '0'
	STAX	D		Append
	INX	D		Next
	MVI	A,$2A		Get '*'
	STAX	D		Append
	INX	D		Next
	MVI	A,$2C		Get ',' for drive
	STAX	D		Append
	INX	D		Next
	MOV	A,C		Get drive
	STAX	D		Append to filename
	SUI	$30		Convert to binary
	STA	DRIVE		Set our drive
	SVC	29		Set DOS disk drive
	JNZ	FERROR		Error
	INX	D		Skip drive
	MVI	A,$0D		Terminate with CR
	STAX	D		Store it
	LXI	D,FNBUF		Point to filename buffer
	SVC	17		Parse filename
	JNZ	FERROR		Error
	SVC	24		Lookup in directory
	CALL	TSTHDE		Test for HDE
	JNZ	FNDFRE		Not found
	SHLD	DMFDIR		Save DMF dirctory pointer
; Translate into north-star format
	LXI	D,NSDIR		Point to output entry
	MVI	B,$08		Move 8 chars
XDL4	MOV	A,M		Read from DMF
	STAX	D		Write to NS
	INX	H		Next DMF
	INX	D		Next NS
	DCR	B		Finished?
	JNZ	XDL4		Copy them all
	INX	H		Skip DMF type1
	INX	H		Skip DMF type2
	MOV	A,M		Get DMF type3
	SUI	$30		Convert to binary
	STA	NSDIR+12	Save NS file type
	INX	H		Skip type
	MOV	A,M		Get DMF disk address H
	STAX	D		Save in NS H
	INX	H		Next DMF
	INX	D		Next NS
	MOV	A,M		Get DMF disk address L
	STAX	D		Save in NS L
	INX	H		Next DMF
	MOV	A,M		Get DMF size
	STA	NSDIR+10	Save for later
	INX	H		Next DMF
	MOV	A,M		Get DMF UA
	STA	NSDIR+13	Save NS UA
	CALL	SWPADDR		Swap diskaddr endian
	LXI	H,NSDIR+8	Point to directory entry
	LDA	DRIVE		Get drive
	ANA	A		Clear C
	RET
;Not found - return free disk area
FNDFRE	SVC	37		Locate free area
	LDA	DRIVE		Get drive
	STC			Indicate not found
	RET
; General Error
FERROR	SUB	A		Get zero
	STC			Indicate fail
	RET
; Blank filename - request for empty dir
FNDNEW	MOV	A,C		Get drive
	SUI	$30		Convert to binary
	SVC	29		Set disk drive
	JNZ	FERROR		Error
	SVC	21		Read directory
	CALL	TSTHDE		Test for HDE
	SVC	38		Find free DIR entry
	SHLD	DMFDIR		Save for later
	LXI	H,NSDIR+8	Point to directory entry
	LDA	DRIVE		Get drive
	ANA	A		Clear C
	RET
; Test for hard disk error & handle
TSTHDE	RZ			No error - do nothing
	CPI	HDE		Was it HDE?
	JZ	HERROR		Yes - handle
	RET
; Write directry entry back to disk
XDWRIT	CALL	SAVSP		Save SP in case error
	LXI	D,NSDIR		Point to NS entry
	CALL	SWPADDR		Adjust disk address to DMF
	LHLD	DMFDIR		Point to DMF entry
	MVI	B,$08		Copy 8 bytes
XDW1	LDAX	D		Get from NS
	MOV	M,A		Write to DMF
	INX	D		Next NS
	INX	H		Next DMF
	DCR	B		Done?
	JNZ	XDW1		Do all 8
	MVI	M,$23		Set DMF type1 to '#'
	INX	H		Next
	MVI	M,$30		Set DMF type2 to '0'
	INX	H		Next
	LDA	NSDIR+12	Get NS type
	ADI	$30		Convert to ASCII
	MOV	M,A		Set DMF type3
	INX	H		Next
	LDAX	D		Get NS disk address H
	MOV	M,A		Set DMF disk address H
	INX	D		Next NS
	INX	H		Next DMF
	LDAX	D		Get NS disk address L
	MOV	M,A		Set DMF disk address L
	INX	H		Net
	LDA	NSDIR+10	Get NS file size
	MOV	M,A		Write DMF file size
	LDA	NSDIR+13	Get NS user data
	INX	H		Next
	MOV	M,A		Write DMF user data
	SVC	22		Write directory back to drive
	JMP	TSTHDE		Test for HDE & return
; Reset filename to blanks
BLFILE	PUSH	H		Save HL
	PUSH	B		Save BC
	MVI	B,$08		Copy 8 chars
	LXI	H,NSDIR		Point to filename
BFIL1	MVI	M,$20		Set to space
	INX	H		Next
	DCR	B		Reduce count
	JNZ	BFIL1		Set them all
	POP	B		Restore B
	POP	H		Restore H
	RET
; Swap endian of NorthStar entry to match DMF
SWPADDR	PUSH	H		Save HL
	LHLD	NSDIR+8		Get NS disk address
	MOV	A,L		Copy low to temp
	MOV	L,H		Copy high to low
	MOV	H,A		Copy temp to high
	SHLD	NSDIR+8		Resave
	POP	H		Restore HL
	RET
; Save stack pointer
GETSP	PUSH	H		; Save HL
	LXI	H,0-4		; (adjust for RET + HL)
	DAD	SP		; Get SP
	SHLD	SAVSP		; Save SP
	POP	H		; Restore H
	RET
;
; Startup - load file into memory
;
START	MVI	M,'#'		Append '#'
	INX	H		Next
	MVI	M,'0'		Append '0'
	INX	H		Next
	MVI	M,'1'		Append '1'
	XCHG			Get command position
	SHLD	SCMDP		Save for later
	SVC	24		Locate name in directory
	RNZ			Failed - stop
	PUSH	H		Save dir position
	LXI	D,$000E		Offset to udata
	DAD	D		Adjust pointer
	MOV	B,M		Get RUN addr HI
	INX	H		Next
	MOV	C,M		Get RUN addr LO
	POP	H		Restore dir pointer
	SVC	25		Compute disk operands
	RNZ			Failed - stop
	PUSH	D		Save RUN address
	SVC	28		Read file from disk
	POP	D		Restore RUN address
	RNZ			Failed - stop
	PUSH	D		Resave RUN address
	LHLD	SCMDP		Get command pointer
	RET			Execute NS program
;
SCMDP	DW	0		Saved command pointer
SAVSP	DW	0		Saved Stack pointer
NSDIR	STR	'        '	FILENAME
	DW	0		Disk address
	DW	0		File size
	DB	2		File type
	DW	0		User data
	DB	0		User data
FNBUF	STR	'ABCDEFGH.#0*,1  '
DRIVE	DB	$01		Drive indicator
DMFDIR	DW	$0000		DMF directory pointer
