RAM EQU *+$1000
STACK EQU RAM+$FF
DATA EQU RAM+$100
TCTRL EQU $10
TDATA EQU TCTRL+1
* TAPE PROTOCOL HANDSHAKEING FLAGS.
SOH     EQU     1               START OF DISK HEADER.
EOH     EQU     2               END OF DISK HEADER.
SOB     EQU     3               START OF BLOCK.
EOB     EQU     4               END OF BLOCK.
SOR     EQU     5               START OF RECORD.
EOR     EQU     6               END OF RECORD.
EOF     EQU     7               END OF FILE MARKER.
EOT     EQU     $FF             END OF TAPE MARKER.
FLAG    EQU     $DD             FLAG BYTE FOR TAPE MARKS.
TAPE LXI H,TABLE
 SVC 36
 ANA A
 JNZ DUMP
REWIND MVI A,$FB
 OUT TCTRL
REW1 IN TCTRL
 ANI $10
 JNZ REW1
 JMP STOP
DUMP DCR A
 JNZ LOAD
 LXI H,VOLID
 SVC 8
 SVC 13
 CALL SWRI
 MVI A,SOH
 CALL WCMD
WVOL LDAX D
 CALL WRITE
 INX D
 CPI $0D
 JNZ WVOL
 MVI A,EOH
 CALL WCMD
 CALL WSTOP
 MVI A,35
 LXI H,0
DMPLP PUSH PSW
 PUSH H
 LXI D,DATA
 LXI B,$0101
 MVI A,10
 SVC 27
 JNZ HDE
 LXI H,DATA
 MVI C,10
 CALL WBLOK
 POP H
 LXI B,10
 DAD B
 POP PSW
 DCR A
 JNZ DMPLP
 CALL SWRI
 MVI A,EOF
 CALL WCMD
 CALL WSTOP
 LXI H,VERMSG
 SVC 8
 CALL SCBAC
 JMP CHKDAT
LOAD DCR A
 JNZ NEXT
 CALL LOCVOL
 MVI A,35
 LXI H,0
LDLP PUSH PSW
 PUSH H
 LXI H,DATA
 CALL RBLOK
 LXI D,DATA
 POP H
 PUSH H
 LXI B,$0001
 MVI A,10
 SVC 27
 JNZ HDE
 POP H
 LXI B,10
 DAD B
 POP PSW
 DCR A
 JNZ LDLP
 CALL SRED
 CALL SCMD
 CPI EOF
 JNZ FMTERR
 JMP STOP
LOCVOL LXI H,VOLID
 SVC 8
 SVC 13
 CALL SRED
LOOK CALL SCMD
 CPI EOT
 JZ ENDT
 DCR A
 JNZ LOOK
 MOV H,D
 MOV L,E
CMPAR CALL READ
 CMP M
 INX H
 JNZ LOOK
 CPI $0D
 JNZ CMPAR
 CALL SCMD
 CPI EOH
 JNZ FMTERR
 RET
NEXT DCR A
 JNZ BACK
 SVC 16
 JNZ HDE
 CALL SRED
NXLP CALL SCMD
 CPI EOT
 JZ ENDT
 CPI EOF
 JNZ NXLP
 DCR L
 JNZ NXLP
 JMP STOP
BACK DCR A
 JNZ OFFL
SCBAC MVI A,$FD
 OUT TCTRL
SCB CALL READ
 CPI FLAG
 JNZ SCB
 CALL READ
 DCR A
 JNZ SCB
 CALL READ
 CPI FLAG
 JNZ SCB
 JMP STOP
OFFL DCR A
 JNZ SCAN
 MVI A,$F7
 OUT TCTRL
 MVI A,$FF
 OUT TCTRL
 SUB A
 RET
SCAN DCR A
 JNZ FEOT
 CALL SRED
 LXI H,0
FNDHED CALL SCMD
 CPI EOT
 JZ ENDT
 DCR A
 JNZ FNDHED
 LXI D,RAM
WRTITL CALL READ
 STAX D
 INX D
 CPI $0D
 JNZ WRTITL
 MVI A,'#'
 SVC 3
 SVC 11
 MVI C,SOR
SPLP SVC 7
 DCR C
 JNZ SPLP
 PUSH H
 LXI H,RAM
 SVC 8
 POP H
 INR L
 JMP FNDHED
FEOT DCR A
 JNZ CLOSE
 CALL SRED
LKEOT CALL SCMD
 INR A
 JNZ LKEOT
 CALL STOP
 MVI A,$FD
 OUT TCTRL
 CALL SCMD
 JMP STOP
CLOSE DCR A
 JNZ CHECK
 CALL SWRI
 MVI A,EOT
 CALL WCMD
 JMP WSTOP
CHECK DCR A
 JNZ ERROR
 CALL LOCVOL
CHKDAT MVI A,35
CHLP PUSH PSW
 LXI H,DATA
 CALL RBLOK
 POP PSW
 DCR A
 JNZ CHLP
 CALL SRED
 CALL SCMD
 CPI EOF
 JNZ FMTERR
 JMP STOP
ERROR LXI H,UNCMD
 JMP ERET
WAIRDY IN TCTRL
 ANI $2
 JNZ WAIRDY
 RET 
SRED MVI A,$FE
 OUT TCTRL
 RET 
SWRI MVI A,$EE
 OUT TCTRL
 CALL DELAY
 MVI A,16
WRZ1 PUSH PSW
 SUB A
 CALL WRITE
 POP PSW
 DCR A
 JNZ WRZ1
 RET
DELAY IN TCTRL
 ANI $10
 JNZ SDLY
LDLY PUSH H
 LXI H,0
 JMP DLYGO
SDLY PUSH H
 LXI H,$1000
DLYGO DCX H
 MOV A,H
 ORA L
 JNZ DLYGO
 POP H
 RET 
WRITE PUSH PSW
 OUT TDATA
 MVI A,SOR
WLP DCR A
 JNZ WLP
 POP PSW
 RET 
WCMD PUSH PSW
 MVI A,FLAG
 CALL WRITE
 POP PSW
 CALL WRITE
 MVI A,FLAG
 JMP WRITE
SCMD CALL READ
 CPI FLAG
 JNZ SCMD
 CALL READ
 CPI FLAG
 JZ SCMD
 PUSH PSW
 CALL READ
 CPI FLAG
 JNZ FMTERR
 POP PSW
 RET 
READ IN TCTRL
 RRC TEST
 JNC READ
 IN TDATA
 RET 
WBLOK CALL WAIRDY
 CALL SWRI
 MVI C,10
 MVI A,SOB
 CALL WCMD
WMEM PUSH B
 CALL WREC
 POP B
 DCR C
 JNZ WMEM
 MVI A,EOB
 CALL WCMD
WSTOP MVI A,8
WSLP PUSH PSW
 SUB A
 CALL WRITE
 POP PSW
 DCR A
 JNZ WSLP
STOP MVI A,$FF
 OUT TCTRL
 JMP WAIRDY
RBLOK CALL SRED
RBLP CALL SCMD
 CPI SOB
 JNZ RBLP
RDAT CALL RREC
 JZ RDAT
 CPI EOB
 JNZ FMTERR
 JMP STOP
WREC IN TCTRL
 ANI $40
 JZ WPROT
 MVI A,SOR
 CALL WCMD
 LXI B,0
WDAT MOV A,M
 INX H
 CALL WRITE
 CPI FLAG
 CZ WRITE
 ADD C
 MOV C,A
 DCR B
 JNZ WDAT
 CALL WRITE
 CPI FLAG
 CZ WRITE
 MVI A,EOR
 JMP WCMD
RREC LXI B,0
REC1 CALL SCMD
 CPI SOR
 RNZ
REC2 CALL READ
 CPI FLAG
 JNZ NODD
 CALL READ
 CPI FLAG
 JNZ FMTERR
NODD MOV M,A
 ADD C
 MOV C,A
 INX H
 DCR B
 JNZ REC2
 CALL READ
 CPI FLAG
 CZ READ
 CMP C
 JNZ CHKERR
 CALL SCMD
 CPI EOR
 RZ
FMTERR LXI H,FMTMSG
 JMP ERET
WPROT LXI H,WMSG
 JMP ERET
ENDT LXI H,EMSG
 JMP ERET
CHKERR LXI H,CHKMSG
ERET CALL STOP
 SVC 8
 MVI A,99
HDE SVC 30
FMTMSG STR 'INVALID TAPE FORMAT'
 DB $0D
CHKMSG STR 'CHECKSUM ERROR'
 DB $0D
VOLID STR 'VOLUME?!'
EMSG STR 'END OF TAPE.'
 DB $0D
UNCMD STR 'UNKNOWN COMMAND'
 DB $0D
WMSG STR 'TAPE PROTECTED'
 DB $0D
VERMSG STR 'CHECKING...'
 DB $0D
TABLE DB $83
 STR 'REWIND'
 DB $82
 STR 'DUMP'
 DB $82
 STR 'LOAD'
 DB $82
 STR 'NEXT'
 DB $82
 STR 'BACK'
 DB $83
 STR 'OFFLINE'
 DB $82
 STR 'SCAN'
 DB $82
 STR 'EOT'
 DB $83
 STR 'CLOSE'
 DB $82
 STR 'CHECK'
 DB $80
ENDIF EQU *
