***************************************************************************
* TAPE BASED DISK BACKUP/RESTORE PROGRAM USING PERCOM 9 TRACK TAPE DRIVE. *
*-------------------------------------------------------------------------*
* FUNCTIONS SUPPORTED:                                                    *
*     TAPE REWIND           - REWIND TO PHYSICAL BEGINNING OF TAPE.       *
*     TAPE DUMP             - DUMP DISK IN DRIVE#1 TO TAPE.               *
*     TAPE LOAD             - RESTORE DISK IN DRIVE#1 FROM TAPE.          *
*     TAPE NEXT <N>         - POSITION THE TAPE AHEAD <N> SAVED DISKS.    *
*     TAPE BACK             - POSITION THE TAPE BACK BY ONE SAVED DISK.   *
*     TAPE OFFLINE          - FORCE TAPE DRIVE OFFLINE.                   *
*     TAPE SCAN             - DISPLAYS NAMES OF ALL SAVED DISK VOLUMES    *
*                             FROM THE CURRENT POSITION TO END OF TAPE.   *
*     TAPE EOT              - ADVANCE TO JUST BEFORE END OF TAPE MARKER.  *
*     TAPE CLOSE            - WRITE AN END OF TAPE MARKER ON THE TAPE.    *
*     TAPE CHECK            - VERIFY A SAVED VOLUME CHECKSUM AND FORMAT.  *
*-------------------------------------------------------------------------*
* TAPE INTERFACE PORTS:                                                   *
*                                                                         *
*  CONTROL PORT (WRITE ONLY, INVERTED LOGIC (0=ENABLED)):                 *
*     BIT# 7 6 5 4 3 2 1 0 -- START DRIVE IN FORWARD MOTION.              *
*          ^ ^ ^ ^ ^ ^ ^----- START DRIVE IN REVERSE MOTION.              *
*          ^ ^ ^ ^ ^ ^------- REWIND TO LOAD POINT.                       *
*          ^ ^ ^ ^ ^--------- FORCE DRIVE OFFLINE.                        *
*          ^ ^ ^ ^----------- ENABLE WRITE OPERATION.                     *
*          ^ ^ ^------------- SELECT DENSITY.                             *
*          ^ ^--------------- WRITE AMPLIFIER RESET.                      *
*          ^----------------- OVERWRITE.                                  *
*                                                                         *
*  STATUS PORT (READ ONLY, INVERTED LOGIC (0=TRUE)):                      *
*      BIT# 7 6 5 4 3 2 1 0 -- DATA AVAILABLE.                            *
*           ^ ^ ^ ^ ^ ^ ^----- DRIVE READY.                               *
*           ^ ^ ^ ^ ^ ^------- REWINDING.                                 *
*           ^ ^ ^ ^ ^--------- END OF TAPE.                               *
*           ^ ^ ^ ^----------- LOAD POINT.                                *
*           ^ ^ ^------------- DATA DENSITY INDICATOR.                    *
*           ^ ^--------------- TAPE WRITE PROTECTED.                      *
*           ^----------------- DATA PARITY ERROR.                         *
***************************************************************************
* MEMORY AND I/O LOCATIONS.
RAM	EQU	*+$1000		POINT TO FREE RAM.
STACK	EQU	RAM+$FF		PLACE TO SET UP STACK.
DATA	EQU	RAM+$100	DATA FOR TRACK BUFFER.
TCTRL	EQU	$10		TAPE CONTROL/STATUS PORT.
TDATA	EQU	TCTRL+1		TAPE DATA PORT.
PORTS	EQU	08		CONSOLE STATUS PORT
PORTD	EQU	09		CONSOLE DATA PORT
* TAPE PROTOCOL HANDSHAKEING FLAGS.
SOH	EQU	1		START OF DISK HEADER.
EOH	EQU	2		END OF DISK HEADER.
SOB	EQU	3		START OF BLOCK.
EOB	EQU	4		END OF BLOCK.
SOR	EQU	5		START OF RECORD.
EOR	EQU	6		END OF RECORD.
EOF	EQU	7		END OF FILE MARKER.
EOT	EQU	$FF		END OF TAPE MARKER.
FLAG	EQU	$DD		FLAG BYTE FOR TAPE MARKS.
* START OF PROGRAM CODE, FIND OUT COMMAND, AND EXECUTE.
TAPE	LXI	H,TABLE		POINT TO COMMAND TABLE.
	SVC	36		LOOK UP COMMAND IN TABLE.
	ANA	A		TEST FOR REWIND COMMAND.
	JNZ	DUMP
* REWIND COMMAND, REWINDS TAPE TO START.
REWIND	MVI	A,$FB		GET REWIND TAPE COMMAND.
	OUT	TCTRL		OUTPUT TO CONTROL PORT.
* WAIT FOR LOAD POINT BEFORE CONTINUING.
REW1	IN	TCTRL		READ TAPE STATUS.
	ANI	$10		IS DRIVE AT LOAD POINT (START OF TAPE).
	JNZ	REW1		IF NOT, KEEP WAITING.
	JMP	STOP		RETURN TO STOP DRIVE.
* DUMP COMMAND, DUMPS A DISK VOLUME TO TAPE DRIVE.
DUMP	DCR	A		IS IT 'DUMP'.
	JNZ	LOAD		NO, TRY LOAD.
	LXI	H,VOLID		POINT TO MESSAGE.
	SVC	8		DISPLAY ON TERMINAL.
	SVC	13		GET A LINE OF INPUT.
	CALL	SWRI		START TAPE FOR WRITE OPERATION.
	MVI	A,SOH		GET START OF HEADER BYTE.
	CALL	WCMD		WRITE FLAG TO TAPE.
WVOL	LDAX	D		GET CHARACTER FROM VOLUME NAME.
	CALL	WRITE		WRITE TO TAPE.
	INX	D		ADVANCE TO NEXT.
	CPI	$0D		WAS IT A CARRIAGE RETURN.
	JNZ	WVOL		IF NOT, KEEP GOING.
	MVI	A,EOH		END OF HEADER FLAG.
	CALL	WCMD		WRITE TO TAPE.
	CALL	WSTOP		STOP TAPE.
	LXI	D,19584		MOVE 35 TRACKS.
	LXI	H,0		START AT ADDRESS ZERO.
DMPLP	PUSH	D		SAVE NUMBER OF TRACK REMAINING.
	PUSH	H		SAVE CURRENT DISK ADDRESS.
	LXI	D,DATA		POINT TO FREE RAM.
	MVI	A,10		READ 10 SECTORS (ONE TRACK).
	CALL	GETLINK		PERFORM DISK READ.
	LXI	H,DATA		POINT TO DATA SPACE.
	MVI	C,10		WRITE 10 SECTORS TO TAPE.
	CALL	WBLOK		WRITE OUT BLOCK.
	POP	H		RESTORE DISK ADDRESS.
	LXI	B,10		OFFSET BY 10 SECTORS (ONE TRACK).
	DAD	B		ADD TO DISK ADDRESS.
	POP	D		RESTORE NUMBER OF TRACKS TO GO.
	DCX	D		REDUCE NUMBER OF TRACKS REMAINING.
	MOV	A,D		GET VALUE
	ORA	E		TEST
	JNZ	DMPLP		IF MORE, KEEP DUMPING.
	CALL	SWRI		START TAPE FOR WRITE.
	MVI	A,EOF		GET END OF FILE FLAG.
	CALL	WCMD		WRITE FLAG TO TAPE.
	CALL	WSTOP		STOP TAPE.
	LXI	H,VERMSG	POINT TO CHECKING MESSAGE.
	SVC	8		DISPLAY ON TERMIANL.
	CALL	SCBAC		BACKUP TO START OF FILE.
	JMP	CHKDAT		CHECK TAPE FILE FOR INTEGRITY.
* LOAD COMMAND, RESTORES A DISK FROM TAPE.
LOAD	DCR	A		IS IT 'LOAD'.
	JNZ	NEXT		NO, TRY 'NEXT'.
	CALL	LOCVOL		FIND THE VOLUME WE WANT.
	MVI	A,35		WRITE 35 TRACKS.
	LXI	H,0		STARTING AT DISK ADDRESS ZERO.
LDLP	PUSH	PSW		SAVE TRACKS REMAINING.
	PUSH	H		SAVE DISK ADDRESS.
	LXI	H,DATA		POINT TO DATA AREA.
	CALL	RBLOK		READ A BLOCK.
	LXI	D,DATA		POINT TO DATA AREA.
	POP	H		RESTORE DISK ADDRESS.
	PUSH	H		RESAVE DISK ADDRESS.
	LXI	B,$0001		INDICATE WRITE OPERATION, ON DRIVE ONE.
	MVI	A,10		WRITE 10 SECTORS (ONE TRACK).
	SVC	27		PERFORM DISK WRITE.
	JNZ	ABORT		IF DISK ERROR, HANDLE.
	POP	H		RESTORE DISK ADDRESS.
	LXI	B,10		OFFSET BY 10 SECTORS (ONE TRACK).
	DAD	B		ADD TO CURRENT DISK ADDRESS.
	POP	PSW		RESTORE NUMBER OF TRACKS REMAINING.
	DCR	A		REDUCE TRACKS REMAINING.
	JNZ	LDLP		IF MORE, KEEP GOING.
	CALL	SRED		START TAPE FOR READ.
	CALL	SCMD		GET FLAG BYTE.
	CPI	EOF		TEST FOR END OF FILE.
	JNZ	FMTERR		IF NOT, FORMAT ERROR.
	JMP	STOP		STOP TAPE.
* PROMPTS FOR VOLUME NAME FROM TERMINAL, AND LOCATES IT ON THE TAPE.
LOCVOL	LXI	H,VOLID		POINT TO PROMPT MESSAGE.
	SVC	8		DISPLAY ON TERMINAL.
	SVC	13		GET LINE FROM TERMINAL.
	CALL	SRED		START TAPE FOR READ.
LOOK	CALL	SCMD		LOOK FOR FLAG BYTE.
	CPI	EOT		IS IT END OF TAPE.
	JZ	ENDT		IF SO, ABORT.
	DCR	A		TEST FOR START OF HEADER.
	JNZ	LOOK		IF NOT, KEEP LOOKING.
	MOV	H,D		SWAP ADDRESS INTO H-L, BUT ...
	MOV	L,E		PRESERVE D-E IN CASE WE HAVE TO LOOK AGAIN.
CMPAR	CALL	READ		GET A CHARACTER FROM TAPE.
	CMP	M		DOES IT MATCH?
	INX	H		ADVANCE TO NEXT.
	JNZ	LOOK		IF NOT, START AGAIN.
	CPI	$0D		IS IT A CARRIAGE RETURN?
	JNZ	CMPAR		IF NOT, KEEP COMPARING.
	CALL	SCMD		LOOK FOR END OF HEADER.
	CPI	EOH		IS IT END OF HEADER.
	JNZ	FMTERR		IF NOT, FORMAT ERROR.
	RET			RETURN WITH NEWS.
* NEXT COMMAND, SKIPS AHEAD A NUMBER OF SAVED DISKS.
NEXT	DCR	A		IS IT 'NEXT' COMMAND.
	JNZ	BACK		NO, TRY 'BACK'.
	SVC	16		GET OPERAND.
	JNZ	ABORT		IF ERROR, HANDLE IT.
	CALL	SRED		START TAPE FOR READ.
NXLP	CALL	SCMD		SCAN FOR COMMAND.
	CPI	EOT		IS IT END OF TAPE.
	JZ	ENDT		IF SO, INDICATE SO.
	CPI	EOF		IS IT END OF FILE.
	JNZ	NXLP		IF NOT, KEEP LOOKING.
	DCR	L		REDUCE COUNT OF DISKS TO GO.
	JNZ	NXLP		IF MORE, KEEP LOOKING.
	JMP	STOP		STOP TAPE.
* BACKUP COMMAND, BACKS UP ONE RECORD.
BACK	DCR	A		TEST FOR 'BACK.
	JNZ	OFFL		NO, TRY 'OFFLINE'.
SCBAC	MVI	A,$FD		SYNCRONUS REVERSE COMMAND.
	OUT	TCTRL		OUTPUT TO TAPE DRIVE.
SCB	CALL	READ		LOOK FOR A CHARACTER.
	CPI	FLAG		IS IT A COMMAND FLAG.
	JNZ	SCB		IF NOT, KEEP LOOKING.
	CALL	READ		GET FLAG BYTE.
	DCR	A		IS IT START OF HEADER?
	JNZ	SCB		NOZ, KEEP LOOKING.
	CALL	READ		GET NEXT BYTE.
	CPI	FLAG		IS IT A FLAG.
	JNZ	SCB		NO, MUST HAVE BEEN INVALID.
	JMP	STOP		STOP DRIVE.
* OFFLINE COMMAND, FORCE DRIVE OFFLINE.
OFFL	DCR	A		IS IT OFFLINE?
	JNZ	SCAN		NO, TRY 'SCAN'.
	MVI	A,$F7		GET OFFLINE COMMAND.
	OUT	TCTRL		OUTPUT TO TAPE DRIVE.
	MVI	A,$FF		RESET CONTROL BITS.
	OUT	TCTRL		OUTPUT TO TAPE DRIVE.
	SUB	A		SET ZERO RETURN CODE.
	RET
* SCAN COMMAND, SEARCH TAPE.
SCAN	DCR	A		IS TI 'SCAN'?
	JNZ	FEOT		NO, TRY FIND END OF TAPE.
	CALL	SRED		START DRIVE.
	LXI	H,0		INDICATE FILE# ZERO.
FNDHED	CALL	SCMD		LOOK FOR HEADER BYTE.
	CPI	EOT		IS IT END OF TAPE?
	JZ	ENDT		IF SO, GET UPSET (TERMINATE).
	DCR	A		TEST FOR START OF HEADER.
	JNZ	FNDHED		NO, KEEP LOOKING.
	LXI	D,RAM		POINT TO SPARE RAM.
WRTITL	CALL	READ		READ A CHARACTER.
	STAX	D		SAVE IN BUFFER.
	INX	D		ADVANCE TO NEXT.
	CPI	$0D		TEST FOR END OF LINE.
	JNZ	WRTITL		NO, KEEP SAVEING TITLE.
	MVI	A,'#'		GET NUMBER SIZE.
	SVC	3		DISPLAY ON CONSOLE.
	SVC	11		DISPLAY NUMBER.
	MVI	C,2		DISPLAY TWO SPACES.
	MOV	A,L		GET NUMBER WE DISPLAYED.
	CPI	10		<10?
	JNC	NOE1		NO EXTRA SPACE.
	INR	C		ADVANCE SPACE COUNT.
NOE1	CPI	100		> 100?
	JNC	SPLP		NO EXTRA SPACE.
	INR	C		ADVANCE SPACE COUNT.
SPLP	SVC	7		DISPLAY A SPACE.
	DCR	C		REDUCE COUNT.
	JNZ	SPLP		DISPLAY ALL SPACES.
	PUSH	H		SAVE NUMBER.
	LXI	H,RAM		POINT TO SAVED VOLUME NAME.
	SVC	8		DISPLAY TITLE OF DISK.
	POP	H		RESTORE NUMBER.
	INR	L		INCREMENT NUMBER.
	JMP	FNDHED		LOOK FOR NEXT HEADER.
* EOT COMMAND, LOOK FOR END OF TAPE.
FEOT	DCR	A		IS TI 'EOT'?
	JNZ	CLOSE		NO, TRY 'CLOSE'.
	CALL	SRED		START TAPE.
LKEOT	CALL	SCMD		LOOK FOR FLAG.
	INR	A		IS IT END OF TAPE?
	JNZ	LKEOT		NO, KEEP LOOKING.
	CALL	STOP		STOP TAPE.
* WE FOUND END OF TAPE, BACKUP UP TILL WE READ THE FLAG AGAIN, ALLOWING
* NEW ENTRIES TO OVERWRITE THE END OF TAPE MARKER.
	MVI	A,$FD		READ BACKWARDS COMMAND.
	OUT	TCTRL		OUTPUT TO TAPE.
	CALL	SCMD		SEARCH FOR A COMMAND.
	JMP	STOP		STOP DRIVE.
* CLOSE COMMAND, WRITES AND END OF TAPE MARKER.
CLOSE	DCR	A		IS IT 'CLOSE'?
	JNZ	CHECK		NO, TRY 'CHECK'.
	CALL	SWRI		START TAPE DRIVE.
	MVI	A,EOT		GET END OF TAPE MARKER.
	CALL	WCMD		WRITE TO TAPE DRIVE.
	JMP	WSTOP		STOP TAPE.
* CHECK COMMAND, VERIFIES A TAPE FILE FOR INTEGRITY.
CHECK	DCR	A		IS IT A 'CHECK'?
	JNZ	ERROR		NO, IT'S INVALID.
	CALL	LOCVOL		LOOK FOR OUR VOLUME.
CHKDAT	MVI	A,35		CHECK 35 BLOCKS.
CHLP	PUSH	PSW		SAVE COUNT.
	LXI	H,DATA		POINT TO DATA AREA.
	CALL	RBLOK		READ A BLOCK.
	POP	PSW		RESTORE COUNT.
	DCR	A		REDUCE NUMBER OF BLOCKS LEFT.
	JNZ	CHLP		IF MORE, READ THEM TWO.
	CALL	SRED		START FOR READ.
	CALL	SCMD		LOOK FOR COMMAND.
	CPI	EOF		IS IT END OF FILE?
	JNZ	FMTERR		IF NOT, IT'S A FORMAT ERROR.
	JMP	STOP		STOP TAPE DRIVE.
* INVALID COMMAND WAS ENTERED, INDICATE SO.
ERROR	LXI	H,UNCMD		POINT TO MESSAGE.
	JMP	ERET		ABORT.
* START TAPE FOR A READ OPERATION.
SRED	MVI	A,$FE		COMMAND TO START TAPE FORWARD, READ.
	OUT	TCTRL		ISSUE COMMAND TO TAPE CONTROLLER.
	RET
* START TAPE FOR WRITE OPERATION.
SWRI	MVI	A,$EE		COMMAND TO START TAPE FORWARD, WRITE.
	OUT	TCTRL		OUTPUT TO TAPE CONTROLLER.
	CALL	DELAY		WAIT FOR SPEED.
	MVI	A,16		WRITE 16 ZERO BYTES.
WRZ1	PUSH	PSW		SAVE COUNT.
	SUB	A		GET A ZERO.
	CALL	WRITE		OUTPUT TO TAPE.
	POP	PSW		RESTORE COUNT.
	DCR	A		REDUCE.
	JNZ	WRZ1		KEEP GOING TILL DONE.
	RET
* WAIT FOR TAPE TO GET INTO MOTION. IF AT LOAD POINT, DELAY LONGER.
DELAY	PUSH	H		SAVE H-L.
	LXI	H,$1000		GET SHORT DELAY VALUE.
	IN	TCTRL		GET TAPE STATUS.
	ANI	$10		ARE WE AT LOAD POINT?
	JNZ	DLYGO		IF NOT, USE SHORT DELAY.
	LXI	H,0		GET A LONG DELAY VALUE.
DLYGO	DCX	H		REDUCE COUNT.
	MOV	A,H		GET HIGH BYTE.
	ORA	L		TEST WITH LOW FOR ZERO.
	JNZ	DLYGO		KEEP GOING TILL WE USE UP DELAY.
	POP	H		RESTORE H-L.
	RET
* WRITES A FLAG TO THE TAPE.
WCMD	PUSH	PSW		SAVE THE FLAG VALUE.
	MVI	A,FLAG		GET FLAG BYTE.
	CALL	WRITE		OUTPUT TO TAPE.
	POP	PSW		GET VALUE BACK.
	CALL	WRITE		OUTPUT TO TAPE.
	MVI	A,FLAG		GET FLAG BYTE AGAIN.
* WRITE A CHARACTER TO THE TAPE.
WRITE	PUSH	PSW		SAVE CHARACTER.
	OUT	TDATA		OUTPUT TO TAPE.
	MVI	A,5		SHORT INTER-CHARACTER DELAY.
WLP	DCR	A		REDUCE COUNT.
	JNZ	WLP		LOOP TO USE UP DELAY.
	POP	PSW		RESTORE CHARACTER.
	RET
* SCAN FOR A COMMAND (FLAG) BYTE.
SCMD	CALL	READ		GET A CHARACTER.
	CPI	FLAG		IS IT A FLAG.
	JNZ	SCMD		NO, IGNORE IT.
	CALL	READ		READ VALUE.
	CPI	FLAG		TEST FOR NULL (DATA).
	JZ	SCMD		IF SO, IGNORE IT.
	PUSH	PSW		SAVE VALUE.
	CALL	READ		READ NEXT CHARACTER.
	CPI	FLAG		IS IT A FLAG.
	JNZ	FMTERR		NO, FORMAT ERROR.
	POP	PSW		RESTORE VALUE.
	RET
* READ A CHARACTER FROM TAPE.
READ	IN	TCTRL		GET TAPE STATUS.
	RRC			TEST FOR DATA AVAILABLE.
	JNC	READ		NO, KEEP TRYING.
	IN	TDATA		GET DATA.
	RET
* WRITE A BLOCK TO TAPE, HL=MEMORY ADDRESS, C=SIZE OF BLOCK (256 BYTE RECORDS)
WBLOK	CALL	WAIRDY		WAIT FOR DRIVE READY.
	CALL	SWRI		START FOR WRITE OPERATION.
	MVI	A,SOB		GET START OF BLOCK FLAG.
	CALL	WCMD		OUTPUT TO TAPE.
WMEM	PUSH	B		SAVE COUNT.
	CALL	WREC		WRITE A RECORD.
	POP	B		RESTORE COUNT.
	DCR	C		REDUCE COUNT.
	JNZ	WMEM		MORE TO WRITE.
	MVI	A,EOB		GET END OF BLOCK FLAG.
	CALL	WCMD		OUTPUT TO TAPE.
* STOP TAPE AFTER WRITE, PAD WITH 8 NULLS.
WSTOP	MVI	A,8		NUMBER OF NULLS TO PAD WITH.
WSLP	PUSH	PSW		SAVE COUNT.
	SUB	A		GET A ZERO.
	CALL	WRITE		WRITE TO TAPE.
	POP	PSW		RESTORE COUNT.
	DCR	A		REDUCE COUNT.
	JNZ	WSLP		WRITE ALL NULLS.
* STOP TAPE DRIVE, DISABLE ALL ACTIVE FUNCTIONS.
STOP	MVI	A,$FF		DISABLE ALL FUNCTIONS.
	OUT	TCTRL		OUTPUT TO TAPE CONTROLLER.
	XCHG			DELAY FOR TAPE CONTROLLER.
	XCHG			AND AGAIN SO WE LEAVE REGISTERS OK.
* WAIT FOR DRIVE TO BECOME READY.
WAIRDY	IN	TCTRL		GET TAPE STATUS.
	ANI	$2		IS DRIVE READY?
	JNZ	WAIRDY		NO, TRY AGAIN.
	RET
* READ A BLOCK, H-L IS START ADDRESS.
RBLOK	CALL	SRED		START TAPE FOR READ.
RBLP	CALL	SCMD		SHEACH FOR COMMAND.
	CPI	SOB		LOOK FOR START OF BLOCK.
	JNZ	RBLP		IF NOT, KEEP LOOKING.
RDAT	CALL	RREC		READ A RECORD.
	JZ	RDAT		IF MORE, KEEP GOING.
	CPI	EOB		LOOK FOR END OF BLOCK.
	JNZ	FMTERR		IF NOT, FORMAT ERROR.
	JMP	STOP		STOP DRIVE.
* WRITE A RECORD (256 BYTES).
WREC	IN	TCTRL		READ TAPE STATUS.
	ANI	$40		TEST FOR WRITE PROTECT.
	JZ	WPROT		IF SO, INDICATE INVALID.
	MVI	A,SOR		START OF RECORD FLAG.
	CALL	WCMD		WRITE TO TAPE.
	LXI	B,0		SET COUNT AND CHECKSUM TO ZERO.
WDAT	MOV	A,M		GET VALUE FROM MEMORY.
	INX	H		ADVANCE TO NEXT MEMORY LOCATION.
	CALL	WRITE		OUTPUT TO TAPE.
	CPI	FLAG		IS IT A FLAG BYTE.
	CZ	WRITE		IF SO, WRITE TWO FOR TRANSPARENT DATA.
	ADD	C		ADD TO CHECKSUM.
	MOV	C,A		REPLACE CHECKSUM.
	DCR	B		REDUCE COUNT.
	JNZ	WDAT		IF MORE, KEEP GOING.
	CALL	WRITE		OUTPUT CHECKSUM.
	CPI	FLAG		IS IT A FLAG.
	CZ	WRITE		IF SO, WRITE TWICE.
	MVI	A,EOR		GET END OF RECORD FLAG.
	JMP	WCMD		OUTPUT TO TAPE.
* READ A RECORD FROM TAPE, ON EXIT, Z=1 IF READ WAS OK, Z=0 IF NO RECORD
* WAS FOUND, AND ACC CONTAINS THE FLAG BYTE WHICH WAS FOUND INSTEAD.
RREC	LXI	B,0		SET CHECKSUM AND COUNT TO ZERO.
REC1	CALL	SCMD		LOOK FOR CONTROL BYTE.
	CPI	SOR		IS IT START OF RECORD.
	RNZ			NO, RETURN WITH VALUE.
REC2	CALL	READ		READ A CHARACTER.
	CPI	FLAG		IS IT A FLAG.
	JNZ	NODD		IF NOT, TREAT NORMAL.
	CALL	READ		READ NEXT CHARACTER.
	CPI	FLAG		IS IT A FLAG.
	JNZ	FMTERR		NO, FORMAT ERROR.
NODD	MOV	M,A		SAVE IN MEMORY.
	ADD	C		ADD TO CHECKSUM.
	MOV	C,A		REPLACE CHECKSUM.
	INX	H		ADVANCE TO NEXT.
	DCR	B		REDUCE COUNT.
	JNZ	REC2		IF MORE, KEEP READING.
	CALL	READ		GET CHECKSUM FROM TAPE.
	CPI	FLAG		IS IT A FLAG.
	CZ	READ		IF SO, READ DUPLICATE.
	CMP	C		DO THEY MATCH?
	JNZ	CHKERR		NO, GET UPSET.
	CALL	SCMD		SCAN FOR COMMAND.
	CPI	EOR		SEARCH FOR END OF RECORD.
	RZ			IF SO, GO HOME.
* TAPE FORMAT ERROR WAS DETECTED.
FMTERR	LXI	H,FMTMSG	POINT AT MESSAGE.
	JMP	ERET		HANDLE AND RETURN.
* TAPE WAS WRITE PROTECTED.
WPROT	LXI	H,WMSG		POINT AT MESSAGE.
	JMP	ERET		PROCESS AND RETURN.
* END OF TAPE WAS ENCOUNTERED.
ENDT	LXI	H,EMSG		POINT AT MESSAGE.
	JMP	ERET		HANDLE AND RETURN.
* CHECKSUM ERROR WAS DETECTED.
CHKERR	LXI	H,CHKMSG	POINT AT MESSAGE.
* DISPLAY ERROR MESSAGE AND RETURN.
ERET	CALL	STOP		STOP TAPE (IN CASE IT WAS RUNNING).
	SVC	8		OUTPUT MESSAGE.
	MVI	A,99		SET RETRUN CODE TO 99.
ABORT	SVC	30		RETURN TO OS.
*
* READ MULTIPLE BLOCKS FROM THE DISK
GETLINK	PUSH	PSW		SAVE COUNT
	CALL	GETBLK		GET A BLOCK
	POP	PSW		RESTORE COUNT
	DCR	A		REDUCE COUNT
	JNZ	GETLINK		MORE TO GO
	RET
* READ A BLOCK FROM THE DISK
GETBLK	CALL	ACK		SEND ACK
	CALL	WAITSOH
	JC	GETBLK
	LXI	B,0
BLKLP	CALL	GETHEX
	JC	CHARERR
	STAX	D
	INX	D
	DCR	C
	JNZ	BLKLP
	CALL	GETHEX		GET CHKSUM
	MOV	A,B
	CPI	0
	JNZ	CHARERR
	RET
CHARERR	CALL	NACK
	CALL	WAITSOH
	JC	CHARERR
	LXI	B,0
	JMP	BLKLP
*
ACK	MVI	A,'A'
	CALL	OUTPORT
	RET
*
NACK	MVI	A,'N'
	CALL	OUTPORT
	RET
*
WAITSOH	CALL	INPORT
	RC
	CPI	':'
	JNZ	WAITSOH
	ANA	A
	RET
*
GETHEX	CALL	HEX
	PUSH	B
	RLC
	RLC
	RLC
	RLC
	ANI	$F0
	MOV	B,A
	CALL	HEX
	ORA	B
	POP	B
	PUSH	PSW
	ADD	B
	MOV	B,A
	POP	PSW
	RET
HEX	CALL	INPORT
	RC
	SUI	'0'
	CPI	10
	JC	NXTHEX
	SUI	7
NXTHEX	RET
*
INPORT	LXI	H,$FFFF
INLP	IN	PORTS
	ANI	$20
	JNZ	FND
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	INLP
NOTFND	STC
	RET
FND	IN	PORTD
	ANA	A
	RET
*
OUTPORT	PUSH	PSW
PLP	IN	PORTS
	ANI	2
	JZ	PLP
	POP	PSW
	OUT	PORTD
	RET
*
* STRINGS AND MESSAGES.
*
FMTMSG	STR	'INVALID TAPE FORMAT'
	DB	$0D
CHKMSG	STR	'CHECKSUM ERROR'
	DB	$0D
VOLID	STR	'VOLUME?!'
EMSG	STR	'END OF TAPE.'
	DB	$0D
UNCMD	STR	'UNKNOWN COMMAND'
	DB	$0D
WMSG	STR	'TAPE PROTECTED'
	DB	$0D
VERMSG	STR	'CHECKING...'
	DB	$0D
* COMMAND TABLE.
TABLE	DB	$83
	STR	'REWIND'
	DB	$82
	STR	'DUMP'
	DB	$82
	STR	'LOAD'
	DB	$82
	STR	'NEXT'
	DB	$82
	STR	'BACK'
	DB	$83
	STR	'OFFLINE'
	DB	$82
	STR	'SCAN'
	DB	$82
	STR	'EOT'
	DB	$83
	STR	'CLOSE'
	DB	$82
	STR	'CHECK'
	DB	$80
ENDIF	EQU	*
