SVC	MACRO
\0	RST	2
	DB	\1
	ENDMAC
	ORG	$100
;
; DMF "TYPE" File display utility by D. Dunfield
;
	SVC	19		; Get single filename
	RNZ			; Failure
	SVC	14		; Next option
	LXI	H,1		; Assume begin at line 1
	JZ	NODAT		; No start line given
	SVC	16		; Get start line number
NODAT	SHLD	COUNT		; Save for later
	SVC	14		; Next option
	LXI	H,$FFFF		; Assume enture file
	JZ	NOLIN		; No line count
	SVC	16		; Read #lines
	RNZ			; Bad option
NOLIN	SHLD	NLINES		; Save #lines
	LXI	H,TEXT		; Data buffer
	SVC	26		; Calculate disk optinos
	RNZ			; Calculation error
	MVI	B,1		; Read command
	SVC	28		; Read disk
	RNZ			; Disk error
	LXI	D,TEXT		; Point to text
	LHLD	COUNT		; Get line count
LINE	MOV	A,H		; Get high
	ANA	A		; Test
	JNZ	NXT		; Not at line 1 - wait
	MOV	A,L		; Get low
	CPI	1		; At line 1
	JZ	GOPRT		; Yes, output
NXT	LDAX	D		; Read data
	INX	D		; Advance to next
	CPI	$FF		; End of file?
	JZ	NOLINE		; Yes, exit
	CPI	$0D		; End of line?
	JNZ	NXT		; No, keep looking
	DCX	H		; Reduce line count
	JMP	LINE		; And resave
; display a line
GOPRT	LHLD	NLINES		; Get # lines
LOOP	MOV	A,H		; Get count
	ORA	L		; Test
	JZ	EOF		; At end - exit
	DCX	H		; Reduce
NOCR	LDAX	D		; Get source data
	INX	D		; Next
	ANA	A		; End of file?
	JM	EOF		; Yes - exit
	SVC	3		; Display
	CPI	$0D		; End of line?
	JNZ	NOCR		; No, keep going
	MVI	A,10		; Line-feed
	SVC	3		; Display
	JMP	LOOP		; Do next line
; End of file - return success
EOF	SUB	A
	RET
; End of file found before starting line
NOLINE	LXI	H,STLMSG	; Point to message
	SVC	8		; Display
	MVI	A,99		; Return code
	RET
STLMSG	STR	'STARTING LINE NOT FOUND'
	DB	$0D
COUNT	DW	0		; Starting line
NLINES	DW	0		; # lines to output
TEXT	EQU	*		; Data buffer
