/*
 * High-bit constants for function execution
 */
#define	F_NUM		0xC0			// Indicates a large number
#define	F_ADD		0xC1			// Add function
#define	F_SUB		0xC2			// Subtract function
#define	F_MUL		0xC3			// Multiply function
#define	F_DIV		0xC4			// Divide function
#define	F_MOD		0xC5			// Modulus function
#define	F_AND		0xC6			// Logical AND function
#define	F_OR		0xC7			// Logical OR function
#define	F_XOR		0xC8			// Logical XOR function
#define	F_SHR		0xC9			// Shift right function
#define	F_SHL		0xCA			// Shift left function
#define	F_CMP		0xCB			// Compare ==
#define	F_PC		0xCC			// Current PC value
#define	F_REGV		0xCD			// Get register value
#define	F_LOW		0xCE			// Get LOW value
#define	F_HIGH		0xCF			// Get high value
#define	F_SWAP		0xD0			// Swap high/low
#define	F_EXTEND	0xD1			// Sign extend
#define	F_JUMP		0xD2			// Alternate JMP address
#define	F_ID		0xD3			// Special instruction ID
#define	F_PUT1		0xD4			// Save variable 1
#define	F_PUT2		0xD5			// Save variable 2
#define	F_PUT3		0xD6			// Save variable 3
#define	F_GET1		0xD7			// Read variable 1
#define	F_GET2		0xD8			// Read variable 2
#define	F_GET3		0xD9			// Read variable 3
#define	F_LOOPS		0xDA			// Loop start
#define	F_LOOPE		0xDB			// Loop end
#define	F_COND1		0xDC			// Conditional start
#define	F_COND2		0xDD			// Conditional next
#define	F_COND3		0xDE			// Conditional exit
#define	F_LINK		0xDF			// Link to function
#define	F_MEM1		0xE0			// Indirect via memory-1
#define	F_MEM2		0xE1			// Indirect via memory-2
#define	F_MEM3		0xE2			// Indirect via memory-3
#define	F_MEM4		0xE3			// Indirect via memory-4
#define	F_MEM5		0xE4			// Indirect via memory-5
#define	F_MEM6		0xE5			// Indirect via memory-6
#define	F_OPCODE	0xE6			// Beginning of opcode encoding
#define	F_OPEND		0xEF			// End of opcode encoding
#define	F_SYM0		0xF0			// Symbol of type 0
#define	F_SYM1		0xF1			// Symbol of type 1
#define	F_SYM2		0xF2			// Symbol of type 2
#define	F_SYM3		0xF3			// Symbol of type 3
#define	F_SYM4		0xF4			// Symbol of type 4
#define	F_SYM5		0xF5			// Symbol of type 5
#define	F_SYM6		0xF6			// Symbol of type 6
#define	F_SYM7		0xF7			// Symbol of type 7
#define	F_REG		0xF8			// Output value as register name
#define F_CHAR		0xF9			// Output value as character
#define	F_DEC		0xFA			// Output value as decimal (signed)
#define	F_UDEC		0xFB			// Output value as decimal (Unsigned)
#define	F_BYTE		0xFC			// Output value as byte
#define	F_WORD		0xFD			// Output value as word
#define	F_EXIT		0xFE			// Exit early
#define	F_END		0xFF			// End of definition

/*
 * High bit constants for instruction decode
 */
#define	I_REG		0xC0			// Register name

/*
 * Encoded commands in register names
 */
#define	R_BIT		1				// Display bit stream
#define	R_PTR		2				// Display memory content

/*
 * Sequence list special modes
 */
#define	L_BIG		57				// max register
#define	L_KM		0x7B			// Kernel memory block
#define	L_IL		0x7C			// Instruction length
#define	L_IF		0x7D			// Instruction flags
#define	L_JL		0x7E			// Jump address low
#define	L_JH		0x7F			// Jump address high

/*
 * Symbol table types
 */
#define	S_CONST		0				// Constant value
#define	S_MEM1		1				// Memory type 1
#define	S_MEM2		2				// Memory type 2
#define	S_MEM3		3				// Memory type 3
#define	S_MEM4		4				// Memory type 4
#define	S_STACK		5				// Stack offset

/*
 * CPU capabilities flags
 */
#define	CPU_SADDRL	0x0001			// CPU receives addresses in LE
#define	CPU_DTRSTOP	0x0002			// CPU aborts on DTR
#define	CPU_INVDTR	0x0004			// CPU inverts DTR
#define	CPU_INVRTS	0x0008			// CPU inverts RTS
#define	CPU_RVECTOR	0x0010			// CPU vectors to reset
#define	CPU_BENDIAN	0x0020			// CPU is big endian
#define	CPU_WORDALN	0x0040			// CPU is word aligned

/*
 * Kernel command indexes
 */
#define	KCMD_QUERY	0				// Query target
#define	KCMD_BREAK	1				// Set breakpoint
#define	KCMD_EXEC	2				// Execute
#define	KCMD_ABORT	3				// Abort process
#define	KCMD_STEP	4				// Single-step
#define	KCMD_UPDATE	5				// Update registers
#define	KCMD_RESP1	6				// Query response 1
#define	KCMD_RESP2	7				// Query response 2
#define	KCMD_READ1	8				// Read memory type 1
#define	KCMD_READ2	9				// Read memory type 2
#define	KCMD_READ3	10				// Read memory type 3
#define	KCMD_READ4	11				// Read memory type 4
#define	KCMD_READ5	12				// Read memory type 5
#define	KCMD_READ6	13				// Read memory type 6
#define	KCMD_WRITE1	14				// Write memory type 1
#define	KCMD_WRITE2	15				// Write memory type 2
#define	KCMD_WRITE3	16				// Write memory type 3
#define	KCMD_WRITE4	17				// Write memory type 4
#define	KCMD_WRITE5	18				// Write memory type 5
#define	KCMD_WRITE6	19				// Write memory type 6
#define	KCMD_SIZE	20				// Size of kernel command buffer
