#define	HELP_CMD	0
#define	HELP_MAIN	2
#define	HELP_EDIT	3
#define	HELP_REGE	4
#define	HELP_TTY	5
#define	HELP_VALUE	6
#define	HELP_SEDIT	7

#ifndef NOHELP

/* Help subsystem parameters */
#define	LINK_S		('N'-0x40)			/* Start of a link */
#define	LINK_E		('O'-0x40)			/* End of a link */
#define	TAB_SIZE	4					/* Spacing of TABs */
#define	LINKS		40					/* Maximum # links per screen */

/*
 * Simple help system with links
 *
 * Input: Section number to display
 */
void help(unsigned section)
{
	int c, lx, ly, ox, oy;
	unsigned i, j, size, ncount;
	unsigned char buffer[65], *ptr, *pptr;
	unsigned char xs[LINKS], ys[LINKS], *names[LINKS], link[LINKS];
	FILE *fp;

	concat(names, ARGV[0], "DMSHELP.HLP");
	if(!(fp = fopen(names, "rb"))) {
		if(!section ) {
			printf("\nCannot open help file: %s", names);
			putc('\n', stdout); }
		else
			w_printf(dwin, "\nCannot open help file: %s", names);
		return; }

	/* Locate the section in question */
	pptr = &pool[pool_top];
lookup:
	size = getc(fp);
	size |= getc(fp) << 8;
	if(section--) {
		fseek(fp, 0, size, 1);
		goto lookup; }

	/* Draw the screen */
	wopen(5, 2, 70, 17, WSAVE|WCOPEN|WBOX1|colors[CO_HELPS]);
	wcursor_off();
	i = ncount = ptr = 0;
	while(buffer[i++] = getc(fp));

	/* Make a title */
	memcpy(buffer+50, W_OPEN, 6);
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", buffer);
	memcpy(W_OPEN, buffer+50, 6);

	/* Display help text & record links */
	wgotoxy(0, 0);
	while(i++ < size) switch(c = getc(fp)) {
	case LINK_S :	/* Start link */
		names[ncount] = ptr = pptr;
		xs[ncount] = W_OPEN->WINcurx;
		ys[ncount] = W_OPEN->WINcury;
		*W_OPEN = colors[CO_HELPL];
		break;
	case LINK_E :	/* End link */
		link[ncount++] = getc(fp);
		*pptr++ = ptr = 0;
		*W_OPEN = colors[CO_HELPS];
		++i;
		break;
	case '\t' :		/* Horizontal TAB */
		do
			wputc(' ');
		while(W_OPEN->WINcurx % TAB_SIZE);
		break;
	case 0 :		/* End of line */
		c = '\n';
	default:
		wputc(c);
		if(ptr)
			*pptr++ = c; }

	/* Allow user to select field & link to new screen */
	i = section = 0;
	for(;;) {
		wgotoxy(xs[section], ys[section]);
		*W_OPEN = colors[CO_HELPL];
		wputs(names[section]);
		wgotoxy(xs[i], ys[i]);
		*W_OPEN = colors[CO_HELPC];
		wputs(names[section = i]);
		*W_OPEN = colors[CO_HELPS];
		switch(c = wgetc()) {		/* User keystroke */
		case _KLA :				/* Left arrow - previous field */
			i = (i ? i : ncount) - 1;
			break;
		case _KRA :				/* Right arrow - next field */
			i = (i + 1) % ncount;
			break;
		case _KUA : ox = oy = -1000; goto do_find;
		case _KDA : ox = oy = 1000;
		do_find:
			size = i;
			for(j = 0; j < ncount; ++j) {
				lx = (int)xs[j] - (int)xs[i];
				ly = (int)ys[j] - (int)ys[i];
				if(c == _KUA) {
					if((ly >= 0) || (ly < oy)) continue; }
				else {
					if((ly <= 0) || (ly > oy))	continue; }
				if(abs(lx) > abs(ox)) continue;
				size = j;
				ox = lx;
				oy = ly; }
			i = size;
			break;
		case '\n' :				/* Enter - chain to menu */
			rewind(fp);
			section = link[i];
			wclose();
			goto lookup;
		case 0x1B:				/* Escape exit */
		case _K10 :
			wclose();
			fclose(fp);
			return; } }
}
#endif
