#include <stdio.h>
#include <file.h>

/*
 * Structure of EXE header
 */
struct EXEheader {
	char sig1;
	char sig2;
	unsigned last_block;
	unsigned number_of_blocks;
	unsigned num_rel;
	unsigned size_of_header;
	unsigned min_add_ram;
	unsigned max_add_ram;
	unsigned ss_offset;
	unsigned initial_sp;
	unsigned checksum;
	unsigned initial_ip;
	unsigned cs_offset;
	unsigned first_rel; } ;

unsigned
	L1[2] = { 1 },			// Long constant 1
	L512[2] = { 512 },		// Long constant 512
	lt[2],					// Long temp register
	fsize[2],				// Calculated size of file
	stop,					// Top of used segment list
	saddr,					// Current segment write address
	seg_list[10];			// List of allocated segments
unsigned char
	*infile,				// Input filename
	*outfile,				// Output filename
	verbose,				// Verbose output
	remove = -1,			// Remove unneeded header information
	header[50000],			// Header & 1st file storage
	buffer[65];				// Temporary buffer
FILE
	*fp;					// File pointer

extern unsigned
	Longreg[2];				// Long number register

char help[] = { "\n\
Use:	bhead	infile [outfile] [options]\n\n\
opts:	/R	= do not remove surplus header information\n\
	/V	= Verbose output\n\
\n?COPY.TXT 2002-2005 Dave Dunfield -  -- see COPY.TXT --.\n" };

/*
 * Open a file - supply default extension
 */
FILE *xopen(char *file, char *a, char *d)
{
	char f, *p;
	f = -1;
	p = buffer;
	while(*p = *file++) {
		if(*p++ == '.')
			f = 0; }
	if(f)
		strcpy(p, ".EXE");
	if(verbose)
		printf("%sing: %s\n", d, buffer);
	return fopen(buffer, a);
}

/*
 * Write data to external memory segments
 */
void write_seg(unsigned char c)
{
	static unsigned s;
	if(!saddr) {
		if(!(s = seg_list[stop++] = alloc_seg(4096)))
			abort("Not enough memory");
		if(verbose)
			printf("Allocated segment: %04x\n", s); }
	poke(s, saddr++, c);
}

/*
 * Read data from external memory segments
 */
int read_seg()
{
	static unsigned s;
	if(!saddr) {
		s = seg_list[stop++];
		if(verbose)
			printf("Reading segment: %04x\n", s); }
	return peek(s, saddr++);
}

main(int argc, char *argv[])
{
	int c;
	unsigned i, j, k;
	unsigned char *p;

	for(i=1; i < argc; ++i) {
		p = argv[i];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
		case '/V' :
		case '-V' :	verbose = -1;				continue;
		case '/R' :
		case '-R' : remove = 0;					continue; }
		if(!infile) {
			infile = argv[i];
			continue; }
		if(!outfile) {
			outfile = argv[i];
			continue; }
		printf("Unknown option: %s\n", argv[i]);
		exit(-1); }
	if(!infile)
		abort(help);
	if(!outfile)
		outfile = infile;

	IOB_size = 4096;
	fp = xopen(infile, "rvqb", "Load");
	fsize[0] = fget(header, sizeof(header), fp);
	if((header.sig1 != 'M') || (header.sig2 != 'Z'))
		abort("File is not an EXE file.");
	if(header.first_rel < 0x1C)
		abort("Invalid relocation table");
	while((c = getc(fp)) != -1) {
		write_seg(c);
		longadd(fsize, L1); }
	fclose(fp);

	// Compute size of file in blocks/last-block
	longcpy(lt, fsize);
	longdiv(lt, L512);
	if(*Longreg)
		longadd(lt, L1);

	// Validate header size with calculated value
	if(*lt != header.number_of_blocks)
		printf("Header size (%u blocks) disagrees with file (%u)\n",
			header.number_of_blocks, *lt);
	if(*Longreg != header.last_block)
		printf("Header last-block-size (%u bytes) disagrees with file (%u)\n",
			header.last_block, *Longreg);

	// Compress header if possible
	k = 0x1C;
	if(((i=header.first_rel) > k) && remove) {
		if(verbose)
			printf("Shifting header information down %u bytes.\n", i-k);
		for(j=0; j < header.num_rel; ++j) {
			header[k++] = header[i++];
			header[k++] = header[i++];
			header[k++] = header[i++];
			header[k++] = header[i++]; }
		header.first_rel = 0x1C; }

	// Zero to end of header
	i = (header.num_rel * 4) + 0x1C;
	while(i & 0x0F)
		header[i++] = 0;

	j = header.size_of_header;
	ltoa(fsize, buffer, 10);
	printf("Old file/header size: %s/%u\n", buffer, j); 
	longset(lt, k = (j*16)-i);
	longsub(fsize, lt);
	ltoa(fsize, buffer, 10);
	header.size_of_header = i >> 4;
	printf("New file/header size: %s/%u\n", buffer, i >> 4);

	if(!k)
		abort("No change in file size.\n");

	// Update blocks/last in header
	longcpy(lt, fsize);
	longdiv(lt, L512);
	if(*Longreg)
		longadd(lt, L1);
	header.number_of_blocks = *lt;
	header.last_block = *Longreg;

	// Write new file
	fp = xopen(outfile, "wvqb", "Sav");
	fput(header, i, fp);

	// Calculate size of data portion of file
	longset(lt, i);
	longsub(fsize, lt);

	// Write data from header block
	j *= 16;		// Offset to data area
	while(longtst(fsize)) {
		putc(header[j], fp);
		longsub(fsize, L1);
		if(++j >= sizeof(header))
			break; }

	// Write data from external memory segments
	saddr = stop = 0;
	while(longtst(fsize)) {
		putc(read_seg(), fp);
		longsub(fsize, L1); }

	fclose(fp);
}
