#include <stdio.h>
#include <window.h>

#define	NCOL	3	// Bit-Number column (2)
#define	PCOL	5	// Bit-Position column
#define	BCOL	6	// Bit entry column
#define	FCOL	7	// Field size column
#define	RCOL	8	// Result column
#define	HCOL	14	// Help column

#define	BITS	32

int
	Pos;			// Current bit position
unsigned
	Ph,				// Current horizontal bit position
	Ph1,			// End of field X position
	Nbits = BITS	// Number of bits
	Nx,				// Bit/Byte indicator shift
	Nbm1,			// Nbits-1
	Fields,			// Number of fields
	Origin,			// Origin value
	Bif,			// Bit in field
	Wof,			// Width of field
	L[2],			// Longvalue
	L1[2],			// ""
	L2[2];			// ""
unsigned char
	*Ptr,			// General pointer
	Ff,				// Field flag
	Fp,				// Field position
	Fw,				// Field width
	Nibble,			// Display Nibble fields
	Nreverse,		// Reverse numeric field
	Hp[BITS],		// Horizontal position
	Bits[BITS],		// Bit values
	Space[BITS+1],	// Insert space flags
	Fpos[BITS],		// Field position
	Fwidth[BITS],	// Field width
	Temp[256];		// Temp buffer

extern unsigned Longreg[];

char Help[] = { "\n\
Help!\n\
" };

char Chelp[] = { "\n\
0/1\x8A=Set bit\xA8\x1B/\x1A\xB2=Move position\n\
Pup/Pdn\x8A=Move in field\xA8Hom/End\xB2=First/Last position\n\
Space\x8A=Insert space before\xA8Bkspc\xB2=Remove space before\n\
Insert\x8A=Insert space after\xA8Del\xB2=Remove space after\n\
F1\x8A=Toggle nibble display\xA8F10\xB2=End\n\
F2\x8A=Reverse position display" };

unsigned char *lvalue(unsigned ln[2], unsigned base)
{
	unsigned l[2], l1[2];
	unsigned char c, *p;
	longcpy(l, ln);
	longset(l1, base);
	p = Temp+sizeof(Temp);
	*--p = 0;
	do {
		longdiv(l, l1);
		if((c = *Longreg) > 9)
			c += 7;
		*--p = c + '0'; }
	while(longtst(l));
	return p;
}

void clxy(unsigned x, unsigned y)
{
	wgotoxy(0, y);
	wcleol();
	wgotoxy(x, y);
}

void rc()
{
	if(Pos < 0)
		Pos = Nbm1;
	if(Pos >= Nbits)
		Pos = 0;
}

main(int argc, char *argv[])
{
	unsigned i, j, k;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++)<<8)|toupper(*Ptr++)) {
		case '/1' : Origin = 1;			continue;
		case 'N=' : Nbits = atoi(Ptr);	continue;
		} help: abort(Help); }
	if((Nbits < 1) || (Nbits > 32)) goto help;

	Nbm1 = Nbits - 1;
	Nx = Nbits & 3;
	wopen(0, 0, 80, 25, WSAVE|WCOPEN|NORMAL|0x17);
	wgotoxy(30, 0);
	wputs("BitTwiddler 1.0");

	i = HCOL-1; Ptr = Chelp;
	hnxt:	wgotoxy(0, ++i); k=0; wcleol();
	for(;;) switch(j = *Ptr++) {
		case 0 : 	goto redraw;
		case '\n':	goto hnxt;
		default:
			if(j & 0x80) {
				j &= 0x7F;
				while(++k < j)
					wputc(' ');
				continue; }
			wputc(j);
			++k; }

redraw:
	Space[0] = 255;
	rc();
	wgotoxy(0, BCOL);
	longset(L, j = Ff = Fields = k = 0);
	longset(L1, 0);
	for(i=0; i < Nbits; ++i)	{
		if(((i&3) == Nx) && Nibble)
			*W_OPEN = (++k & 1) ? 0x1B : 0x17;
		if(Space[i]) {
			wputc(' ');
			if(i) {
				Fpos[Fields] = W_OPEN->WINcurx;
				Fwidth[Fields++] = i - j; }
			if(Ff) {
				longcpy(L2, L1);
				Wof = i - j;
				Ff = 0; }
			longset(L1, 0);
			j = i; }
		Hp[i] = W_OPEN->WINcurx;
		if(i == Pos) {
			Ph = W_OPEN->WINcurx;
			Bif = j;
			Ff = 255; }
		longshl(L);
		longshl(L1);
		if(Bits[i]) {
			*L |= 1;
			*L1 |= 1;
			wputc('1'); }
		else
			wputc('0'); }
	*W_OPEN = 0x17;
	Fwidth[Fields] = i - j;
	Fpos[Fields] = W_OPEN->WINcurx+1;
	if(Ff) {
		Wof = i - j;
		longcpy(L2, L1); }
	Ph1 = W_OPEN->WINcurx + 3;
	wcleol();

	// Display field sizes
	wgotoxy(0, FCOL); wcleol();
	for(i=0; i <= Fields; ++i) {
		j = Fpos[i] - 2;
		if((k = Fwidth[i]) > 9)
			--j;
		wgotoxy(j, FCOL);
		wprintf("%u", k); }


	clxy(0, NCOL);
	clxy(0, NCOL+1);
	clxy(0, PCOL);
	for(i=0; i < Nbits; ++i) {
		j = Nreverse ? i : Nbm1-i;
		wgotoxy(Hp[i], NCOL);
		wprintf("%u", j / 10);
		wgotoxy(Hp[i], NCOL+1);
		wprintf("%u", j % 10);
		wgotoxy(Hp[i], PCOL);
		wputc(0xFA); }

	// Display bit position in current field
	if(j = Ph)
		--j;
	i = Pos-Bif;
	if(i > 9) if(j) --j;
//	clxy(j, PCOL);
	wgotoxy(j, PCOL);
	wprintf("%u\x1D%u", (i = Pos-Bif)+Origin, ((Wof-1) - i)+Origin);
	if(Fields) {
		wgotoxy(Ph1, PCOL);
		wprintf("%u\x1D%u", Pos+Origin, (Nbm1-Pos)+Origin); }


	// Display results
	clxy(0, RCOL+0); wprintf("Hex: %s", lvalue(L, 16));
	clxy(0, RCOL+1); wprintf("Dec: %s", lvalue(L, 10));
	clxy(0, RCOL+2); wprintf("Oct: %s", lvalue(L, 8));
	clxy(0, RCOL+3); wprintf("Bin: %s", lvalue(L, 2));
	if(Fields) {
		wgotoxy(Ph1, RCOL+0); wputs(lvalue(L2, 16));
		wgotoxy(Ph1, RCOL+1); wputs(lvalue(L2, 10));
		wgotoxy(Ph1, RCOL+2); wputs(lvalue(L2, 8)); }

recmd: wgotoxy(Ph, BCOL);
	Space[Nbits] = 255;
	i = toupper(wgetc());
	switch(i) {
	case '0' : Bits[Pos] = 0;				goto adv;
	case '1' : Bits[Pos] = 255;
adv:	if(Pos >= Nbm1)		goto redraw;
	case _KRA: ++Pos;						goto redraw;
	case ' ' : Space[Pos] = 255;			goto redraw;
	case _KBS: Space[Pos] = 0;				goto redraw;
	case _KIN:
		if(Pos < Nbm1)
			Space[Pos+1] = 255;
		goto redraw;
	case _KDL:
		if(Pos < Nbm1)
			Space[Pos+1] = 0;
		goto redraw;
	case _KLA: --Pos;						goto redraw;
	case _KHO: Pos = 0;						goto redraw;
	case _KEN: Pos = Nbits - 1;				goto redraw;
	case _KPD:
		if((Pos < Nbm1) && !Space[Pos+1]) do {
			++Pos; }
			while((Pos < Nbm1) && !Space[Pos+1]);
		else do {
			++Pos;
			rc(); }
		while(!Space[Pos]);
		goto redraw;
	case _KPU:
		if(Space[Pos]) do {
			--Pos; }
			while(!Space[Pos+1]);
		else do {
			--Pos;
			rc(); }
		while(!Space[Pos]);
		goto redraw;
	case _K1 : Ptr = &Nibble;				goto toggle;
	case _K2 : Ptr = &Nreverse;
	toggle:	*Ptr = *Ptr ? 0 : 255;			goto redraw;
	case _K10:
	case 0x1B: wclose();					return;
	} goto recmd;
	wclose();
}
