#include <stdio.h>

unsigned char
	Cfix,
	Root,
	*cmdptr,
	buffer[200],
	temp[50],
	cmd[128];
FILE
	*fp;

unsigned char  *cmdpaths[] = {
	"C:\\WINNT\\SYSTEM32\\CMD.EXE",
	"C:\\WINDOWS\\SYSTEM32\\CMD.EXE",
	"C:\\WINDOWS\\COMMAND.COM",
	0 };

register error(unsigned args)
{
	unsigned char out[500];
	_format_(nargs()*2 + &args, out);
	fputs(out, stdout);
	fputs(": ", stdout);
	fputs(buffer, stdout);
	putc('\n', stdout);
}

int istemp(unsigned char *n)
{
	unsigned char ext[50], *p;
	if(*n != '$') return 0;
	while(*n != '.') {
		if(!*n++)
			return 0; }
	if(*(n-1) == '$') {
		p = ext;
		while(*p++ = toupper(*++n));
		if(!strcmp(ext, "TMP"))
			return 255;
		if(!strcmp(ext, "DAT"))
			return 255; }
	return 0;
}

unsigned char help[] = { "\n\
Use:	CHKDIR [/L]\n\n\
Opts:	/L	- automatically rename to Lower case\n\
	/R	- allow use at Root\n\
\n?COPY.TXT 2005-2007 Dave Dunfield\n -- see COPY.TXT --.\n" };

main(int argc, char *argv[])
{
	int c;
	unsigned char *p, *cp, ef, cf;

	for(c=1; c < argc; ++c) {
		p = argv[c];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
		case '-L' :
		case '/L' :	Cfix = 255;	continue;
		case '-R' :
		case '/R' : Root = 255;	continue;
		} abort(help); }

	for(c=0; cmdptr = cmdpaths[c]; ++c) {
		if(fp = fopen(cmdptr, "rb")) {
			fclose(fp);
			goto found_path; } }
	abort("Cannot find command path");
found_path:

	getdir(buffer);
	if(!(*buffer | Root)) {
		printf("At root of drive - use /R if you really mean it.\n");
		return; }

	Root = get_drive();
	printf("Checking: %c:\\%s\n", Root+'A', buffer);

	if(exec(cmdptr, "/c dir/b/s >$dir$.tmp"))
		abort("?exec failed");

	fp = fopen("$dir$.tmp", "rvq");

	while(fgets(p = buffer, sizeof(buffer)-1, fp)) {
		++p;		// Skip drive letter
		if(*p++ != ':') {
			error("No drive letter");
			continue; }
		cp = p;
		cf = ef = 0;
		while(c = *p++) switch(c) {
			case '\\' : cp = p;
			case '_' :
			case '.' :
				continue;
			default:
				if(islower(c)) continue;
				if(isdigit(c)) continue;
				ef = 255;
				if(!isupper(c))
					cf = 255; }
		if(!ef) continue;
		if(cf) {
			if(istemp(cp))
				continue;
			error("Invalid character name");
			continue; }
		if(!Cfix) {
			error("Uppercase in name");
			continue; }
		strcpy(temp, cp);
		strlwr(temp);
		printf("Rename '%s' -> '%s'\n", buffer, temp);
		sprintf(cmd, "/c rename %s %s", buffer, temp);
		if(exec(cmdptr, cmd))
			abort("?exec failed"); }
	fclose(fp);
	delete("$dir$.tmp");
}
		
