#include <stdio.h>
#include <file.h>

#define	FILES	5000
unsigned
	Seg,
	SegTop,
	Line,
	Files[FILES],
	FileTop,
	FileBot = FILES,
	PreTop;
unsigned char
	Prefix[200],
	buffer[1000],
	temp[500],
	fname[100],
	*ext,
	*File,
	*ptr,
	Unref,
	Stats;
FILE
	*fp;

unsigned char Help[] = { "\n\
Use:	CHKLINK [file] [/S /U]\n\n\
Opts:	/S	- report Statistics\n\
	/U	- report Unreferenced files\n\
\n?COPY.TXT 2005-2006 Dave Dunfield\n -- see COPY.TXT --.\n" };

unsigned char *getseg(unsigned i)
{
	unsigned char *p;
	static unsigned char buffer[100];
	p = buffer;
	i = Files[i];
	while(*p++ = peek(Seg, i++));
	return buffer;
}

main(int argc, char *argv[])
{
	unsigned i;
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-U' :
		case '/U' :
			Unref = 255;
			continue;
		case '-S' :
		case '/S' :
			Stats = 255;
			continue;
		case '?'<<8 :
		case '-?' :
		case '/?' :
			abort(Help); }
		if(*temp)
			abort(Help);
		strcpy(temp, ptr-2); }

	Seg = alloc_seg(4096);
	addhtm(*temp ? temp : "index.htm");

	for(i=0; i < FileTop; ++i)
		check(getseg(i));

/*	for(i=0; i < FileTop; ++i)
		printf("'%s'\n", getseg(i));
	for(i=FileBot; i < FILES; ++i)
		printf("'%s'\n", getseg(i)); */

	if(Unref) {
		ptr = fname;
		chkdir(buffer); }
	if(Stats)
		printf("HTM=%u Other=%u Seg=%u\n", FileTop, FILES-FileBot, SegTop);

}

chkdir(unsigned char *dp)
{
	unsigned a, i;
	unsigned char name[13], *d, *p, *p1;

	d = dp;
	strcpy(ptr, "*.*");
	if(find_first(fname, 0x3F, name, &i, &i, &a, &i, &i)) {
		printf("No files: %s\n", fname);
		return; }
	do {
		p = name;
		if(a & DIRECTORY) {
			if(*p != '.')
				while(*d++ = tolower(*p++));
			continue; }
		p1 = ptr;
		while(*p1++ = tolower(*p++));
/*		p = fname; p1=temp;
		do {
			if((i = *p++) == '\\')
				i = '/'; }
		while(*p1++ = i); */
		for(i=0; i < FileTop; ++i) {
			if(compseg(fname, i))
				goto ok; }
		for(i=FileBot; i < FILES; ++i) {
			if(compseg(fname, i))
				goto ok; }
		printf("Unref: %s\n", fname);
	ok: }
	while(!find_next(name, &i, &i, &a, &i, &i));
	p = ptr;
	while(dp < d) {
		ptr = p;
		while(*ptr = *dp++)
			++ptr;
		*ptr++ = '\\';
		chkdir(d); }
	ptr = p;
}

register error(unsigned args)
{
	unsigned char out[100];
	_format_(nargs() * 2 + &args, out);
	printf("%s(%u): ", File, Line);
	fputs(out, stdout);
	putc('\n', stdout);
	fputs(buffer, stdout);
	putc('\n', stdout);
	fgets(out, sizeof(out)-1, stdin);
}

skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

testfor(unsigned char *t)
{
	unsigned char *p;
	p = ptr;
	while(*t) {
		if(toupper(*ptr++) != *t++) {
			ptr = p;
			return 0; } }
	return 255;
}

check(unsigned char *name)
{
	int c;
	unsigned /* st, ft, */ pt, i;
//	unsigned char *sf;
//	sf = File;
//	st = SegTop;
//	ft = FileTop;
	pt = PreTop;

	printf("Checking: %s\n", name);
	if(!(fp = fopen(name, "rv")))
		return;
	ptr = File = name;
	i = 0;
	while(c = *ptr++) {
		switch(c) {
		case '/' :
			c = '\\';
		case '\\' :
			i = PreTop; }
		Prefix[PreTop++] = c; }
	if(i)
		Prefix[PreTop = i+1] = 0;
	else
		Prefix[PreTop = pt] = 0;
	
	Line = 0;
top:
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++Line;
		for(;;) switch(*ptr++) {
		case 0 : goto top;
		case 'h' :
		case 'H' :
			if(testfor("REF="))
				href();
			continue;
		case 's' :
		case 'S' :
			if(testfor("RC="))
				src();
			continue; } }

	fclose(fp);
	Prefix[PreTop = pt] = 0;
//	File = sf;
}

get_file()
{
	int c;
	unsigned i;
	unsigned dt, dl[100];
	unsigned char *p, *fp;

	fp = 0;
	ext = "";
	if(skip() != '"') {
		error("Invalid filename");
		return; }
	++ptr;

	p = temp;
	while((c = *ptr++) != '"') {
		if(!c) {
			error("Invalid filename");
			return 255; }
		*p++ = tolower(c);
		switch(c) {
		case '#' : fp = p-1; continue;
		case '.' :
		case '/' :
		case '_' :
			continue;
		case '~' :
		case ':' :
			*p = 0;
			if(strbeg(temp, "http:"))
				return 255; }
		if(islower(c)) continue;
		if(isdigit(c)) continue;
		if(fp && isupper(c))
			continue;
		error("Bad character '%c'", c);
		return 255; }
	*p = 0;
	if(fp)			// Eliminate #name
		*fp = 0;
//printf("[%s]", temp);

	dt = i = 0;
	p = Prefix;
	while(c = *p++) {
		if(c == '/')
			dl[dt++] = i;
		fname[i++] = c; }
	p = temp;
	while(c = *p) {
		if(strbeg(p, "../")) {	// Backupdir
			i = dt ? dl[--dt] : 0;
			p += 3;
			continue; }
		++p;
		if(c == '/')
			c = '\\';
		fname[i++] = c;
		if(c == '.')
			ext = &fname[i]; }
	fname[i] = 0;
	if(fp = fopen(fname, "rb")) {
		fclose(fp);
		return 0; }
	error("File not found");
	return 255;
}

compseg(unsigned char *n, unsigned index)
{
	int c;
	unsigned offset;
	offset = Files[index];
	do {
		c = peek(Seg, offset++);
		if(c != *n++)
			return 0; }
	while(c);
	return 255;
}

addhtm(unsigned char *name)
{
	unsigned i;
	for(i=0; i < FileTop; ++i) {
		if(compseg(name, i))
			return; }
	if(FileTop >= FileBot)
		abort("Too many files");
	Files[FileTop++] = SegTop;
	do {
		poke(Seg, SegTop++, *name); }
	while(*name++);
}

addother(unsigned char *name)
{
	unsigned i;
	for(i=FileBot; i < FILES; ++i) {
		if(compseg(name, i))
			return; }
	if(FileTop >= FileBot)
		abort("Too many files");
	Files[--FileBot] = SegTop;
	do {
		poke(Seg, SegTop++, *name); }
	while(*name++);
}

href()
{
	skip();
	if(strbeg(ptr, "\"mailto:"))
		return;
	if(get_file()) return;
	if(strbeg(ext, "htm"))
		addhtm(fname);
	else if(Unref)
		addother(fname);
}
src()
{
	get_file();
	if(Unref)
		addother(fname);
}
