#include <stdio.h>
#include <file.h>
#include <window.H>
#define	SEGACCESSPTR	3
#include <segstore.ch>
#define	LFN_FIND
#define	LFN_GET_SHORT
#define	LFN_OPEN
#include <lfn.ch>

#define	NAME	CMPTREE		// Command name
#define	DSTACK	100			// Size of directory stack
#define	ALIST	25			// Size of accept list
#define	ELIST	25			// Size of exclude list

// Entry flags
#define	F_1		0x01		// File#1 is present
#define	F_2		0x02		// File#2 is present
#define	F_ERR	0x04		// File open error
#define	F_HIL	0x08		// File difference noted
#define	F_CMP	0x40		// File compare error
#define	F_END	0x80		// End of file display

unsigned
	Seg[2],					// External segment
	Nseg = 1,				// Number of segments
	Index,					// Filename index
	Tod,					// Top of directory
	Fh1,					// File handle-1
	Fh2,					// File handle-2
	Dsp,					// Stack pointer
	DStod[DSTACK],			// Stacked TOD
	DStos[DSTACK],			// Stacked TOS
	DSpos[DSTACK],			// Stacked position
	DSend[DSTACK],			// Stacked end
	Ptop,					// Top of string pool
	Atop,					// Top of accept list
	Etop,					// Top of exclude list
 	Dtop1,					// Directory top#1
	Dtop2;					// Directory top#2
unsigned char
	*Dbase,					// Directory base
	*Cptr,					// Command pointer
	*Alist[ALIST],			// Accept list
	*Elist[ELIST],			// Exclusion list
	Stat,					// Show statistics
	Ctime,					// Compare time
	Cfile = 255,			// Compare files
	Verbose = 255,			// Verbose output
	LfnOK = 255,			// Long filenames
	Key,					// Wait for key after command
	Cmd[260],				// Command buffer
	Dir1[260],				// Directory buffer#1
	Dir2[260],				// Directory buffer#2
	Pool[2048];				// String pool

struct WINDOW
	*Mwin,					// Main window
	*Swin;					// Status window

struct ENTRY {
	unsigned char	Flags;					// 0
	unsigned		Size2[2];				// 1-4
	unsigned		Time2[2];				// 5-8
	unsigned char	Attr2;					// 9
	unsigned 		Size1[2];				// 10
	unsigned		Time1[2];				//
	unsigned char	Attr1;					//
	unsigned char	Name[260];				//
};

// Entry1, Lfn, Entry2, Filler must stay in this order
struct ENTRY Entry1;
struct LFN Lfn;
struct ENTRY Entry2;
unsigned char Filler[512];
#define	CMPSIZE	512

unsigned char Vattr[] = {	// Video attributes
#define	A_FNOR	0			// File normal
	0x17,
#define	A_FHIL	1			// File hilight
	0x1A,
#define	A_FERR	2			// File error
	0x14,
#define	A_DNOR	3			// Directory normal
	0x13,
#define	A_DHIL	4			// Directory hilight
	0x1B,
#define	A_DERR	5			// Directory error
	0x1C,
#define	A_MISM	6			// File/Directory mismatch
	0x1E,
#define	A_SNOR	7			// Status normal
	0x70,
#define	A_SHIL	8			// Status hilight
	0x74,
#define	A_FSEL	9			// Offset for select
	0x30 };
unsigned char *Vtext[] = {	// Descriptive text
	"Matching file(s)",
	"Mismatched file(s)",
	"I/O error in file(s)",
	"Directory - contains no mismatches",
	"Directory - contains mismatches",
	"Directory - contains I/O errors",
	"Directory/File mismatch",
	"Status line - normal",
	"Status line - hilighted",
	0 };
unsigned char *Chelp[] = {	// Command help
	"\x80Enter subdirectory",
	"\x81Backup directory level",
	"\x82'' exit if at top level",
	"\x83Exit anytime",
	"CCompare selected files",
	"eEdit selected File",
	"vView (hex) selected File",
	0 };
unsigned char *Ckeys[] = {
	"ENTER",
	"BKSP",
	"ESC",
	"K10" };

unsigned char *ErrCodes[] = {
	0xFF02,
	"File not found",		// 2
	"Path not found",		// 3
	"Too many open files",	// 4
	"Access denied",		// 5
	0xFF08,
	"Insufficent memory",	// 8
	0xFF20,
	"Sharing violation",	// 32
	"File-lock violation",	// 33
	0 };

// Add entry to string pool
unsigned char *add_pool(void)
{
	unsigned char *p;
	p = Pool + Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			abort("Out of memory"); }
	while(Pool[Ptop++] = *Dbase++);
	return p;
}

// Update work entry in external segment
void UpSeg(unsigned offset, unsigned data)
{
	pokew(SegSeg, SegPtr+offset, data);
}

// Set bit in active entry mask in external segment
void set(mask) asm
{
		MOV		AL,4[BP]
		MOV		BX,DGRP:_SegPtr
		MOV		ES,DGRP:_SegSeg
		OR		ES:[BX],AL
}

// Compare two names independant of case
int compare(s1, s2) asm
{
		MOV		SI,4[BP]		// String1
		MOV		Di,6[BP]		// String2
cmp1:	MOV		AL,[SI]			// Get from 1
		INC		SI				// Next
		CMP		AL,'a'			// Lower?
		JB		cmp2			// No
		CMP		AL,'z'			// Upper?
		JA		cmp2			// no
		AND		AL,5Fh			// Convert to upper
cmp2:	MOV		AH,[DI]			// Get from 2
		INC		DI				// Next
		CMP		AH,'a'			// Lower?
		JB		cmp3			// No
		CMP		AH,'z'			// Upper?
		JA		cmp3			// No
		AND		AH,5Fh			// Convert to upper
cmp3:	CMP		AL,AH			// Match?
		JNZ		cmp4			// No - fail
		AND		AL,AL			// More?
		JNZ		cmp1			// Yes - keep going
		MOV		AL,255			// Report match
		POP		BP				// Clean stack
		RET
cmp4:	XOR		AX,AX			// Report mismatch
}

// High speed string length
unsigned Strlen(string) asm
{
		MOV		SI,4[BP]		// Point to string
		XOR		BX,BX			// Zero offset
sl1:	MOV		AL,[BX+SI]		// Get data
		INC		BX				// Skip to next
		AND		AL,AL			// Zero?
		JNZ		sl1				// Go till zero
		MOV		AX,BX			// Get count
		DEC		AX				// Remove last
}

// Add name to stored directories
void add_name(unsigned char *name)
{
	Dir1[Dtop1++] = '\\';
	Dir2[Dtop2++] = '\\';
	while(*name) {
			Dir1[Dtop1++] = *name;
			Dir2[Dtop2++] = *name++; }
	Dir1[Dtop1] = Dir2[Dtop2] = 0;
}

// Remove last name from stored directories
void remove_name()
{
	while(Dtop1) {
		if(Dir1[--Dtop1] == '\\')
			break; }
	while(Dtop2) {
		if(Dir2[--Dtop2] == '\\')
			break; }
	Dir1[Dtop1] = Dir2[Dtop2] = 0;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int fmatch(name, pattern) asm
{
		MOV		SI,4[BP]			// Get pattern
		MOV		DI,6[BP]			// Get name
//	Get character from pattern, classify & process
fm1:	MOV		AL,[SI]				// get *pattern
		INC		SI					// ++pattern
		AND		AL,AL				// End?
		JZ		fme					// Yes - handle end
		CMP		AL,'*'				// '*'?
		JZ		fms					// Yes - handle multiple wildcard
		CMP		AL,'?'				// '?'?
		JZ		fmq					// Yes - handle single wildcard
// Normal character correct case & match
		CMP		AL,'a'				// Lower?
		JB		fm2					// No
		CMP		AL,'z'				// Lower?
		JA		fm2					// No
		AND		AL,0DFh				// Convert to  upper
fm2:	MOV		AH,[DI]				// Get *name
		INC		DI					// ++name
		CMP		AH,'a'				// Lower?
		JB		fm3					// No
		CMP		AH,'z'				// Lower?
		JA		fm3					// No
		AND		AH,0DFh				// Covert to upper
fm3:	CMP		AL,AH				// Match?
		JZ		fm1					// Continue
fmr0:	XOR		AX,AX				// Return zero
		POP		BP					// Clean stack
		RET
// '*' - multiple wildcard
fms:	MOV		AL,[SI]				// Get next
		AND		AL,AL				// End?
		JZ		fmr1				// Yes, pass
fms1:	MOV		AL,[DI]				// Get from name
		AND		AL,AL				// At end?
		JZ		fmr0				// Yes, fail
		PUSH	DI					// Pass name
		PUSH	SI					// Pass pattern
		CALL	_fmatch				// Recurse
		POP		SI					// Restore pattern
		POP		DI					// Restore name
		JNZ		fmr1				// matched - continue
		INC		DI					// ++name
		JMP short fms1				// And continue
// '?' - single wildcard
fmq:	MOV		AL,[DI]				// get *name
		INC		DI					// ++
		AND		AL,AL				// End of name?
		JNZ		fm1					// Yes, continue
		JMP short fmr0				// No, fail
// End of pattern - pass if also end of name
fme:	OR		AL,[DI]				// End of name?
		JNZ		fmr0				// No, fail
fmr1:	XOR		AH,AH				// Zero high
		OR		AL,255				// TRUE
		POP		BP					// Clean stack
		RET
}

int accept()
{
	unsigned i;
	if(Atop) {
		for(i=0; i < Atop; ++i) {
			if(fmatch(Lfn.Lname, Alist[i]))
				return 255; }
		if(!Etop)
			return 0; }
	for(i=0; i < Etop; ++i) {
		if(fmatch(Lfn.Lname, Elist[i]))
			return 0; }
	return 255;
}

// Walk directory and process files
unsigned walk()
{
	unsigned dt1, dt2, s, e, ps, pp;
	unsigned char f;
	static unsigned i, j, l;
	static unsigned char o;

	ps = SegSeg;
	pp = SegPtr;
	dt1 = Dtop1;
	dt2 = Dtop2;
	s = Index;
	f = o = 0;
	Dir1[Dtop1] = Dir2[Dtop2] = 0;
	if(Verbose && l) {
		fputs(Dbase, stdout);
		putc('\n', stdout); }
	strcpy(Dir1+Dtop1, "\\*.*");
	strcpy(Dir2+Dtop2, "\\*.*");

	// Add files from first directory path
	if(!lfn_find_first(Dir1, 0x3F, Lfn)) {
		o = 1;
		do {
			if(Lfn.Attrib & DIRECTORY) {
				if(*Lfn.Lname == '.')
					continue;
				memset(Lfn.SizeL, 0, 4); }
			else if(!accept())
				continue;
			memset(Entry1.Size2, 0, 9);
			strcpy(Entry1.Name, Lfn.Lname);
			Entry1.Time1[0] = Lfn.Date;
			Entry1.Time1[1] = Lfn.Time;
			Entry1.Size1[0] = Lfn.SizeL[0];
			Entry1.Size1[1] = Lfn.SizeL[1];
			Entry1.Attr1 = Lfn.Attrib;
			Entry1.Flags = F_1;
			if((i=AddSeg(Seg, Entry1, Strlen(Entry1.Name)+19)) != Index++)
				abort((i == -1) ? "Out of memory" : "Index mismatch");
		} while !lfn_find_next(Lfn);
		lfn_find_close(); }

	e = Index;
	// Check/add files from second directory path
	if(!lfn_find_first(Dir2, 0x3F, Lfn)) {
		o |= 2;
		do {
			if(Lfn.Attrib & DIRECTORY) {
				if(*Lfn.Lname == '.')
					continue;
				memset(Lfn.SizeL, 0, 4); }
			else if(!accept())
				continue;
			for(i=s; i < e; ++i) {
				Entry2[GetSeg(Seg, i, Entry2)] = 0;
				if(compare(Lfn.Lname, Entry2.Name)) {
					UpSeg(1, Lfn.SizeL[0]);
					UpSeg(3, Lfn.SizeL[1]);
					UpSeg(5, Lfn.Date);
					UpSeg(7, Lfn.Time);
					poke(SegSeg, SegPtr+9, Lfn.Attrib);
					set(F_2);
					goto found; } }
				// New file in file2
				memset(Entry1.Time2, 0, 9);
				strcpy(Entry1.Name, Lfn.Lname);
				Entry1.Time1[0] = Lfn.Date;
				Entry1.Time1[1] = Lfn.Time;
				Entry1.Size1[0] = Lfn.SizeL[0];
				Entry1.Size1[1] = Lfn.SizeL[1];
				Entry1.Attr1 = Lfn.Attrib;
				Entry1.Flags = F_2;
				if((i=AddSeg(Seg, Entry1, Strlen(Entry1.Name)+19)) != Index++)
					abort((i == -1) ? "Out of memory" : "Index mismatch");
		found:
			} while !lfn_find_next(Lfn);
		lfn_find_close(); }

	if((o != 3) && !l) {
		Dir1[Dtop1] = Dir2[Dtop2] = 0;
		if(!(o & 1)) {
			printf("Cannot scan: ");
			fputs(Dir1, stdout);
			putc('\n', stdout); }
		if(!(o & 2)) {
			printf("Cannot scan: ");
			fputs(Dir2, stdout);
			putc('\n', stdout); }
		exit(-1); }

	if((e = Index) != s) {		// Files were found - mark end
		GetSeg(Seg, e-1, Entry1);
		set(F_END); }
	else if(ps) {				// Mark parent as empty
		pokew(ps, pp+1, 0);
		pokew(ps, pp+10, 0); }

	// Compare files - walk sub directories
	++l;
	while(s < e) {
		Entry1[GetSeg(Seg, s++, Entry1)] = 0;
		if((Entry1.Flags & (F_1|F_2)) != (F_1|F_2)) {	// No both present
	hil:	set(F_HIL);
			f |= F_HIL;
			continue; }
		if((Entry1.Attr1 ^ Entry1.Attr2) & DIRECTORY)	// Mismatch
			goto hil;
		Dtop1 = dt1;
		Dtop2 = dt2;
		add_name(Entry1.Name);
		if(Entry1.Attr1 & DIRECTORY) {
			pokew(SegSeg, SegPtr+1, Index);
			pokew(SegSeg, SegPtr+10, Index);
			if(j = walk()) {
				set(j);
				f |= j; }
			continue; }
		if(memcmp(Entry1.Size1, Entry1.Size2, 4))		// Not same size
			goto hil;
		if(Ctime) {
			if(memcmp(Entry1.Time1, Entry1.Time2, 4)) {
				set(F_HIL);
				f |= F_HIL; } }
		if(!Cfile)			// Do not compare files
			continue;
		if(!(Fh1 = lfn_open(Dir1, F_READ|F_BINARY))) {
			set(F_ERR);
			f |= F_ERR;
			continue; }
		if(!(Fh2 = lfn_open(Dir2, F_READ|F_BINARY))) {
			set(F_ERR);
			f |= F_ERR;
			close(Fh1);
			continue; }
		do {
			i = read(Entry1, CMPSIZE, Fh1);
			j = read(Entry2, CMPSIZE, Fh2);
			if(i != j) goto cerr;
			if(i) {
				if(memcmp(Entry1, Entry2, i)) {
	cerr:			set(F_HIL|F_CMP);
					f |= F_HIL;
					break; } } }
		while(i >= CMPSIZE);
		close(Fh1);
		close(Fh2); }
	--l;

	Dir1[Dtop1 = dt1] = 0;
	Dir2[Dtop2 = dt2] = 0;
	SegPtr = pp;
	SegSeg = ps;
	return f;
}

unsigned char
	Oc,					// Output position counter
	Ob[8][20];			// Output buffer

// Decode time into printable string
unsigned char *time(unsigned tim[2])
{
	unsigned T, D, j, k;
	unsigned char *p;
	D = tim[0];
	j = (k = ((T=tim[1]) >> 11) & 0x1f) % 12;
	sprintf(p = Ob[++Oc & 7], "%2u-%02u-%02u%3u:%02u%c", 
		(D>>5)&0x0F, D&0x1F, ((D>>9)+80)%100,
		(j)?j:12, (T>>5)&0x3F, (k>11)?'p':'a'	);
	return p;
}
// Decode size into printable string
unsigned char *size(struct ENTRY *e, unsigned s)
{
	unsigned l[2];
	unsigned char *p, *d, a;
	if(s) {
		longcpy(l, e->Size2);
		a = e->Attr2; }
	else {
		longcpy(l, e->Size1);
		a = e->Attr1; }
	p = Ob[++Oc & 7];
	if(a & DIRECTORY) {
		d = "<DIR>";
		if(!((e->Attr1 ^ e->Attr2) & DIRECTORY)) {
			if(!*l)
				d = "<emptyDIR>"; }
		strcpy(p, d); }
	else
		ltoa(l, p, 10);
	return p;
}
// decode attributes into printable string
unsigned char *attr(unsigned char a)
{
	unsigned i;
	unsigned char *p, *p1;
	static unsigned char A[] = { "RHSVDA" };
	p = p1 = Ob[++Oc & 7];
	for(i=0; i < (sizeof(A)-1); ++i)
		*p++ = ((1<<i) & a) ? A[i] : '-';
	*p = 0;
	return p1;
}

// Display an entry in the status line
staic unsigned char *Sflag;
void Shil() { *Swin = Vattr[A_SHIL]; }
void Snor() { *Swin = Vattr[A_SNOR]; }
void show(struct ENTRY *e)
{
	unsigned i;
	unsigned char f, *p1, *p2;
	static unsigned char F[] = { "12E!" };

	switch(Sflag) {
	case 0 :
		Sflag = 15;
		return;
	case 15:
		Sflag = 255; }

	w_gotoxy(0, 0, Swin);
	if(((f = e->Flags) & 3) == 3)
		Snor();
	else
		Shil();
	for(i=0; i < (sizeof(F)-1); ++i) {
		if(i == 2)
			Shil();
		if((1 << i) & f)
			w_putc(F[i], Swin); }
	f &= 3;
	Snor();
	while(Swin->WINcurx < 4)
		w_putc(' ', Swin);

	w_printf(Swin, "%s", p1=time(e->Time1));
	if(f == 3) {
		p2 = time(e->Time2);
		if(strcmp(p1, p2)) {
			Shil();
			w_printf(Swin, "  %s", time(e->Time2));
			Snor();
			goto df1; } }
	w_printf(Swin, "%17s", "");
df1:

	w_printf(Swin, "  %10s", p1 = size(e, 0));
	if(f == 3) {
		p2 = size(e, 1);
		if((e->Flags & F_CMP) || strcmp(p1, p2)) {
			Shil();
			w_printf(Swin, " %-10s", p2);
			Snor();
			goto df2; } }
	w_printf(Swin, "%11s", "");
df2:

	w_printf(Swin, "  %7s", attr(e->Attr1));
	if((f == 3) && (e->Attr1 != e->Attr2)) {
		Shil();
		w_printf(Swin, "  %s", attr(e->Attr2));
		Snor(); }
	else
		w_printf(Swin, "%8s", "");
	w_cleow(Swin);
}

int prep(unsigned m)
{
	if(m & 1) {
		if(!(Entry2.Flags & F_1))	{		rf: return 255; }
		if(Entry2.Attr1 & DIRECTORY)		goto rf; }

	if(m & 2) {
		if(!(Entry2.Flags & F_2))			goto rf;
		if(Entry2.Attr2 & DIRECTORY)		goto rf; }

	add_name(Entry2.Name);
	switch(m & 3) {
	case 3 :	lfn_get_short(Entry2.Name, Dir2);
	case 1 :	lfn_get_short(Entry1.Name, Dir1);
		break;
	case 2 :	lfn_get_short(Entry1.Name, Dir2); }
	return 0;
}

// Show status
void showseg(unsigned sp[])
{
	unsigned s, n, i, h, l;
	s = *sp;
	n = sp[1];
	do {
		i = peekw(s, 0);
		l = (i*2) + 6;
		h = peekw(s, 2);
		printf("%5u/%04x-%04x=%04x %u\n", i, h, l, h-=l, h);
		s += 4096; }
	while(--n);
	putc('\n', stdout);
}

unsigned char Hello[] = {
	" "#NAME" - Dave Dunfield - "#__DATE__" - Press '?' for help" };

unsigned char Help[] = { "\n\
use:	"#NAME"	path1 path2 [match-pattern...] [options...]\n\n\
opts:	/C		- do not test file Content\n\
	/K		- pause for Key after commands\n\
	/L		- disable Long-filename support\n\
	/Q		- Quiet: reduce informational output\n\
	/S		- show memory Statistics\n\
	/T		- compare Timestamps\n\
	A=file		- read Arguments from file		[none]\n\
	E=pattern	- Exclude matching files		[none]\n\
	H=file		- read args from file in Home directory	[none]\n\
	S=#		- set number of Segments to allocate	[1]\n\
\nIf both match-pattern and E= are specified, all E= files\
\nare excluded except those that match match-pattern.\n\
\nDave Dunfield - "#__DATE__"\n" };

void help()	{	abort(Help);	}

// Get value from command line
unsigned value()
{
	unsigned v, c, f;
	v = f = 0;
	for(;;) {
		c = *Dbase;
		if((c < '0') || (c > '9'))
			break;
		v = (v * 10) + (c - '0');
		++Dbase;
		++f; }
	if(!f)
		help();
	return v;
}

// Process command line argument
void process_arg()
{
	unsigned i;
	FILE *fp;

	switch((toupper(*Dbase++) << 8) | toupper(*Dbase++)) {
	case '-C' :
	case '/C' : Cfile = 0;					break;
	case -'K' :
	case '/K' : Key = 255;					break;
	case '-L' :
	case '/L' : LfnOK = 0;					break;
	case '-Q' :
	case '/Q' : Verbose = 0;				break;
	case '-S' :
	case '/S' : Stat = 255;					break;
	case '-T' :
	case '/T' : Ctime = 255;				break;
	case 'S=' :	Nseg = value();				break;
	case 'E=' :
		if(Etop >= ELIST)
			help();
		Elist[Etop++] = add_pool(Dbase);
		return;
	case 'A=' :
		fp = fopen(Dbase, "rvq");
		goto dc;
	case 'H=' :
		strcpy(Cptr, Dbase);
		fp = fopen(Cmd, "rvq");
dc:		while(fgets(Dbase = Filler, sizeof(Filler)-1, fp)) {
			while(isspace(*Dbase))
				++Dbase;
			switch(*Dbase) {
			case ';' :
			case 0 : continue; }
			for(i=0; Dbase[i]; ++i);
			while(isspace(Dbase[i-1])) --i;
			Dbase[i] = 0;
			process_arg(); }
		fclose(fp);
		return;
	default: Dbase -= 2;
		if(!*Dir1) {
			strcpy(Dir1, Dbase);
			return; }
		if(!*Dir2) {
			strcpy(Dir2, Dbase);
			return; }
		if(Atop >= ALIST)
			help();
		Alist[Atop++] = add_pool(Dbase);
		return; }
	if(*Dbase)
		help();
}

main(int argc, char *argv[])
{
	int t, s, e, c, h;
	unsigned i, j, k, l, m;
	unsigned char *p, f, d, x;

	Dbase = Cptr = Cmd;
	p = argv[0];
	for(;;) switch(*Dbase++ = *p++) {
		case 0 : goto ex;
		case '\\' :
		case ':' : Cptr = Dbase; }
ex:
	
	for(i=1; i < argc; ++i) {
		Dbase = argv[i];
		process_arg(); }

	if((!*Dir2) || !Nseg)
		help();

	if(SegAlloc(Seg, Nseg))
		abort("Out of memory");
	while(Dir1[Dtop1]) ++Dtop1;
	Dbase = (Dir1+Dtop1)+1;
	while(Dir2[Dtop2]) ++Dtop2;

	if(LfnOK)
		lfn_init();
	else
		lfn_disable();

	walk();
	if(Verbose|Stat)
		showseg(Seg);
	if(Stat)
		return;

#if 0
	for(i=0; i < Index; ++i) {
		Entry2[GetSeg(Seg, i, Entry2)] = 0;
		show(Entry2);
		printf("\n  %u '%s' %x %u\n", i, Entry2.Name, Entry2.Flags, Entry2.Size2[0]); }
	return;
#endif
	Swin = wopen(0, 0, 80, 1, WSAVE|WCOPEN|Vattr[A_SNOR]);
	wputs(Hello);
	Mwin = wopen(0, 1, 80, 24, WSAVE|WCOPEN|Vattr[A_FNOR]);
	wcursor_off();

#if 0
	i = malloc(10);
	free(i);
	wprintf("%04x %u", i, i);
	kbget();
#endif

rescan:	//wclwin(); wprintf("%u ", Tod); wgetc();
	h = s = t = m = 0;
	e = Tod;
	do {
		if(!(j=GetSeg(Seg, e++, Entry1)))
			break;
		Entry1[j] = 0;
		if((k = Strlen(Entry1.Name)) > m)
			m = k; }
	while(!(Entry1.Flags & F_END));
	e = e - Tod - 1;
//m = 85;
	m = (m < 79) ? 0 : m - 79;

redraw:
	if(s < 0) s = 0;
	if(s > e) s = e;
	if(s < t)
		t = s;
	if(s > (t+23))
		t = s-23;
	if(h < 0) h = 0;
	if(h > m) h = m;
	wgotoxy(0, 0);
	j = Tod + t;
	for(i=0; i < 24; ++i, ++j) {
		wgotoxy(0, i);
		if((c = t + i) <= e) {
			Entry1[GetSeg(Seg, j, Entry1)] = x = k = 0;
			f = Entry1.Flags;
			if(d=Entry1.Attr1 & DIRECTORY) {
				x = '\\';
				k = A_DNOR; }
			if((Entry1.Attr2 & DIRECTORY) ^ d) {
				k = A_MISM;
				x = '?'; }
			else if(f & F_ERR)
				k += A_FERR;
			else if(f & F_HIL)
				k += A_FHIL;
			else
				k += A_FNOR;
			d = Vattr[k];
			if(c == s) {
				memcpy(Entry2, Entry1, sizeof(Entry2));
				show(Entry1);
				d += Vattr[A_FSEL]; }
			*W_OPEN = d;
			l = Strlen(p = Entry1.Name);
			if(x) {
				p[l++] = x;
				p[l] = 0; }
			if((l = Strlen(p=Entry1.Name)+1) > 80) {
				if((l - (k = h)) < 80)
					k = l - 80;
				p += k; }
			for(k=0; k < 80; ++k)
				wputc(*p ? *p++ : ' '); }
		else {
			*W_OPEN = Vattr[A_FNOR];
			wcleol(); } }

	if(m) {
		w_gotoxy(80-3, 0, Swin);
		w_printf(Swin, "%3u", h); }

	for(;;) {
		switch(i = wgetc()) {
		case _KUA: --s;			goto redraw;
		case _KDA: ++s;			goto redraw;
		case _KPU: s -= 23;		goto redraw;
		case _KPD: s += 23;		goto redraw;
		case _KHO: s = 0;		goto redraw;
		case _KEN: s = e;		goto redraw;
		case _KRA: ++h;			goto redraw;
		case _KLA: --h;			goto redraw;
		case _CRA: h = m;		goto redraw;
		case _CLA: h = 0;		goto redraw;
		case '\n':
			if(!(Entry2.Attr1 & Entry2.Attr2 & DIRECTORY))	break;
			if(!(j=Entry2.Size2[0]))						break;
			DStod[Dsp] = Tod;
			DStos[Dsp] = t;
			DSpos[Dsp] = s;
			DSend[Dsp++] = e;
			add_name(Entry2.Name);
			Tod = j;
			goto rescan;
		case 0x1B:
			if(!Dsp) {
		case _K10:
				wclose();
				wclose();
				return; }
		case _KBS:
			if(!Dsp)										break;
			remove_name();
			Tod = DStod[--Dsp];
			t = DStos[Dsp];
			s = DSpos[Dsp];
			e = DSend[Dsp];
			goto redraw;
		case 'c' :											// Compare
		case 'C' :											// Compare
			if(prep(3))	break;
			p = "XC.COM";
			sprintf(Filler, "%s %s", Entry1.Name, Entry2.Name);
			goto cmd1;
		case 'e' :											// Edit 1
			if(prep(1)) break;
			i = Entry2.Size1[0];
			j = Entry2.Size1[1];
			goto edit;
		case 'E' :											// Edit 2
			if(prep(2)) break;
			i = Entry2.Size2[0];
			j = Entry2.Size2[1];
edit:		p = ((i > 45000) | j) ? "EB.COM" : "EDT.EXE";
cmd:		strcpy(Filler, Entry1.Name);
cmd1:		*Swin = *Mwin = 0x07;
			wclwin();
			wcursor_line();
			w_clwin(Swin);
			putc('>', stdout);
			fputs(Cmd, stdout);
			putc(' ', stdout);
			fputs(Filler, stdout);
			putc('\n', stdout);
			strcpy(Cptr, p);
			if(j = exec(Cmd, Filler)) {
				for(i=0; p = l = ErrCodes[i]; ++i) {
					if(l >= 0xFF00) {
						k = l & 0xFF;
						continue; }
					if(j == k)
						goto found;
					++k; }
				p = 0;
	found:		printf("\nDOS return code %d", j);
				if(p) {
					fputs(" : ", stdout);
					fputs(p, stdout); }
				putc('\n', stdout); }
			wcursor_off();
			if(Key | j) {
				fputs("\nPress a key...", stdout);
				kbget(); }
			remove_name();
//			*Swin = Vattr[A_SNOR];
//			*Mwin = Vattr[A_FNOR];
			goto redraw;
		case 'v' :											// View 1
			if(prep(1)) break;
			goto view;
		case 'V' :											// View 2
			if(prep(2))	break;
view:	p = "XV.COM";
			goto cmd;
		case _K1:
			Dir1[Dtop1] = Dir2[Dtop2] = 0;
			wclwin();
			wprintf("Tod=%u s=%u e=%u t=%u\n\n", Tod, s, e,  t);
			wputs(Dir1);
			wputs("\n\n");
			wputs(Dir2);
			wputc('\n');
			wgetc();
			goto redraw;
		case '?' :
			w_clwin(Swin); w_puts(Hello, Swin);
			wclwin();
			for(j=0; p = Vtext[j]; ++j) {
				wgotoxy(45, j+2);
				*W_OPEN = Vattr[j];
				wputs(p);
				*W_OPEN = Vattr[A_FNOR]; }
			j -= 1;
			for(i=0; p = Chelp[i]; ++i) {
				wgotoxy(2, i+j);
				if((d = *p++) & 0x80)
					wprintf("%5s = ", Ckeys[d & 0x7F]);
				else
					wprintf("  '%c' = ", tolower(d));
				wputs(p);
				if((d >= 'a') && (d <= 'z')) {
					wputs("#1");
					while(W_OPEN->WINcurx < 45)
						wputc(' ');
					wprintf("'%c' = File#2", toupper(d)); } }
			wgotoxy(0, 22);
			wputs("\nPress a key...");
			wgetc();
			goto redraw; }
		if(Sflag == 15)
			goto redraw; }
}
