#include <stdio.h>

#define	FILEP	"$_DIR_$"		// Prefix for detection
#define	FILE1	"$_DIR_$1.TMP"
#define	FILE2	"$_DIR_$2.TMP"

/*
0         1         2         3         4         5 
0123456789012345678901234567890123456789012345678901234567890
09/15/2009  02:48a      <DIR>3,773,283 DRIFTA~1.MP3    Drift Away.mp3
09/15/2009  03:48 AM    <DIR>3,773,283 DRIFTA~1.MP3 Drift Away.mp3
*/
#define DIRECTORY_OFFSET	14
#define	DAY_OFFSET			3
#define	YEAR_OFFSET			6
#define	HOUR_OFFSET			12
#define	MINITE_OFFSET		15
#define	SIZE_OFFSET			24
#define	NAME_OFFSET			39

unsigned
	Seg,					// Extra segment
	Stop,					// Top of segment
	Sptr,					// Segment pointer
	Lyear = 65535,			// Lowest year seen
	Time[2],				// File timestamp
	Time1[2],				// Secondary file timestamp
	Size[2],				// File size
	Size1[2];				// Secondary file size

unsigned char
	*ptr,					// General pointer
	*cmdptr,				// Command pointer
	*Path1,
	*Path2,
	buffer[256],			// General buffer
	Directory[256],			// Directory name
	Long[256],				// Long filename
	Long1[256],				// Secondary long filename
	Verbose,				// Verbose command flag
	Hour = 255,				// Allow 1-hour difference
	Test = 255,				// Test mode
	Keep = 255,				// Keep temp files
	Flag,					// File flag
	Dn,						// Directory output flag
	Fn;						// Filename output flag

struct DIRFILE {
	FILE		*Fp;		// File pointer
	unsigned	Doffset;	// Offset to variable directory
	} File1, File2;

unsigned L10[] = { 10, 0 };	// Long constant 10

unsigned char  *cmdpaths[] = {
	"C:\\WINNT\\SYSTEM32\\CMD.EXE",		// Win2K
	"C:\\WINDOWS\\SYSTEM32\\CMD.EXE",	// WinXP
	"C:\\WINDOWS\\COMMAND.COM",			// Win98
	0 };

unsigned DinM[] = {			// Days in Months
//	xxx,	Ja,	Fe,	Mr, Ap,	Ma,	Jn, Jl, Au, Se, Oc, No, De
	32,		31,	28,	31,	30,	31,	30,	31,	31,	30,	31,	30,	31 };

unsigned char Help[] = { "\n\
Use: compdir path [path] [options]\n\n\
opts:	/H	- disable 1-Hour difference allowance\n\
	/K	- Keep temp files\n\
	/T	- Test mode (read from files, no delete)\n\
	/V	- Verbose output\n\
\nDave Dunfield - "#__DATE__"\n" };

/*
 * Report severe error and terminate
 */
register error(unsigned args)
{
	unsigned buf[128];
	_format_(nargs() * 2 + &args, buf);
	fputs(buf, stderr);

	if(File1.Fp)
		fclose(File1.Fp);
	if(File2.Fp)
		fclose(File2.Fp);

	if(Test) {
		if(File1.Fp)
			delete(FILE1);
		if(File2.Fp)
			delete(FILE2); }

	exit(-1);
}

/*
 * Skip ahead to non-blank
 */
int skip(void)
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

/*
 * Open a directory listing file
 */
void open_dir(unsigned char *name, struct DIRFILE *File)
{
	unsigned i;
	FILE *fp;

	File->Fp = fp = fopen(name, "rvq");

	while(fgets(buffer, sizeof(buffer)-1, fp)) {
		strupr(buffer);
		if(!strbeg(buffer, " DIRECTORY OF "))
			continue;
		if(Verbose)
			printf("Base dir: '%s'\n", buffer+DIRECTORY_OFFSET);
		File->Doffset = strlen(buffer+DIRECTORY_OFFSET) + DIRECTORY_OFFSET;
		while(fgets(buffer, sizeof(buffer)-1, fp)) {
			if(isdigit(*buffer)) {
				if((i = atoi(buffer+YEAR_OFFSET)) < Lyear)
					Lyear = i; } }
		rewind(fp);
		return; }
	error("No initial directory");
}

/*
 * Open next directory in input file
 */
int find_next_dir(struct DIRFILE *File, unsigned char *name)
{
	while(fgets(buffer, sizeof(buffer)-1, File->Fp)) {
		strupr(buffer);
		if(!strbeg(buffer, " DIRECTORY OF "))
			continue;
		if(!*(ptr = buffer+File->Doffset)) {
			*ptr = '\\';
			ptr[1] = 0; }
		strcpy(name, ptr);
		fgets(buffer, sizeof(buffer)-1, File->Fp);
		return 255; }
	return 0;
}

/*
 * Open specific directory in input file
 */
int find_dir(struct DIRFILE *File, unsigned char *name)
{
	rewind(File->Fp);
	while(fgets(buffer, sizeof(buffer)-1, File->Fp)) {
		strupr(buffer);
		if(!strbeg(buffer, " DIRECTORY OF "))
			continue;
		if(!*(ptr = buffer+File->Doffset)) {
			*ptr = '\\';
			ptr[1] = 0; }
		if(!strcmp(ptr, name)) {
			fgets(buffer, sizeof(buffer)-1, File->Fp);
			return 255; } }
	return 0;
}

/*
 * Read file information from directory listing
 */
int read_file(struct DIRFILE *File)
{
	unsigned d, mo, y, h, mi, l[2];

again:
	do {
		if(!fgets(buffer, sizeof(buffer)-1, File->Fp))
			return 0;
		if(!isdigit(*buffer))				// Not a filename
			return 0; }
	while(buffer[SIZE_OFFSET] == '<');		// Ignore directories

	// Extract filename
	strupr(buffer+NAME_OFFSET);
	ptr = buffer+NAME_OFFSET;
	skip();
	if(strbeg(ptr, FILEP))		// Skip temp files
		goto again;
	strcpy(Long, ptr);

	// Extract timestamp
	mo= atoi(buffer);					// Month
	d = atoi(buffer+DAY_OFFSET);		// Day
	y = atoi(buffer+YEAR_OFFSET)-Lyear;	// Year
	h = atoi(buffer+HOUR_OFFSET);		// Hour
	mi= atoi(buffer+MINITE_OFFSET);		// Minite
	ptr = buffer+(MINITE_OFFSET+2);
	switch(skip()) {
	default: error("Bad AM/PM\n");
	case 'a' :
	case 'A' :
		if(h == 12)
			h = 0;
		break;
	case 'p' :
	case 'P' :
		if(h < 12)
			h += 12; }
	Time[1] = d + (mo*32) + (y * (12*32));
	Time[0] = mi + (h * 60);

	// Extract size
	ptr = buffer+SIZE_OFFSET;
	skip();
	longset(Size, 0);
	longset(l, 0);
	for(;;) {
		if((d = *ptr++) == ',')		// Ignore commas
			continue;
		if(!isdigit(d))
			break;
		longmul(Size, L10);
		longset(l, d-'0');
		longadd(Size, l); }

	return 255;
}

/*
 * Write file information to segment
 */
void write_segment()
{
	unsigned s;
	unsigned char *p;
	pokew(Seg, s = Stop, Size[0]);
	pokew(Seg, Stop+2, Size[1]);
	pokew(Seg, Stop+4, Time[0]);
	pokew(Seg, Stop+6, Time[1]);
	Stop += 8;
	p = Long;
	do {
		poke(Seg, Stop++, *p); }
	while(*p++);
	poke(Seg, Stop++, 0);		// Marker
	if(Stop < s)
		error("Out of memory");
}

/*
 * Read file information from segment
 */
int read_segment()
{
	unsigned char *p;

	if(Sptr >= Stop)
		return 0;

	Size1[0] = peekw(Seg, Sptr);
	Size1[1] = peekw(Seg, Sptr+2);
	Time1[0] = peekw(Seg, Sptr+4);
	Time1[1] = peekw(Seg, Sptr+6);
	Sptr += 8;

	p = Long1;
	while(*p++ = peek(Seg, Sptr++));
	Flag = peek(Seg, Sptr++);
	if(Sptr > Stop)
		error("Segment read error");
	return 255;
}

register Ferror(unsigned args)
{
	unsigned char buffer[256];
	_format_(nargs() * 2 + &args, buffer);

	if(!Dn) {
//		fputs("Directory: ", stdout);
		fputs(Directory, stdout);
		putc('\n', stdout);
		Dn = 255; }

	putc(' ', stdout);
	if(!Fn) {
		fputs(Long, stdout);
		fputs(":", stdout);
		Fn = 255; }

	fputs(buffer, stdout);
}

/*
 * Add 60 mins to a date
 */
void add60(unsigned nt[2], unsigned time[2])
{
	unsigned y, m, d, t;

	nt[0] = time[0] + 60;
	if(nt[0] < (24*60)) {		// No overflow
		nt[1] = time[1];
		return; }

	nt[0] = time[0] - (23*60);	// Backup to previous
	t = time[1];
	y = t / (12 * 32);		t %= (12 * 32);
	m = t / 32;
	d = t % 32;

	if(++d >= DinM[m]) {
		d = 1;
		if(++m >= 12) {
			m = 1;
			++y; } }

	nt[1] = d + (m * 32) + (y * (32*12));
}

/*
 * Compare timestamps
 */
int compare_time()
{
	unsigned x[2], h, h1, m, m1, y, y1, t, t1;


	if(!longcmp(Time, Time1)) return 0;
	if(Hour) {
		add60(x, Time);
		if(!longcmp(x, Time1)) return 0;
		add60(x, Time1);
		if(!longcmp(x, Time)) return 0; }

	h = Time[0] / 60;
	m = Time[0] % 60;
	h1 = Time1[0] / 60;
	m1 = Time1[0] % 60;
	y  = Time[1] / (12*32); t = Time[1] % (12*32);
	y1  = Time1[1] / (12*32); t1 = Time1[1] % (12*32);
	Ferror(" ?Time(%u/%02u/%04u %u:%02u-%u/%02u/%04u %u:%02u)",
		t%32, t/32, y+Lyear, h, m,
		t1%32, t1/32, y1+Lyear, h1, m1);

	return 255;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char f;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch( (toupper(*ptr++)<<8) | toupper(*ptr++) ) {
		case '-H' :
		case '/H' : Hour = 0;				continue;
		case '-K' :
		case '/K' : Keep = 0;				continue;
		case '-T' :
		case '/T' : Test = 0; Path1 = "";	continue;
		case '-V' :
		case '/V' : Verbose = 255;			continue;
		}
		if(!Path1) {
			Path1 = ptr-2;
			continue; }
		if(!Path2) {
			Path2 = ptr-2;
			continue; }
		abort("Too many arguments\n"); }

	if(!Path1)
		abort(Help);
	if(!Path2) Path2 = "";

	if(!(Seg = alloc_seg(4096)))
		abort("Out of memory");

	if(Test) {
		for(i=0; cmdptr = cmdpaths[i]; ++i) {
			if(File1.Fp = fopen(cmdptr, "rb")) {
				fclose(File1.Fp);
				goto found_path; } }
		abort("Cannot find command path");
found_path:


		sprintf(buffer, " /c dir/s/c %s >%s", Path1, FILE1);
		if(exec(cmdptr, buffer))
			abort("?exec failed");
		sprintf(buffer, " /c dir/s/c %s >%s", Path2, FILE2);
		if(exec(cmdptr, buffer))
			abort("?exec failed"); }

	open_dir(FILE1, File1);
	open_dir(FILE2, File2);
	while(find_next_dir(File1, Directory)) {
		Stop = Dn = Fn = 0;
		if(Verbose) {
			printf("Scanning: '%s'\n", Directory);
			Dn = 255; }
		if(!find_dir(File2, Directory)) {
			Fn = 255;
			Ferror("Directory not found in dest.\n");
			continue; }

		// Cache FILE2 data in extra segment
		while(read_file(File2))
			write_segment();

		// Read and compare FILE1 data
		while(read_file(File1)) {
			Sptr = f = Fn = 0;
			while(read_segment()) {
				if(strcmp(Long, Long1))
					continue;
				poke(Seg, Sptr-1, 255);
				f = 255;
				if(longcmp(Size, Size1))
					Ferror(" ?Size(%x%04x:%x%04x)", Size[1], Size[0], Size1[1], Size1[0]);
				compare_time();
				if(Fn)
					putc('\n', stdout);
				break; }
			if(!f)
				Ferror(" Not in dest\n"); }

		Sptr = 0;
		while(read_segment()) {
			Fn = 0;
			if(!peek(Seg, Sptr-1)) {
				strcpy(Long, Long1);
				Ferror(" Not in source\n"); } } }

	fclose(File1.Fp);
	fclose(File2.Fp);

	if(Test && Keep) {
		delete(FILE1);
		delete(FILE2); }
}
