#include <stdio.h>
#include <window.h>

#define	LINES	5000	// # lines to be patched
#define	VARS	27		// Maximum # variables
#define	PATCH	25		// Maximum # patches
#define	VBASE	'@'		// Base offset for variables

unsigned
	Sseg = 0xF000,		// System BIOS segment
	Ssize = 32768,		// System BIOS size
	Vseg = 0xC000,		// Video Segment
	Vsize = 32768,		// Video SIZE
	CK1, CK2,			// Check values
	Fseg,				// Load file segment
	Ftop,				// Load file top marker
	Line,				// Input Line number
	Mcount,				// machine count
	Found,				// Machine was found!
	line,				// File line
	lines[LINES],		// File line number offsets
	plines[PATCH];		// Patch lines
unsigned char
	*cfile[65],			// Config file
	File[65],			// Filename
	buffer[100],		// General buffer
	Xbuf,				// Stacked buffer flag
	Fail,				// Patch failed
	Confirm = -1,		// Confirm update
	Update,				// Update required
	Upflag = -1,		// Update flag
	Verbose = -1,		// Verbose flag
	Test,				// Display test results
	Reconfig,			// Reconfigure this machine
	*ptr,				// General pointer
	vname[VARS][51],	// Variable names
	vvalue[VARS][51],	// Variable value
	patches[PATCH][101]; // Patch values
FILE
	*fp,				// General file pointer
	*fpx;				// Config file pointer

extern unsigned
	IOB_size;

unsigned char help[] = { "\n\
Use:	CONFIG	[options]\n\n\
opts:	/A	= Automatic (no confirmation)\n\
	/I	= display machine ID\n\
	/Q	= Quite mode\n\
	/R	= Reconfigure current machine\n\
	/U	= do not Update config files\n\
	I=file	= specify .INI file\n\
\n?COPY.TXT 2003-2005 Dave Dunfield\n -- see COPY.TXT --.\n" };

register error(unsigned args)
{
	char buffer[81];

	_format_(nargs() * 2 + &args, buffer);
	printf("[%u]: %s\n", Line, buffer);
	if(fp)
		fclose(fp);
	if(fpx)
		fclose(fpx);
	exit(-1);
}

unsigned calcheck(unsigned seg, unsigned size)
{
	unsigned c, a;
	c = 0;
	a = -2;
	size &= 0xFFFE;
	do
		c += peekw(seg, a += 2);
	while(size -= 2);
	return c;
}

skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

parse(char *dest)
{
	skip();
	while(*ptr && !isspace(*ptr))
		*dest++ = *ptr++;
	*dest = 0;
	return *dest;
}

expect(unsigned char c)
{
	skip();
	if(*ptr++ != c)
		error("Expected '%c'", c);
}

getval()
{
	unsigned char t[50];
	parse(t);
	if(*t == '$')
		return atox(t+1);
	return atoi(t);
}

docheck()
{
	static char x;
	if(!x) {
		CK1 = calcheck(Sseg, Ssize);
		CK2 = calcheck(Vseg, Vsize);
		x = -1;
		if(Test)
			printf("Machine ID: %04x %04x\n", CK1, CK2); }
}

config_new(unsigned cf, unsigned char sflag)
{
	unsigned i, j, t, s;
	wopen(s = 0, 0, 80, 25, WSAVE|WCOPEN|0x17);
	wgotoxy(17, 0);
	wputs("THIS MACHINE WAS NOT FOUND IN THE DATABASE");
	wcleol();
reload:
	memset(vvalue, 0, sizeof(vvalue));
	if(fpx = fopen(cfile, "r")) {
		t = j = 0;
		while(fgets(ptr = buffer, sizeof(buffer)-1, fpx)) {
			skip();
			if(*ptr++ == '!') {
				if(t == cf) {
					getval();
					getval();
					while(skip())
						parse(vvalue[j++]); }
				++t; } }
		fclose(fpx); }
	wgotoxy(0,2); wprintf("Index: %-5u%s", cf+1, (cf == t) ? "(NEW)" : "");
	wcleol();
redraw:
	for(i=0; i < VARS; ++i) {
		wgotoxy(0, i+4); wcleol();
		if(*vname[i])
			wprintf("%-30s: %s", vname[i], vvalue[i]); }
	wcleow();
	wgotoxy(0, 24);
	if(cf < t) {
		wgotoxy(10, 24); wputs("F1=next"); }
	if(cf) {
		wgotoxy(20,24); wputs("F2=prev"); }
	wgotoxy(30, 24); wputs("ENTER=Save ESC=Quit");
recmd:
	for(;;) switch(wgets(32, s+4, vvalue[s], 50)) {
		case _KUA : if(s) --s;				goto redraw;
		case _KDA :	if(*vname[s+1]) ++s;	goto redraw;
		case _K1 : if(cf < t) ++cf;			goto reload;
		case _K2 : if(cf) --cf; 			goto reload;
		case '\n' :
			for(i=0; i < VARS; ++i) {
				if(*vname[i] && !*vvalue[i]) {
					wgotoxy(15, 23);
					wputs("You must enter a value for ALL variables");
					goto recmd; } }
			wclose();
			if(sflag) {
				fpx = fopen(cfile, "wvqa");
				fprintf(fpx, "!$%04x $%04x", CK1, CK2);
				for(i=0; i < VARS; ++i) {
					if(*vname[i])
						fprintf(fpx, " %s", vvalue[i]); }
				putc('\n', fpx);
				fclose(fpx); }
			return -1;
		case 0x1B :
			wclose();
			return 0; }
}

load_text(unsigned char *file)
{
	unsigned c, d;
	strcpy(File, file);
	fp = fopen(File, "rvq");
	lines[0] = Ftop = 0;
	line = 1;
	while((c = getc(fp)) != EOF) {
		poke(Fseg, Ftop++, d=c);
		if(c == '\n')
			lines[line++] = Ftop; }
	fclose(fp);
	if(d != '\n')
		lines[line++] = Ftop;
}

process_text()
{
	unsigned i, c, p;

	p = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fpx)) {
		if(!isspace(*buffer)) {
			Xbuf = -1;
			break; }
		if(!(plines[p] = getval()))
			error("Bad line number");
		if(p >= PATCH)
			error("Too many patches");
		skip();
		strcpy(patches[p++], ptr); }

	// Check patch lines
	for(Update=i=0; i < p; ++i)
		check_patch(plines[i], patches[i]);
	if(Fail)
		return;

	if(Update) {
		if(Confirm) {
			printf("Update %s ?", File);
		rc:	switch(toupper(kbget())) {
			default: goto rc;
			case 0x1B: error("Abort!");
			case 'N' : fputs("N\n", stdout); return;
			case 'Y' : fputs("Y\n", stdout); } }
		if(Verbose)
			printf("Updating: %s\n", File);
		fp = fopen(File, "wvq");
		for(i=0; i < line; ++i) {
			for(c=0; c < p; ++c) {
				if((plines[c]-1) == i) {	// Patch found
					write_patch(c);
					goto doend; } }
			write_line(i);
		doend: }
		fclose(fp); }
}

write_line(unsigned l)
{
	unsigned c, d;
	d = lines[l];
	while(d < Ftop) {
		putc(c = peek(Fseg, d++), fp);
		if(c == '\n')
			return; }
}

write_patch(unsigned patch)
{
	unsigned char *p, c, v;
	p = patches[patch];
	while(c = *p++) {
		if(c == '%') {				// Variable
			if((v = *p++) == '%')	// Bypass
				goto usep;
			if((v -= VBASE) >= VARS)
				error("Bad Variable");
			fputs(vvalue[v], fp);
			continue; }
usep:	putc(c, fp); }
	putc('\n', fp);
}

check_patch(unsigned l, unsigned char *s)
{
	unsigned offset;
	unsigned char c, v, buffer[100], t[50], *p, *p1, *p2;

	offset = lines[l-1];
	p = buffer;
	while(offset < Ftop) {
		if((c = peek(Fseg, offset++)) == '\n')
			break;
		*p++ = c; }
	*p = 0;
	p = buffer;
	p1 = s;
	do {
		if((c = *p1++) == '%') {		// Variable
			if((v = *p1++) == '%')	// Bypass
				goto usep;
			if((v -= VBASE) >= VARS)
				error("Bad variable");
			p2 = t;
			while(*p && (*p != *p1))
				*p2++ = *p++;
			*p2 = 0;
			if(strcmp(vvalue[v], t))
				Update = Upflag;
			continue; }
usep:	if(*p++ != c) {
			printf("***Incompatible file patch:\n");
			printf("File: %s, Line: %u\n", File, l);
			printf("S> %s\n", buffer);
			printf("P> %s\n", s);
			Fail = -1;
			return 0; } }
	while(c);
	return -1;
}

main(int argc, char *argv[])
{
	unsigned i, c, v;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case 'F=' :	// control file
			strcpy(cfile, ptr);
			continue;
		case '/A' :	// Auto
		case '=R' :
			Confirm = 0;
			continue;
		case '/R' :	// Reconfigure
		case '-R' :
			Reconfig = -1;
			continue;
		case '/I' :	// Display ID
		case '-I' :
			Test = -1;
			continue;
		case '/U' :	// Inhibit update
		case '-U' :
			Upflag = 0;
			continue;
		case '/Q' :	// Quiet mode
		case '-Q' :
			Verbose = 0;
			continue;
		default: printf("Bad option: %s\n", argv[i]);
		case '?' << 8 :
		case '/?' :
		case '-?' :
			fputs(help, stdout);
			exit(-1); } }

	if(!*cfile) {
		i = Fseg = 0;
		ptr = cfile;
		for(;;) switch(*ptr++ = argv[0][Fseg++]) {
			case 0 : goto nopre;
			case '.' : v = ptr;		}
	nopre:
		strcpy(v ? v : ptr-1, "INI"); }
	
		
	Fseg = alloc_seg(IOB_size = 4096);
	fpx = fopen(cfile, "rvq");
	strcpy(vname, "Machine name");
	v = 1;
	for(;;) {
		if(Xbuf) {
			Xbuf = 0;
			ptr = buffer; }
		else {
			if(!fgets(ptr = buffer, sizeof(buffer)-1, fpx))
				break;
			++Line; }
		skip(); switch(*ptr++) {
		case '=' :				// System definition
			Sseg = getval();
			Ssize = getval();
			Vseg = getval();
			Vsize = getval();
		case 0 :				// Null line
		case ';' : continue;	// Comment
		case '%' :				// Variable definition
			if(v >= VARS)
				error("Too many variables");
			strcpy(vname[v++], ptr);
			continue;
		case '$' :				// Text file
			while(fgets(ptr = buffer, sizeof(buffer)-1, fpx)) {
				++Line;
				if(!isspace(*buffer)) {
					Xbuf = -1;
					break; } }
			continue;
		case '!' :				// Machine descriptor
			++Mcount;
			docheck();
			if((getval() == CK1) && (getval() == CK2)) {
				Found = Mcount;
				i = 0;
				while(skip()) {
					if(i >= VARS)
						error("Too many values");
					parse(vvalue[i++]); }
				} continue;
		} error("Unknown command"); }
	fclose(fpx);
	docheck();
	if(Found) {	// Machine exists
		if(Verbose)
			printf("Machine name: %s\n", vvalue);
		if(Reconfig && config_new(Found-1, 0)) {
			if(Verbose)
				printf("Updating: %s\n", cfile);
			load_text(cfile);
			fp = fopen(cfile, "wvq");
			for(i=0; i < line; ++i) {
				if(peek(Fseg, v = lines[i]) == '!') {
					for(c=0; c < 15; ++c)
						buffer[c] = peek(Fseg, ++v);
					(ptr = buffer)[c] = 0;
					if((getval() == CK1) && (getval() == CK2)) {
						fprintf(fp, "!$%04x $%04x", CK1, CK2);
						for(v=0; v < VARS; ++v) {
							if(*vname[v])
								fprintf(fp, " %s", vvalue[v]); }
						putc('\n', fp);
						continue; } }
				write_line(i); }
			fclose(fp); } }
	else {	// Machine does not exist
		if(!config_new(Mcount, -1))
			return; }

	fpx = fopen(cfile, "rvq");
	Line = 0;
	for(;;) {
		if(Xbuf) {
			Xbuf = 0;
			ptr = buffer; }
		else {
			if(!fgets(ptr = buffer, sizeof(buffer)-1, fpx))
				break;
			++Line; }
		skip(); switch(*ptr++) {
		case '$' :	// Text file
			load_text(ptr);
			process_text(); } }
	fclose(fpx);
	free_seg(Fseg);
}
