#include <stdio.h>
#include <file.h>
#include <window.h>

#define	DIRS	256
#define	DSCR	50

unsigned
	Top,				// Top of screen
	Pos,				// Position on screen
	Dtop,				// Top of directory list
	Ptop;				// Top of string pool
FILE
	*fp;				// General file pointer
unsigned char
	*Dest,				// Destination
	*Dirs[DIRS],		// List of directories
	Func,				// Function
	Select[DIRS],		// Selected
	Pool[16384];		// String pool

struct WINDOW
	*mwin;			// Main window

unsigned char *Form[] = {
	(71<<8)|4,
	"\x00\x00\x3FCmd:",
	"\x00\x01\x3FOpt:",
	0 };
#define FARGS	Cmd,Opt

unsigned char	Dtag[]		= { "$$DOSYNC$$" };
unsigned char	Cmd[64]		= { 0 };
unsigned char	Opt[64]		= { "?\"?N?\" ?\"?D\\?N?\" /R /Y" };
#define	DSIZE	((64*2)+sizeof(Dtag))		// Size of data items

#define	LFN_FIND
#include <lfn.ch>
struct LFN Lfn;

unsigned char Help[] = { "\n\
Use:	DOSYNC	[destination] [opts]\n\n\
opts:	/D	= set Default command parameters\n\
	/T	= Test; display-but-not-execute commands\n\
\nDave Dunfield - "#__DATE__"\n" };

unsigned char Whelp[] = { "DOSYNC - "#__DATE__" - Dave Dunfield\n\n\
Enter = perform SYNC\n\
 ESC  = quit\n\
Space = toggle select\n\
 F1   = deselect all\n\
 F2   = deselect to cursor\n\
 F3   = deselect from cursor\n\
 F4   = deselect dirs containing <=' ' or >='~'\n\
 F5   = select all but HIDDEN/SYSTEM\n\n\
Press any key." };

#define	TICK	peekw(0x40,0x6C)

// Display formatted error & terminate
register error(unsigned args)
{
	unsigned buf[80];
	_format_(nargs() * 2 + &args, buf);
	fputs(buf, stderr);
	putc('\n', stderr);
	exit(-1);
}

// Add a string to the string-pool
unsigned char *add_pool(unsigned char *string)
{
	unsigned char *p;
	p = Pool+Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			error("Out of memory");
		Pool[Ptop++] = *string; }
	while(*string++);
	return p;
}

// Wait for specific key
unsigned waitkey(unsigned char *keys, unsigned time)
{
	int c;
	unsigned t;
	unsigned char *p;
	t = TICK;
	for(;;) {
		if(c = kbtst()) {
			p = keys;
			while(*p) {
				if(*p++ == c) {
					putc('\n', stdout);
					return c; } } }
		if(time) {
			if((TICK-t) > time) {
				putc('\n', stdout);
				return 0; } } }
}

// Check for valid filename
int chk(unsigned char *s)
{
	while(*s) {
		if(*s <= ' ')
			return 255;
		if(*s++ >= '~')
			return 255; }
	return 0;
}

// Substitute option values into commands
void setopt(unsigned char *d, unsigned char *s, unsigned char *name)
{
	unsigned char f;
	f = chk(name);
	for(;;) switch(*d = *s++) {
		case '?' : switch(toupper(*s++)) {
			default:
				*s = 0;
				error("Bad variable: %s", s-2);
			case 'N' : strcpy(d, name);		goto skip;
			case 'D' :
				if(!Dest) {
					printf("Destination required\n");
					abort(Help); }
				strcpy(d, Dest);
		skip:	while(*d) ++d;
				continue;
			case '"' :
				if(f)
					*d++ = '"';
				continue;
			case '?' : *d++ = '?';			continue; }
		case 0 : return;
		default: ++d; }
}

main(int argc, char *argv[])
{
	unsigned i, t;
	unsigned char *p, *p1, c;

	for(i=1; i < argc; ++i) {
		p = argv[i];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
		case '-D' :
		case '/D' :	Func = 0x55;			continue;
		case '-T' :
		case '/T' : Func = 0xAA;			continue;
		case '-?' :
		case '/?' :
		case '?'<<8: help:
			abort(Help);
		}
		if(Dest)
			goto help;
		Dest = p - 2; }

	fp = fopen(argv[0], "rvqb");
	t = fget(Pool, sizeof(Pool), fp);
	fclose(fp);
	for(i = t - (DSIZE+32); i < t; ++i) {
		if(strbeg(Pool+i, Dtag)) {
			memcpy(Dtag, Pool+i, DSIZE);
			break; } }
	if(Func == 0x55) {
		if(!wform(4, 10, WSAVE|WBOX1|WCOPEN|0x17, Form, FARGS) ) {
			memcpy(Pool+i, Dtag, DSIZE);
			fp = fopen(argv[0], "wvqb");
			fput(Pool, i+DSIZE, fp);
			fclose(fp); }
		return; }

	setopt(Lfn.Lname, Opt, "");

	// Locate SYNC.COM in path
	if(!*Cmd) {
		if(!getenv("PATH", p = Pool))
			error("No path");
		for(;;) {
			p1 = p;
			while(c = *p) {
				++p;
				if(c == ';') {
					*(p-1) = 0;
					break; } }
			if(!*p1)
				break;
			sprintf(Cmd,"%s%s%s", p1, "\\"+(p1[strlen(p1)-1] == '\\'), "SYNC.COM");
			if(i = open(Cmd, F_READ|F_BINARY)) {
				close(i);
				goto found; } }
		error("CMD not found!"); }
found:

	lfn_init();

	// Lookup directories
#if 255
	if(lfn_find_first("*.*", 0x3F, Lfn))
		error("No files");
	// Cache directory names
	do {
		if(!(Lfn.Attrib & DIRECTORY))
			continue;
		t = 15;
		if(!strcmp(Lfn.Lname, "."))			continue;
		if(!strcmp(Lfn.Lname, ".."))		continue;
		if(Dtop >=DIRS)
			error("Too many dirs");
		if(Lfn.Attrib & SYSTEM)				t |= 0x80;
		if(Lfn.Attrib & HIDDEN)				t |= 0x40;
//		if(chk(Lfn.Lname))					t |= 0x20;
		Select[Dtop] = (t & 0xF0) ? (t & 0xF0) : t;
		Dirs[Dtop++] = add_pool(Lfn.Lname); }
	while !lfn_find_next(Lfn);
	lfn_find_close();
#else
	for(i=0; i < 35; ++i) {
		sprintf(Cmd, "Directory%03u", i+1);
		Dirs[Dtop++] = add_pool(Cmd); }
#endif

	if(!Dtop)
		error("No directories");

	mwin = wopen(0, 0, 80, (DSCR/2), WSAVE|WCOPEN|0x17);
	wcursor_off();
redraw:
	if(Pos & 0x8000) 		Pos = 0;
	if(Pos > (Dtop-1))		Pos = Dtop - 1;
	if(Pos < Top)			Top = Pos;
	if((Pos - Top) >= DSCR)	Top = Pos - (DSCR-1);
	for(i=0; i < DSCR; ++i) {
		wgotoxy((i >= (DSCR/2)) * 40, i%(DSCR/2));
		if((t=Top+i) == Pos)
			*W_OPEN = 0x71;
		wputc((Select[t]&15) ? 0x04 : ' ');
		wputf(((t < Dtop) ? Dirs[t] : ""), 40);
		*W_OPEN = 0x17; }
	t = Pos - Top;
	for(;;) switch(wgetc()) {
	case _KUA:	--Pos;								goto redraw;
	case _KDA:	++Pos;								goto redraw;
	case _KRA:
	case _KLA:
			if(t >= (DSCR/2))
				Pos -= (DSCR/2);
			else
				Pos += (DSCR/2);
			goto redraw;
	case _KPU:	Pos -= DSCR;						goto redraw;
	case _KPD:	Pos += DSCR;						goto redraw;
	case _KHO:	Pos = Top = 0;						goto redraw;
	case _KEN:	Pos = 32767;						goto redraw;
	case ' ' :	Select[t] ^= 15;					goto redraw;
	case _K1 :	i = 0; t = Dtop;				// Deselect ALL
desel:	while(i < t)
			Select[i++] &= 0xF0;
		goto redraw;
	case _K2: i = 0; t = Pos; goto desel;		// Deselect to current
	case _K3: i = Pos+1; t = Dtop; goto desel;	// Deselect from current
	case _K4 :									// Deselect <' ' & > '~'
		for(i=0; i < Dtop; ++i) {
			if(chk(Dirs[i]))
				Select[i] &= 0xF0; }
		goto redraw;
	case _K5 :									// Select ALL
		for(i=0; i < Dtop; ++i) {
			if(!(Select[i] & 0xF0))
				Select[i] |= 15; }
		goto redraw;
	case '\n' : goto runsync;
	case 0x1B:
		wclose();
		return;
	default:
		wclwin();
		wputs(Whelp);
		wgetc();
		goto redraw; }
runsync:

	wclwin();
	if(wform(4, 10, WSAVE|WBOX1|WCOPEN|0x17, Form, FARGS)) {
		wclose();
		return; }

	wclose();

	for(i=0; i < Dtop; ++i) {
		if(!(Select[i] & 15))
			continue;
		setopt(Lfn.Lname, Opt, Dirs[i]);
		fputs("SYNC", stdout);
		putc(' ', stdout);
		fputs(Lfn.Lname, stdout);
		putc('\n', stdout);
		t = 0;
		if(Func != 0xAA)
			t = exec(Cmd, Lfn.Lname);
		if(t) {
			Select[i] |= 0x10;
			fputs(Dirs[i], stdout);
			printf(" RC=%u, SPACE to continue, ESC to quit:\x07", t);
			switch(waitkey(" \x1B", 60*18)) {
			case 0x1B: return;
			case 0   :
			case ' ' : goto next; } }
		printf("complete: %s\n", Dirs[i]);
		if(waitkey("\x1B", 18)) {
			while(++i < Dtop)
				Select[i] &= 0xF0; }
next:	}

	printf("Summary:\n");
	Pos = 1;
	i = 0;
	for(;;) {
		t = Select[i];
		if(!(t & 15)) {
			printf("skipped: %s" , Dirs[i]);
//			if(t & 0x80) printf(" -SYSTEM");
//			if(t & 0x40) printf(" -HIDDEN");
//			if(t & 0x20) printf(" -NAME");
			putc('\n', stdout);
			++Pos; }
		else if(t & 0x10) {
			printf("failed: %s\n", Dirs[i]);
			++Pos; }
		if(++i >= Dtop)
			break;
		if(Pos >= 22) {
			printf("Press SPACE to continue.");
			waitkey(" ", 0);
			Pos = 0; } }
}
