#include <stdio.h>
#include <file.h>
#define	LFN_FIND
#include <lfn.ch>

#define	VERSION		2.0
#define	MAXFILE		256		// Maximum files to retain
#define	MAXDIR		25		// Maximum directiorys to search
#define	MAXPAT		25		// Maximum patterns to scan for
#define	MAXEXC		25		// Maximum patterns to exclude

unsigned
	Seg,				// External segment
	Dseg,				// Directory segment
	Stop,				// Top of external segment
	Dtop,				// Top of directory segment
	Ntop,				// Top of directory/file name
	Ptop,				// Top of string pool
	DLtop,				// Top of directory list
	PLtop,				// Top of patterm list
	ELtop,				// Top of exclusion list
	MaxFile = 18,		// Max. files to scan
	Dcount,				// Directory count
	Fcount,				// File count
	Time[2],			// Current file timestamp
	Ftime[MAXFILE][2],	// File times
unsigned char
	*Ptr,				// General pointer
	*Dlist[MAXDIR],		// Directory list
	*Plist[MAXPAT],		// Pattern list
	*Elist[MAXEXC],		// Exclution list
	Dtime = 15,			// Display time
	Recurse = 255,		// Recurse into subdirs
	Verbose = 255,		// Verbose output
	UseLfn = 255,		// Use LFN if available
	Ddir,				// Display directory
	Old,				// Look for oldest
	Reverse,			// Reverse output
	Fmask,				// Masked file types
	Index[MAXFILE],		// Name indexes
	Name[256],			// Directory/File name
	Pool[4096];			// String pool

struct LFN Lfn;

unsigned char OutOfMemory[] = { "Out of memory\n" };
unsigned char NameTooLong[] = { "Name too long\n" };

// Add a string to the string pool
unsigned char *addpool(unsigned char *d)
{
	unsigned char *p;
	p = Pool+Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			abort("String pool exhausted\n"); }
	while(Pool[Ptop++] = *d++);
	return p;
}
		
// Compare time
int cmptime(t) asm
{
		MOV		BX,4[BP]
		MOV		AX,DGRP:_Time+2
		CMP		AX,2[BX]
		JB		rl
		JA		ra
		MOV		AX,DGRP:_Time
		CMP		AX,[BX]
		JB		rl
		JA		ra
		XOR		AX,AX
		POP		BP
		RET
rl:		MOV		AX,-1
		POP		BP
		RET
ra:		MOV		AX,1
}

// Copy time
void cptime(d, s) asm
{
		MOV		DI,6[BP]
		MOV		SI,4[BP]
		MOV		AX,[SI]
		MOV		[DI],AX
		MOV		AX,2[SI]
		MOV		2[DI],AX
}

// Put a string in the directory segment
int put_dir(n) asm
{
		MOV		ES,DGRP:_Dseg
		MOV		DI,DGRP:_Dtop
		MOV		SI,4[BP]
x1:		MOV		AL,[SI]
		INC		SI
		MOV		ES:[DI],AL
		INC		DI
		AND		DI,DI
		JZ		OutMem
		AND		AL,AL
		JNZ		x1
		MOV		DGRP:_Dtop,DI
		XOR		AX,AX
		POP		BP
		RET
OutMem:	MOV		AX,offset DGRP:_OutOfMemory
		JMP short Abort
NamLon:	MOV		AX,offset DGRP:_NameTooLong
Abort:	PUSH	AX
		CALL	_abort
}
// Get a string from the directory segment
unsigned get_dir(o, n) asm
{
		MOV		ES,DGRP:_Dseg
		MOV		SI,6[BP]
		MOV		DI,4[BP]
x3:		MOV		AL,ES:[SI]
		INC		SI
		MOV		[DI],AL
		INC		DI
		AND		AL,AL
		JNZ		x3
		MOV		AX,SI
		SUB		AX,6[BP]
}

// Put an entry in the file list
void put_seg(i) asm
{
		MOV		BH,4[BP]
		XOR		BL,BL
		MOV		ES,DGRP:_Seg
		MOV		SI,offset DGRP:_Name
		JMP short ps2
ps1:	AND		BL,BL		// Into next name
		JZ		NamLon		// Report fail
ps2:	MOV		AL,[SI]
		INC		SI
		MOV		ES:[BX],AL
		INC		BL
		AND		AL,AL
		JNZ		ps1
// Set time
		MOV		BX,4[BP]
		SHL		BX,1
		SHL		BX,1
		MOV		AX,DGRP:_Time
		MOV		DGRP:_Ftime[BX],AX
		MOV		AX,DGRP:_Time+2
		MOV		DGRP:_Ftime+2[BX],AX
}

// Get a name from the file segment
void get_seg(o) asm
{
		MOV		BH,4[BP]
		XOR		BL,BL
		MOV		ES,DGRP:_Seg
		MOV		DI,offset DGRP:_Name
gs1:	MOV		AL,ES:[BX]
		INC		BX
		MOV		[DI],AL
		INC		DI
		AND		AL,AL
		JNZ		gs1
}

// Sort the filenames
void sort()
{
	unsigned i, j, k;

	for(i=0; i < Stop; ++i)
		Index[i] = i;

	for(i=0; i < Stop; ++i) {
		cptime(Time, Ftime[i]);
		for(j=i+1; j < Stop; ++j) {
			if(cmptime(Ftime[j]) > 0) {		// Newer than this one
				cptime(Ftime[i], Ftime[j]);
				cptime(Ftime[j], Time);
				cptime(Time, Ftime[i]);
				k = Index[i];
				Index[i] = Index[j];
				Index[j] = k; } } }
}

void display()
{
	unsigned i, e, o, j, k, D, T;
	unsigned char *p;

	if(Old) {
		Ptr = "Old";
		Reverse = Reverse ? 0 : 255; }
	else
		Ptr = "New";

	if(Reverse) {
		p = "Old";
		i = 0;
		e = Stop;
		o = 1; }
	else {
		p = "New";
		i = Stop-1;
		e = o = -1; }

	if(Verbose)
		printf("Date Ranger "#VERSION" - Dave Dunfield - %u %sest files (%sest first):\n\n", Stop, Ptr, p);

	while(i != e) {
		get_seg(Index[i]);
		if(Dtime) {
			T = Ftime[i][0];
			D = Ftime[i][1];
			j = (T >> 11) & 0x1f;
			printf("%2u-%02u-%02u", 
				D&0x1F,
				(D>>5)&0x0F,
				((D>>9)+80)%100 );
			if(Dtime & 0xF0)
				printf("%3u:%02u ", j, (T>>5)&0x3F);
			else {
				k = j % 12;
				printf("%3u:%02u%c ", (k)?k:12, (T>>5)&0x3F, (j>11)?'p':'a'); } }
		fputs(Name, stdout);
		putc('\n', stdout);
		i += o; }
}

// Find the oldest file on record
int findold()
{
	unsigned i, j;

	cptime(Time, Ftime[j=0]);
	for(i=1; i < Stop; ++i) {
		if(cmptime(Ftime[i]) > 0)	// Newer than this one
			cptime(Time, Ftime[j=i]); }
	return j;
}

// Find the newest file on record
int findnew()
{
	unsigned i, j;

	cptime(Time, Ftime[j=0]);
	for(i=1; i < Stop; ++i) {
		if(cmptime(Ftime[i]) < 0)	// Older than this one
			cptime(Time, Ftime[j=i]); }
	return j;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(toupper(*name++) != c)
			return 0; }
}

void process_dir(void)
{
	unsigned d, dt, nt;
	static unsigned i;
	static unsigned char a;

	dt = Dtop;		// Directory list top
	nt = Ntop;		// Directory name top
	++Dcount;

	if(Ddir) {
		Name[Ntop] = 0;
		putc('[', stdout);
		fputs(Name, stdout);
		fputs("]\n", stdout); }
	strcpy(Name+Ntop, "*.*");

	if(lfn_find_first(Name, 0x3F, Lfn))
		return;
	do {
		if((a = Lfn.Attrib) & VOLUME)
			continue;
		if(a & DIRECTORY) {
			if(*Lfn.Lname == '.') {		// Possible self-reference
				switch(Lfn.Lname[1]) {
					case '.' :
					case 0 : continue; } }
			put_dir(Lfn.Lname);
			continue; }
		if(i & Fmask)
			continue;
		if(PLtop) {
			for(i=0; i < PLtop; ++i) {
				if(fmatch(Lfn.Lname, Plist[i]))
					goto ok; }
skip:		continue; }
ok:		if(ELtop) {
			for(i=0; i < ELtop; ++i) {
				if(fmatch(Lfn.Lname, Elist[i]))
					goto skip; } }
		++Fcount;
		if(Stop < MaxFile) {	// Not full yet - keep looking
			Time[0] = Lfn.Time;
			Time[1] = Lfn.Date;
			strcpy(Name+Ntop, Lfn.Lname);
			put_seg(Stop++);
			continue; }
		if(Old) {				// Scanning for old
			i = findnew();
			Time[0] = Lfn.Time;
			Time[1] = Lfn.Date;
			if(cmptime(Ftime[i]) < 0) {		// Older
				strcpy(Name+Ntop, Lfn.Lname);
				put_seg(i); }
			continue; }
		i = findold();			// Scanning for new
		Time[0] = Lfn.Time;
		Time[1] = Lfn.Date;
		if(cmptime(Ftime[i]) > 0) {		// Newer
			strcpy(Name+Ntop, Lfn.Lname);
			put_seg(i); } }
	while !lfn_find_next(Lfn);
	lfn_find_close();

	if(Recurse) {
		d = dt;
		while(d < Dtop) {
			i = get_dir(d, Name+nt);
			d += i;
			Ntop += (i-1);
			Name[Ntop++] = '\\';
			process_dir();
			Ntop = nt; } }
	Dtop = dt;
}

// Determine if a string is a filespec pattern
int ispat(unsigned char *p)
{
	for(;;) switch(*p++) {
		case '*' :
		case '?' : return 255;
		case 0 : return 0; }
}

unsigned char Help[] = { "\n\
Date Ranger "#VERSION" - Dave Dunfield - "#__DATE__"\n\n\
use:	DR [pattern...] | [directory...] [options]\n\n\
opts:	/D		- display Directories scanned\n\
	/Epattern	- Exclude files\n\
	/F		- Flip display order\n\
	/H		- exclude Hidden files\n\
	/L		- disable Long-filename support\n\
	/N1-256		- Number of files to show		[18]\n\
	/O		- show Oldest files (otherwise newest)\n\
	/Q		- Quiet: less output\n\
	/R		- do not Recurse into subdirectories\n\
	/S		- exclude System files\n\
	/T		- do not show Timestamp\n\
	/2		- use 24 hour time\n\
" };

// Process command line argument
void argument()
{
	unsigned char *p;

	switch(*Ptr) {	// Handle command switches
	case '-' :
	case '/' :
		++Ptr;
		for(;;) switch(toupper(*Ptr++)) {
		default: goto help;
		case 'D' : Ddir = 255;			continue;
		case 'F' : Reverse = 255;		continue;
		case 'H' : Fmask |= HIDDEN;		continue;
		case 'L' : UseLfn = 0;			continue;
		case 'O' : Old = 255;			continue;
		case 'Q' : Verbose = 0;			continue;
		case 'R' : Recurse = 0;			continue;
		case 'S' : Fmask |= SYSTEM;		continue;
		case 'T' : Dtime = 0;			continue;
		case '2' : Dtime = 255;			continue;
		case 'E' :
			if(ELtop >= MAXEXC)
				abort("Too many exclusions\n");
			strupr(Elist[ELtop++] = addpool(Ptr));
			return;
		case 'N' :
			MaxFile = atoi(Ptr);
			if((MaxFile > MAXFILE) || !MaxFile)
				goto help;
		case 0 : return; }
	case '?' :
		help: abort(Help); }

	p = Ptr;
	for(;;) switch(*p++) {
		case '?' :
		case '*' : goto dopat;
		case 0 : goto dodir; }
dopat:	// Add a pattern to the pattern list
	if(PLtop >= MAXPAT)
		abort("Too many patterns\n");
	strupr(Plist[PLtop++] = addpool(Ptr));
	return;

dodir:	// Add a directory to the directory list
	if(DLtop >= MAXDIR)
		abort("Too many directories\n");
	Dlist[DLtop++] = addpool(Ptr);
}

main(int argc, char *argv[])
{
	unsigned i;
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		argument(); }

	Dseg = (Seg = alloc_seg(4096*2)) + 4096;
	if(UseLfn)
		lfn_init();
	else
		lfn_disable();
	if(DLtop) for(i=0; i < DLtop; ++i) {
		strcpy(Name, Dlist[i]);
		Ntop = strlen(Name);
		Name[Ntop++] = '\\';
		process_dir(); }
	else
		process_dir();
	if(!Stop)
		abort("No files\n");
	sort();
	display();
	if(Verbose)
		printf("\n%u directories, %u files scanned.\n", Dcount, Fcount);
}
