/*
 * Program to sumarize disk space
 *
 * ?COPY.TXT 1991-2005 Dave Dunfield
 *  -- see COPY.TXT --
 */
#include <stdio.h>
#include <dir.h>
#include <dos.h>

#define	NUMDIR	25		/* Maximum number of dirs on the command line */
#define PAUSE	24		/* Pause after this many lines */

/* Command option flags */
	char recurse = -1, total = -1, verbose = -1, cume = -1, pause = 0,
		help = 0;

/* Attributes searched for */
	int search_attrs = (FA_HIDDEN|FA_SYSTEM);

/* List of directories to process */
	int dcount = 0;
	char *dlist[NUMDIR];

/* Counter used by "pause" option */
	int pcount = 0;

/* Various string buffers */
	char outcmd[80], dname[65], match[20], lname[65], oname[65];

/* Statistics counters */
	unsigned total_count = 0, total_dirs = 0;
	long total_size = 0;

/* Help text displayed in response to '?' or '-?' arguments */
	char *helptxt[] = {
		"Use: DUS <directories...> <options>\n",
		"Options: -c - Produce Cumulative display",
		"         -d - Do not display individual directories",
		"         -h - Exclude hidden files",
		"         -p - Pause between each page of output",
		"         -r - Do not recurse into sub directories",
		"         -s - Exclude System files",
		"         -v - Do not display startup message",
		0 };
/*
 * Main program, parse filenames & options, scan dirs & print results
 */
main(argc, argv)
	int argc;
	int *argv[];
{
	int i, j;
	char chr, chr1, *ptr, *ptr1;
	struct ffblk ffblk;

	dlist[0] = "*.*";	/* Default to in current directory */

/* Process all arguments: build dir list & set options flags */
	for(i=1; i < argc; ++i) switch(*argv[i]) {
		case '-c' :		/* Cumulative display */
			cume = 0;
			break;
		case '-d' :		/* Inhibit each directory display */
			total = 0;
			break;
		case '-h' :		/* Exclude hidden files */
			search_attrs &= ~FA_HIDDEN;
			break;
		case '-p' :		/* Pause in display */
			pause = -1;
			break;
		case '-r' :		/* Recurse sub-dirs */
			recurse = 0;
			break;
		case '-s' :		/* Exclude system files */
			search_attrs &= ~FA_SYSTEM;
			break;
		case '-v' :		/* Inhibit header display */
			verbose = 0;
			break;
		case '?'  :		/* Help request */
		case '-?' :		/* Help request */
			help = -1;
			break;
		default :
			dlist[dcount++] = argv[i]; }

	if(verbose)
		fputs("DISK USE SUMMARY 1.0 - ?COPY.TXT 1991-2005 Dave Dunfield.  -- see COPY.TXT --.\n\n", stderr);

	if(help) {
		for(i=0; helptxt[i]; ++i) {
			fputs(helptxt[i], stdout);
			putc('\n', stdout); }
		return; }

/* Scan dir list, and process each one */
	argc = 0;
	fputs("Files  Size (bytes)  Name\n", stdout);
	do {
		ptr = dlist[argc];
		strcpy(match,"*.*");		/* Assume all files */
		ptr1 = dname;
		chr1 = i = 0;
		while(*ptr1++ = *ptr++)
			++i;
		j = i;
		while(i) {
			chr = dname[--i];
			if((chr == '\\') || (chr == ':')) {
				++i;
				break; }
			if((chr == '*') || (chr == '?'))
				chr1 = -1; }
		if(!chr1) {		/* Name did not contain wildcards, test file */
			if(!findfirst(dname,&ffblk,0))	/* Test for directory */
				chr1 = -1;
			else {
				if((dname[j-1] != '\\') && (dname[j-1] != ':'))
					dname[j++] = '\\';
				dname[j] = 0; } }
		if(chr1) {		/* Hack off filespec from dir */
			strcpy(match, &dname[i]);
			dname[i] = 0; }

		do_dir(); }
	while(++argc < dcount);

/* Display grand total */
	if((total_dirs != 1) || !total) {
		test_pause();
		printf("%-6u %-13lu Total of %u directories.\n",
			total_count, total_size, total_dirs); }
}

/* 
 * Scan an individual directory, and report on its size
 */
do_dir()
{
	int i, file_count, old_count;
	long file_size, old_size;
	struct ffblk ffblk;

	strcpy(outcmd, dname);
	strcat(outcmd, match);

	++total_dirs;

	old_count = total_count;
	old_size = total_size;

	file_count = file_size = 0;

/* we have at least one file, search them all */
	if(!findfirst(outcmd, &ffblk, search_attrs)) do {
		++file_count;
		file_size += ffblk.ff_fsize; }
	while(!findnext(&ffblk));

/* If not a "cumulative" display, we already know the numbers, and can
   print them now so that the resultant output is "parents first". */

	if(total && cume) {
		test_pause();
		printf("%-6u %-13lu %s\n", file_count, file_size, outcmd); }


	total_count += file_count;
	total_size  += file_size;

/* If "recursing", search for and process sub-directories */
	if(recurse) {
		strcpy(outcmd, dname);
		strcat(outcmd,"*.*");
		if(findfirst(outcmd, &ffblk, FA_DIREC))
			return;
		i = strlen(dname);
		do {
			if((ffblk.ff_attrib & FA_DIREC) && (ffblk.ff_name[0] != '.')) {
				strcat(dname, ffblk.ff_name);
				strcat(dname,"\\");
				do_dir();
				dname[i] = 0; } }
		while(!findnext(&ffblk)); }

/* For "cumulative" displays, statistics are not known until all of the
   sub-directories have been processed. Therefore, we must output here,
   resulting in a less pretty "children first" display. */

	if(total && !cume) {
		test_pause();
		printf("%-6u %-13lu %s%s\n", total_count - old_count,
			total_size - old_size, dname, match); }
}

/*
 * This routine is called once for each line output, and is PAUSE is
 * enabled, will output a more prompt between each full screen.
 */
test_pause()
{
	if(pause && (++pcount >= PAUSE)) {
		fputs("More...", stdout);
		while(getc(stdin) != '\n');
		pcount = 0; }
}
