#include <stdio.h>
#include <file.h>

#define	FNAME	"$FD$.DAT"

int
	Width = 79;				// Display width
unsigned
	depth,					// Current depth in tree
	maxdepth = -1,			// Maximum depth to go
	count,					// Count of files found
	ldate,					// Lowest datestamp in dir search
	ltime,					// Lowest timestamp in dir search
	mdate,					// Mark date
	mtime,					// Mark time
	xdate,					// Search date
	xtime,					// Search time
	ptop,					// Top of pool
	sh,						// file Size high
	sl,						// file Size low
	attr,					// file Attributes
	time,					// file timestamp
	date,					// file datestamp
	Mtop,					// Mark upper bound
	Msel,					// Mark selection
	d, mo, y,				// Date
	h, mi, s;				// Second

unsigned char
	mark,					// Mark time only
	donly,					// Directories only
	prev,					// Look for younger files
	msg,					// Message output flag
	*pattern = "*.*",		// Match patterh
	name[13],				// file Name
	dir[65],				// directory being processed
	home[65],				// home directory
	temp[65],				// temp buffer
	*dptr,					// Pointer to end of dir
	*ptr,					// general pointer
	Marklist[10][20],		// Cached markfile
	pool[32767];			// Storage pool

FILE
	*fp;

unsigned char help[] = { "\n\
Use:	FD	[-][dd/mm/yy] [hh:mm:ss] [options]\n\n\
opts:	/C[0-9]	- show files Changed since /M[ark]\n\
	/D	- list Directories only\n\
	/M[0-9]	- Mark latest date/time in $FD$.DAT\n\
	/R	- make Relative to current path\n\
	/V	- Verbose output\n\
	M=n	- Maximum entries to show under each branch	[All]\n\
	P=spec	- file match Pattern				[*.*]\n\
	W=n	- display Width					[79]\n\
\n?COPY.TXT 2004-2006 Dave Dunfield -  -- see COPY.TXT --.\n" };

/*
 * Obtain numeric value from input pointer
 */
unsigned getnum(void)
{
	unsigned value;

	value = 0;
	while(isdigit(*ptr))	/* Assemble decimal value from digits */
		value = (value * 10) + (*ptr++ - '0');
	return value;
}

/*
 * Test for specific character in input stream and discard
 * 0 = any whitespace including '\0'.
 */
int expect(unsigned char c)
{
	unsigned char d;
	if(isspace(d = *ptr))
		d = 0;
	if(d != c)
		return 255;
	if(*ptr)
		++ptr;
	return 0;
}

/*
 * Get a time/date value from the input stream
 */
int gettime(void)
{
	unsigned i;
	while(isspace(*ptr))
		++ptr;
	i = getnum();
	switch(*ptr++) {
	case '/' :		// Date
		d = i;
		mo = getnum();
		if(expect('/')) return 0;
		y = getnum();
		if(expect(0)) return 0;
		return 1;
	case ':' :		// Time
		h = i;
		mi = getnum();
		s = 0;
		if(*ptr) {
			if(expect(':')) return 0;
			s = getnum();
			if(expect(0)) return 0; }
		return 2; }
	return 0;
}

/*
 * Display a date/time value with prompt
 */
void showtime(int c, unsigned char *p, unsigned date, unsigned time, FILE *fp)
{
	int i;
	d	= date & 0x1F;
	mo	= (date >> 5) & 0x0F;
	y	= (date >> 9) + 1980;
	h	= time >> 11;
	mi	= (time >> 5) & 0x3F;
	s	= (time & 0x1F)*2;
	i = 0;
	while(*p) {
		++i;
		putc(*p++, stdout); }
	if(!mark) {
		do {
			putc(' ', stdout); }
		while(++i < Width); }
	fprintf(fp, "%2u/%02u/%02u%c%2u:%02u:%02u\n",
		d, mo, y%100, c ? '+' : ' ', h, mi, s);
}		

/*
 * Load mark file into memory
 */
void load_mark(unsigned char *p)
{
	if((Msel = atoi(ptr)) > 9)
		abort(help);
	if(fp = fopen(FNAME, p)) {
		while(fgets(temp, sizeof(Marklist[0])-1, fp))
			strcpy(Marklist[Mtop++], temp);
		fclose(fp); }
}

/*
 * Add string to literal pool
 */
void add_pool(char *s)
{
	while(*s)
		pool[ptop++] = *s++;
}

/*
 * Compare date/time - Return:
 *	d1/t1 < d2/t2	= -1
 *	d1/t1 = d2/t2	= 0
 *	d1/t1 > d2/t2	= 1
 */
int ctime(unsigned date, unsigned time, unsigned d, unsigned t)
{
	if(date < d)
		return -1;
	if(date > d)
		return 1;
	if(time < t)
		return -1;
	if(time > t)
		return 1;
	return 0;
}

/*
 * Process subdirectory and all lower levels
 */
void do_sub(unsigned char top)
{
	unsigned p, p1;
	unsigned char f, *d;

	p = p1 = ptop;
	f = 0;
	strcpy(d=dptr, "*.*");

	if(find_first(dir, 0x3F, name, &sh, &sl, &attr, &time, &date))
		return;
	do {
		if(attr & VOLUME) continue;
		if(attr & DIRECTORY) {
			if(*name == '.') continue;
			add_pool(name);
			add_pool("\\");
			continue; } }
	while(!find_next(name, &sh, &sl, &attr, &time, &date));

	strcpy(d, pattern);
	if(!find_first(dir, 0x3F, name, &sh, &sl, &attr, &time, &date)) do {
		if(attr & VOLUME) continue;
		if(attr & DIRECTORY) continue;
		if(!strcmp(name, FNAME)) {
			continue; }
		if(prev) {
			if(ctime(date, time, xdate, xtime) > 0)
				continue;
			if(ctime(date, time, ldate, ltime) < 0) {
				ldate = date;
				ltime = time; } }
		else {
			if(ctime(date, time, xdate, xtime) < 0)
				continue;
			if(ctime(date, time, ldate, ltime) > 0) {
				ldate = date;
				ltime = time; } }
		if(!f) {
			f = 15;
			ldate = date;
			ltime = time; }
		*dptr = 0;
		++count;
		if(donly) {
			if(date == xdate)
				f = 255; }
		else if(depth < maxdepth) {
			++depth;
			sprintf(temp, "%s%s%s", home, dir, name);
			if(!mark)
				showtime(date == xdate, temp, date, time, stdout); } }
					
	while(!find_next(name, &sh, &sl, &attr, &time, &date));
	if(prev) {
		if(ctime(ldate, ltime, mdate, mtime) < 0) {
			mdate = ldate;
			mtime = ltime; } }
	else {
		if(ctime(ldate, ltime, mdate, mtime) > 0) {
			mdate = ldate;
			mtime = ltime; } }
	if(donly && f && (depth < maxdepth)) {
		++depth;
		sprintf(temp, "%s%s", home, dir);
		if(!*temp)
			strcpy(temp, "<current>");
		if(!mark)
			showtime(f & 0xC0, temp, ldate, ltime, stdout); }
	while(p1 < ptop) {
		dptr = d;
		while((*dptr++ = pool[p1++]) != '\\');
		if(top)
			depth = 0;
		do_sub(0); }
	ptop = p;
	dptr = d;
}

main(int argc, char *argv[])
{
	unsigned i;

	// Get current directory as starting point
	getdir(ptr = home);
	while(*ptr) ++ptr;
	strcpy(ptr, "\\");

	get_date(&d, &mo, &y);		// Default to today

	// Parse for command line arguments
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-D' :
		case '/D' : donly = 255;			continue;
		case '-R' :
		case '/R' : *home = 0;				continue;
		case '-V' :
		case '/V' : msg = 255;				continue;
		case '-M' :
		case '/M' :
			mark = 255;
			load_mark("r");
			continue;
		case '-C' :
		case '/C' :
			load_mark("rvq");
			ptr = Marklist[Msel];
			if((gettime() != 1) || (gettime() != 2))
				abort("Bad marklist");
			if((s += 2) > 58) {
				s = 0;
				if(++mi > 59) {
					mi = 0;
					++h; } }
			continue;
		case 'M=' : maxdepth = atoi(ptr);	continue;
		case 'P=' : pattern = ptr;			continue;
		case 'W=' : Width = atoi(ptr);		continue; }
		ptr -= 2;
		if(*ptr == '-') { prev = 255; ++ptr; }
		if(*ptr)
			if(!gettime()) abort(help); }

	if(msg)
		printf("Scanning for files changed %s %u/%02u/%02u %2u:%02u:%02u\n",
			prev ? "before" : "since", d, mo, y%100, h, mi, s);

	Width -= 17;

	// Convert d/mo/y h/mi/s into DOS encoded unsigneds
	if(y < 80)
		y += 2000;
	else if(y < 100)
		y += 1900;
	xdate = ((y-1980) << 9) | (mo << 5) | d;
	xtime = (h << 11) | ( mi << 5) | (s >> 1);

	// For mark, assume either end of timeline
	if(mark)
		mdate = mtime = xdate = xtime = prev ? -1 : 0;

	dptr = dir;
	do_sub(255);

	if(mark) {		// Update markfile
		showtime(0, "Latest timestamp: ", mdate, mtime, stdout);
		fp = fopen(FNAME, "wvq");
		for(i=0; (i < Mtop) || (i <= Msel); ++i) {
			if(i == Msel)
				showtime(0, "", mdate, mtime, fp);
			else {
				fputs(Marklist[i], fp);
				putc('\n', fp); } }
		fclose(fp); }
}
