#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include "tty.h"
#include "video.h"
#define	putchr	v_putc

#define SFILES 22
#define GLOB 10
#define MAX_GLOBS 100
#define LINES 24
#define CMD_WIDTH 35

struct dentry {
	char *link;
	char lattr;
	int ltime;
	int ldate;
	int lsize;
	char lname[13];
	char lcmd[CMD_WIDTH+1]; } ;

	char *globs[MAX_GLOBS], dname[65], buffer[80], match[50], mattrs = 0x37;

	char insflg = !0, cmdflg = !0, pasflg = 0, filflg = !0;

	char attributes[] = { 'R', 'H', 'S', 'V', 'D', 'A', 0 };

main(argc, argv)
	int argc;
	char *argv[];
{
	char chr, chr1;
	unsigned i, j, gnum, tf, nxtglob;
	int k, tos, locat, xpos, xcur, ts;

	struct ffblk *dirent = &buffer;
	struct dentry *firstent, *memptr, *curent, *lstent, *lstchg;

	tos = locat = xpos = 0;
	for(i=0; i<MAX_GLOBS; ++i)
		globs[i] = 0;
	strcpy(dname,"*.*");  /* default, assume all files */
	strcpy(match, dname);

/* process arguments - setup directory & attribute mask */
	for(i=1; i < argc; ++i) {
		if((*argv[i] == '+') || (*argv[i] == '-')) {
			tf = 0;
			while(chr=toupper(argv[i][++tf])) {
				j = 1;
				for(k=0; (chr1 = attributes[k]) != chr; ++k) {
					if(!chr1)
						xabort("\nFDIR: Invalid attribute\n");
					j <<= 1; }
				if(*argv[i] == '+')
					mattrs |= j;
				else
					mattrs &= ~j; } }
		else
			strcpy(dname, argv[i]); }

/* we have filename, determine if it is a directory */
	for(chr1=i=0; chr = dname[i]; ++i);	/* find end of string */
	j = i;
	while(i) {
		chr = dname[--i];
		if((chr == '\\') || (chr == ':')) {
			++i;
			break; }
		if((chr == '*') || (chr == '?'))
			chr1 = -1; }
	if(!chr1) {		/* Name did not contain wildcards, test file */
		if(!findfirst(dname,dirent,0))	/* Test for directory */
			chr1 = -1;
		else {
			if((dname[j-1] != '\\') && (dname[j-1] != ':'))
				dname[j++] = '\\';
			dname[j] = 0; } }
	if(chr1) {		/* Hack off filespec from dir */
		strcpy(match, &dname[i]);
		dname[i] = 0; }

#ifdef DEBUG
	fprintf(stderr,"%s\n%s\n", dname, match);
#endif

/* directory is open, 'match' contains file match pattern */
read_directory:
	firstent=tf=ts=nxtglob=gnum=lstchg=0;
	strcpy(buffer, dname);
	strcat(buffer, match);
	if(findfirst(buffer, dirent, mattrs))
		xabort("\nFDIR: No files found\n");
	init_tty();
	do {
		++tf;
		if(!gnum) {					 /* need to allocate */
			if(globs[nxtglob])
				memptr=globs[nxtglob++];
			else {
				if(!(memptr=malloc(GLOB * sizeof(struct dentry))))
					xabort("\nFDIR: no memory\n");
				globs[nxtglob++] = memptr; }
				gnum = GLOB; }
		ts += (memptr->lsize = (dirent->ff_fsize / 128)) + 1;
		memptr->lattr = dirent->ff_attrib;
		memptr->ltime = dirent->ff_ftime;
		memptr->ldate = dirent->ff_fdate;
		strcpy(memptr->lname, dirent->ff_name);
		memptr->lcmd[0] = 0;
		/* we have file, insert into list */
		curent=firstent;
		/* locate where it fits */
		lstent=0;
		while((curent!=0)&&(0<strcmp(memptr->lname,curent->lname))) {
			lstent=curent;
			curent=curent->link; }
		if(lstent) {
			memptr->link = curent;
			lstent->link = memptr; }
		else {		  /* inserting at start of list */
			memptr->link = firstent;
			firstent = memptr; }
		++memptr;
		--gnum; }
	while(!findnext(dirent));

/* we have sorted list, display */
draw_screen:
	memptr = firstent;
	for(i=0; ((i<tos) && (memptr->link)); ++i)
		memptr = memptr->link;
	tos = i;			/* in case beyond end */
	gotoxy(0,0);
	putstr("Filename      DOS Command                            Size  Time    Date   Attrs");
	gnum = 0;
	for(curent=memptr; ((LINES > ++gnum)) && curent; curent=curent->link) {
		gotoxy(0, gnum);
		printf("%-14s",curent->lname);
		printf("%-39s",curent->lcmd);
		printf("%4u", (curent->lsize+4) / 8);
		j = (k = ((i = curent->ltime) >> 11) & 0x1f) % 12;
		printf(" %2u:%02u%c", (j)?j:12, (i>>5)&0x3f, (k>11)?'p':'a');
		i = curent->ldate;
		printf(" %2u-%02u-%02u ", (i>>5)&0x0f, i&0x1f, ((i>>9)+80)%100);
		disp_attributes(curent->lattr); }
	gotoxy(0, gnum);
	putchr(_CD);
	gotoxy(0, LINES);
	printf("FDIR: %s%s, %u files, %uk.", dname, match, tf, ts / 8);
	show_flag(68, 'c', cmdflg);
	show_flag(71, 'f', filflg);
	show_flag(74, 'i', insflg);
	show_flag(77, 'p', pasflg);
move_cursor:
	curent = memptr;		/* position to current entry */
	for(i=tos; ((i<locat) && (lstent = curent->link)); ++i) curent = lstent;
	locat = i;
move_x_cursor:
	if(xpos > (CMD_WIDTH - 1))
		xpos = (CMD_WIDTH - 1);
	for(i=0; ((i<xpos) && curent->lcmd[i]); ++i);
	xcur = i;
get_cmd:
	gotoxy(14+xcur, 1+locat-tos);
	chr = getchr();
	switch(chr) {
		case _KUP :		 /* move cursor up */
			if(tos > --locat) {
				if(0 > (tos -= SFILES)) {
					tos=0;
					locat = SFILES; }
					goto draw_screen; }
			goto move_cursor;
		case '\n' :
			xpos = 0;
		case _KDO :		 /* move cursor down */
			if((tos+SFILES) < ++locat) {
				tos += SFILES;
				locat = tos;
				goto draw_screen; }
			goto move_cursor;
		case _KPD :		 /* page down */
			tos += SFILES;
			locat += SFILES;
			goto draw_screen;
		case _KPU :		 /* page up */
			locat -= SFILES;
			if(0 > (tos -= SFILES))
				locat = tos = 0;
			goto draw_screen;
		case _KHO :		 /* cursor to start of file */
			locat = tos = 0;
			goto draw_screen;
		case _KEN :		 /* cursor to end of file */
			locat = tf - 1;
			if(0 > (tos = locat - 21)) tos = 0;
			goto draw_screen;
		case _KND :		 /* cursor forward */
			if(curent->lcmd[xcur])
				xpos = xcur+1;
			goto move_x_cursor;
		case _KBS :		 /* cursor backwards */
			if(0 > (xpos = xcur - 1))
				xpos = 0;
			goto move_x_cursor;
		case _KDP :		 /* delete previous character */
			if(xcur) {
				putchr(_BS);
				--xcur;
				goto del_chr; }
			break;
		case _KDC :		 /* delete in place */
del_chr:	for(i=xcur; curent->lcmd[i]; ++i) {
				chr = curent->lcmd[i] = curent->lcmd[i+1];
				if(chr) putchr(chr); }
			putchr(' ');
			xpos = xcur;
			goto move_x_cursor;
		case _K3 :		  /* toggle character insert mode */
			show_flag(74, 'i',insflg = !insflg);
			break;
		case _K4 :		  /* toggle filename append */
			show_flag(71, 'f', filflg = !filflg);
			break;
		case _K5 :		  /* toggle command echo */
			show_flag(68, 'c', cmdflg = !cmdflg);
			break;
		case _K8 :		  /* delete current line */
			xcur = 0;
			gotoxy(14, 1+locat-tos);
			for(i=0; curent->lcmd[i]; ++i)
				putchr(' ');
			curent->lcmd[0] = 0;
			break;
		case _K6 :		  /* toggle pauseing */
			show_flag(77, 'p', pasflg = !pasflg);
			break;
		case _K2 :		  /* exit */
		case _K14:
		case 0x1B:
			quit();
		case _K7 :		  /* copy last changed command */
			gotoxy(14, 1+locat-tos);
			if(lstchg) {			/* we did change one */
				for(i=0; lstchg->lcmd[i]; ++i)
					putchr(curent->lcmd[i] = lstchg->lcmd[i]);
				curent->lcmd[i] = 0;
				for(k=i; k < CMD_WIDTH; ++k)
					putchr(' '); }
			goto move_x_cursor;
		case _KCL :		 /* clear screen */
			goto draw_screen;
		case _KPR :		 /* cursor to end of line */
			xpos = CMD_WIDTH - 1;
			goto move_x_cursor;
		case _KPL :		 /* cursor to start of line */
			xpos = xcur = 0;
			break;
		case _K1 :		  /* execute commands */
		case _K15:
			putchr(_CL);
			gotoxy(0,0);
			gnum = 0;
			for(curent = firstent; curent; curent = memptr) {
				memptr = curent->link;
				if(curent->lcmd[0]) {
					++gnum;
					j=k=0;
					for(i=0; (chr=curent->lcmd[i]); ++i) {
						xcur = 0;
						switch(chr) {
							case '@' :		/* insert entire filename */
								while(buffer[j] = curent->lname[xcur++])
									++j;
								k = -1;
								break;
							case '$' :		/* name only */
								while((chr = curent->lname[xcur++]) && (chr != '.'))
									buffer[j++] = chr;
								k = -1;
								break;
							case '^' :		/* Directory name */
								while(chr = dname[xcur++])
									buffer[j++] = chr;
								k = -1;
								break;
							case '!' :		/* protect next char */
								buffer[j++] = curent->lcmd[++i];
								break;
							default :
								buffer[j++] = chr; } }
					if(filflg && !k) {  /* append directory and file name */
						buffer[j++] = ' ';
						if(*dname) {	/* directory to insert */
							for(xcur=0; (chr = dname[xcur]); ++xcur)
								buffer[j++] = chr;
						/*	if(buffer[j-1] != '\\')
								buffer[j++] = '\\'; */ }
						for(xcur=0; (chr=curent->lname[xcur]); ++xcur)
							buffer[j++] = chr; }
					buffer[j] = 0;
					if(cmdflg) {
						fputs("FDIR: ", stderr);
						fputs(buffer, stderr);
						putc('\n', stderr); }
					system(buffer); } }
			if(gnum) {
				if(pasflg) {
					gotoxy(0, LINES);
					putstr("FDIR: Press any key to continue... ");
					getchr(); }
				goto read_directory; }
			else
				quit();
		default:
			if(chr > 0) {	   /* non-control code */
				lstchg = curent;
				xpos = xcur + 1;
				if(insflg && (xcur < (CMD_WIDTH-1))) { /* inserting */
					do {
						putchr(chr1 = chr);
						chr = curent->lcmd[xcur];
						curent->lcmd[xcur++] = chr1; }
					while(chr && (xcur < CMD_WIDTH));
					curent->lcmd[xcur] = 0; }
				else {
					if(!curent->lcmd[xcur])
						curent->lcmd[xpos] = 0;
					putchr(curent->lcmd[xcur] = chr); }
				goto move_x_cursor; } }
	goto get_cmd;
}

disp_attributes(attr)
	char attr;
{
	char *ptr;

	ptr = attributes;
	while(*ptr) {
		putchr((attr & 0x01) ? *ptr : '-');
		++ptr;
		attr >>= 1; }
}

show_flag(x,chr,flag)
	int x;
	char chr, flag;

{   gotoxy(x, LINES);
	putchr(chr);
	if(flag) putchr('+');
	else putchr('-');
}

/*
 * Abort with message
 */
xabort(msg)
	char *msg;
{
	fputs(msg, stdout);
	exit(-1);
}

/*
 * Say goodbye & terminate
 */
quit()
{
	putchr(_CL);
	gotoxy(0,0);
	fputs("Fullscreen DIRectory - Rel 1.0\n\n?COPY.TXT 1986-2005 Dave Dunfield\n -- see COPY.TXT --.\n", stderr);
	exit(0);
}

/*
 * Write a string to the output device
 */
putstr(ptr)
	char *ptr;
{
	register char c;

	while(c = *ptr++)
		putchr(c);
}

/*
 * Formatted print to console device
 */
v_printf(args)
	unsigned args;
{
	char buffer[100];

	_format_(&args, buffer);
	putstr(buffer);
}

/*
 * Shared format routine, format spec. and operands are passed
 * as a pointer to the calling functions argument list.
 */
_format_(optr, outptr)
	unsigned *optr;
	char *outptr;
{
	char outstk[17], *ptr, *format, justify, zero, minus, chr;
	unsigned width, value, i;

	format = (char *) *optr;

	while(chr = *format++) {
		if(chr == '%') {					/* format code */
			chr = *format++;
			*(ptr = &outstk[16]) = justify = minus = width = value = i = 0;
			zero = ' ';
			if(chr == '-') {				/* left justify */
				--justify;
				chr = *format++; }
			if(chr == '0')					/* leading zeros */
				zero = '0';
			while(isdigit(chr)) {			/* field width specifier */
				width = (width * 10) + (chr - '0');
				chr = *format++; }

			value = *++optr;				/* get parameter value */

			switch(chr) {
				case 'd' :					/* decimal number */
					if(value > 32767) {
						value = 0 - value;
						++minus; }
				case 'u' :					/* unsigned number */
					i = 10;
					break;
				case 'x' :					/* hexidecimal number */
					i = 16;
					break;
				case 'o' :					/* octal number */
					i = 8;
					break;
				case 'b' :					/* binary number */
					i = 2;
					break;
				case 'c' :					/* character data */
					*--ptr = value;
					break;
				case 's' :					/* string */
					ptr = (char *) value;
					break;
				default:					/* all others */
					*--ptr = chr;
					--optr; }

			if(i)		/* for all numbers, generate the ASCII string */
				do {
					if((chr = (value % i) + '0') > '9')
						chr += 7;
					*--ptr = chr; }
				while(value /= i);

/* output sign if any */
			if(minus) {
				*outptr++ = '-';
				if(width)
					--width; }

/* pad with 'zero' value if right justify enabled  */
			if(width && !justify) {
				for(i = strlen(ptr); i < width; ++i)
					*outptr++ = zero; }

/* move in data */
			i = 0;
			value = width - 1;
			while((*ptr) && (i <= value)) {
				*outptr++ = *ptr++;
				++i; }

/* pad with 'zero' value if left justify enabled */
			if(width && justify) {
				while(i < width) {
					*outptr++ = zero;
					++i; } } }
		else
/* not a format code, simply display the character */
			*outptr++ = chr; }

	*outptr = 0;
}
