#include <stdio.h>
#include <file.h>

unsigned
	Seg,
	Stop,
	Code,
	Day,
	Month,
	Year,
	Lcode,
	Lday,
	Lmonth,
	Lyear;

FILE
	*fp;

unsigned char
	Mode,
	buffer[100],
	*ptr;

extern unsigned RAND_SEED;

cmpseg(unsigned *i, unsigned char *s)
{
	unsigned o;
	o = *i;
/*unsigned i;
printf("%u: ", o);
for(i=0; i < 20; ++i)
	putc(peek(Seg, o+i), stdout);
putc('\n', stdout); */
	while(*s) {
		if(peek(Seg, o++) != *s++)
			return 0; }
	*i = o;
	return 255;
}

fix(unsigned char *file)
{
	int c;
	unsigned i, j, f, v;
	unsigned char cstring[6], w;

	Stop = w = 0;
	fp = fopen(file, "rvq");
	printf("Read '%s' ", file);
	while((c = getc(fp)) != EOF) {
		poke(Seg, Stop++, c);
		if(!Stop)
			abort("Segment overflow!"); }
	fclose(fp);
	printf("%u bytes,...", Stop);

	for(i=f=0; i < Stop; ++i) {
		if(peek(Seg, i) == '<') {		// Possible batch
			if(cmpseg(&i, "<A HREF=\"../img")) {	// Match
				printf("\b\b\b%3u", ++f);
				for(j=v=0; j < 5; ++j) {
					if(!isdigit(c = peek(Seg, i++)))
						abort("\nIMG name malformed (non-numeric)");
					v = (v * 10) + (c - '0'); }
				switch(Mode) {
				case 0 :		// Check code
					sprintf(cstring, "%05u", Code = v);
					Mode = 100;
				case 100:
					if(v != Code) {
						printf("\nBad match %u<>%u! ...", Code, v);
						goto setcode; }
					break;
				case 1 :		// Next random sequence
					RAND_SEED = v;
					Code = rand();
				case 2 :		// Fixed number
					Mode = 101;
					sprintf(cstring, "%05u", Code);
				case 101: setcode:
					w = 255;
					i -= 5;
					for(j=0; j < 5; ++j)
						poke(Seg, i++, cstring[j]); }
				if(peek(Seg, i++) != '/')
					abort("\nIMG name malformed (no '/')");
		} } }
	if(!f)
		abort("\nNo adjustment!");

	printf(" fixups, ");
	if(w) {
		printf("Rewrite, ");
		fp = fopen(file, "wvq");
		for(i=0; i < Stop; ++i)
			putc(peek(Seg, i), fp);
		fclose(fp); }
	printf("Done!\n");
}

num()
{
	unsigned v;
	while(isspace(*ptr))
		++ptr;
	v = 0;
	while(isdigit(*ptr))
		v = (v * 10) + (*ptr++ - '0');
	return v;
}

unsigned char help[] = { "\n\
Use: FIXIMG [number | /Random | /Next]\n" };

main(int argc, char *argv[])
{
	unsigned i;
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++)<<8)|toupper(*ptr++)) {
		case '-N' :
		case '/N' :
			Mode = 1;
			continue;
		case '-R' :
		case '/R' :
			RAND_SEED = peekw(0x40, 0x6C);
			Code = rand();
			Mode = 2;
			continue; }
		ptr -= 2;
		if(isdigit(*ptr)) {
			if(!Mode) {
				Code = atoi(ptr);
				Mode = 2;
				continue; } }
		abort(help); }

	IOB_size = 4096;
	Seg = alloc_seg(4096);

	fix("img\\index.htm");

	printf("\nDirectory: img%05u\n", Code);
}
