#include <stdio.h>
#include <dir.h>
#include <dos.h>

	unsigned crc, fcrc;
	unsigned long size, fsize;
	char dname[64], match[13], fname[80], path[80];

	unsigned crctab[] = {
		0x0000,0x1189,0x2312,0x329B,0x4624,0x57AD,0x6536,0x74BF,
		0x8C48,0x9DC1,0xAF5A,0xBFD3,0xCA6C,0xDBE5,0xE97E,0xF8F7,
		0x1081,0x0108,0x3393,0x221A,0x56A5,0x472C,0x75B7,0x643E,
		0x9CC9,0x8D40,0xBFDB,0xAF52,0xDAED,0xCB64,0xF9FF,0xE876,
		0x2102,0x308B,0x0210,0x1399,0x6726,0x76AF,0x4434,0x55BD,
		0xAD4A,0xBCC3,0x8E58,0x9ED1,0xEB6E,0xFAE7,0xC87C,0xD9F5,
		0x3183,0x200A,0x1291,0x0318,0x77A7,0x662E,0x54B5,0x453C,
		0xBDCB,0xAC42,0x9ED9,0x8E50,0xFBEF,0xEA66,0xD8FD,0xC974,
		0x4204,0x538D,0x6116,0x709F,0x0420,0x15A9,0x2732,0x36BB,
		0xCE4C,0xDFC5,0xED5E,0xFDD7,0x8868,0x99E1,0xAB7A,0xBAF3,
		0x5285,0x430C,0x7197,0x601E,0x14A1,0x0528,0x37B3,0x263A,
		0xDECD,0xCF44,0xFDDF,0xED56,0x98E9,0x8960,0xBBFB,0xAA72,
		0x6306,0x728F,0x4014,0x519D,0x2522,0x34AB,0x0630,0x17B9,
		0xEF4E,0xFEC7,0xCC5C,0xDCD5,0xA96A,0xB8E3,0x8A78,0x9BF1,
		0x7387,0x620E,0x5095,0x411C,0x35A3,0x242A,0x16B1,0x0738,
		0xFFCF,0xEE46,0xDCDD,0xCC54,0xB9EB,0xA862,0x9AF9,0x8B70,
		0x8408,0x9581,0xA71A,0xB693,0xC22C,0xD3A5,0xE13E,0xF0B7,
		0x0840,0x19C9,0x2B52,0x3BDB,0x4E64,0x5FED,0x6D76,0x7CFF,
		0x9489,0x8500,0xB79B,0xA612,0xD2AD,0xC324,0xF1BF,0xE036,
		0x18C1,0x0948,0x3BD3,0x2B5A,0x5EE5,0x4F6C,0x7DF7,0x6C7E,
		0xA50A,0xB483,0x8618,0x9791,0xE32E,0xF2A7,0xC03C,0xD1B5,
		0x2942,0x38CB,0x0A50,0x1AD9,0x6F66,0x7EEF,0x4C74,0x5DFD,
		0xB58B,0xA402,0x9699,0x8710,0xF3AF,0xE226,0xD0BD,0xC134,
		0x39C3,0x284A,0x1AD1,0x0A58,0x7FE7,0x6E6E,0x5CF5,0x4D7C,
		0xC60C,0xD785,0xE51E,0xF497,0x8028,0x91A1,0xA33A,0xB2B3,
		0x4A44,0x5BCD,0x6956,0x79DF,0x0C60,0x1DE9,0x2F72,0x3EFB,
		0xD68D,0xC704,0xF59F,0xE416,0x90A9,0x8120,0xB3BB,0xA232,
		0x5AC5,0x4B4C,0x79D7,0x695E,0x1CE1,0x0D68,0x3FF3,0x2E7A,
		0xE703,0xF68A,0xC411,0xD598,0xA127,0xB0AE,0x8235,0x93BC,
		0x6B4B,0x7AC2,0x4859,0x58D0,0x2D6F,0x3CE6,0x0E7D,0x1FF4,
		0xF78F,0xE606,0xD49D,0xC514,0xB1AB,0xA022,0x92B9,0x8330,
		0x7BC7,0x6A4E,0x58D5,0x485C,0x3DE3,0x2C6A,0x1EF1,0x0F78 };

	char buffer[80], verbose=-1, action=0, backfile=0, allfile = -1;
	char *index = "\\FSCAN";
	struct ffblk dirent;
	FILE *ifp, *ofp;

/*
 * Main program
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;
	char chr, chr1, *ptr, *ptr1;

/* default, assume all files */
	strcpy(dname,"*.*");
	strcpy(match, dname);

/* process arguments - setup directory & attribute mask */
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((tolower(*ptr++) << 8) | tolower(*ptr++)) {
			case 'v-':
				verbose = 0;
				break;
			case 'b+' :
				backfile = -1;
				break;
			case 'm+' :
				action = 1;
				break;
			case 'd+':
				action = 2;
				break;
			case 'l+':
				action = 3;
				break;
			case '=i' :
				index = ptr;
				break;
			default:
				ptr = argv[i];
				ptr1 = dname;
				if(*ptr == '\\') {
					*ptr1++ = getdisk() + 'A';
					*ptr1++ = ':'; }
				do
					*ptr1++ = toupper(*ptr);
				while(*ptr++);
				allfile = 0; } }

	if(verbose)
		printf("FSCAN - ?COPY.TXT 1990-2005 Dave Dunfield.  -- see COPY.TXT --.\n");

/* we have filename, determine if it is a directory */
	for(chr1=i=0; chr = dname[i]; ++i);	/* find end of string */
	while(i) {
		chr = dname[--i];
		if((chr == '\\') || (chr == ':')) {
			++i;
			break; }
		if((chr == '*') || (chr == '?'))
			chr1 = -1; }
	if(!chr1) {				/* Name did not contain wildcards, test file */
		if(!isdir(dname))
			chr1 = -1; }

/* If file was not a directory, hack off filespec */
	if(chr1) {
		strcpy(match, &dname[i]);
		dname[i] = 0; }

/* If no directory name, convert to current directory */
	if(!dname[0])
		getcwd(dname, sizeof(dname));

/* Insure that the directory name terminates with '\\' */
	ptr = dname;
	do
		chr = *ptr++;
	while(*ptr);
	if(chr != '\\') {
		*ptr++ = '\\';
		*ptr = 0; }

#ifdef DEBUG
	printf("Dir='%s'\nFile='%s'\n", dname, match);
#endif

	strcpy(path, dname);
	strcat(path, match);

	file_name("IDX");
	if(!(ifp = fopen(buffer, "rb"))) {
		if(action != 1) {
			printf("Cannot open index file: '%s'\n", buffer);
			exit(-1); } }

	switch(action) {
		case 0 :		/* Compare files against checklist */
			i = j = 0;
			while(scan_input()) {
				if(allfile || fmatch(fname, path)) {
					if(process_file(fname)) {
						++i;
						if(size != fsize) {
							printf("%s has different SIZE\n", fname);
							++j; }
						else if(crc != fcrc) {
							printf("%s has different CRC\n", fname);
							++j; } }
					else
						printf("Cannot access %s\n", fname); } }
			fclose(ifp);
			if(verbose) {
				if(j)
					printf("\007*** %u of %u files failed verification ***\007\n", j, i);
				else
					printf("%u files tested and verified.\n", i); }
			break;
		case 1 :			/* Update files to checklist */
		case 2 :			/* Delete files in checklist */
			file_name("$$$");
			if(!(ofp = fopen(buffer, "wb"))) {
				printf("Cannot create new index file: '%s'\n", buffer);
				exit(-1); }
			if(ifp) {
				while(scan_input()) {
					if(!fmatch(fname, path)) {	/* File does not fit */
						fputs(fname, ofp);
						putc(0, ofp);
						fwrite(&fsize, 1, sizeof(fsize), ofp);
						fwrite(&fcrc , 1, sizeof(fcrc) , ofp); }
					else if(verbose)
						printf("Dropping '%s'\n", fname); }
				fclose(ifp); }
			else if(verbose)
				printf("Creating '%s.IDX' index file\n", index);
			if(action == 1) {
				if(!findfirst(path, &dirent, FA_HIDDEN|FA_SYSTEM)) {
					do {
						strcpy(buffer, dname);
						strcat(buffer, dirent.ff_name);
						if(process_file(buffer)) {
							if(verbose)
								printf("Adding '%s'\n", buffer);
							fputs(buffer, ofp);
							putc(0, ofp);
							fwrite(&size, 1, sizeof(size), ofp);
							fwrite(&crc , 1, sizeof(crc) , ofp); }
						else
							printf("Cannot access '%s'\n", buffer); }
					while(!findnext(&dirent)); } }
			fclose(ofp);
			file_name(backfile ? "BAK" : "IDX");
			unlink(buffer);
			file_name("IDX");
			strcpy(fname, buffer);
			if(backfile) {
				file_name("BAK");
				rename(fname, buffer); }
			file_name("$$$");
			rename(buffer, fname);
			break;
		case 3 :			/* List checklist filenames */
			i = j = 0;
			while(scan_input()) {
				++i;
				if(allfile || fmatch(fname, path)) {
					++j;
					printf("%-50s %10lu %04X\n", fname, fsize, fcrc); } }
			if(verbose) {
				if(i != j)
					printf("%u of ", j);
				printf("%u files found in index.\n", i); }
			fclose(ifp);
			break;
	}
}

/*
 * Process a file (calculate size & crc)
 */
process_file(filename)
	char *filename;
{
	int c;
	unsigned x;
	FILE *fp;

	size = 0;
	crc = -1;
	if(!(fp = fopen(filename,"rb")))
		return 0;
	while((c = getc(fp)) >= 0) {
		x = crctab[c ^ (crc & 0x00ff)];
		crc = (x & 0xff00) | ((x & 0x00ff) ^ (crc >> 8));
		++size; }
	fclose(fp);
	return -1;
}

/*
 * Scan input record
 */
scan_input()
{
	int c;
	char *ptr;

	ptr = fname;
	while(*ptr++ = c = getc(ifp)) {
		if(c < 0)
			return 0; }
	fread(&fsize, 1, sizeof(fsize), ifp);
	fread(&fcrc, 1, sizeof(fcrc), ifp);
	return -1;
}

/*
 * Match a file against a string
 */
fmatch(filename, pattern)
	char *filename, *pattern;
{
#ifdef DEBUG
	printf("Compare '%s' <> '%s'\n", filename, pattern);
#endif
	for(;;) switch(*pattern) {
		case '?' :
			if((*filename == '.') || (*filename == '\\') || !*filename)
				return 0;
			++filename;
			break;
		case '*' :
			while(*pattern && (*pattern != '.'))
				++pattern;
			while(*filename && (*filename != '.')) {
				if(*filename == '\\')
					return 0;
				++filename; }
			break;
		case 0 :
			return *filename == 0;
		default:
			if(*pattern++ != *filename++)
				return 0; }
}

/*
 * Build up a filename from index to buffer
 */
file_name(extension)
	char *extension;
{
	char *ptr, *ptr1;

	ptr = index;
	ptr1 = buffer;
	while(*ptr)
		*ptr1++ = *ptr++;
	*ptr1++ = '.';
	do
		*ptr1++ = *extension;
	while(*extension++);
}

/*
 * Test for a file being a directory.
 */
isdir(name)
	char name[];
{
	if((name[2] == '\\') && !name[3])		/* Root directory */
		return -1;
	if(findfirst(name,&dirent,FA_DIREC|FA_HIDDEN|FA_SYSTEM))
		return 0;
	return (dirent.ff_attrib & FA_DIREC) != 0;
}
