#include <stdio.h>
#include <window.h>

#define	SCREEN	25
#define	WIDTH	80
#define	NORMAL	0x07
#define	REVERSE	0x70
#define	LINE	512

int
	Top,					// Current top of screen
	Ltop,					// Last top of screen (to detect redraw)
	Ftop = 32767;			// Top of file
	Line,					// Current line
	Horz;					// Current horizontal position
FILE
	*fp;					// File access pointer
unsigned char
	*Ptr,					// General pointer
	*Edt,					// Edit pointer
	Buffer[128],			// Filename buffer
	Lines[SCREEN][LINE];	// Line buffer

unsigned char Help[] = { "\n\
use:	FSEL filename [options]\n\n\
opts:	/B		- use Big editor\n\
	E=<sc>text	- define Editor\n\
\nDave Dunfield - "#__DATE__"\n" };

// Load index file into memory
void load()
{
	unsigned i, l;
	unsigned char f;

	rewind(fp);
	l = i = f = 0;

	while(l < Top) {
		if(!fgets(Lines, LINE-1, fp)) {
			Ftop = l;
			memset(Lines, 0, sizeof(Lines));
			return; }
		++l; }

	while(i < SCREEN) {
		memset(Ptr = Lines[i], 0, LINE);
		if(!f) {
			if(!fgets(Ptr, LINE-1, fp)) {
				strcpy(Ptr, "**EOF**");
				Ftop = l;
				f = 255; } }
		++i; ++l; }
}

// Draw current index file
void draw()
{
	int c;
	unsigned i, j, l;
	l = Line - Top;
	for(i=0; i < SCREEN; ++i) {
		wgotoxy(0, i);
		if(i == l)
			*W_OPEN = REVERSE;
		Ptr = Lines[i] + Horz;
		for(j=0; j < WIDTH; ++j) {
			if(!(c = *Ptr++)) {
				wcleol();
				break; }
			if((c < ' ') || (c > 0x7E)) switch(c) {
				case '\t' : c = ' ';	break;
				default: c = 0xA8; }
			wputc(c); }
		*W_OPEN = NORMAL; }
}

// Main program
main(int argc, char *argv[])
{
	unsigned i, c;
	unsigned char *p;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++) << 8) | toupper(*Ptr++)) {
		case '/B' :
		case '-B' : Edt = "EB %s %u";			continue;
		case 'E=' : p = Ptr;
			c = *p++;
			Edt = p;
			while(*p) {
				if(*p == c)
					*p = ' ';
				++p; }
			continue;
		} if(fp)
			abort(Help);
		fp = fopen(Ptr-2, "rvq"); }

	if(!fp)
		abort(Help);

	if(!Edt)
		Edt = "EDT %s c=%u";

	load();
	if(!Ftop)
		abort("No entries!\n");

reopen:
	wopen(0, 0, WIDTH, SCREEN, WSAVE|WCOPEN|NORMAL);
	wcursor_off();

redraw:
	if(Line < 0)
		Line = 0;
	if(Line > Ftop)
		Line = Ftop;
	if(Horz < 0)
		Horz = 0;
	if(Line < Top)
		Top = Line;
	if((Top+SCREEN) <= Line)
		Top = Line-(SCREEN-1);
	if(Top != Ltop) {
		load();
		if(Line > Ftop)
			goto redraw;
		Ltop = Top; }
	draw();
	for(;;) switch(c = wgetc()) {
	case _KUA: --Line;				goto redraw;
	case _KDA: ++Line;				goto redraw;
	case _KHO: Top = Line = 0;		goto redraw;
	case _KEN: Line = Ftop-1;		goto redraw;
	case _KPU: Line = Top-SCREEN;	goto redraw;
	case _KPD: Line = Top+(SCREEN*2-1);	goto redraw;
	case _KLA: --Horz;				goto redraw;
	case _KRA: ++Horz;				goto redraw;
	case _CLA: Horz -= WIDTH/5;		goto redraw;
	case _CRA: Horz += WIDTH/5;		goto redraw;
	case _CHO: Horz = 0;			goto redraw;
	case 0x1B:
		wclose();
		return;
	case '\n' :
		if(Line >= Ftop)
			continue;
		wclose();
		Ptr = Lines[Line-Top];
		p = Buffer;
		while(*Ptr != '(') {
			if(!*Ptr)
				abort("Does not appear to be a findlist");
			*p++ = *Ptr++; }
		*p = 0;
		sprintf(Lines, Edt, Buffer, atoi(Ptr+1));
		fputs(Lines, stdout);
		putc('\n', stdout);
		system(Lines);
		Ltop = -1;
		goto reopen; }
}
