#include <stdio.h>
#include <dir.h>
#include <dos.h>
#define	LINE_SIZE	500
#define NUM_CMDS	15

char verbose = -1, recurse = 0, text = 0, dual = -1;
char *cmds[NUM_CMDS], outcmd[80], dname[65], match[20];
char chr, chr1, *ptr, *ptr1, xbuf[80];
int ccount = 0, fcount = 0, tmatch[NUM_CMDS] = { 0 };

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;
	struct ffblk ffblk;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
			case 'C+' :		/* Case sensitive */
				dual = 0;
				break;
			case 'R+' :		/* recurse into sub-directories */
				recurse = -1;
				break;
			case 'T+' :		/* Display text of matched lines */
				text = -1;
				break;
			case 'V-' :		/* Turn off vebose output */
				verbose = 0;
				break;
			default:
				cmds[ccount++] = argv[i]; } }

	if(!ccount) {
	help:
		fputs("\nUse: locate <filespec> \"pattern\"* [+c +r +t -v]\n\n?COPY.TXT 1989-2005 Dave Dunfield\n -- see COPY.TXT --.\n", stderr);
		exit(-1); }
	if(ccount < 2) {
		fputs("Search for?", stderr);
		fgets(cmds[ccount++] = ptr = xbuf, sizeof(xbuf), stdin);
		while(*ptr) {
			if(*ptr == '\n') {
				*ptr = 0;
				break; }
			++ptr; }
		if(!xbuf[0]) goto help; }

	if(dual) {		/* Dual case selected, convert strings to upper */
		for(i=0; i < ccount; ++i) {
			ptr = cmds[i];
			while(*ptr) {
				*ptr = toupper(*ptr);
				++ptr; } } }

	strcpy(match,"*.*");

/* we have filename, determine if it is a directory */
	ptr = cmds[0];
	ptr1 = dname;
	chr1 = i = 0;
	while(*ptr1++ = *ptr++)
		++i;
	j = i;
	while(i) {
		chr = dname[--i];
		if((chr == '\\') || (chr == ':')) {
			++i;
			break; }
		if((chr == '*') || (chr == '?'))
			chr1 = -1; }
	if(!chr1) {		/* Name did not contain wildcards, test file */
		if(!findfirst(dname,&ffblk,0))	/* Test for directory */
			chr1 = -1;
		else {
			if((dname[j-1] != '\\') && (dname[j-1] != ':'))
				dname[j++] = '\\';
			dname[j] = 0; } }
	if(chr1) {		/* Hack off filespec from dir */
		strcpy(match, &dname[i]);
		dname[i] = 0; }

	do_dir();

	if(!fcount)
		fputs("No files found", stderr);

	if(verbose && (fcount > 1)) {
		printf("Total matches:");
		for(i=1; i < ccount; ++i)
			printf(" %u", tmatch[i]);
		putc('\n', stdout); }
}

do_dir()
{
	int i;
	struct ffblk ffblk;

	strcpy(outcmd, dname);
	strcat(outcmd, match);

	if(!findfirst(outcmd, &ffblk, 0)) {
/* we have at least one file, search them all */
		do {
			++fcount;
			strcpy(outcmd, dname);
			strcat(outcmd, ffblk.ff_name);
			search_file(outcmd); }
		while(!findnext(&ffblk)); }

/* Now, search for directories */
	if(recurse) {
		strcpy(outcmd, dname);
		strcat(outcmd,"*.*");
		if(findfirst(outcmd, &ffblk, FA_DIREC))
			return;
		i = strlen(dname);
		do {
			if((ffblk.ff_attrib & FA_DIREC) && (ffblk.ff_name[0] != '.')) {
				strcat(dname, ffblk.ff_name);
				strcat(dname,"\\");
				do_dir();
				dname[i] = 0; } }
		while(!findnext(&ffblk)); }
}

/*
 * Search a file for a string
 */
search_file(name)
	char *name;
{
	int line, match[NUM_CMDS];
	FILE *fp;
	char buffer[LINE_SIZE];
	register int i;
	register char *ptr, lflag, tflag;

	if(!(fp = fopen(name, "r"))) {
		fprintf(stderr,"***Unable to open: '%s'\n", name);
		return 0; }

	if(verbose)
		printf("Searching '%s' ", name);

	tflag = line = 0;
	for(i = line = 0; i < NUM_CMDS; ++i)
		match[i] = 0;

	while(fgets(ptr = buffer, LINE_SIZE, fp)) {
		++line;
		lflag = 0;
		while(*ptr) {
			for(i=1; i < ccount; ++i) {
				if(partial_match(cmds[i], ptr)) {
					if(text && !lflag)
						if(verbose) {
							if(!tflag) {
								putc('\n', stdout);
								tflag = -1; }
							printf("%u: %s", line, buffer); }
						else
							printf("%s(%u): %s", name, line, buffer);
					lflag = -1;
					++match[i]; } }
			++ptr; } }

	fclose(fp);

	if(verbose) {
		printf("Found:");
		for(i=1; i < ccount; ++i) {
			tmatch[i] += match[i];
			printf(" %u", match[i]); }
		putc('\n', stdout); }
}

/*
 * Test for a partial match of two strings
 */
partial_match(str1, str2)
	char *str1, *str2;
{
	while(*str1) {
		if(*str1++ != (dual ? toupper(*str2) : *str2))
			return 0;
		++str2; }
	return -1;
}
