// I used this to make most of the "link" pages on my original DDS site
#include <stdio.h>

FILE
	*fpi,
	*fpo;

unsigned
	Day,
	Month,
	Year,
	Line,
	L512[] = { 512, 0 },
	L1024[] = { 1024, 0 },
	Size[2];

unsigned char
	State,
	Title[256],
	buffer[256],
	temp[50],
	name[50],
	*ptr;

#define	S_PRE	1			// Preformatted
#define	S_PAR	2			// Paragraph

register error(unsigned args)
{
	unsigned char *p, buf[80];
	_format_(nargs() * 2 + &args, buf);
	printf("%u: %s\n", Line, buf);
	fputs(p=buffer, stdout);
	putc('\n', stdout);
	while(p < ptr) {
		++p;
		putc(' ', stdout); }
	fputs("^\n", stdout);
	exit(-1);
}

int skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

parse(unsigned char *d)
{
	skip();
	while(*ptr && !isspace(*ptr))
		*d++ = *ptr++;
	*d = 0;
}

fill(unsigned c)
{
	while(c) {
		--c;
		putc(' ', fpo); }
}

int rate()
{
	unsigned c;
	c = ' ';
	if(isdigit(skip())) {
		c = *ptr++;
		skip(); }
	return c;
}

setstate(unsigned new)
{
	if(State == new)
		return;
	switch(State) {
	case S_PRE : fputs("</PRE>\n", fpo);		break;
	case S_PAR : fputs("</P>\n", fpo);			break;
	}
	switch(State = new) {
	case S_PRE : fputs("<PRE>", fpo);			return;
	case S_PAR : fputs("<P>", fpo);				}
}

putstring(unsigned char *p)
{
	int c;
	static unsigned char *months[] = {
		"???", "January", "February", "March", "April", "May", "June", "July",
		"August", "September", "October", "Novembed", "December", "???",
		"???", "???" };
		
	unsigned v;
	unsigned char *f, format[10];
	while(c = *p++) {
		if(c == '~') {
			f = format;
			*f++ = '%';
			while(isdigit(c = *p++))
				*f++ = c;
			switch(c) {
			case 'd' :	v = Day;	goto doval;		// Day of month
			case 'm' :	v = Month;	goto doval;		// Month - numeric
			case 'y' : 	v = Year;	goto doval;		// Year
			case 'Y' :	v = Year % 100;
doval:			*f++ = 'u';
				*f = 0;
				fprintf(fpo, format, v);
				continue;
			case 'M' :								// Month - text
				*f++ = 's';
				*f = 0;
				fprintf(fpo, format, months[Month]);
				continue;
			default:
				*f++ = 'c';
				*f = 0;
				fprintf(fpo, format, c);
				continue; } }
		putc(c, fpo); }
}

main()
{
	unsigned j;
//	unsigned char *p;

	get_date(&Day, &Month, &Year);
	fpi = fopen("INDEX.TXT", "rvq");
	fpo = fopen("INDEX.HTM", "wvq");
	while(fgets(ptr = buffer, sizeof(buffer)-1, fpi)) {
		++Line;
		switch(skip()) {
		case 0 : continue;
		case '~' :
			switch(*++ptr) {
			case '\'':					// Paragraph
				if(State == S_PAR)
					putc('\n', fpo);
				setstate(S_PAR);
				putstring(ptr+1);
				continue;
			case '"' :					// No format
				setstate(0);
			case '+' :					// Same state
				putstring(ptr+1);
				putc('\n', fpo);
				continue;
			case '*' :					// Reset state
				setstate(0);
				continue;
			case '$' :					// Title
				fputs("<HTML><HEAD>\n<TITLE>", fpo);
				fputs(ptr+1, fpo);
				fputs("</TITLE>\n</HEAD>\n<BODY>\n<H1>", fpo);
				fputs(ptr+1, fpo);
				fputs("</H1>\n\n", fpo);
				continue;
			case '-' :					// Horizontal line
				setstate(0);
				fputs("<hr>\n", fpo);
				continue;
			case '!' :					// Header-3
				setstate(0);
				fputs("<br><H3>", fpo);
				putstring(ptr+1);
				fputs("</H3>\n", fpo);
				setstate(S_PRE);
				continue;
			case '@' :					// Header-2
				setstate(0);
				fputs("<br><H2>", fpo);
				putstring(ptr+1);
				fputs("</H2>\n", fpo);
				setstate(S_PRE);
				continue;
			default: error("Bad option"); }
		} parse(name);
		if(find_first(name, 0, temp, &Size[1], &Size[0], &j, &j, &j)) {
			printf("Not found: %s\n", name);
			continue; }
		longadd(Size, L512);
		longdiv(Size, L1024);
		fprintf(fpo, "<A HREF=\"%s\"", name);
//		fill(12-strlen(name));
		for(j=0; name[j]; ++j) {
			if(name[j] == '.')
				name[j] = 0; }
		fprintf(fpo, ">%s</A>", name);
		fill(8-strlen(name));
		skip();
		fprintf(fpo, "%4uk %c %s\n", *Size, rate(), ptr);
	}

	setstate(0);
//	fputs("<hr>\n", fpo);
//	fputs("<A HREF=\"../index.htm\">", fpo);
//	fputs("Back to Old Computers</A>\n<br><br>?COPY.TXT 2009-2010 ", fpo);
//	fputs("<A HREF=\"../contact.htm\">", fpo);
//	fputs("Dave Dunfield</A>.\n</BODY></HTML>\n", fpo);

	fclose(fpo);
	fclose(fpi);
}
