#include <stdio.h>
#include <file.h>

#define	PATCHES	500

unsigned
	Seg,					// External segment
	Stop,					// Top of external segment
	Ptop,					// Top of patch lists
	Pcur,					// Current patch list entry
	L[2],					// Long value
	L1[2],					// ""
	PsizeIn[PATCHES],		// Patch in size
	PatchIn[PATCHES],		// Patch input list
	PsizeOut[PATCHES],		// Patch out size
	PatchOut[PATCHES],		// Patch output list
	PatchAddr[PATCHES][2];	// Patch address
FILE
	*fpi,					// Input file
	*fpo;					// Output file
unsigned char
	*Ptr,					// General pointer
	*Base,					// Base for error out
	*InFile,				// Input file
	*OutFile,				// OutPut file
	Dpatch,					// Display patch option
	Vsize = 255,			// Allow variable size
	Buffer[512];			// General buffer

unsigned char Help[] = { "\n\
use:	PATCH infile outfile [options]\n\n\
opts:	/D			- Display patch table\n\
	/M			- allow Mismatched size\n\
	F=file			- load patches from File\n\
	P=addr[:]old=new	- apply Patch\n\
\nold/new can be hex-values or strings:\n\
	1,2,3=3,4,5\n\
	'dave'=\"fred\"\n\
	1,'dave',2=2,'fred',1\n\
\nDave Dunfield - "#__DATE__"\n" };

// Report an error
register error(unsigned args)
{
	unsigned char *p, buf[81];
	_format_(nargs() * 2 + &args, buf);
	fputs(buf, stdout);
	putc('\n', stdout);
	if(Base) {
		fputs(p=Base, stdout);
		putc('\n', stdout);
		while(++p < Ptr)
			putc(' ', stdout);
		fputs("^\n", stdout); }
	if(fpo) fclose(fpo);
	if(fpi) fclose(fpi);
	exit(-1);
}

// Skip to non-blank
int skip()
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

// Encode patch string
unsigned encode(unsigned char e)
{
	unsigned c, d, v, t;

	t = Stop;
again:
	switch(c = skip()) {
	case '\'':
	case '"' :
		++Ptr;
		while((d = *Ptr++) != c) {
			if(!d)
				error("'%c' expected", c);
			poke(Seg, Stop++, d); }
		break;
	default:
		v = d = 0;
		for(;;) {
			c = *Ptr;
			if((c >= '0') && (c <= '9'))
				c -= '0';
			else if((c >= 'a') && (c <= 'f'))
				c -= ('a'-10);
			else if((c >= 'A') && (c <= 'F'))
				c -= ('A'-10);
			else
				break;
			v = (v << 4) + c;
			++d;
			++Ptr; }
		if(!d)
			error("String or value expected");
		if(v > 255)
			error("Value too large");
		poke(Seg, Stop++, v); }

	if((c = skip()) == ',') {
		++Ptr;
		goto again; }
	if(c != e)
		error("Syntax error");
	++Ptr;
	return Stop - t;
}

// Encode a patch value
void addpatch()
{
	unsigned c, d, t[2];

	if(Ptop >= PATCHES)
		error("Too many patches");
	longset(L, d=0);
	for(;;) {
		c = *Ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if((c >= 'a') && (c <= 'f'))
			c -= ('a'-10);
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			break;
		longset(t, 16);
		longmul(L, t);
		longset(t, c);
		longadd(L, t);
		++d;
		++Ptr; }
	if(!d)
		error("Value expected");
	if(skip() == ':')
		++Ptr;
	longcpy(PatchAddr[Ptop], L);
	PatchIn[Ptop] = Stop;
	PsizeIn[Ptop] = c = encode('=');
	PatchOut[Ptop] = Stop;
	PsizeOut[Ptop++] = d = encode(0);
	if((d != c) && Vsize)
		error("In/Out must be same size");
}

// Get a character from the input file
int Getc()
{
	if(!++*L)
		++L[1];
	return getc(fpi);
}

main(int argc, char *argv[])
{
	unsigned i, j, k, l;
	Seg = alloc_seg(4096);

	IOB_size = 4096;

	// Process command line arguments
	for(i=1; i < argc; ++i) {
		Ptr = Base = argv[i];
		switch((toupper(*Ptr++) << 8) | toupper(*Ptr++)) {
		case '-D' :
		case '/D' : Dpatch = 255;		continue;
		case '-M' :
		case '/M' : Vsize = 0;			continue;
		case 'P=' : addpatch();			continue;
		case 'F=' :
			fpi = fopen(Ptr, "rvq");
			while(fgets(Ptr = Base = Buffer, sizeof(Buffer)-1, fpi)) {
				switch(skip()) {
				case ';' :
				case 0 : continue; }
				addpatch(); }
			fclose(fpi);
			fpi=0;
			continue;
		} Ptr -= 2;
		if(!InFile) {
			InFile = Ptr;
			continue; }
		if(!OutFile) {
			OutFile = Ptr;
			continue; }
		abort(Help); }

	// Sort the patch list
	for(i=0; i < Ptop; ++i) {
		longcpy(L, PatchAddr[i]);
		for(j = i + 1; j < Ptop; ++j) {
			if(longcmp(PatchAddr[j], L) < 0) {
				longcpy(PatchAddr[i], PatchAddr[j]);
				longcpy(PatchAddr[j], L);
				longcpy(L, PatchAddr[i]);
				k = PsizeIn[i];		PsizeIn[i] = PsizeIn[j];	PsizeIn[j] = k;
				k = PatchIn[i];		PatchIn[i] = PatchIn[j];	PatchIn[j] = k;
				k = PsizeOut[i];	PsizeOut[i] = PsizeOut[j];	PsizeOut[j] = k;
				k = PatchOut[i];	PatchOut[i] = PatchOut[j];	PatchOut[j] = k; } } }

	// Display the patch list
	if(Dpatch) {
		for(i=0; i < Ptop; ++i) {
			printf("%04x%04x %u", PatchAddr[i][1], PatchAddr[i][0], l=PsizeIn[i]);
			if((k = PsizeOut[i]) != l)
				printf("=%u", k);
			fputs(": ", stdout);
			j = PatchIn[i];
			while(l--)
				printf("%02x ", peek(Seg, j++));
			putc('=', stdout);
			j = PatchOut[i];
			while(k--)
				printf(" %02x", peek(Seg, j++));
			putc('\n', stdout); }
		return; }

	if(!OutFile)
		abort(Help);

	longset(L, Base = 0);
	fpi = fopen(InFile, "rvqb");
	fpo = fopen(OutFile, "wvqb");
	while(Pcur < Ptop) {	// Patch entries to go
		longcpy(L1, PatchAddr[Pcur]);
		while(longcmp(L, L1) < 0)		// Copy up to entry
			putc(Getc(), fpo);
		// Substitute patch data
		l = PsizeIn[Pcur];
		j = PatchIn[Pcur];
		while(l--) {
			if(Getc() != peek(Seg, j++)) {
				longset(L1, 1);
				longsub(L, L1);
				error("Mismatch at %04x%04x", L[1], *L); } }
		l = PsizeOut[Pcur];
		j = PatchOut[Pcur++];
		while(l--)
			putc(peek(Seg, j++), fpo); }
	while((i = Getc()) != EOF)
		putc(i, fpo);
	fclose(fpo);
	fclose(fpi);
}
