/*
 * Pull lines from a text file,
 */
#include <stdio.h>
#include <window.h>
#include <file.h>
#if 0
	#define	LFN_OPEN
	#define	LFN_FOPEN
	#include <lfn.ch>
	#define	fopen	lfn_fopen
#endif

#define	LINDEX		16		// Number of lines per index
#define	LISIZE		2048	// Number of indexes

#define	HEIGHT		24		// Height of browse window
#define	WIDTH		78		// Width of browse window

#define EOLATTR		0x4E	// End of line attribute
#define	EOLCHAR		0xB0	// End of line character
#define	SECATTR		0x03	// Section attribute
#define	STAATTR		0x17	// Status window attribute
#define	INDATTR		0x03	// Indicator attriute
#define	SELATTR		0x30	// Selected text
#define	ANKATTR		0x70	// Anker atrtibute
#define	ERRATTR		0x47	// Error window attribute

unsigned
	Seg,				// External segment
	Seg1,				// Backup copy
	Cline,				// Current line
	Tline,				// Line at top of screen
	Fline,				// Last find line
	Maxline,			// Max lines in file
	Maxmark,			// Maximum marker value
	Markline = -1,		// Marked line
	Tab = 4,			// Tab width
	Horz,				// Horizontal offset
	Litop,				// Line index top
	Lindex[LISIZE][2];	// Line index offsets
FILE
	*fp,
	*fpo;
unsigned char
	*Ifile,				// Input file	(source material)
	*Pfile,				// Pull file	(marked sections)
	*Ofile,				// Output file	(input minus marked sections)
	*Ptr,				// General pointer
	Marker,				// Marker value
	Mlast,				// Last marker value
	Lmarker,			// Last marker value
	Eolm,				// End of line markeer value enable
	Reverse,			// Reverse order of output
	Temp[16],			// Temp storage
	Input[66],			// Input buffer
	Buffer[1024];		// Line buffer

struct WINDOW
	*Swin,				// Status window
	*Iwin,				// Inidicator window
	*Mwin;				// Main window

// Display a status-line message
register status(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	w_gotoxy(0, 0, Swin);
	w_puts(buf, Swin);
	if(Swin->WINcurx < 80)
		w_cleol(Swin);
}

/*
 * Read line from input with tab updates
 */
int readline()
{
	int c;
	unsigned p;

	p = 0;
	while((c = getc(fp)) != '\n') {
		if(c == EOF) {
			if(!p)
				return -1;
			break; }
		if(c == '\t') {
			do {
				Buffer[p] = ' '; }
			while(++p % Tab);
			continue; }
		Buffer[p++] = c; }
	Buffer[p] = 0;
	return p;
}

/*
 * Position to desired line
 */
unsigned goto_line(unsigned line)
{
	unsigned i;
	if(line >= Maxline)
		line = Maxline;
	rewind(fp);
	if(i = line / LINDEX)
		fseek(fp, Lindex[i-1][1], Lindex[i-1][0], 0);
	else
		rewind(fp);
	i = line % LINDEX;
	while(i--)
		fgets(Buffer, sizeof(Buffer)-1, fp);
	return line;
}

// Get a marker value
int getmark(void)
{
	unsigned i, j, k;
	i = j = k = 0;
	do {
		poke(Seg1, i, j = peek(Seg, i));
		if(j > k)
			k = j; }
	while(++i < Maxline);
	return k+1;
}

/*
 * Write section to file
 */
void write_section(unsigned s, unsigned char *file)
{
	unsigned i, ll;
	ll = -1;
	i = 0;
	do {
		if(peek(Seg, i) == s) {
			if(!fpo)
				fpo = fopen(file, "wvq");
			if(i != ll) {
				printf("Seek %u\n", i);
				goto_line(ll = i); }
			fgets(Buffer, sizeof(Buffer)-1, fp);
			fputs(Buffer, fpo);
			putc('\n', fpo);
			++ll; } }
	while(++i < Maxline);
}

void oclose(void)
{
	if(fpo)
		fclose(fpo);
	fpo = 0;
}

register yn(unsigned args)
{
	unsigned l;
	unsigned char buf[81];
	l = _format_(nargs() * 2 + &args, buf);
	wopen(40-(l/2), 10, l+2, 3, WSAVE|WCOPEN|WBOX1|ERRATTR);
	wputs(buf);
	for(;;) switch(wgetc()) {
		case 'y' :
		case 'Y' : wclose(); return 255;
		case 'n' :
		case 'N' : wclose(); return 0; }
}

// Input from the status line
int sinput(unsigned char *buf, unsigned len)
{
	int r;
	W_OPEN = Swin;
	r = wgets(W_OPEN->WINcurx, 0, buf, len);
	wcursor_off();
	W_OPEN = Mwin;
	return r;
}

/*
 * If line is off-screen, attempt to center
 */
void center(unsigned offset)
{
	if((Cline > Tline) && (Cline < (Tline+HEIGHT)))		// On-screen
		return;
	Tline = (Cline > offset) ? Cline - offset : 0;
}

unsigned char Help[] = { "\n\
use:	PULL input-file pull-file [output-file] [options]\n\n\
opts:	/E	- End-of-line markers\n\
	/R	- Reverse sections in output (highest to lowest)\n\
	T=n	- set Tab width\n\
\nDave Dunfield - "#__DATE__"\n" };
		
main(int argc, char *argv[])
{
	int c;
	unsigned h, i, j, k, l;
	unsigned char *p;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		j = toupper(*Ptr++) << 8;
		switch(toupper(*Ptr++) | j) {
		case ('T'<<8)|'=' :
			if(!(Tab = atoi(Ptr)))
				Tab = 1;
			continue;
		case ('-'<<8)|'E' :
		case ('/'<<8)|'E' : Eolm = 255;			continue;
		case ('-'<<8)|'R' :
		case ('/'<<8)|'R' : Reverse = 255;		continue;
		} Ptr -= 2;
		if(!Ifile) {
			Ifile = Ptr;
			continue; }
		if(!Pfile) {
			Pfile = Ptr;
			continue; }
		if(!Ofile) {
			Ofile = Ptr;
			continue; }
	help:	abort(Help); }

	if(!Pfile) goto help;

#ifdef LFN_FOPEN
	lfn_init();
#endif

	Seg1 = (Seg = alloc_seg(8192)) + 4096;
	i = 0; do {
		pokew(Seg, i, 0);
		pokew(Seg1,i, 0); }
	while(i -= 2);

	// Open source file and index it
	// Do this in BINARY mode so we don't get misaligned by multi-byte EOLs
	fp = fopen(Ifile, "rvqb");
	h = l = i = j = 0;
	while((c = getc(fp)) != EOF) {
		if(!++l)
			++h;
		if(c == '\n') {
			++Maxline;
			if(!(++j % LINDEX)) {
				if(Litop >= LISIZE)
					abort("Too many lines!");
				Lindex[Litop][0] = l;
				Lindex[Litop++][1] = h; } } }
	while(Litop < LISIZE) {		// Point rest of table at end
		Lindex[Litop][0] = l;
		Lindex[Litop++][1] = h; }
	// Switch to NON-BINARY so multi-byte EOLs read as single '\n'
	fp->FILE_options &= ~F_BINARY;

	Swin = wopen(0, 0, 80, 1, WSAVE|WCOPEN|STAATTR);
	Iwin = wopen(WIDTH, 1, 80-WIDTH, HEIGHT, WSAVE|WCOPEN|INDATTR);
	Mwin = wopen(0, 1, WIDTH, HEIGHT, WSAVE|WCOPEN|NORMAL);
	wcursor_off();

	// Display one screen
top:
	if(Cline > Maxline)			// Beyond end of file
		Cline = Maxline;
	if(Cline < Tline)			// Before start of screen
		Tline = Cline;
	else if(Cline >= (Tline+HEIGHT))	// Past end of screen
		Tline = Cline - (HEIGHT-1);
	goto_line(Tline);
	if(Horz & 0x8000)			// Negative scroll
		Horz = 0;
	if(Cline < Markline) {		// Set low, high mark range
		l = Cline;
		h = Markline; }
	else {
		l = Markline;
		h = Cline; }
	for(i=0; i < HEIGHT; ++i) {
		wgotoxy(0, i);
		if(readline() == -1) {
			*W_OPEN = REVERSE;
			wputs("[EOF]");
			*W_OPEN = NORMAL;
			wcleow();
			break; }
		// Display the line
		p = Buffer;
		j = Horz;
		while(j && *p) {
			--j;
			++p; }
		if((k = Tline + i) == Cline)
			*W_OPEN = REVERSE;
		else if(peek(Seg, k))
			*W_OPEN = SECATTR;
		for(j=0; j < WIDTH; ++j) {
			if(!*p) {
				wcleol();
				if(Eolm) {
					*W_OPEN = EOLATTR;
					wputc(EOLCHAR); }
				break; }
			wputc(*p++); }
		*W_OPEN = NORMAL;
		// Update the information window
		w_gotoxy(0, i, Iwin);
		if(Markline == -1)
			*Iwin = INDATTR;
		else if(k == Markline)
			*Iwin = ANKATTR;
		else
			*Iwin = ((k >= l) && (k <= h)) ? SELATTR : INDATTR;
		if(j = peek(Seg, Tline+i))
			w_printf(Iwin, "%2u", j);
		else
			w_cleol(Iwin); }

	// Process user input
	if(Markline == -1)
		strcpy(Buffer, "[NEW SECTION]");
	else if(Marker)
		sprintf(Buffer, "Section-%u: %u-%u%s", Marker, l, h, (Marker == Mlast) ? " [LAST]" : "");
	else
		sprintf(Buffer, "Clear section: %u-%u", l, h);

	status("Line:%5u of %-7uCols:%3u-%-5u%s", Cline+1, Maxline, Horz+1, Horz+WIDTH, Buffer);
nostat:
	for(;;) switch(wgetc()) {
	default:
		status("1:Mark 2:%s 3:%s 4:Undo 5:Goto 6:Find 7:Next 8:Eol 10:Save ESC:Quit",
			Marker ? "Unset" : "Last",
			(Markline == -1) ? "Pickup" : "EndSec");
		continue;
	case 0x1B:		// Exit with no save
		if(!yn("Exit and LOSE CHANGES (Y/N)?"))
			continue;
		wclose();
		wclose();
		wclose();
		fclose(fp);
		return;
	case _K10:		// Save and exit
		if(!yn("Exit and SAVE output files (Y/N)?"))
			continue;
		wclose();
		wclose();
		wclose();
		fpo = 0;
		j = getmark();		// Highest section number
		if(Reverse) {		// Output sections in reverse order
			while(--j)
				write_section(j, Pfile); }
		else {				// Output sections in forward order
			for(i=1; i < j; ++i)
				write_section(i, Pfile); }
		oclose();
		if(Ofile) {
			write_section(0, Ofile);
			oclose(); }
		fclose(fp);
		return;
	case _KRA: ++Horz;		goto top;
	case _KLA: --Horz;		goto top;
	case _CRA: Horz += 20;	goto top;
	case _CLA: Horz -= 20;	goto top;
	case _KHO: Horz = 0;	goto top;
	case _KEN:
		goto_line(Cline);
		if((i = readline()) != -1) {
			Horz = (i > WIDTH) ? i-WIDTH : 0; }
		goto top;
	case _KUA:
		if(Cline)
			--Cline;
		goto top;
	case _KDA :
		++Cline;
		goto top;
	case _KPU:
		if(!Tline) {
			Cline = 0;
			goto top; }
		i = Cline - Tline;
		Cline = (Tline = (Tline < HEIGHT) ? 0 : (Tline - HEIGHT)) + i;
		goto top;
	case _KPD:
		i = Cline - Tline;
		Cline = (Tline += HEIGHT) + i;
		goto top;
	case _CHO:
	case _CPU:
		Cline = 0;
		goto top;
	case _CEN :
	case _CPD :
		Cline = Maxline;
		goto top;
	case _K1 :		// Start / expand a block
		if(Markline == -1) {
			poke(Seg, Markline = Cline, Marker = Mlast = getmark());
			goto top; }
		if((i = Markline) > (j = Cline)) {
			i = Cline;
			j = Markline; }
		do {
			poke(Seg, i, Marker); }
		while(++i < j);
		poke(Seg, Markline = Cline, Marker);
		goto top;
	case _K2 :		// Remove a line
		poke(Seg, Markline = Cline, Marker = Marker ? 0 : Mlast);
		goto top;
	case _K3 :		// End section
		if(Markline == -1) {
			Marker = peek(Seg, Markline = Cline);
			goto top; }
		Markline = -1;
		goto top;
	case _K4 :		// Undo
		i = 0;
		do {
			poke(Seg, i, peek(Seg1, i)); }
		while(++i < Maxline);
		goto top;
	case _K5:		// Goto line
		status("Line? ");
		*Temp = 0;
		if(sinput(Temp, 0x85) == '\n') {
			Cline = atoi(Temp)-1;
//			center(HEIGHT/2); }
}
		goto top;
	case _K6:		// Find
		status("Find? ");
		if(sinput(Input, 65) != '\n')
			goto top;
		goto_line(i = Cline);
find:	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
			while(*Ptr) {
				if(strbeg(Ptr, Input)) {
					Cline = Fline = i;
					center(5);
					goto top; }
				++Ptr; }
			++i; }
		status("Not found!");
		Fline = 0;
		goto nostat;
	case _K7:		// Find next
		goto_line(i = Fline + 1);
		goto find;
	case _K8 :		// End of line markers
		Eolm = Eolm ? 0 : 255;
		goto top;
	case _K9:
		dump();
	}
}

dump()
{
	FILE *fp;
	unsigned i;
	fp = fopen("R:XX", "wvq");
	for(i=0; i < LISIZE; ++i)
		fprintf(fp, "%5u %04x:%04x\n", i, Lindex[i][1], Lindex[i][0]);
	fclose(fp);
}
