;
; RAMfile... This set of functions allows you to establish a
; data file in ram, which can be written to and read back.
;
DGROUP	GROUP	_DATA	; Set up data group
;
_DATA	segment	word public 'DATA'
;
BASE	DW		0				; Base segment
W_SEG	DW		0				; Write Segment offset
W_OFF	DW		0				; Write Memory offset
R_SEG	DW		0				; Read segment offset
R_OFF	DW		0				; Read memory offset
_DATA ENDS
;
_TEXT	segment byte public 'CODE'
		assume	cs:_TEXT,ds:DGROUP
		public	_rinit, _rreset, _rwrite, _rread
;
; Initialize the RAMfile subsystem
;
_rinit:	MOV		BX,-1			; Assume MAX memory
		MOV		AH,48h			; Request allocate memory
		INT		21h				; Ask DOS - get available size
		MOV		AH,48h			; Try again with right size
		INT		21h				; Ask DOS
rinit1:	MOV		DGROUP:BASE,AX	; Save segment
;
; Reset the RAMfile
;
_rreset:XOR		AX,AX			; Get ZERO
		MOV		DGROUP:W_SEG,AX	; Reset write segment
		MOV		DGROUP:W_OFF,AX	; Reset write offset
		MOV		DGROUP:R_SEG,AX ; Reset read segment
		MOV		DGROUP:R_OFF,AX	; Reset read offset
		RET
;
; Write data to the RAMfile
;
_rwrite:MOV		BX,SP			; Address parms
		MOV		CX,2[BX]		; Save char
		MOV		AX,DGROUP:BASE		; Get data segment
		ADD		AX,DGROUP:W_SEG	; Offset to segment
		MOV		BX,DGROUP:W_OFF	; Include offset
		PUSH	ES				; Save EXTRA segment
		MOV		ES,AX			; Set up segment register
		MOV		ES:[BX],CL		; Save character
		POP		ES				; Restore EXTRA segment
		INC		BX				; Advance count
		CMP		BX,16			; Past segment
		JB		rwr1			; No, its OK
		INC		DGROUP:W_SEG	; Advance segment
		XOR		BX,BX			; Reset to zero
rwr1:	MOV		DGROUP:W_OFF,BX	; Save
		RET
;
; Read data from the RAMfile
;
_rread:	MOV		BX,DGROUP:R_OFF	; Get offset
		MOV		AX,DGROUP:R_SEG	; Get read segment
		CMP		AX,DGROUP:W_SEG	; At write segment
		JB		rrd1			; Ok to read
		JNZ		rrd3			; Over, don't read
		CMP		BX,DGROUP:W_OFF	; Test offset
		JAE		rrd3			; Over, report error
rrd1:	MOV		AX,DGROUP:BASE	; Get data seg
		ADD		AX,DGROUP:R_SEG	; Offset to segment
		PUSH	ES				; Save EXTRA segment
		MOV		ES,AX			; Set it up
		MOV		AL,ES:[BX]		; Get data
		POP		ES				; Restore EXTRA segment
		INC		BX				; Advance offset
		CMP		BX,16			; Are we over?
		JB		rrd2			; No, its OK
		INC		DGROUP:R_SEG	; Offset to sement
		XOR		BX,BX			; Reset to zero
rrd2:	MOV		DGROUP:R_OFF,BX	; Write new offset
		XOR		AH,AH			; Clear high byte
		RET
rrd3:	MOV		AX,-1			; Report error
		RET
;
_TEXT	ENDS
		END
