#include <stdio.h>
#include <file.h>

#define TAB_STOPS	250		/* maximum number of tab stops supported */

unsigned itabs[TAB_STOPS], otabs[TAB_STOPS];

char
	Fill = -1,
	Space,
	Trail,
	*ptr;

static char help[] = { "\n\
Use:	RETAB	[options] filename [>output_file]\n\n\
opts:	-F		= disable Filling with spaces\n\
	I=n[,n,...]	= specify Input  tab stops (8,16,...)\n\
	O=n[,n,...	= specify Output tab stops (8,16,...)\n\
	-S		= convert Spaces->tabs where possible\n\
	-T		= remove Trailing spaces/tabs\n\
\n?COPY.TXT 1988-2005 Dave Dunfield\n -- see COPY.TXT --.\n" };

main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned i, j, k, l;
	FILE *fp;
	static char flag = -1, flag1 = 0;

	IOB_size = 8192;
	stdout = setbuf(stdout, 8192);

/* Install default tabs at 8 space intervals */
	for(i=j=0; i < TAB_STOPS; ++i)
		itabs[i] = otabs[i] = (j += 8);

/* parse the options and parameters */
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((tolower(*ptr++) << 8) | tolower(*ptr++)) {
			case '-f':		/* disable fill */
				Fill = 0;
				goto parm;
			case '-s':		/* enable space processing */
				Space = -1;
				goto parm;
			case '-t' :		/* enable trailing cleanup */
				Trail = -1;
				goto parm;
			case 'i=':		/* specify input tabs */
				j = 0;
				do
					itabs[j++] = k = l = get_dec();
				while(*ptr++ == ',');
				if(j > 1)
					k -= itabs[j-2];
				while(j < (sizeof(itabs)/2))
					itabs[j++] = l += k;
				goto parm;
			case 'o=':		/* specify output tabs */
				j = 0;
				do
					otabs[j++] = k = l = get_dec();
				while(*ptr++ == ',');
				if(j > 1)
					k -= otabs[j-2];
				while(j < (sizeof(otabs)/2))
					otabs[j++] = l += k;
			parm:
				flag1 = -1;
				break;
			default:
				flag = flag1 = 0;
				if(fp = fopen(argv[i], "r")) {
					do_convert(fp);
					fclose(fp); }
				else {
					fputs("RETAB: Cannot open: '", stderr);
					fputs(argv[i], stderr);
					fputs("'\n", stderr); } } }
	fflush(stdout);

	if(flag1)
		fputs("RETAB: Trailing options have no effect!!!\n", stderr);

	if(flag)
		fputs(help, stderr);
}

/* get a decimal number from the input line */
get_dec()
{
	register unsigned value;

	value = 0;
	if(isdigit(*ptr)) {				/* decimal number */
		while(isdigit(*ptr))
			value = (value * 10) + *ptr++ - '0'; }
	else {
		fputs("RETAB: Invalid number\n", stderr);
		exit(-1); }

	return(value);
}

/* do the tab conversion */
do_convert(fp)
	FILE *fp;
{
	unsigned ip, op, i, scount;
	register char chr;

	ip = op = scount = 0;

	while((chr = getc(fp)) != -1) {				/* read entire file */
		if(chr == 0x09) {						/* found a tab */
			ip += scount;						/* offset for any spaces */
			for(i=0; ip >= itabs[i]; ++i);		/* next input tab position */
			ip = itabs[i];
			scount = 0; }
		else if((chr == ' ') && Space) 			/* convert spaces */
			++scount;
		else {									/* std character */
/*
 * if more than 1 space is encountered, or a single space
 * is adjacent to a one or more tabs, convert it to tabs.
 */
			if((op < ip) || (scount > 1)) {
				ip += scount;
				scount = 0; }

/*
 * If character is newline, we have spaces/tabs at end of the line
 */
			if((chr == '\n') && Trail) {
				putc('\n', stdout);
				ip = op = scount = 0;
				continue; }

/*
 * if the output pointer lags behind the input pointer
 * we have received tabs or multiple spaces. Generate
 * tabs in the output file to restore the position.
 */
			if(op < ip) {			/* we have whitespace to fill in */
				for(i=0; op >= otabs[i]; ++i);	/* next output tab position */
				while(otabs[i] <= ip) {
					putc(0x09, stdout);
					op = otabs[i++]; }
/*
 * Input pointer is not on an output tab stop, fill with
 * spaces as nessary, to restore the correct position.
 */
				if(Fill) while(op < ip) {
					putc(' ', stdout);
					++op; }
				else
					op = ip; }
			++ip;
/*
 * Single space received, copy to output file
 */
			if(scount) {
				putc(' ', stdout);
				++op;
				++ip;
				scount = 0; }
/*
 * Copy character into output file
 */
			putc(chr, stdout);
			++op;
			if(chr == '\n')
				ip = op = 0; } }
}
