//#define	DEBUG
#include <stdio.h>

unsigned
	Line,					// Line number
	atop,					// Top of arguments
	ntop,					// Top of name list
	itop,					// Item top
	ptop;					// Top of string pool

unsigned char
	Debug,					// Debug mode
	*args[10],				// Command line arguments
	*names[100],			// Substitute names
	*strings[100],			// Substitute strings
	*items[100],			// Items
	*isub[100],				// Substitution strings
	*ptr,					// General pointer
	Verbose = 15,			// Verbose mode
	aflag[10],				// Arguments used flags
	file[65],				// Filename
	buffer[200],
	temp[200],
	temp1[200],
	temp2[200],
	Tempfile[200],			// Temporary file prefix
	pool[32768];			// String pool

FILE
	*fp,
	*fpi,
	*fpo;

/*
 * Report an error and terminate
 */
register error(unsigned args)
{
	unsigned char buffer[200];
	_format_(nargs() * 2 + &args, buffer);
	printf("%u: %s\n", Line, buffer);
	exit(-1);
}

/*
 * Add a string to the string-pool
 */
unsigned char *add_pool(unsigned char *p)
{
	unsigned char *h;
	h = &pool[ptop];
	do {
		if(ptop >= sizeof(pool))
			error("Out of memory");
		pool[ptop++] = *p; }
	while(*p++);
	return h;
}

/*
 * Skip ahead to non-blank
 */
int skip()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

/*
 * Parse string without spaces & convert to upper
 */
int parse(unsigned char *dest, unsigned char term)
{
	unsigned char c;
	while((*ptr != term) && *ptr) {
		if(isspace(c = *ptr++))
			continue;
		*dest++ = toupper(c); }
	*dest = 0;
	return *ptr;
}

/*
 * Process a file
 */
process_file()
{
	unsigned i, j;
	unsigned char *p, *p1, *p2, *p3, c, f;
	unsigned char name[50];

	if(!*file)
		goto skipfile;
	p = ptr;

	fpi = fopen(file, "rvq");
	fpo = fopen(Tempfile, "wvq");
	f = 0;
	while(fgets(p1 = ptr = temp1, sizeof(temp1)-1, fpi)) {
		parse(temp2, 0);
		for(i=0; i < itop; ++i) {
			if(strbeg(temp2, p2 = items[i])) {		// We have a match
				ptr = temp1;
				while(*p2) {
					while(isspace(*ptr))
						++ptr;
					if(toupper(*ptr++) != *p2++)
						error("Mismatch"); }
				p2 = temp2;
				while(p1 < ptr)
					*p2++ = *p1++;
				while(isspace(*ptr))
					*p2++ = *ptr++;
				p1 = isub[i];
				while(c = *p1++) {
					if(c == '{') {
						p3 = name;
						while((c = *p1++) != '}') {
							if(!c) error("Expected '}'");
							*p3++ = toupper(c); }
						*p3 = 0;
						for(j=0; j < ntop; ++j) {
							if(!strcmp(names[j], name))
								goto ok1; }
						error("Not found: %s", name);
				ok1:	p3 = strings[j];
						while(c = *p3++)
							*p2++ = c;
						continue; }
					*p2++ = c; }
				*p2 = 0;
				if(strcmp(temp1, temp2)) {
					if((Verbose & 0xF0) && !f) {
						printf("[%s]\n", file);
						putc('<', stdout); fputs(temp1, stdout); putc('\n', stdout);
						putc('>', stdout); fputs(temp2, stdout); putc('\n', stdout); }
					strcpy(temp1, temp2);
					f = 255; }
				break; } }
		fputs(temp1, fpo);
		putc('\n', fpo); }

	fclose(fpo);
	fclose(fpi);
	if(f && !Debug) {		// Changes occured
		if(Verbose)
			printf("Update: %s\n", file);
		fpi = fopen(Tempfile, "rvq");
		p1 = p2 = file;
#ifdef DEBUG
		while(*p1) switch(*p1++) {
			case ':' :
			case '\\': p2 = p1; }
#endif
		fpo = fopen(p2, "wvq");
		while(fgets(temp1, sizeof(temp1)-1, fpi)) {
			fputs(temp1, fpo);
			putc('\n', fpo); }
		fclose(fpo);
		fclose(fpi); }

	if(itop)
		ptop = items[0];
	ptr = p;
skipfile:
	*file = itop = 0;
}

unsigned char help[] = { "\n\
Use:	SETSYS mode [arguments...] [options]\n\n\
opts:	/D	= Debug display - no updates\n\
	/Q	= Quiet: no informational messages\n\
	/V	= Verbose: extra informational messages\n\
	T=file	= specify Temporary file\n\
	S=file	= specify Selection file\n\
\n?COPY.TXT 2006 Dave Dunfield\n -- see COPY.TXT --.\n" };

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char *p, c, f, sf;

	// Determine location of default selection file
	strcpy(i = ptr = temp1, argv[0]);
	while(c = *ptr++) switch(c) {
		case '.' :
			i = ptr;
			continue;
		case '\\' :
			i = temp1; }
	strcpy(i, "DAT");

	// Determine default temporary file
	if(getenv("TEMP", ptr = Tempfile)) {
		while(*ptr) ++ptr;
		if(*(ptr-1) != '\\')
			*ptr++ = '\\'; }
	strcpy(ptr, "$SETSYS$.TMP");

	// Parse command line arguments
	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++)<<8)|toupper(*ptr++)) {
		case '-D' :
		case '/D' : Debug = 255;
		case '-V' :
		case '/V' : Verbose = 255;					continue;
		case '-Q' :
		case '/Q' : Verbose = 0;					continue;
		case 'S=' : concat(temp1, ptr, ".DAT");		continue;
		case 'T=' : strcpy(Tempfile, ptr);			continue;
		default:
			args[atop++] = (ptr -= 2);
			if(!*temp)
				parse(temp, 0); } }

	if(!*temp)
		abort(help);

	fp = fopen(temp1, "rvq");
	c = f = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++Line;
		if(skip() == '?') {		// Conditional
			++ptr;
			sf = 0;
			while(skip()) {
				parse(temp1, ' ');
				if(!strcmp(temp, temp1)) {
					sf = f = 255;
					break; } }
			continue; }
		if(sf) switch(*ptr) {
		case '^' :				// File command
			for(i=1; i < atop; ++i)
				if(!aflag[i])
					error("Too many arguments");
			process_file();
			strcpy(file, ptr+1);
			c = 255;
		case ';' :
		case 0 :
			continue;
		default:
			if(!c) {			// No filename yet
				if(!parse(temp1, '='))
					error("Bad format - '=' expected");
				names[ntop] = add_pool(temp1);
				p = temp2;
				++ptr;
				while(c = *ptr++) {
					if((c == '~') && isdigit(*ptr)) {
						if((i = *ptr++ - '0') >= atop)
							error("More arguments required");
						aflag[i] = 255;
						strcpy(p, args[i]);
						while(*p) ++p;
						continue; }
					*p++ = c; }
				*p = 0;
				strings[ntop++] = add_pool(temp2);
				continue; }
			// Filename has occured - build list to handle files
			if(!parse(temp1, '{'))
				error("Bad format - '{' expected");
			items[itop] = add_pool(temp1);
			isub[itop++] = add_pool(ptr);
	}	}
	if(!f)
		error("Not found: '%s'", temp);
	process_file();
	fclose(fp);
	delete(Tempfile);
}
