#include <stdio.h>
#include <file.h>

unsigned
	block_size = 50,		// Maximum block size
	out_count = 0;			// Current output count position

char
	Text,					// Text mode flag
	Combine,				// Recombine file
	Delete,					// Delete temps after recombine
	*infile,				// Input file
	*outname = "#",			// Output filename pointer
	outfile[65];			// Output filename

char help[] = { "\n\
Use:	SPLIT	<filename> [options]\n\n\
Opts:	B=nn	= specify Block size (50K)\n\
	-C[D]	= reCombine file (otherwise split)\n\
	N=-#-$	= specify output file Names\n\
	S=nn	= specify output Sequence start\n\
	-T	= split file in Text mode\n\
	-V	= Verbose mode\n\
\n?COPY.TXT 1988-2010 Dave Dunfield\n -- see COPY.TXT --.\n" };

/*
 * Generate a new output file name
 */
FILE open_output(char *options)
{
	unsigned v, sp, f;
	char *ptr, *ptr1, s[10], c, flag;

	ptr1 = outfile;
	ptr = outname;
	sp = f = flag = 0;
	v = out_count++;
	do {
		switch(c = *ptr++) {
		case '-' :
			++f;
			continue;
		case '#' :	/* Numeric input */
			do
				s[sp++] = (v % 10) + '0';
			while(v /= 10);
			c = '0';
		dump_stack:
			if(f) {
				++f;
				while(f > sp) {
					*ptr1++ = c;
					--f; } }
			while(sp)
				*ptr1++ = s[--sp];
			flag = -1;
			continue;
		case '@' :	/* Alphabetic input */
			do
				s[sp++] = (v % 26) + 'A';
			while(v /= 26);
			c = 'A';
			goto dump_stack; }
		*ptr1++ = c; }
	while(c);
	if(!flag)
		abort("Output name must have variable portion ('#' or '@')");

	return fopen(outfile, options);
}

main(int argc, char *argv[])
{
	unsigned i, s, sl;
	char buffer[1024], *ptr;
	FILE *fpi, *fpo;

	IOB_size = 8192;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case 'B=' : block_size = atoi(ptr); continue;
		case 'N=' : outname = ptr;			continue;
		case 'S=' : out_count = atoi(ptr);	continue;
		case '-T' : Text = 255;				continue;
		case '-C' :
			Combine = 255;
			if(toupper(*ptr) == 'D')
				Delete = 255;
			continue; }
		if(infile)
			goto dohelp;
		infile = argv[i]; }

	if(!infile) {
	dohelp: abort(help); }

	if(Combine) {
		if(Text) {	// Recombine text file
			fpo = fopen(argv[1], "wvq");
			while(fpi = open_output("r")) {
				while(fgets(buffer, sizeof(buffer), fpi)) {
					fputs(buffer, fpo);
					putc('\n', fpo); }
				fclose(fpi); }
			fclose(fpo);
			if(Delete)
				delete(outfile);
			return; }
		// Recombine binary file
		fpo = fopen(argv[1], "wvqb");
		while(fpi = open_output("rb")) {
			while(s = fget(buffer, sizeof(buffer), fpi)) {
				fput(buffer, s, fpo);
				if(s != sizeof(buffer))
					break; }
			fclose(fpi);
			if(Delete)
				delete(outfile); }
		fclose(fpo);
		return; }

	if(Text) {
		if(block_size > 63)
			abort("Block size in text mode must be < 64\n");

		block_size *= 1024;
		fpi = fopen(argv[1], "rvq");
		fpo = open_output("wvq");

		s = 0;
		while(fgets(buffer, sizeof(buffer), fpi)) {
			s += (sl = strlen(buffer)+2);
			if(s > block_size) {
				fclose(fpo);
				fpo = open_output("wvq");
				s = sl; }
			fputs(buffer, fpo);
			putc('\n', fpo); }
		fclose(fpo);
		fclose(fpi);
		return; }

	fpi = fopen(argv[1], "rvqb");
	for(;;) {
		fpo = open_output("wvqb");
		for(i=0; i < block_size; ++i) {
			if(s = fget(buffer, sizeof(buffer), fpi))
				fput(buffer, s, fpo);
			if(s != sizeof(buffer)) {
				fclose(fpo);
				fclose(fpi);
				return; } }
		fclose(fpo); }

}
