/*
 * Program to display a file assuming tab stops are at 4 character
 * Intervals. By redirecting the output from this program to the
 * printer, you may properly print the MICRO-C listings.
 *
 * In MICRO-C, the operation "a && b" is defined as returning zero
 * without evaluating "b" if "a" evaluates to zero, otherwise "b"
 * is evaluated and returned.
 *
 * The statement "j = (chr != '\n') && j+1" shows how && (or ||) may
 * be used to create a very efficent conditional expression in MICRO-C.
 * NOTE that this is not "standard", and is NOT PORTABLE. The more
 * conventional equivalent is: "j = (chr != '\n') ? j+1 : 0"
 *
 * ?COPY.TXT 1988-2005 Dave Dunfield
 */

#include <stdio.h>
#define TAB_SIZE	8		/* tab spacing */

unsigned
	Tab = 4;

#include "R:\\Help.h"

void Pc(unsigned char c)	{ putc(c, stdout); }
main(int argc, char *argv[])
{
	unsigned i, j, c;
	FILE *fp;
	unsigned char *p;

	if(argc < 2) {
		p = Help;
		while(c = *p++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }
/*ChtTxt R:\Help.h
TYPE with 4-space tabs

use:	TYPE4 [-tabsize] filename ...

tabsize must be >0 and defaults to 4.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
	for(i=1; i < argc; ++i) {
		if(*(p = argv[i]) == '-') {
			if(!(Tab = atoi(p+1)))
				abort("\nTabSize must be !0\n");
			continue; }
		fp = fopen(p, "rvq");
		j = 0;
		while((c = getc(fp)) != EOF) {
			if(c == '\t') {			/* tab */
				do
					putc(' ', stdout);
				while(++j % Tab); }
			else {						// not a tab
				j = (c != '\n') && j+1;	// see opening comment
				putc(c, stdout); } }
		fclose(fp); }
}
