#include <stdio.h>
#include <file.h>

#define BUFFER_SIZE 150
#define MAX_TITLES 200
#define MAX_SECTIONS 8
#define MAX_FILES 15

char
	buffer[BUFFER_SIZE],
	title[80],
	text[BUFFER_SIZE],
	format_out[BUFFER_SIZE],
	depth[MAX_TITLES],
	tbuff[MAX_TITLES*50],
	*titptr,
	*fmtptr,
	section[MAX_SECTIONS],
	*files[MAX_FILES],
	vars[10][50],
	varset[10],
	Temp[65];

char
	term = 0,
	retype = 255,
	wrnflg = 0,
	n_files = 0,
	cur_file = 0,
	verb = -1,
	condoc = 0,
	jstflg = -1,
	fmtflg = -1,
	dblflg = 0,
	undrscr=0;

unsigned
	pages[MAX_TITLES],
	ptr,
	txtptr = 0,
	tnum = 0,
	inline = 0,
	flstack[5],
	margin=0,
	indent=0,
	page=0,
	line=0,
	width=72,
	pagsiz=59,
	isize=3,
	tlimit = 2,
	tabsiz = 4,
	fpsptr = 0;

FILE
	*fp,
	*fp1,
	*fpstack[5];

/*
 * Open a filename with the appropriate extension &
 * report an error if not possible
 */
FILE *open_file(filename, extension, options, prompt)
	char *filename, *extension, *options, *prompt;
{
	char buffer[50], *ptr, *dot;
	FILE *fp;

	dot = 0;

	for(ptr = buffer; *ptr = *filename; ++ptr) {	/* Copy filename */
		if(*filename == '.')
			dot = filename;
		++filename; }

	if(!dot) {									/* No extension supplied */
		*ptr++ = '.';
		do
			*ptr++ = *extension;
		while(*extension++); }
	else
		*dot = 0;

	if(!(fp = fopen(buffer, options))) {
		fprintf(stderr,"Unable to access: '%s'\n", buffer);
		exit(-1); }

	if(prompt && verb)
		fprintf(stderr,"%s: %s\n", prompt, buffer);

	return fp;
}

/*
 * Main program
 */
main(argc, argv)
	unsigned int argc;
	char *argv[];
{
	unsigned i, j, tmp, sect;
	char chr;

	for(i=1; i<argc; ++i) {			/* parse for parameters */
		chr = toupper(argv[i][1]);
		switch(argv[i][0]) {
		case '+' : switch(chr) {
			case 'T' : term = 255;		continue;		// Redirect to term
			case 'C' : condoc = 255;	continue;		// Concatinate
			default: bad_operand(); }
		case '-' : switch(chr) {
			case 'R' : retype = 0;		continue;		// Do not re-order
			case 'W' : wrnflg = 255;	continue;		// Inhibit warnings
			case 'V' : verb = 0;		continue;		// Inhibit progress
			default: bad_operand(); }
		case '@' :			// Variabke assignment
			tmp = 0; ptr=1;
			if(isdigit(chr))
				tmp = argv[i][ptr++] - '0';
			strcpy(vars[tmp], &argv[i][ptr]);
			varset[tmp] = -1;
			continue; }
		files[n_files++] = argv[i]; }

	if(!n_files) {
		fputs("\nUse: typeset <docfile*> [+c +t -r -v -w @n<text>]\n\n?COPY.TXT 1985-2005 Dave Dunfield\n -- see COPY.TXT --.\n", stderr);
		exit(-1); }

	IOB_size = 2048;

	fp = open_file(files[0],"DOC","r","Processing");

	if(retype) {
		if(!getenv("TEMP", Temp))
			abort("TEMP environment variable not set");
		for(i=0; Temp[i]; ++i);
		while(i && isspace(Temp[i-1])) --i;
		switch(Temp[i-1]) {
		default: Temp[i++] = '\\';
		case ':' :
		case '\\' : }
		strcpy(Temp+i, "TYPESET.$$$");
		fp1 = fopen(Temp, "wvq"); }
	else if(term) 
		fp1 = setbuf(stdout, 2048);
	else
		fp1 = open_file(files[0],"TXT","w",0);

	strcpy(title,files[0]);			/* default title */

	titptr = tbuff;

	while(get_line()) {
		if((chr=buffer[ptr]) == '.') {		/* control code */
			++ptr;
			switch(toupper(chr=buffer[ptr++])) {
				case 'P' :			/* skip page */
					flush_text(0);
					line = 9999;
					break;
				case 'S' :			/* space blank lines */
					flush_text(0);
					for(i=get_dec(1); i>0; --i)
						write_line("");
					break;
				case 'Q' :			/* Quiet page (no title) */
					++page;
				case 'E' :			/* extra page */
					flush_text(0);
					putc('\f',fp1);
					line = 0;
					break;
				case '=' :			/* set option value */
					switch(toupper(chr=buffer[ptr++])) {
						case 'P' :		/* set page number */
							page=get_dec(1)-1;
							break;
						case 'I' :		/* set indent value */
							isize = get_dec(isize);
							break;
						case 'M' :		/* set margin */
							margin = get_dec(margin);
							break;
						case 'W' :		/* set page width */
							width=get_dec(width);
							break;
						case 'L' :		/* set page length */
							pagsiz=get_dec(pagsiz);
							break;
						case 'H' :		/* set horizontal tabs */
							tabsiz = get_dec(tabsiz);
							break;
						case 'T' :		/* set table of contents levels */
							tlimit = get_dec(tlimit);
							break;
						case '>' :		/* set current section */
							j=0;
							do {
								section[j] = get_dec(section[j]);
								++j; }
							while(buffer[ptr++] == '.');
							*titptr++ = 0x80 + j;
							for(i=0; i < j; ++i)
								*titptr++ = section[i];
							break;
						default:
							fprintf(stderr,"*** Invalid SET option: '.=%c', Line=%u\n",chr,inline);
							break; }
					break;
				case 'T' :			/* set title. */
					skip_blank();
					strcpy(title,&buffer[ptr]);
					break;
				case 'F' :			/* format enable */
					if(!set_switch(&fmtflg)) flush_text(0);
					break;
				case 'J' :			/* justification */
					set_switch(&jstflg);
					break;
				case 'D' :			/* double spaceing */
					set_switch(&dblflg);
					break;
				case 'I' :			/* indent page */
					flush_text(0);
					tmp = get_dec(indent);
					skip_blank();
					if(buffer[ptr])
						write_text(&buffer[ptr], tmp);
					else
						indent = tmp;
					break;
				case 'C' :			/* center */
					flush_text(0);
					tmp = margin;
					skip_blank();
					margin += (width-strlen(&buffer[ptr]))/2;
					write_line(&buffer[ptr]);
					margin = tmp;
					break;
				case '_' :			/* underline single line */
					flush_text(0);
					j = undrscr;
					undrscr = -1;
					write_line(&buffer[ptr]);
					undrscr = j;
					break;
				case 'U' :			/* permanent underscore */
					set_switch(&undrscr);
					break;
				case '!' :			/* Delete variable */
				case '$' :			/* Conditional assignment */
				case '@' :			/* Assign variable */
					if(!isdigit(buffer[ptr])) {
						fprintf(stderr, "***: Invalid variable name in line %u\n", inline);
						break; }
					tmp = buffer[ptr++] - '0';
					switch(buffer[ptr-2]) {
						case '!' :	/* Delete variable */
							varset[tmp] = 0;
						case '$' :	/* Conditional assignment */
							if(varset[tmp])
								break;
						default :	/* Standard assignment */
							strcpy(vars[tmp], &buffer[ptr]);
							varset[tmp] = -1; }
					break;
				case '?' :			/* conditional */
				nextquest:
					i = ptr;
					while((chr = buffer[ptr]) && (chr != '='))
						++ptr;
					if(chr) {
						buffer[ptr++] = 0;
						do {
							j = ptr;
							while((chr = buffer[ptr]) && (chr != ','))
								++ptr;
							buffer[ptr++] = 0;
							tmp = strcmp(&buffer[i], &buffer[j]); }
						while(chr && tmp);
						if(tmp) while(get_line()) {
							if((buffer[0] == '.') && (buffer[1] == '?')) {
								ptr = 2;
								goto nextquest; } } }
					break;
				case '.' :			/* Include a file */
					flush_text(0);
					flstack[fpsptr] = inline;
					fpstack[fpsptr++] = fp;
					fp = open_file(&buffer[ptr],"DOC","r","Including");
					inline = 0;
					break;
				default :
					fprintf(stderr,"*** Invalid command: '.%c', Line=%u\n",chr,inline);
				case '*' :			/* source line comment */
					break; } }
		else if(chr=='>') {				/* new sub section */
			flush_text(0);
			sect = 0;
			while(buffer[ptr] == '>') {
				++ptr;
				++sect; }
			for(i=sect; i<MAX_SECTIONS; ++i)
				section[i] = 0;
			++section[sect-1];
			fmtptr = format_out;
			for(i=0; i<sect; ++i) {
				print_number(section[i]);
				*fmtptr++ = '.'; }
			if(i != 1) --fmtptr;
			*fmtptr++ = ' ';
			skip_blank();
			depth[tnum] = sect;
			pages[tnum++] = page + (pagsiz < (line + 1));
			do
				*titptr++ = *fmtptr++ = chr = buffer[ptr++];
			while(chr);
			indent = sect * isize;
			write_text(format_out, indent - isize);
			flush_text(0); }
		else {
			skip_blank();
			if(!buffer[ptr]) {					/* null line */
				flush_text(0);
				write_line(""); }
			else if(isblank(buffer[0])) {		/* for indented lines */
					flush_text(0);
					write_text(buffer, indent + isize); }
			else 
				write_text(buffer,indent); } }
	flush_text(0);

	if(retype) {
		fclose(fp1);
		fp = fopen(Temp, "rvq");
		if(term) 
			fp1 = setbuf(stdout, 2048);
		else
			fp1 = open_file(files[0],"TXT","w",0);
		while((i = getc(fp)) != EOF) {
			if(i == '\f')
				break;
			putc(i, fp1); } }

/* now print table of contents */
	if(tnum && tlimit) {			/* were any sub-sections used */
		titptr = tbuff;
		fputs("\f\n\n\n",fp1);
		line = 8;
		tmp = margin;
		margin += (width - strlen(title))/2;
		write_line(title);
		putc('\n',fp1);
		margin = tmp + (width - 17)/2;
		write_line("TABLE OF CONTENTS");
		toc_page(margin = tmp);
		for(i = 0; i < MAX_SECTIONS; ++i)
			section[i] = 0;
		for(ptr = 0; ptr < tnum; ++ptr) {
			if(0 > *titptr) {			/* section change */
				j = *titptr++ & 0x7f;
				for(i = 0; i < j; ++i)
					section[i] = *titptr++; }
			sect = depth[ptr];
			for(i = sect; i < MAX_SECTIONS; ++i)
				section[i] = 0;
			++section[sect-1];
			fmtptr = format_out;
			for(i = 0; i < sect; ++i) {
				print_number(section[i]);
				*fmtptr++ = '.'; }
			if(i != 1) --fmtptr;
			*fmtptr++ = ' ';
			do
				*fmtptr++ = chr = *titptr++;
			while(chr);

			if(tlimit >= sect) {			/* we print this one */
				if(sect == 1) {				/* main section, skip line */
					if(pagsiz > ++line)
						putc('\n', fp1); }
				if(pagsiz <= ++line) {		/* page skip required */
					putc('\f',fp1);
					putc('\n', fp1);
					for(i=1; i<tmp; ++i) putc(' ',fp1);
					for(i=0; title[i]; ++i) putc(title[i],fp1);
					i += 17;
					while(width > i++) putc(' ',fp1);
					fputs("Table of Contents",fp1);
					toc_page(tmp);
					line = 4; }
				margin = isize * (sect-1);
				for(i=0; i<tmp; ++i)
					putc(' ',fp1);
				for(i = 0; i < margin; ++i)
					putc(' ',fp1);
				fmtptr = format_out;
				while(chr = *fmtptr++) {
					++i;
					putc(chr, fp1); }
				while(i < (width - 4)) {
					++i;
					putc(' ', fp1); }
				fprintf(fp1,"%4u\n",pages[ptr]);
				if(sect == 1) {
					if(pagsiz > ++line)
						putc('\n', fp1); } } } }

	if(retype) {
		putc('\f', fp1);
		while((i = getc(fp)) != EOF)
			putc(i, fp1);
		fclose(fp);
		delete(Temp); }
	fclose(fp1);

}

/* write line to output file, page eject if necessary */
write_line(strng)
	char strng[];
{
	unsigned i, outpos;
	register char chr, *ptr;

	if(pagsiz < ++line) {
		if(line != 10000) warn("Page skip forced");
		putc('\f',fp1);
		for(i=1; i<margin; ++i) putc(' ',fp1);
		for(i=0; title[i]; ++i) putc(title[i],fp1);
		i += 7;
		while(width > i++) putc(' ',fp1);
		fprintf(fp1,"Page: %u\n\n\n",++page);
		line = 3; }

/* Display the line text */
	for(ptr = strng; *ptr == ' '; ++ptr);
	if(*ptr) {
		for(i=1; i < margin; ++i)	/* space over margin */
			putc(' ',fp1);
		for(i=outpos = 0; chr = strng[i]; ++i) {
			if(chr == '\t') {		/* tab char */
				do
					putc(' ', fp1);
				while(++outpos % tabsiz); }
			else {					/* anything else */
				putc(chr, fp1);
				++outpos; } }

	/* underline non_blanks if enabled */
		if(undrscr) {
			putc('\r', fp1);
			for(i=1; i<margin; ++i)	/* space over margin */
				putc(' ',fp1);
			for(i=outpos=0; chr = strng[i]; ++i) {
				if(chr == '\t') {		/* tab char */
					do
						putc(' ', fp1);
					while(++outpos % tabsiz); }
				else
					putc((chr == ' ') ? ' ' : '_', fp1); } } }

	putc('\n',fp1);
	if(dblflg) {			/* double space if turned on */
		putc('\n',fp1);
		++line; }
}

/* skips to next non-blank in buffer */
skip_blank()
{
	register char chr;

	while(((chr=buffer[ptr]) == ' ') || (chr == 9))
		++ptr;
}

/* test for blank character (space, tab, end of line) */
isblank(chr)
	char chr;
{
	return((chr==' ') || (chr==9) || (chr==0));
}

/* get decimal value */
int get_dec(deflt)
	unsigned deflt;
{
	register unsigned value;
	register char chr;

	if((chr=buffer[ptr]) == '+') {
		++ptr;
		value = deflt + get_dec(isize); }
	else if(chr == '-') {
		++ptr;
		value = deflt - get_dec(isize); }
	else {
		value=0;
		if(isdigit(chr))		/* number is present */
			while(isdigit(buffer[ptr]))
				value=(value*10)+(buffer[ptr++]-'0');
		else
			value = deflt; }

	return((value < 50000) ? value : 0);
}

/* set/clear a switch */
int set_switch(flag)
	char *flag;
{
	if(buffer[ptr] == '+') {
		*flag = 0xff;
		return(1); }
	else if(buffer[ptr] == '-') {
		*flag = 0;
		return(0); }
	else {
		fprintf(stderr,"*** Bad switch: '%s', Line=%u\n",buffer);
		return(2); }
}

/* output text buffer to format line */
write_text(string, idnt)
	char string[];
	unsigned idnt;
{
	register unsigned i;
	register char chr;

	if(fmtflg) {		/* Formatting enabled */
		if(!txtptr)
			for(i=0; i < idnt; ++i)			/* insert indent */
				text[txtptr++] = ' ';
		ptr = 0;			/* point to start of input */
		for(;;) {
			while(((chr=string[ptr]) == ' ') || (chr == 9))	/* skip blanks */
				++ptr;
			if(chr) {
				for(i=ptr; !isblank(string[i]); ++i);
				if((txtptr + (i-ptr)) > width) {	/* line overflowed */
					flush_text(jstflg);				/* write output buffer */
					for(i = 0; i < indent; ++i)		/* Insert ident */
						text[txtptr++] = ' '; }
				while(!isblank(string[ptr]))		/* Copy in this word */
					text[txtptr++] = string[ptr++];
				text[txtptr++] = ' '; }		/* end off this word */
			else
				break; } }
	else				/* Formatting not enabled */
		write_line(string);
}

/* flush justification buffer */
flush_text(fmtflg)
	char fmtflg;
{
	if(txtptr) {		/* insure we have a line to output */
		text[--txtptr] = 0;
		if(fmtflg) {	/* formatting is requested */
			add_space(format_out, text, width-txtptr);
			strcpy(text, format_out); }
/*			expand_text(); */
		txtptr = 0;
		write_line(text); }
}

/* display invalid operand message */
bad_operand()
{
	fprintf(stderr,"*** Invalid operand\n");
	exit(-1);
}

/* display a warning message */
warn(string)
	char *string;
{
	if(!wrnflg)
		fprintf(stderr,"Warning - %s : Page=%u, Line=%u, Input=%u\n",string,page,line,inline);
}

/* display number in output file */
print_number(num)
	char num;
{
	if(num > 9)
		print_number(num / 10);
	*fmtptr++ = '0' + (num % 10);
}

/* display page title for table of contents */
toc_page(margin)
	unsigned margin;
{
	register unsigned i;

	fputs("\n\n",fp1);
	for(i=0; i < margin; ++i)
		putc(' ',fp1);
	for(i=0; i < width - 4; ++i)
		putc(' ',fp1);
	fputs("Page\n",fp1);
}

/*
 * Function to read a line from the input file without
 * placing a newline character at the end.
 */
char *my_fgets(dest, size, fp)
	char *dest;
	int size;
	FILE *fp;
{
	register int chr;
	register char *ptr, *ptr1;

	ptr = dest;
	while(size--) {
		if((chr = getc(fp)) < 0) {		/* end of file */
			if(ptr == dest)
				dest = 0;				/* no last line, indicate end */
			break; }
		if(chr == '@') {
			if(isdigit(chr = getc(fp))) {
				if(varset[chr - '0']) {
					ptr1 = vars[chr - '0'];
					while(*ptr1) {
						*ptr++ = *ptr1++;
						--size; }
					continue; } }
			if(chr != '@') {
				*ptr++ = '@';
				--size; } }
		if(chr == '\n')					/* end of line */
			break;
		*ptr++ = chr; }
	*ptr = 0;
	return dest;
}

/* get line from file (or next) */
get_line()
{
	if(my_fgets(buffer,BUFFER_SIZE,fp)) {
		++inline;
		ptr = 0;
		return -1; }
	else {			/* go to next file */
		fclose(fp);
		if(fpsptr) {
			flush_text(0);
			fp = fpstack[--fpsptr];
			inline = flstack[fpsptr];
			return get_line(); }
		if(n_files > ++cur_file) {
			if(condoc) {				/* concatinating documents */
				flush_text(0);
				line = 0;
				putc('\f',fp1); }
			fp = open_file(files[cur_file],"DOC","r","Processing");
			inline = 0;
			return get_line(); }
		else
			return 0; }
}

add_space(char *dest, char *buffer, int n)
{
	int i, j, c;
	int spaces[BUFFER_SIZE], scount[BUFFER_SIZE], stop;
	int insert[BUFFER_SIZE], itop;
	char priority[BUFFER_SIZE];

	stop = itop = 0;

	/* Skip leading spaces */
	i = 0;
	while(buffer[i] == ' ')
		++i;
	/* Build index of spaces */
	while(c = buffer[i]) {
		if(c == ' ') {
			j = 2;
			switch(buffer[i-1]) {
				case '.' :	j = 10;	goto setpri;
				case ',' :
				case ';' :
				case ':' :	j = 9;	goto setpri;
				case ')' :	j = 8;	goto setpri;
				case '>' :
				case ']' :	j = 6;	goto setpri;
				case '\'':
				case '"' :	j = 4;	goto setpri; }
			switch(buffer[i+1]) {
				case '(' :	j = 7; 	break;
				case '<' :
				case '[' :	j = 5;	break;
				case '\'':
				case '"' :	j = 3; }
		setpri:
			priority[stop] = j;
			scount[stop] = 2;
			spaces[stop++] = i; }
		++i; }

	/* Determine positions to insert spaces */
	while(n-- > 0) {
		j = -1;
		i = stop;
		c = 0;
		while(i) {
			if((priority[--i] > c) && scount[i]) {
				j = i;
				c = priority[i]; } }
		if(j == -1) {
			strcpy(dest, buffer + i);
			warn("Unable to justify");
			return; }

		insert[itop++] = spaces[j];
		
		--scount[j];
		priority[j] = (c > 1) ? 1 : 0; }

	/* Sort insert list */
	for(i=0; i < itop; ++i)
		for(j = i+1; j < itop; ++j)
			if(insert[i] > insert[j]) {
				c = insert[j];
				insert[j] = insert[i];
				insert[i] = c; }
	insert[itop] = -1;

	/* Copy over text & insert spaces */
	i = j = 0;
	while(c = buffer[i]) {
		*dest++ = c;
		while(insert[j] == i) {
			*dest++ = ' ';
			++j; }
		++i; }
}
