/*
 * Generate an older file using the newer file, and a diff of the
 * new file from the older one.
 */
#include <stdio.h>
#include <file.h>

#define	LINE_SIZE	200

char help[] = { "\n\
Use: undiff input_file diff_file (compare_file | >output_file)\n\n\
?COPY.TXT 1999-2005 Dave Dunfield.\n\
 -- see COPY.TXT --.\n" };

FILE *cfp = 0;
unsigned line = 0;
char cpass = -1;

main(int argc, char *argv[])
{
	FILE *ifp, *dfp;
	char difbuf[LINE_SIZE+2], buffer[LINE_SIZE+1], *ptr;
	unsigned off1, off2;
	static dline = 0;

	IOB_size = 8192;

	if(argc == 4)
		cfp = fopen(argv[3], "rvq");
	else if(argc != 3)
		abort(help);

	stdout = setbuf(stdout, 512);

	ifp = fopen(argv[1], "rvq");
	dfp = fopen(argv[2], "rvq");

new_line:
	fgets(difbuf, sizeof(difbuf)-1, dfp);
	++dline;

next_diff:
	if(!strbeg(ptr = difbuf, "*** ")) {
		if(!strbeg(difbuf, "###")) {
			fprintf(stderr, "Bad DIFF header at line %u\n", dline);
			exit(-1); }
		*difbuf = 0;
		goto new_line; }

	while(*ptr != '(') {
		if(!*ptr++) {
			fprintf(stderr, "Unable to find first offset at line %u\n", dline);
			exit(-1); } }
	++ptr;
	off1 = atoi(ptr)-1;
	while(*ptr != '(') {
		if(!*ptr++) {
			fprintf(stderr, "Unable to find second offset at line %u\n", dline);
			exit(-1); } }
	off2 = atoi(ptr+1);

	while(line < off1) {
		if(!fgets(buffer, sizeof(buffer)-1, ifp)) {
			fprintf(stderr,"EOF at line %u while looking for offset %u (dline=%u)\n",
				line, off1, dline);
			exit(-1); }
		++line;
		write_output(buffer); }

	for(;;) {
		*difbuf = 0;
		if(!fgets(difbuf, sizeof(difbuf)-1, dfp)) {
			fprintf(stderr," EOF on diff file at line %u\n", dline);
			exit(-1); }
		++dline;
		if(*difbuf == '<') {
			if(!fgets(buffer, sizeof(buffer)-1, ifp)) {
				fprintf(stderr,"EOF at line %u while comparing dline %u\n", line, dline);
				exit(-1); }
			++line;
			if(strcmp(difbuf+1, buffer)) {
				fprintf(stderr,"Line %u does not match dline %u\n", line, dline);
				fprintf(stderr,"<%s\n", difbuf+1);
				fprintf(stderr,">%s\n", buffer);
				exit(-1); }
			continue; }
		if(*difbuf == '>') {
			write_output(difbuf+1);
			continue; }
		break; }
	if(!isdigit(*difbuf))
		goto next_diff;

	ptr = difbuf;
	while(isdigit(*ptr)) ++ptr;
	if(strcmp(ptr, " differences.")) {
		fprintf(stderr,"Bad end record in DIFF file at %u\n", dline);
		exit(-1);  }

	while(fgets(buffer, sizeof(buffer)-1, ifp))
		write_output(buffer);

	fclose(dfp);
	fclose(ifp);
	if(cfp) {
		fclose(cfp);
		fputs(cpass ? "Files match exactly." : "File compare failed!", stdout);
		putc('\n', stdout); }
	fflush(stdout);
}

write_output(char *text)
{
	char buffer[LINE_SIZE+1];
	static char cflag = -1;

	if(cfp) {
		if(!fgets(buffer, sizeof(buffer)-1, cfp)) {
			fprintf(stderr, "EOF on compare file at line %u\n", line);
			exit(-1); }
		if(strcmp(text, buffer)) {
			if(cflag) {
				fprintf(stdout, "*** Line %u\n", line);
				cflag = cpass = 0; }
			fprintf(stdout,"<%s\n", text);
			fprintf(stdout,">%s\n", buffer);
			return; }
		cflag = -1;
		return; }
	fputs(text, stdout);
	putc('\n', stdout);
}
