#include <stdio.h>
#include <file.h>

#define	MAXEXC		100
#define	MAXDIR		50
#define	MAXMAT		10

unsigned
	Seg,			// External segment
	Stop,			// Top of external segment
	Spos,			// Position in external segment
	Ptop,			// Pool top
	Etop,			// Top of exclusion list
	Dtop,			// Top of directory list
	Mtop;			// Top of match list
FILE
	*fp,
	*fp1;
unsigned char
	*Ptr,			// General pointer
	*Ini,			// Default ini file
	*Elist[MAXEXC],	// Exclusiion list
	*Dlist[MAXDIR],	// Directory list
	*Mlist[MAXMAT],	// Match list
	Dskip,			// Display skipped files
	Dnotf,			// Display not-found files
	Dsync = 255,	// Display out-of-sync files
	Name[13],		// Name of file
	Buffer[256],	// General buffer
	Pool[32768];	// String pool

struct FENTRY {
	unsigned	Size[2],
	unsigned	Date,
	unsigned	Time,
	unsigned char Name[256]; } F1, F2, F3;

// Skip to non-blank in input stream
int skip()
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

// Add string(Ptr) to pool
unsigned char *addpool(void)
{
	unsigned char *p;
	p = Pool+Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			abort("Pool exhausted\n"); }
	while(Pool[Ptop++] = toupper(*Ptr++));
	return p;
}

// Add a byte to external segment
int addbyte(int c)
{
	poke(Seg, Stop++, c);
	if(!Stop)
		abort("Seg exhausted\n");
	return c;
}

// Write a directory entry to the external segment
void put_entry(struct FENTRY *p)
{
	unsigned i;
	for(i=0; i < 8; ++i)
		addbyte(*p++);
	while(addbyte(*p++));
}

// Retrieve a directory entry from the external segment
int get_entry(struct FENTRY *p)
{
	unsigned i;
	if(Spos < Stop) {
		for(i=0; i < 8; ++i)
			*p++ = peek(Seg, Spos++);
		while(*p++ = peek(Seg, Spos++));
		return 255; }
	return 0;
}

// Display a directory entry
void show_entry(struct FENTRY *f)
{
	unsigned t, d, j, k;
	unsigned char string[32];
	k = (j = ((t = f->Time) >> 11) & 0x1F) % 12;
	d = f->Date;
	ltoa(f->Size, string, 10);
	printf("%2u-%02u-%02u%3u:%02u%c%11s ", 
		d&0x1F, (d>>5)&0x0F, ((d>>9)+80)%100,
		(k)?k:12, (t>>5)&0x3F, (j>11)?'p':'a',
		string);
	fputs(f->Name, stdout);
	putc('\n', stdout);
}

// Remove trailing blanks from line
void trim(unsigned char *p)
{
	unsigned i;
	for(i=0; p[i]; ++i);
	while(i && isspace(p[i-1]))
		--i;
	p[i] = 0;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

// Check to see if f2 is a newer file than f1
int isnewer(struct FENTRY f1, struct FENTRY f2)
{
	if(f1.Date > f2.Date)				// File 1 older date
		return 0;
	if(f1.Date == f2.Date) {			// Same date
		if(f1.Time > f2.Time)			// File 1 older time
			return 0;
		if(f1.Time == f2.Time) {		// Same time
			if(longcmp(f1.Size, f2.Size)) {	// Same size!
				if(Dsync) {
					printf("***Same time, but sizes differ!\n");
					show_entry(f2);
					show_entry(f1); } }
			return 0; } }
	return 255;
}

// Determine if a string is a filespec pattern
int ispat(unsigned char *p)
{
	for(;;) switch(*p++) {
		case '*' :
		case '?' : return 255;
		case 0 : return 0; }
}

/*
 * Touch the file with encoded date
 */
touch(fp, time, date) asm
{
		MOV		DX,4[BP]	; Get date
		MOV		CX,6[BP]	; Get time
		MOV		BX,8[BP]	; Get file handle
		MOV		AX,5701h	; Set date & time function
		INT		21h			; Ask DOS
}

unsigned char Help[] = { "\n\
use: UPD [updfile] [pattern] [options]\n\n\
opts:	/N	- display Not-found files\n\
	/S	- display Skipped files\n\
	/W	- inhibit sync Warning\n\
\nDave Dunfield - "#__DATE__"\n" };

main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char uf;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++)<<8)|toupper(*Ptr++)) {
		case '-N' :
		case '/N' : Dnotf = 255;		continue;
		case '-S' :
		case '/S' : Dskip = 255;		continue;
		case '-W' :
		case '/W' : Dsync = 0;			continue;
		case '?' << 8:
		case '-?' :
		case '/?' : help: abort(Help); }
		if(ispat(Ptr -= 2)) {
			if(Mtop >= MAXMAT)
				abort("Too many match patterns");
			strupr(Mlist[Mtop++] = Ptr);
			continue; }
		if(Ini) goto help;
		Ini = Ptr; }

	Ptr = argv[i=j=0];
	for(;;) switch(Pool[i++] = *Ptr++) {
		case 0 : goto e1;
		case ':' :
		case '\\' :
			j = i; }
e1:	concat(Pool+j, Ini || "UPD", ".UPD");

	fp = fopen(Pool, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		trim(Ptr);
		switch(skip()) {
		case ';' :
		case 0 : continue;
		case '!' :
			++Ptr;
			skip();
			if(Etop >= MAXEXC)
				abort("Too many exclusions\n");
			Elist[Etop++] = addpool();
			continue; }
		if(Dtop >= MAXDIR)
			abort("Too many directories\n");
		Dlist[Dtop++] = addpool(); }
	fclose(fp);

	Seg = alloc_seg(4096);
	if(find_first("*.*", 0x3F, F1.Name, &F1.Size[1], &F1.Size[0], &i, &F1.Time, &F1.Date))
		abort("No files");
	do {
		if(i & (DIRECTORY|VOLUME))
			continue;
		put_entry(F1);
	} while !find_next(F1.Name, &F1.Size[1], &F1.Size[0], &i, &F1.Time, &F1.Date);

	while(get_entry(F1)) {
		if(Mtop) {
			for(i=0; i < Mtop; ++i) {
				if(fmatch(F1.Name, Mlist[i]))
					goto x1; }
skip:		if(Dskip) {
				putc('-', stdout);
				show_entry(F1); }
			continue; }
x1:		for(i=0; i < Etop; ++i) {
			if(fmatch(F1.Name, Elist[i]))
				goto skip; }
		memcpy(F3, F1, sizeof(F3));
		for(i=uf=0; i < Dtop; ++i) {
			if(!(Ptr = Dlist[i]))
				continue;
			concat(Buffer, Ptr, "\\", F1.Name);
			switch(find_first(Buffer, 0x3F, F2.Name, &F2.Size[1], &F2.Size[0], &j, &F2.Time, &F2.Date)) {
			case 3 :
				printf("?Path: ");
				fputs(Ptr, stdout);
				putc('\n', stdout);
				Dlist[i] = 0;
			default: continue;
				continue;
			case 0 : }
			uf |= 15;
			strcpy(F2.Name, Buffer);
			if(isnewer(F3, F2)) {
				memcpy(F3, F2, sizeof(F3));
				uf = 255; } }
		if(!uf) {
			if(Dnotf) {
				printf("***Not found!\n");
				show_entry(F1); } }
		if(!(uf & 0xF0))
			continue;
		printf("*** File has been updated!\n");
		show_entry(F3);
		show_entry(F1);
		printf("Copy(Y/N)?");
x2:		switch(kbtst()) {
		default: goto x2;
		case 0x1B: abort("Abort\n");
		case 'n' :
		case 'N' : fputs("N\n", stdout);		continue;
		case 'y' :
		case 'Y' : fputs("Y\n", stdout); }
			fp = fopen(F3.Name, "rvqb");
			fp1 = fopen(F1.Name, "wvqb");
			do {
				if(i = fget(Buffer, sizeof(Buffer), fp))
					fput(Buffer, i, fp1); }
			while(i == sizeof(Buffer));
			touch(fp1->FILE_handle, F3.Time, F3.Date);
			fclose(fp1);
			fclose(fp);
			continue;
	}
}
