#include <stdio.h>
#include <dir.h>
#include <dos.h>
#define	LINE_SIZE	100
#define NUM_CMDS	10

char verbose = -1, recurse = 0, multi = 0, cd = 0;
char *cmds[NUM_CMDS], outcmd[LINE_SIZE], dname[65], match[20];
int ccount = 0, fcount = 0;

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;
	char chr, chr1, *ptr, *ptr1;
	struct ffblk ffblk;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((tolower(*ptr++) << 8) | tolower(*ptr++)) {
			case 'c+' :		/* Change directory */
				cd = -1;
				break;				
			case 'v-' :		/* Turn off vebose output */
				verbose = 0;
				break;
			case 'm+' :		/* Do not process each file */
				multi = -1;
				break;
			case 'r+' :		/* recurse into sub-directories */
				recurse = -1;
				break;
			default:
				cmds[ccount++] = argv[i]; } }

	if(ccount < 2) {
		fputs("\nUse: wdir <filespec> \"command\"* [+c +m +r -v]\n\n?COPY.TXT 1989-2005 Dave Dunfield\n -- see COPY.TXT --.\n", stderr);
		exit(-1); }

	strcpy(match,"*.*");

/* we have filename, determine if it is a directory */
	ptr = cmds[0];
	ptr1 = dname;
	chr1 = i = 0;
	while(*ptr1++ = *ptr++)
		++i;
	j = i;
	while(i) {
		chr = dname[--i];
		if((chr == '\\') || (chr == ':')) {
			++i;
			break; }
		if((chr == '*') || (chr == '?'))
			chr1 = -1; }
	if(!chr1) {		/* Name did not contain wildcards, test file */
		if(!findfirst(dname,&ffblk,0))	/* Test for directory */
			chr1 = -1;
		else {
			if((dname[j-1] != '\\') && (dname[j-1] != ':'))
				dname[j++] = '\\';
			dname[j] = 0; } }
	if(chr1) {		/* Hack off filespec from dir */
		strcpy(match, &dname[i]);
		dname[i] = 0; }

	do_dir();

	if(!fcount)
		fputs("No files found", stderr);
}

do_dir()
{
	int i;
	struct ffblk ffblk;

	if(cd) {
		strcpy(outcmd, match);
		for(i=0; dname[i]; ++i);
		if(i && (dname[i-1] == '\\'))
			dname[i-1] = 0;
		chdir(dname); }
	else {
		strcpy(outcmd, dname);
		strcat(outcmd, match); }

	if(!findfirst(outcmd, &ffblk, 0)) {
		++fcount;
/* we have at least one file, search them all */
		if(multi) {
			for(i=1; i < ccount; ++i)
				do_cmd(cmds[i], match); }
		else {
			do {
				for(i=1; i < ccount; ++i)
					do_cmd(cmds[i], ffblk.ff_name); }
			while(!findnext(&ffblk)); } }

/* Now, search for directories */
	if(recurse) {
		strcpy(outcmd, dname);
		strcat(outcmd,"*.*");
		if(findfirst(outcmd, &ffblk, FA_DIREC))
			return;
		i = strlen(dname);
		do {
			if((ffblk.ff_attrib & FA_DIREC) && (ffblk.ff_name[0] != '.')) {
				strcat(dname, ffblk.ff_name);
				strcat(dname,"\\");
				do_dir();
				dname[i] = 0; } }
		while(!findnext(&ffblk)); }
}

do_cmd(cmd, name)
	char *cmd, *name;
{
	char chr, chr1, *ptr, *ptr1;

	ptr = outcmd;
	chr1 = -1;
	while(chr = *cmd++) {
		ptr1 = name;
		switch(chr) {
			case '@' :		/* insert entire filename */
				while(*ptr = *ptr1++)
					++ptr;
				chr1 = 0;
				break;
			case '$' :		/* name only */
				while(*ptr1 && (*ptr1 != '.'))
					*ptr++ = *ptr1++;
				chr1 = 0;
				break;
			case '^' :		/* directory name */
				ptr1 = dname;
				while(*ptr = *ptr1++)
					++ptr;
				chr1 = 0;
				break;
			case '!' :		/* protect next char */
				*ptr++ = *cmd++;
				break;
			default :
				*ptr++ = chr; } }
	if(chr1) {	/* Supply default filename */
		*ptr++ = ' ';
		for(ptr1 = dname; *ptr = *ptr1++; ++ptr);
		for(ptr1 = name;  *ptr = *ptr1++; ++ptr); }
	*ptr = 0;
	if(verbose) {
		fputs("WDIR: ", stdout);
		fputs(outcmd, stdout);
		putc('\n', stdout); }
	system(outcmd);
}
