#include <stdio.h>
#include <file.h>
#define	LFN_FIND
// #define	LFN_RENAME
// #define	LFN_CD
#define	LFN_MKDIR
// #define	LFN_RMDIR
// #define	LFN_GETDIR
// #define	LFN_DELETE
// #define	LFN_ATTR
#define	LFN_OPEN
// #define	LFN_GET_SHORT
// #define	LFN_TOUCH
#define	LFN_FOPEN
#include <lfn.ch>

#define	MAXFILE	100

unsigned
	Ftop,
	Ptop;
FILE
	*fpi,
	*fpo;
struct LFN
	Lfn;
unsigned char
	*Ptr,				// General pointer
	*P1,
	*P2,
	*Idir,				// Input directory
	*Ifile,				// Input file
	*Odir,				// Output directory
	*Fnames[MAXFILE],	// Files to copy
	DoLfn = 255,		// Long filenames
	Dname[65],			// Directory name
	Buffer[512],		// I/O buffer
	Buffer1[256],		// ""
	Buffer2[256],		// ""
	Pool[32768];		// String pool

// Add a string to the string pool
unsigned char *addpool(unsigned char *d)
{
	unsigned p;
	p = Ptop;
	do {
		if(Ptop >= sizeof(Pool))
			abort("Pool exhausted"); }
	while(Pool[Ptop++] = *d++);
	return Pool+p;
}

// Skip to non-blank in input stream
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

// Scan directory name from input stream
unsigned char *scandir(unsigned char **name)
{
	unsigned i;
	unsigned char *n;
	n = *name;
	i = 0;
	for(;;) switch(Dname[i] = *n++) {
	case 0 :		// No directory found
		return *Dname = 0;
	case '\\' :		// Directory exists
		if(i) {
			Dname[i] = 0;
			*name = n;
			return Dname; }
	default:
		++i; }
}

// Remove trailing blanks from string
void trim(unsigned char *str)
{
	unsigned char *s;
	s = str;
	while(*s)
		++s;
	while((s > str) && isspace(*(s-1)))
		--s;
	*s = 0;
}

// Generate an input name
unsigned char *iname(unsigned char *s)
{
	unsigned char *p;
	p = Buffer;
	if(*Idir) {
		p = stpcpy(p, Idir);
		*p++ = '\\'; }
	return stpcpy(p, s);
}

// Issue a Y/N prompt
int prompt(unsigned char *s)
{
	int c, d;
	printf("%s (Y/N)?", s);
	for(;;) switch(c=kbget()) {
		case 'y' :
		case 'Y' : d = 255; goto ex;
		case 0x1B:
		case 0x03: c = 'N';
		case 'n' :
		case 'N' : d = 0; ex:
			putc(c, stdout);
			putc('\n', stdout);
			return d; }
}

// Check file status
//	0 = Not found
//	1 = Directory
//	2 = Normal file
//	3 = Volume label
int isdir(unsigned char *name)
{
	unsigned r;
	r = lfn_find_first(name, 0x3F, Lfn);
	lfn_find_close();
	if(r) return 0;
	if(Lfn.Attrib & DIRECTORY) return 1;
	return (Lfn.Attrib & VOLUME) ? 3 : 2;
}

void xmkdir(unsigned char *s)
{
	int r;
	if(r = lfn_mkdir(s)) {
		printf("mkdir('%s') failed (%d)\n", r);
		exit(-1); }
}

// Check for & create directories in tree
void chkdir(void)
{
	unsigned char *p1;
	p1 = P1;
	if(scandir(&Ptr)) {
		if(P1 != Buffer1)
			*P1++ = '\\';
		P1 = stpcpy(P1, Dname);
		if(!strbeg(Buffer2, Buffer1)) {
			concat(Buffer, Odir, "\\", Buffer1);
			if(isdir(Buffer) != 1)
				xmkdir(Buffer);
			stpcpy(Buffer2, Buffer1); }
		chkdir(); }
	P1 = p1;
}

unsigned char Help[] = { "\n\
use:	XCP	source.xcp destdir [options]\n\n\
opts:	/L	- disable Longfilename support\n\
\nDave Dunfield - "#__DATE__"\n" };

main(int argc, char *argv[])
{
	unsigned i, j;

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		switch((toupper(*Ptr++)<<8) | toupper(*Ptr++)) {
		case '-L' :
		case '/L' : DoLfn = 0;		continue;
		} Ptr -= 2;
		if(!Idir) {
			P1 = Buffer;
			while(scandir(&Ptr)) {
				if(P1 != Buffer)
					*P1++ = '\\';
				P1 = stpcpy(P1, Dname); }
			if(!*Ptr)
				abort("Input .XCP file required");
			Idir = addpool(Buffer);
			Ifile = Ptr;
			continue; }
		if(Odir)
			abort(Help);
		Odir = Ptr; }

	if(!Odir)
		abort(Help);

	if(DoLfn)
		lfn_init();
	else
		lfn_disable();

	printf("Idir='%s' Ifile='%s' Odir='%s'\n", Idir, Ifile, Odir);
	stpcpy(iname(Ifile), ".XCP");
	fpi = lfn_fopen(Buffer, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi)) {
		switch(skip()) {
		case ';' :
		case 0 : continue; }
		trim(Ptr);
		if(Ftop >= MAXFILE)
			abort("Too many files");
		Fnames[Ftop++] = addpool(Ptr); }
	fclose(fpi);

	switch(isdir(Odir)) {
	default:
		printf("'%s' is not a directory.\n");
		return;
	case 1 :
		printf("Dir '%s' exists.\n", Odir);
		if(!prompt("Confirm"))
			return;
		break;
	case 0 :
		xmkdir(Odir); }

	memset(P1 = Buffer1, 0, sizeof(Buffer1)+sizeof(Buffer2));
	for(i=0; i < Ftop; ++i) {
		Ptr = Fnames[i];
		chkdir(); }

	for(i=0; i < Ftop; ++i) {
		iname(Fnames[i]);
		concat(Buffer1, Odir, "\\", Fnames[i]);
		printf("%s\n", Buffer);
		fpi = lfn_fopen(Buffer, "rvqb");
		fpo = lfn_fopen(Buffer1, "wvqb");
		do {
			if(j = fget(Buffer, 1024, fpi))
				fput(Buffer, j, fpo); }
		while(j == 1024);
		fclose(fpo);
		fclose(fpi); }
}
