#include <stdio.h>
#include <window.h>
#include <file.h>

#define	MAX_FILES	1000		// Maximum # files to handle
#define	MAX_TEXT	7			// Maximum # text strings
#define	WIDTH		80			// Max width of screen 
#define	HEIGHT		24			// Max height of screen

#define	STATUS		0x70		// Status line
#define	MAIN		0x17		// Main window
#define	_MAIN		0x71		// Main selected
#define	BROWSE		0x17		// Browser window
#define	_BROWSE		0x47		// Browser highlite
#define	_EOF		0x1E		// End of file
#define	_HEX		0x1A		// Hex data
#define	MBOX		0x47		// Message box
int
	Ftop;				// File list
	
unsigned
	Select,				// Current selection
	Seg,				// Segment of file list
	Ttop,				// Top of text
	Stop,				// Top of file segment
	File[MAX_FILES],	// Indexes of filenames
	Count[MAX_FILES],	// Count of occurances
	Total[MAX_TEXT];	// Total count of occurances

unsigned char
	casf,				// Case sensitive
	hexd,				// Hex display
	sort = 255,			// Sort display
	*fn,				// Filename pointer
	Dir[80],			// Directory
	Text[MAX_TEXT][61],	// Text to scan for
	buffer[4096];		// Working buffer

struct WINDOW
	*swin,				// status window
	*mwin;				// main window

extern unsigned Htab;

char hello[] = { "\neXpress Find - Dave Dunfield - "#__DATE__"\n\n\
Use:	XF	filespec [string ...] [options]\n\n\
opts:	/C	= Case sensitive search\n\
	/H	= display HEX codes in browser\n\
	/S	= do not Sort filenames\n\
	T=n	= set Tab interval\n\
\n?COPY.TXT 2004 Dave Dunfield\n -- see COPY.TXT --.\n" };

char mhelp[] = { "\
Up/Down		= Select file (by 1)\n\
PgUp/PgDn	= Select file (by 23)\n\
Home/End	= Select first/last file\n\
Left/Right	= Select match-line (by 1)\n\
^Left/^Right	= Select match-line (by 9)\n\
^Home/^End	= Select first/last match-line\n\
Enter		= View file at match-line\n\
F1		= Display strings\n\
Esc/F10		= Exit" };

char vhelp[] = { "\
Up/Down		= Move view (by 1 line)\n\
PgUp/PgDn	= Move view (by 23 lines)\n\
Home/End	= View first/last line\n\
^PgUp/^PgDn	= Move view to previous/next string occurance\n\
Left/Right	= Move view (by 1 column)\n\
^Left/^Right	= Move view (by 10 columns)\n\
^Home/^End	= View first/last column\n\
F1		= Display strings\n\
F2		= Return to last string occurance\n\
F3		= Goto line by number\n\
F4		= Set horizontal tab interval\n\
Esc/F10		= Exit" };

/*
 * Re-parse the command line arguments to obtain values in quotations
 *
 * New arguments are parsed into the same holding buffer as the original
 * ones, which means that the value of ARGV will not change. The global
 * ARGC is updated by this function, and the new argc value is returned
 * so that local copies may be easily updated as well.
 */
int parse_quoted_args(void) asm
{
		EXTRN	_ARGC, _ARGV
		MOV		SI,80h					// Command tail
		MOV		AH,[SI]					// Get length
		INC		SI						// Advance
		MOV		BX,offset DGRP:_ARGV+2	// BX = ARGV output
		MOV		DI,[BX]					// First argument
		XOR		CH,CH					// flag = 0;
; Process each char from arguments
qa1:	AND		AH,AH					// End of arguments
		JZ		ql7						// Yes, exit
		DEC		AH						// Reduce count
		MOV		AL,[SI]					// Get from source
		INC		SI						// Advance
		AND		CH,CH					// Already processing string?
		JNZ		qa3						// Yes
		CMP		AL,' '					// Space?
		JZ		qa1						// Keep going
		CMP		AL,9					// Tab
		JZ		qa1						// Keep going
		MOV		[BX],DI					// Save pointer
		ADD		BX,2					// Advance
		CMP		AL,'"'					// Start of quote?
		JNZ		qa2						// No, continune
		MOV		CH,2					// Inside quite
		JMP short qa1					// And continue
qa2:	MOV		CH,1					// Not inside quote
qa3:	CMP		AL,' '					// Space
		JZ		qa5						// Process
		CMP		AL,09h					// Tab?
		JZ		qa5						// Process
		CMP		AL,0Dh					// Secondary EOL?
		JZ		qa4						// Process
		CMP		AL,'"'					// Quote?
		JNZ		qa6						// No processing
; Encountered '"'
		CMP		CH,2					// Processing within quites?
		JNZ		qa6						// No, process
		CMP		AL,[SI]					// Double quotes?
		JNZ		qa4						// No
		INC		SI						// Advance
		DEC		AH						// Reduce length
		JMP short qa6					// and process
; Encountered CR
qa4:	MOV		CH,1					// Reset flag
qa5:	CMP		CH,1					// Quoted?
		JNZ		qa6						// No
		XOR		AL,AL					// Zero terminator
		MOV		CH,AL					// Flag = 0
qa6:	MOV		[DI],AL					// Write to arg
		INC		DI						// Advance
		JMP short qa1					// and proceed
ql7:	MOV		[DI],AH					// Zero terminate
		MOV		AX,BX					// Get address
		SUB		AX,offset DGRP:_ARGV	// Calculate offset
		SHR		AX,1					// /2
		MOV		DGRP:_ARGC,AX			// Set new value
}

/*
 * Report a fatal error and exit
 */
register error(unsigned args)
{
	unsigned char buffer[100];
	_format_(nargs() * 2 + &args, buffer);
	wclose();
	wclose();
	if(*buffer)
		fputs(buffer, stdout);
	exit(-1);
}

/*
 * Scan for text in buffer
 */
int scanfor(text) asm
{
		MOV		DX,(OFFSET DGRP:_buffer)-1	; Point to buffer
		MOV		CL,DGRP:_casf			; Get case flag
scnext:	INC		DX						; Advance to next
		MOV		DI,DX					; DI = buffer position
		MOV		SI,4[BP]				; Reset to top of buffer
scchr:	MOV		AH,[SI]					; Get data from text
		AND		AH,AH					; End of text?
		JZ		scok					; We found it!
		MOV		AL,[DI]					; Get data from line
		AND		AL,AL					; End of line?
		JZ		scfail					; Not found!
		CMP		AL,'a'					; In range?
		JB		scc1					; No
		CMP		AL,'z'					; In range?
		JA		scc1					; No
		AND		CL,CL					; Case sensitive?
		JNZ		scc1					; Yes - dont convert
		AND		AL,0DFh					; Convert to upper case
scc1:	CMP		AL,AH					; Does it match?
		JNZ		scnext					; Failed to match
		INC		SI						; Next in line
		INC		DI						; Next in word
		JMP		short scchr				; Keep looking
scok:	MOV		AX,255					; Indicate OK
		POP		BP
		RET
scfail:	XOR		AX,AX					; indicate fail
}

/*
 * Scan file for strings
 */		
void search(unsigned char *file)
{
	unsigned i, line, t;
	FILE *fp;
	char f, f1;

	t = Stop;
	line = f = 0;
	w_clwin(swin);
	w_puts(file, swin);
	strcpy(fn, file);
	if(!(fp = fopen(Dir, "r"))) {
		w_puts(": Cannot access", swin);
		if(wgetc() == 0x1B)
			error("Abort");
		return; }
	while(fgets(buffer, sizeof(buffer)-1, fp)) {
		++line;
		for(i = f1 = 0; i < Ttop; ++i) {
			if(scanfor(Text[i])) {
				++Total[i];
				f1 = 255; } }
		if(f1) {
			if(!f) {
				f = 255;
				File[Ftop] = Stop;
				Count[Ftop] = 0;
				do {
					poke(Seg, Stop++, *file); }
				while(*file++);
				f = 255; }
			w_gotoxy(70, 0, swin);
			w_printf(swin, "%u", ++Count[Ftop]);
			poke(Seg, Stop++, line);
			poke(Seg, Stop++, line >> 8); } }

	fclose(fp);
	if(f) {		// Entry was found
		if(Ftop++ >= MAX_FILES)
			error("Too many files"); }
	if(Stop < t)
		error("Out of memory");
}

int segcmp(str1, str2) asm
{
		MOV		ES,DGRP:_Seg	; Get segment
		MOV		SI,6[BP]		; Get str1
		MOV		DI,4[BP]		; Get str2
segc1:	MOV		AL,ES:[SI]		; Get source
		INC		SI				; Advance source
		CMP		AL,ES:[DI]		; Compare with desst
		INC		DI				; Advance dest
		JZ		segc1			; Do complete compare
		MOV		AX,0			; Indicate higher
		SBB		AL,0			; Adjust
}

main(int argc, char *argv[])
{
	int e;
	unsigned f, i, j, k, l, t, h, dh, mh;
	unsigned char c, *p, name[13];
	static unsigned Last = -1;

	argc = parse_quoted_args();
	for(i=1; i < argc; ++i) {
		p = argv[i];
		switch((toupper(*p++) << 8) | toupper(*p++)) {
		case '/C' :
		case '-C' :	casf = 255;					continue;
		case '-H' :
		case '/H' : hexd = 255;					continue;
		case '-S' :
		case '/S' : sort = 0;					continue;
		case 'T=' : if(i = atoi(p)) Htab = i;	continue; }
		if(!*Dir) {
			strcpy(Dir, p-2);
			continue; }
		if(Ttop >= MAX_TEXT)
			abort("Too many arguments");
		strcpy(Text[Ttop++], p-2); }

	if(!*Dir)
		abort(hello);
	fn = p = Dir;
	while(c = *p++) switch(c) {
	case ':' :
	case '\\' : fn = p; }
	
	IOB_size = 1024;
	Seg = alloc_seg(4096);
	if(find_first(Dir, 0, name, &i, &i, &j, &i, &i))
		abort("File not found.");

	swin = wopen(0, 0, WIDTH, 1, WSAVE|WCOPEN|STATUS);
	mwin = wopen(0, 1, WIDTH, HEIGHT, WSAVE|WCOPEN|MAIN);
	wcursor_off();

	if(!Ttop) {
		while(Ttop < MAX_TEXT) {
			sprintf(buffer, "Search %u?", Ttop+1);
			if(!getstring(buffer, Text[Ttop], 60))
				break;
			++Ttop; } }
	if(!Ttop)
		error("No strings");

	if(!casf) {
		for(i=0; i < Ttop; ++i)
			strupr(Text[i]); }

	do {
		search(name); }
	while(!find_next(name, &i, &i, &j, &i, &i));

	t = e = dh = 0;

	if(sort) for(i=0; i < Ftop; ++i) {
		for(j=i+1; j < Ftop; ++j) {
			if(segcmp(File[j], File[i])) {
				k = File[i];
				File[i] = File[j];
				File[j] = k;
				k = Count[i];
				Count[i] = Count[j];
				Count[j] = k; } } }

restat:
	w_clwin(swin);
	w_gotoxy(30, 0, swin);
	for(i=j=0; i < Ttop; ++i) {
		j += (k = Total[i]);
		if(Ttop > 1)
			w_printf(swin, "%6u", k); }
	if(!j)
		error("No occurances.");
	if(Ttop > 1) {
		w_gotoxy(75, 0, swin);
		w_printf(swin, "%5u", j); }
	else
		w_printf(swin,"%u: %s", j, Text[0]);
redraw:
	h = dh;
	if(e < 0)
		e = 0;
	if(e >= Ftop)
		e = Ftop-1;
	if(e < t)
		t = e;
	if((t+HEIGHT) <= e)
		t = ((Ftop >= HEIGHT) ? (e-HEIGHT)+1 : 0);
	for(i=mh=0; i < HEIGHT; ++i) {
		wgotoxy(0, i);
		if((f = t + i) >= Ftop) {
			*W_OPEN = MAIN;
			wcleow();
			break; }
		*W_OPEN = c = (f == e) ? _MAIN : MAIN;
		k = File[f];
		while(l = peek(Seg, k++))
			wputc(l);
		*W_OPEN = MAIN; wcleol(); wgotoxy(13, i);
		wprintf("%-5u", j=l=Count[f]);
		if(f == e) {
			if(j > mh)
				mh = j;
			if(h >= j)
				h = j-1;
			w_printf(swin, "\r%5u/%-5u%6u/%-5u", e+1, Ftop, (Select = h)+1, j);
			while(h > 9) {
				--j;
				--h;
				k += 2; } }
		wputc((j == l) ? ' ' : '<');
		for(l=0; l < j; ++l) {
			if(l > 9) {
				*W_OPEN = MAIN;
				wputc('>');
				break; }
			*W_OPEN = (l == h) ? c : MAIN;
			wprintf("%6u", peekw(Seg, k+l+l)); } }
	for(;;) switch(i=wgetc()) {
	case 0x1B :
	case _K10 :
		wclose();
		wclose();
		return;
	case _KUA : --e;					goto redraw;
	case _KDA : ++e;					goto redraw;
	case _KPU : e -= (HEIGHT-1);		goto redraw;
	case _KPD : e += (HEIGHT-1);		goto redraw;
	case _KLA :
		if(dh >= mh)
			dh = mh-1;
		if(dh)
			--dh;
		goto redraw;
	case _KRA : if(dh < mh) ++dh;		goto redraw;
	case _KHO : e = 0;					goto redraw;
	case _KEN : e = Ftop-1;				goto redraw;
	case _CLA : if(dh > 9) { dh -= 9;	goto redraw; }
	case _CHO : dh = 0;					goto redraw;
	case _CRA : if((dh += 9) < mh)		goto redraw;
	case _CEN : dh = mh - 1;			goto redraw;
	case '\n' :
		i = 0; k = File[e];
		while(buffer[i++] = c = peek(Seg, k++));
		wclwin();
		w_clwin(swin); w_gotoxy(60, 0, swin); w_puts(buffer, swin);
		if(e != Last) {
			open_file(buffer);
			Last = e; }
		view(k, Count[e]-1);
		goto restat;
	case _K1 :
		show_strings();
		goto redraw;
	default:
		if(i & 0xFF00) {
	case '?' :
			help(mhelp);
			goto redraw; } }
}

/*
 * ------- File Browser -------
 */
int
	Hpos,				// Horisontal position
	Hlow,				// Horizontal boundary low
	Hhigh,				// Horisontal boundary high
	Hmax,				// Maximum offset
unsigned
	Hilite,				// Selected line
	Ltop,				// Maximum line number
	Htab = 4,			// Horizontal tab stop
	Itop,				// Maximum index block
	Indexh[1024],		// Index HIGH block
	Indexl[1024];		// Index LOW  block

FILE
	*Fp;

/*
 * Open a file for subseqent display
 */
open_file(unsigned char *name)
{
	int c;
	unsigned h, l;

	if(Fp)
		fclose(Fp);
	strcpy(fn, name);
	if(!(Fp = fopen(Dir, "rb")))
		error("Could not open: %s", name);

	Itop = Ltop = h = l = 0;
	while((c = getc(Fp)) != EOF) {
		if(!++l)
			++h;
		if(c == '\n') {
			if(!(++Ltop & 63)) {
				w_printf(swin, "\r%u", Ltop);
				Indexl[Itop] = l;
				Indexh[Itop++] = h; } } }
}

/*
 * Goto indicated line number
 */
goto_line(unsigned line)
{
	int c;
	unsigned i, h, l;

	if(line & 0xFFC0) {
		i = (line >> 6)-1;
		h = Indexh[i];
		l = Indexl[i]; }
	else
		h = l = 0;
	fseek(Fp, h, l, 0);
	i = line & 0x3F;
	while(i) {
		while((c = getc(Fp)) != '\n') {
			if(c == EOF) {
				return; } }
		--i; }
}

display(int c)
{
	static char temp[3];
	static char tc;
	switch(c) {
	case '\t' :
		do {
			display(' '); }
		while(Hpos % Htab);
	case '\r' :
	case 0x1A :
		return; }

	if((c < 0x20) || (c > '~')) {
		if(hexd) {
			sprintf(temp, "%02x", c);
			tc = *W_OPEN;
			*W_OPEN = (tc & 0xF0) | 0x0A;
			display('~');
			display(temp[0]);
			display(temp[1]);
			*W_OPEN = tc;
			return; } }
	if((Hpos >= Hlow) && (Hpos < Hhigh))
		wputc(c|0x100);
	++Hpos;
}

display_screen(unsigned line)
{
	int c;
	unsigned i;
	char ef;

	goto_line(line);
	for(Hmax = i = ef =0; i < HEIGHT; ++i) {
		wgotoxy(Hpos = 0, i);
		if(ef) { doeof:
			*W_OPEN = _EOF;
			wputs("*End Of File*");
			*W_OPEN = BROWSE;
			wcleow();
			return; }
		*W_OPEN = (line == Hilite) ? _BROWSE : BROWSE;
		wcleol();
		while((c = getc(Fp)) != '\n') {
			if(c == EOF) {
				ef = 255;
				if(!Hpos) goto doeof;
				break; }
			display(c); }
		if(Hpos > Hmax)
			Hmax = Hpos;
		++line; }
}

view(unsigned Offset, unsigned Max)
{
	unsigned i, line, rl, Top;

	rl = Top = (Ltop > HEIGHT) ? (Ltop-HEIGHT)+1 : 0;

reline:
	Hilite = line = peekw(Seg, Offset + Select + Select)-1;
	if(line > (HEIGHT/2))
		line -= (HEIGHT/2);
	else
		line = 0;
retab:
	if(Hlow < 0) Hlow = 0;
	Hhigh = Hlow + WIDTH;
redraw:
	if(line > Top) line = rl;
	display_screen(line);
	sprintf(buffer, "%u-%u/%u", line+1, line+HEIGHT, Ltop);
	sprintf(buffer+50, "%u-%u/%u", Hlow+1, Hlow+WIDTH, Hmax);
	w_printf(swin, "\r%-18s%-18s%5u/%-5u %u", buffer, buffer+50, Select+1, Max+1, Hilite+1);
	rl = Top;
	for(;;) switch(i=wgetc()) {
	case _KUA : --line;
	redu: rl=0;							goto redraw;
	case _KDA : ++line;					goto redraw;
	case _KPU : line -= (HEIGHT-1);		goto redu;
	case _KPD : line += (HEIGHT-1);		goto redraw;
	case _KHO : line = 0;				goto redraw;
	case _KEN : line = Top;				goto redraw;
	case _KLA : --Hlow;					goto retab;
	case _KRA : ++Hlow;
xtab:	if(Hmax < WIDTH)
			Hlow = 0;
		else if((Hmax-WIDTH) < Hlow)
			Hlow = Hmax - WIDTH;
		goto retab;
	case _CHO : Hlow = 0;				goto retab;
	case _CEN : Hlow = 32767;			goto xtab;
	case _CLA : Hlow -= 10;				goto retab;
	case _CRA : Hlow += 10;				goto xtab;
	case _CPU :
		if(Select) { --Select; /* rl = 0; */ goto reline; }
		xbeep(); continue;
	case _CPD :
		if(Select < Max) { ++Select; goto reline; }
		xbeep(); continue;
	case _K1 : show_strings();			goto redraw;
	case _K2 : goto reline;
	case _K3 : *buffer = 0;
		if(getstring("Line?", buffer, 6)) {
			if(i = atoi(buffer))
				line = ((i < Ltop) ? i : Ltop)-1; }
		goto redraw;
	case _K4 :
		sprintf(buffer+50, "Tab interval [%u] ?", Htab);
		*buffer = 0;
		if(getstring(buffer+50, buffer, 3)) {
			if(i = atoi(buffer))
				Htab = i; }
		goto redraw;
	case 0x1B :
	case _K10 :return;
	default: if(i & 0xFF00) {
	case '?' :
		help(vhelp);
		goto redraw; } }
}


getstring(unsigned char *prompt, unsigned char *string, unsigned length)
{
	unsigned l, l1;
	l = (l1 = strlen(prompt)) + (length  & 0x7F) + 4;
	wopen(40-(l/2), 10, l, 3, WSAVE|WCOPEN|WBOX1|MBOX);
	wputs(prompt);
	for(;;) switch(wgets(l1, 0, string, length)) {
	case '\n' : if(*string) {
			wclose();
			return 255; }
	case 0x1B : wclose(); return 0; }
}

wait()
{
	wputs("\n\n?COPY.TXT 2004 Dave Dunfield -  -- see COPY.TXT -- - Press any key.");
	wgetc();
}

help(unsigned char *p)
{
	int c, l, h, t;
	wclwin();
	l = Hlow;
	h = Hhigh;
	t = Htab;
	Hlow = 0;
	Hhigh = WIDTH;
	Htab = 8;
top:
	wputc('\n');
	wputc(' ');
	Hpos = 0;
	while(c = *p++) {
		if(c == '\n')
			goto top;
		display(c); }
	wait();
	Hlow = l;
	Hhigh = h;
	Htab = t;
}

show_strings()
{
	unsigned i;
	wclwin(); wgotoxy(0, 3);
	for(i=0; i < Ttop; ++i)
		wprintf("%-5u: %s\n", Total[i], Text[i]);
	wait();
}

xbeep()
{
	beep(1000, 300);
	while(wtstc());
}
