#include <stdio.h>
#include <file.h>
#include <window.h>

#define	FILES	255
#define	SEGS	4

struct WINDOW
	*lwin,				// Left window
	*rwin,				// Right window
	*swin;				// Status window
unsigned
	Seg,				// External segment
	Wh,					// Write handle
	Rh,					// Read handle
	Ptop;				// Top of string pool
unsigned char
	*ptr,				// General pointer
	Sflag,				// Status flag
	Pool[FILES*13],		// String pool
	Temp[256];			// Temp storage

struct FIELD {
	struct WINDOW	*win;				// Display window
	unsigned		select;				// Selection
	unsigned		wtop,				// Top of window
	unsigned 		ltop;				// Top of list
	unsigned char	*list[FILES];
	}	F, J;

register status(unsigned args)
{
	unsigned char buf[81];
	_format_(nargs() * 2 + &args, buf);
	w_cleol(swin);
	w_puts(buf, swin);
	Sflag = 255;
}

unsigned char *add_pool(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	while(Pool[Ptop++] = *p++);
	if(Ptop > sizeof(Pool))
		abort("Pool exhausted\n");
	return Pool+t;
}

void draw(struct FIELD *f, unsigned char a2)
{
	unsigned i, p, s, w, l;
	unsigned char a1;

	W_OPEN = f->win;

	if(!(l=f->ltop)) {
		wclwin();
		return; }
	s = f->select;
	w = f->wtop;

	a1 = *W_OPEN;
//	if(sel & 0x8000)
//		sel = 0;
//	if(sel >= files)
//		sel = files-1;
//	if(sel < tos)
//		tos = sel;
//	if((tos+LINES) <= sel)
//		tos = sel-(LINES-1);
//	if(tos & 0x8000)
//		tos = 0;

	if(s & 0x8000)
		f->select = s = 0;
	if(s >= l)
		f->select = s = l-1;
	if(s < w)
		f->wtop = w = s;
	if((w+24) <= s)
		f->wtop = w = s - 23;
	if(w & 0x8000)
		f->wtop = w = 0;

	for(i=0; i < 24; ++i) {
		wgotoxy(0, i);
		wcleol();
		p = w + i;
		if(p >= l)
			continue;
		if(p == s)
			*W_OPEN = a2;
		wputs(f->list[p]);
		*W_OPEN = a1; }
}

Wclose()
{
	w_close(J.win);
	w_close(F.win);
	w_close(swin);
}

main(int argc, char *argv[])
{
	unsigned i, j, a;
	struct FIELD *f;

	if(argc < 3)
		abort("XJ pattern output");
	i = 0;
	if(find_first(argv[1], 0, Temp, &j, &j, &a, &j, &j))
		abort("No files");
	do {
		if(a & (DIRECTORY|VOLUME))
			continue;
		++i;
		if(F.ltop >= FILES)
			abort("Too many files\n");
		F.list[F.ltop++] = add_pool(Temp); }
	while !find_next(Temp, &j, &j, &a, &j, &j);

	for(i=0; i < F.ltop; ++i) {
		for(j=i+1; j < F.ltop; ++j) {
			if(strcmp(F.list[j], F.list[i]) < 0) {
				a = F.list[i];
				F.list[i] = F.list[j];
				F.list[j] = a; } } }

	if(!(Seg = alloc_seg(SEGS*4096)))
		abort("Out of memory");

	swin = wopen(0,24, 80,  1, WSAVE|WCOPEN|0x70);
	F.win = wopen(0, 0, 40, 24, WSAVE|WCOPEN|0x17);
	J.win = wopen(40,0, 40, 24, WSAVE|WCOPEN|0x47);
	f = F;
redraw:
	if(f != F) {
		if(J.ltop) {
			draw(F, 0x31);
			draw(J, 0x74); }
		else
			f = F; }
	if(f == F) {
		draw(F, 0x71);
		draw(J, 0x34); }
	for(;;) {
		i = wgetc();
		if(Sflag) {
			status("");
			Sflag = 0; }
		switch(toupper(i)) {
		case _KUA: --f->select;			goto redraw;
		case _KDA: ++f->select;			goto redraw;
		case _KPU: f->select -= 24;		goto redraw;
		case _KPD: f->select += 24;		goto redraw;
		case _KHO: f->select = 0;		goto redraw;
		case _KEN: f->select = 32767;	goto redraw;
		case _KRA:
		case _KLA:
			f = (f == F) ? J : F;
			goto redraw;
		case 'A' :		// Add to list
			if(J.ltop >= FILES) {
jfull:			status("Join list full!");
				continue; }
			J.list[J.select=J.ltop++] = F.list[F.select];
			goto redraw;
		case 'I' :		// Insert in list
			if(J.ltop >= FILES) goto jfull;
			for(i=J.ltop; i > J.select; --i)
				J.list[i] = J.list[i-1];
			++J.ltop;
			J.list[J.select=i] = F.list[F.select];
			goto redraw;
		case 'R' :		// Remove from list
			if(J.ltop) {
				for(i=J.select; i < J.ltop; ++i)
					J.list[i] = J.list[i+1];
				--J.ltop; }
			goto redraw;
		case _K10:
			Wclose();
			goto xfiles;
		case 0x1B:
			Wclose();
			return; } }

xfiles:
	if(!J.ltop)
		abort("No files selected");

	if(!(Wh = open(argv[2], F_WRITE|F_BINARY)))
		abort("Cannot open output");

	for(i=0; i < J.ltop; ++i)
		copy(J.list[i]);

	close(Wh);
}

segread(seg) asm
{
		MOV		BX,DGRP:_Rh		; Read handle
		MOV		CX,32768		; Size
		XOR		DX,DX			; Offset zero
		MOV		DS,4[BP]		; Get segment
		MOV		AH,3Fh			; Read file
		INT		21h				; Ask DOS
		JNC		sr1				; Ok
		MOV		AX,-1			; Indicate error
sr1:	PUSH	CS
		POP		DS
}
segwrite(seg, size) asm
{
		MOV		BX,DGRP:_Wh		; Write handle
		MOV		CX,4[BP]		; Get size
		XOR		DX,DX			; Zero offset
		MOV		DS,6[BP]		; Get segment
		MOV		AH,40h			; Write file
		INT		21h				; Ask DOS
		JNC		sw1				; Ok
		MOV		AX,-1			; Indicate error
sw1:	PUSH	CS
		POP		DS
}

copy(unsigned char *name)
{
	unsigned i, c, seg, s, ss[SEGS*2];
	unsigned char e;

	printf("%-13s- ", name);
	if(!(Rh = open(name, F_READ|F_BINARY))) {
		printf("Unable to open\n");
		return; }

	e = 255;
	c = 0;
	fputs("-----", stdout);
	do {
		printf("\b\b\b\b\b%-5u", ++c);
		seg = Seg;
		memset(ss, 0, sizeof(ss));
		for(i=0; i < (SEGS*2); ++i) {
			ss[i] = s = segread(seg);
			if(s != 32768) {
				if(s == -1) {
					printf("Failed\n");
					close(Rh);
					return; }
				e = 0;
				break; }
			seg += 2048; }

		seg = Seg;
		for(i=0; i < (SEGS*2); ++i) {
			if(s = ss[i]) {
				if(segwrite(seg, ss[i]) != s) {
					printf("Failed\n");
					close(Rh);
					return; }
				seg += 2048; } } }
	while(e);
	printf(" Ok\n");
	close(Rh);
}

