#include <stdio.h>
#include <file.h>

unsigned
	Seg1,			// External segment 1
	Seg2,			// External segment 2
	Stop1,			// Top of segment 1
	Stop2,			// Top of segment 2
	Count;			// Count of mismatches
FILE
	*fp1,			// General FP 1
	*fp2;			// General FP 2

unsigned char
	*ptr,			// General pointer
	Verbose,		// Verbose flag
	Content,		// Check content flag
	Rflag,			// Report flag
	Time = 255,		// Report time
	Dir1[65],		// Source directory
	Dir2[65],		// Dest   directory
	Pattern[13],	// Match  pattern
	Temp[80];

struct FINFO {
	unsigned Size[2];
	unsigned Time;
	unsigned Date;
	unsigned char Name[13];
	} F1, F2;

unsigned char Help[] = { "\n\
eXpress Match - Dave Dunfield - "#__DATE__"\n\n\
Use:	XM	filespec path [options]\n\n\
opts:	/C	= check Content of same-size files\n\
	/T	= do not report Timestamp differences\n\
	/V	= Verbose output\n\
\n?COPY.TXT 2010 Dave Dunfield\n -- see COPY.TXT --.\n" };

unsigned load_seg(unsigned seg, unsigned dir, unsigned char *lbl)
{
	unsigned i, a, sh, sl, t, d, n, top;
	unsigned char name[13];

	top = n = 0;
	do {
		pokew(seg, top -= 2, 0); }
	while(top);

	concat(Temp, dir, Pattern);
	if(find_first(Temp, 0x00, name, &sh, &sl, &a, &t, &d)) {
		printf("No files found (%s)\n", lbl);
		exit(-1); }
	do {
		if(!(a & DIRECTORY)) {
			++n;
			ptr = name;
			i = top;
			do {
				poke(seg, top++, *ptr); }
			while(*ptr++);
			pokew(seg, top, sl);
			pokew(seg, top+2, sh);
			pokew(seg, top+4, t);
			pokew(seg, top+6, d);
			if((top += 8) < i)
				abort("Out of memory"); } }
	while(!find_next(name, &sh, &sl, &a, &t, &d));
	if(Verbose)
		printf("%-8s: %u files, %u bytes cached\n", lbl, n, top);
	return top;
}

int get_next(unsigned seg, unsigned *p, struct FINFO *fi)
{
	unsigned np;

	np = *p;
	ptr = fi->Name;
	while(*ptr++ = peek(seg, np++));
	if(!*fi->Name)
		return 0;
	fi->Size[0] = peekw(seg, np);
	fi->Size[1] = peekw(seg, np+2);
	fi->Time	= peekw(seg, np+4);
	fi->Date	= peekw(seg, np+6);
	*p = np + 8;
	return 255;
}

void report(unsigned char *s)
{
	if(!Rflag) {
		Rflag = 255;
		++Count;
		printf("%-13s :", F1.Name); }
	putc(' ', stdout);
	fputs(s, stdout);
}

main(int argc, char *argv[])
{
	int c1, c2;
	unsigned i, j;
	unsigned char *p, *p1;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case '-C' :
		case '/C' : Content = 255;			continue;
		case '-T' :
		case '/T' : Time = 0;				continue;
		case '-V' :
		case '/V' : Verbose = 255;			continue;
		} ptr -= 2;
		if(!*Pattern) {		// Dir1 not set
			p = Dir1;
			p1 = 0;
			while(*p = *ptr++) switch(*p++) {
				case ':' :
				case '\\': p1 = p; }
			if(p1) {
				strcpy(Pattern, p1);
				*p1 = 0;
				continue; }
			*p = 0;
			strcpy(Pattern, Dir1);
			*Dir1 = 0;
			continue; }
		if(!*Dir2) {		// Dir2 not set
			p = Dir2;
			while(*p = *ptr++)
				++p;
			switch(*(p-1)) {
			default: *p++ = '\\';
			case ':' :
			case '\\': }
			continue; }
		abort(Help); }

//	printf("D1:'%s' D2:'%s' P:'%s'\n", Dir1, Dir2, Pattern);

	if(!*Dir2)
		abort(Help);

	if(!(Seg2 = (Seg1 = alloc_seg(8192)) + 4096))
		abort("Out of memory");

	IOB_size = 8192;

	load_seg(Seg1, Dir1, "Source");
	load_seg(Seg2, Dir2, "Dest");
	while(get_next(Seg1, &Stop1, F1)) {
		i = j = Rflag = 0;
		while(get_next(Seg2, &i, F2)) {
			if(!strcmp(F1.Name, F2.Name)) {	// File matches
				poke(Seg2, j, 0xFF);
				if((F1.Time != F2.Time) || (F1.Date != F2.Date)) {
					if(Time)
						report("Time"); }
				if((F1.Size[0] != F2.Size[0]) || (F1.Size[1] != F2.Size[1]))
					report("Size");
				else if(Content) {
					concat(Temp, Dir1, F1.Name);
					if(!(fp1 = fopen(Temp, "rvb")))
						goto found;
					concat(Temp, Dir2, F2.Name);
					if(!(fp2 = fopen(Temp, "rvb"))) {
						fclose(fp1);
						goto found; }
					do {
						c1 = getc(fp1);
						c2 = getc(fp2);
						if(c1 != c2) {
							report("Content");
							break; } }
					while(c1 != EOF);
					fclose(fp1);
					fclose(fp2); }
				goto found; }
			j = i; }
		report("Does not occur in dest!");
found:	if(Rflag)
			putc('\n', stdout); }

	i = 0;
	while(get_next(Seg2, &i, F1)) {
		if(*F1.Name != 0xFF) {
			Rflag = 0;
			report("Does not occur in source!");
			putc('\n', stdout); } }

	if(!Count)
		printf("No file mismatches were found.\n");
	else if(Verbose)
		printf("%u file mismatches were found.\n", Count);
}
